// DeHackEd version 3.0a
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Function prototypes
void AbortProg(char *func);
int  DetectDoomver(int argc, char *argv[]);
int  Parsecommandline(int argc, char *argv[]);
void Loaddoom(FILE *exefp);
void Parseconfigfile(void);
int  RunExe(void);
int  Updatecodep(void);
int  Updateframe(void);
int  Updatemisc(void);
int  Updatesound(void);
int  Updatesprite(void);
int  Updatetext(void);
int  Updatethings(void);
void Writedoom(void);

// Global pointers to thing, frame, sound and weapon data are declared.
// since Sprite info is simply a bunch of pointers to the Text data, it's
// an array of longs.  Also, the ammo info is a simple array of longs.
// The Text data is simply a large array of strings, declared here as one
// large string.  Same with the cheat data.  The misc data is just that,
// stuff stolen from all over in the exe file.
long (*thingdata )[THING_FIELDS];
long (*framedata )[FRAME_FIELDS];
long (*weapondata)[WEAPON_FIELDS];
long (*sounddata )[SOUND_FIELDS];
long *spritedata;
char *textdata;
long *codepdata;
char *cheatdata;
long *ammodata;
long *miscdata;

void *alldata[NUMDATA];

// Other global variables.
ERedraw redraw = ALL;			// Current redraw state
EModes  mode = THING_ED;		//	The mode we start in
EVersions version = NO_VER;   // The Doom version we're using
FILE *doomexefp = NULL;			// File pointer to doom.exe
FILE *doomwadfp = NULL;       // File pointer to doom.wad
FILE *doombakfp = NULL;			// File pointer to doomhack.exe
char curdir[MAXDIR+1];			// Directory at start of program
EBool changes = NO;				// If changes have been made
EBool batch = YES;				// If we're running in batch mode
ScreenSet *Modeptr;					// Pointer to Data for the current mode

// For the dehacked.ini file
char doompath[80]= "";			// Directory to run doom from
char doomexe[80] = "";			// Doom.exe file name
char doombak[80] = "";			// Heretic.exe backup file
char doomwad[80] = "";			// Doom.wad file name
char doomargs[80]= "";			// Arguments when Doom is run
char patchdir[80]= "";			// Patch file directory
long doomsize = 0;				// Doom.exe size
struct sb_conf dev = {544, 7};// Sound blaster info
EBool askatload = YES;			// Ask about reloading data during load
EBool loadlogo = YES;			// Load the logo at program start

DataSet Data[NUMDATA] = {
	// Global data for Things.  Refer to dehacked.h
	// complete struct explanation.
	{ {0x9ED10L, 0x9ED10L, 0x9ED10L, 0xA4400L, 0xA5660L},
		12696, 138, 92,
		"Thing" },

	// Frame
	{ {0x9834CL, 0x9834CL, 0x9834CL, 0x9DA3CL, 0x9EC9CL},
		27048, 966, 28,
		"Frame" },

	// Weapon
	{ {0x95734L, 0x95734L, 0x95734L, 0x9ADA4L, 0x9BFB8L},
		216, 9, 24,
		"Weapon" },

	// Sound
	{ {0x971D4L, 0x971D4L, 0x971D4L, 0x9C8C4L, 0x9DB24L},
		3852, 107, 36,
		"Sound" },

	// Sprite
	{ {0x98124L, 0x98124L, 0x98124L, 0x9D814L, 0x9EA74L},
		552, 138, 4,
		"Sprite" },

	// Text
	{ {0xA2228L, 0xA2228L, 0xA2228L, 0xA7918L, 0xA8B78L},
		0, 0, 0,
		"Text" },

	// Code pointers
	{ {0x3E1D0L, 0x3E122L, 0x3E1D4L, 0x40812L, 0x409EEL},
		3864, 966, 4,
		"Code Pointer" },

	// Cheats
	// IDDT is always assumed to be 3624 bytes before the offset given.
	// If this ever changes... ick.
	{ {0x96440L, 0x96440L, 0x96440L, 0x9BAB0L, 0x9CCC4L},
		148, 17, 0,
		"Cheat" },

	// Ammo
	{ {0x95714L, 0x95714L, 0x95714L, 0x9AD84L, 0x9BF98L},
		32, 8, 4,
		"Ammo" },

	// Miscellaneous
	// The real offset material is stored in Miscoff.
	{ {0x5C858L, 0x5C848L, 0x5C838L, 0x629B8L, 0x62BD8L},
		64, 16, 4,
		"Misc" }
};

// Prototypes for Print functions
extern void Printframe(void);
extern void Printmisc(void);
extern void Printsound(void);
extern void Printsprite(void);
extern void Printtext(void);
extern void Printthing(void);

// Which fields belong to which windows
extern int thingwindows[][2];
extern int miscwindows[][2];

ScreenSet Screen[NUMSCREENS] = {
	// Screen data for Thing editing screen.  Refer to dehacked.h
	// complete struct explanation.
	{  "Thing",
		0, 1, 0, 1, 138,
		{77, 5, 77, 23},
		6, thingwindows,
		Printthing,
		Updatethings },

	// Frame
	{  "Frame",
		0, 1, 0, 0, 965,
		{76, 8, 76, 42},
		6, NULL,
		Printframe,
		Updateframe },

	// Misc
	{  "Weapon",
		0, 1, 0, 1, 9,
		{60, 33, 60, 43},
		3, miscwindows,
		Printmisc,
		Updatemisc },

	// Sound
	{  "Sound",
		0, 1, 0, 1, 107,
		{64, 8, 64, 42},
		3, NULL,
		Printsound,
		Updatesound },

	// Sprite
	{  "Sprite",
		0, 1, 0, 0, 137,
		{54, 8, 54, 42},
		1, NULL,
		Printsprite,
		Updatesprite },

	// Text
	{  "Text",
		0, 1, 0, 0, 0,
		{77, 8, 77, 42},
		1, NULL,
		Printtext,
		Updatetext }
};

int textlength[NUMVERS] = {22540, 22460, 22540, 23188, 24072};
int textobjs[NUMVERS] = {1053, 1047, 1053, 1079, 1094};

// Order (field-wise) of things
char thingorder[23] = {IDNUM, HP, SPEED, WIDTH, HEIGHT, MISSILEDAMAGE,
							  REACTIONTIME, PAINCHANCE, MASS, BITS, ALERTSOUND,
							  ATTACKSOUND, PAINSOUND, DEATHSOUND, ACTSOUND,
							  NORMALFRAME, MOVEFRAME, INJUREFRAME, CLOSEATTACKFRAME,
							  FARATTACKFRAME, DEATHFRAME, EXPLDEATHFRAME,
							  RESPAWNFRAME};

// From screen.cpp
extern void clearscreen(char attr, char fill);
extern void CPrintfXY(int x, int y, char *string, ...);
extern void Drawframe(int type, unsigned char attr, int left, int top,
							 int right,	int bot);
extern void Getwindow(int x1, int y1, int x2, int y2);
extern void Putwindow(void);
extern void WipeScreen(void);

// From print.h
extern char *thingfields[24];
extern char *framefields[7];
extern char *fullwepfields[9];
extern char *soundfields[7];
extern char *cheatfields[17];
extern char *miscfields[16];
extern long toff[NUMVERS];
extern char namelist[138][18];

// From print.cpp
extern int   Printinputwindow(char *buffer, char *prompt, EInptype type, int length, char firstchar = 0);
extern void  Printintro(void);
extern void  Printoptions(void);
extern void  Printtextintro(void);
extern void  Printtextstring(EBool leavewindow);
extern EBool Printwindow(char *message, int type);

// From misc.cpp
extern void Cheatconvert(char *string, char *cheat, int length);
extern int  Gettextnum(int offset);
extern void Highlight(unsigned char attribute);

// From mouse.cpp
extern void  CloseMouse(void);
extern void  InitMouse(void);
extern EBool getLastEvent(unsigned &x, unsigned &y, EButton &left_button,
								  EButton &right_button);

// From mouse.h
extern unsigned LastEventButtons;

// From files.cpp
extern int  GetDoomFiles(char *arg1);
extern int  GetNextLine(char *nextline, int &numlines, FILE *patchp);
extern int  Loadpatch(char *filename);
extern int  ProcessLine(char *nextline, char **line2);
extern int  Savepatch(char *filename, EBool Overwrite);

// From input.cpp
extern int   Inputtext(EBool showonly);
extern EBool ProcessKeypress(void);
extern EBool ProcessMouse(void);
extern EBool Waitforevent(EBool eatevent);

// From playview.cpp
extern int Displaylogo(void);

// From sb_regs.h
extern int SB_DMA_CHAN;