struct pat_header {
    char magic[12];
    char version[10];
    char description[60];
    unsigned char instruments;
    char voices;
    char channels;
    unsigned short nr_waveforms;
    unsigned short master_volume;
    unsigned int data_size;
};

struct sample_header {
    char name[7];
    unsigned char fractions;
    int len;
    int loop_start;
    int loop_end;
    unsigned short base_freq;
    int low_note;
    int high_note;
    int base_note;
    short detune;
    unsigned char panning;

    unsigned char envelope_rate[6];
    unsigned char envelope_offset[6];

    unsigned char tremolo_sweep;
    unsigned char tremolo_rate;
    unsigned char tremolo_depth;

    unsigned char vibrato_sweep;
    unsigned char vibrato_rate;
    unsigned char vibrato_depth;

    char modes;

    short scale_frequency;
    unsigned short scale_factor;
};
