// script.c -- basic script access

#include <stdio.h>
#include <stdlib.h>

#include "wadentry.h"
#include "opcode.h"
#include "instruction.h"
#include "statment.h"
#include "goutput.h"
#include "script.h"


ScriptInfo *gScr=NULL;

void SetgScr(ScriptInfo *scr)
{
  gScr=scr;
}
ScriptInfo *GetgScr(void)
{
  return gScr;
}

ScriptInfo *LoadBehavior(char *pRaw, WORD wSize)
    // Returns NULL on failure.
    // On error You should retriev the error string
    // with the GOutput function GetStringBuffer
    // Do not free pRaw until after calling
    // UnloadBehavior!
{
    ScriptInfo *lpScr;
    BhvInfo *lpBhv;
    
    lpBhv = _LoadBehavior(pRaw, wSize);
    if(!lpBhv) return(NULL);
    lpScr = (ScriptInfo*)calloc(1, sizeof(ScriptInfo));
    if(!lpScr)
    {
        AccumulateString("FATAL: out of memory\n");
        return(NULL);
    }
    lpScr->bhv = lpBhv;
    lpScr->iScript = -1;
    lpScr->iLoadLevel = LS_BEHAVIOR;
    
    return(lpScr);
}

void UnloadBehavior(ScriptInfo *lpScr)
    // Frees memory.
{
    if(lpScr->iLoadLevel >= LS_INSTRUCTIONS)
    {
        UnloadInstructions(lpScr);
    }
    if(lpScr->iLoadLevel >= LS_BEHAVIOR)
    {
        if(lpScr->lpps) lpScr->lpps = NULL;
        _UnloadBehavior(lpScr->bhv);
        lpScr->bhv = NULL;
        lpScr->iLoadLevel = LS_UNLOADED;
        if(lpScr->pwMVarType)
        {
            free(lpScr->pwMVarType);
            lpScr->pwMVarType = NULL;
        }
        lpScr->wMVarCnt = 0;
    }
}

void UnloadInstructions(ScriptInfo *lpScr)
{
    if(lpScr->iLoadLevel >= LS_STATEMENTS)
    {
        UnloadStatements(lpScr);
    }
    if(lpScr->iLoadLevel >= LS_INSTRUCTIONS)
    {
        free(lpScr->lpis);
        lpScr->lpis = NULL;
        lpScr->wCntInst = 0;
        lpScr->iLoadLevel = LS_BEHAVIOR;
        if(lpScr->pwLVarType)
        {
            free(lpScr->pwLVarType);
            lpScr->pwLVarType = NULL;
        }
        lpScr->wLVarCnt = 0;
    }
}

void UnloadStatements(ScriptInfo *lpScr)
{
    if(lpScr->iLoadLevel >= LS_STATEMENTS)
    {
        free(lpScr->lpstat);
        lpScr->lpstat = NULL;
        lpScr->wCntStat = 0;
        lpScr->iLoadLevel = LS_INSTRUCTIONS;
    }
}



// EOF

