/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'E'


#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbsound.h"
#include "lbmusic.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbpatch.h"
#include "lblevel.h"
#include "lbtexu.h"
#include "lblumps.h"
#include "lbbehav.h"
#include "lbqklump.h"
#include "lbduke.h"
#include "lbqkspr.h"
#include "lbqkmdl.h"
#include "lbqktexu.h"







/****************************************************\
*
*
* Misc utilities
*
*
\****************************************************/
/*
** Save Bmp  to file
*/
static Int16 WADbmpToFile(pWADDEF This, pInt8 File)
{ Int16 res;
  res= BMPwrite(&(This->Bmp),File);
  BMPfree(&(This->Bmp));
  return res;
}


/****************************************************\
*
*
* show pictures
*
*
\****************************************************/

/*
**
** Show a Wall patch, as obligatory entry
**
*/
#if (DLLFORDOOM)
Int16 EXPORT WADshowByName(Int16 Self,pWINDOZE PicB,Int16 Id, pInt8 Name)
{ Int16 res=-1;
  pInt8 Lmp;
  Int32 LmpSz;
  Int16 SzX,SzY;
  pWADDEF This=WADgetThis(Self);
  if(This==NULL){return BAD_PARM;}
  if(Name==NULL) return ERRfault(BAD_PARM);
  Lmp=WADreadObligEntryI(This,&LmpSz,Name);
  if(Lmp==NULL)
  { return ERRfaultWad(ERR_PATABSNT);}
  switch(Id)
  { case EGRAPHIC:
	 case ESPRITE:
	 case EPATCH:
		res=BMPinitDoomPic(&(This->Bmp),Lmp,LmpSz,&SzX,&SzY);
		break;
	 case EFLAT:
		if(WADgetFlatWH(&SzX,&SzY,LmpSz)<0)
		{ Free(Lmp); return BAD_PICSZ; }
		res=BMPinitFlat(&(This->Bmp),Lmp,SzX,SzY);
		break;
  }
  Free(Lmp);
  if(res<0) { return res;}
  res= BMPassignToWindoze(&(This->Bmp), PicB);
  BMPfree(&(This->Bmp));
  return res;
}
#endif /*DLLFORDOOM*/




/****************************************************\
*
*
*  Show WAD entries (by type)
*
*
\****************************************************/


/*
** Show any kind of WAD entry
**
*/
Int16 EXPORT WADshowEntry(Int16 Self,Int16 Entry,pWINDOZE Wnd, Int16 Show)
{ Int32 res;
  Int32 start,size;
  IDENT id;
  Int16 what,picture; /*TRUE if must show picture*/
  pWADDEF This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /*list wasted space if -6666*/
  if(Entry==INVALIDINT)
  {
	 if(Show>0)
	 {
		WADIlistWaste(This,Wnd);
	 }
	 return SHOWE_LIST;
  }
  if((Entry<0)||(Entry>This->LstNb))
  { return ERRfault(BAD_PARM);}
  /*get entry params*/
  id=WADDgetEntryI(This,&start,&size,Entry);
  /*show nothing, by default*/
  res=0;
  what=SHOWE_NONE;
  picture=-1;
  /**/
  switch(id)
  {
#if (DLLFORDOOM)
	 case ESNDWAV:  /*WAV sound*/
		/*what|=SHOWE_NONE;*/
		if(Show>0)
		{ res=WADplaySound(This, Entry,WAD_SND_DOOM);}
		break;
	 case EPNAME:   /*PNAME texture*/
		what|=SHOWE_LIST;
		if(Show>0)
		{ res=WADPshowPnameI(This,Entry,Wnd);}
		break;
	 case ETEXU1: case ETEXU2:
		what|=SHOWE_LIST;
		if(Show>0)
		{ res=WADTshowTexLmpI(This,Entry,Wnd);}
		break;
	 case ELMPDMO:  /*Demo*/
		what|=SHOWE_LIST;
		if(Show>0)
		{ res=WADshowDemo(This,Entry,Wnd);}
		break;
	 case ELVLHDR:  /*Level header*/
		what|=SHOWE_LEVL;
		if(Show>0)
		{ res=WADLshowLevelAll(&(This->Dml),This,&(This->Bmp),Entry,Wnd);}
		break;
	 case EBEHAVE:  /*Level behaviour*/
		what|=SHOWE_LIST;
		if(Show>0)
		{ res= WADBshowBehav(This, Entry, Wnd);}
		break;
	 case ESECTOR:  /*Level sector*/
	 case ESIDEDEF: /*Level side def*/
		what|=SHOWE_LIST;
		if(Show>0)
		{ res=WADLshowList(&(This->Dml),This,Entry,id,Wnd);}
		break;
#endif /*DLLFORDOOM*/
	 /*
	 ** Text lump
	 */
	 case ELMPTXT:  /*actual textlump*/
		what|=SHOWE_LIST;
		if(Show>0)
		{ res=WADshowText(This,Entry,Wnd);}
		break;
	 /*
	 ** End screen
	 */
#if (DLLFORQUAK)
	 case EPK_BIN: /*Quake screen*/
#endif
#if (DLLFORDUKE)
	 case EDK_BIN: /*Duke BIN*/
#endif
#if (DLLFORDOOM)
	 case ELMPSCR:  /*end text lump*/
#endif
		what|=SHOWE_LIST;
		if(Show>0)
		{ res=WADshowCGA(This,Entry,Wnd);}
		break;
	 /*
	 ** Raw pictures
	 */
#if (DLLFORQUAK)
	 case EQKCON:   /*Quake console*/
#endif
#if (DLLFORDOOM)
	 case ELMPPIC:  /*FLAT lump*/
#endif /*DLLFORDOOM*/
		what|=SHOWE_PICB;
		if(Show>0)
		{ picture=WADflatToBmp(This,&(This->Bmp),Entry,&(Wnd->OfsX),&(Wnd->OfsY));}
		break;
	 /*
	 ** Palette
	 */
#if 0
	 case ELMPPAL: /*PLAYPAL lump*/
		what|=SHOWE_PICB;
		if(Show>0)
		{ picture= WADplaypalToBmp(This, Entry);}
		break;
#endif
	 default:
		switch(id&EMASK)
		{
#if (DLLFORDOOM)
		  case ESPRITE:  /*Doom sprites*/
			 what|= SHOWE_VIEW;
			 /*no break;*/
		  case EGRAPHIC: /*Doom general pictures*/
		  case EPATCH:   /*Doom patches*/
			 what|= (SHOWE_PICB|SHOWE_OFFS);
			 if(Show>0)
			 { picture= WADpicToBmp(This,&(This->Bmp),Entry,&(Wnd->OfsX),&(Wnd->OfsY));}
			 break;
		  case EFLAT: /*general Doom flats*/
			 what|=SHOWE_PICB;
			 if(Show>0)
			 { picture= WADflatToBmp(This,&(This->Bmp),Entry,&(Wnd->OfsX),&(Wnd->OfsY));}
			 break;
		  case EMUSIC:
			 /*what|=SHOWE_NONE;*/
			 if((Show>0)&&(This->Sound==TRUE))
			 { MUSplay(This->File,start,size);}
			 break;
#endif /*DLLFORDOOM*/
#if (DLLFORQUAK)
		  case EQKTEX:		/*special Quake texture*/
			 what|=SHOWE_PICB;
			 if(Show>0)
			 { picture=BSPtexuToBmp(This,&(This->Bmp),Entry); }
			 break;
		  case EQKPIC: /*special Quake picture*/
		  case EPK_PIC: /*LMP picture*/
			 what|=SHOWE_PICB;
			 if(Show>0)
			 { picture=WADqkpicToBmp(This,&(This->Bmp),Entry); }
			 break;
		  case EPK_WAV:  /*VOC sound*/
			 /*what|=SHOWE_NONE;*/
			 if(Show>0)
			 { res=WADplaySound(This, Entry,WAD_SND_WAV);}
			 break;
		  case EPK_SPR: /*sprites*/
			 what|=SHOWE_SDIR;
			 if(Show>0)
			 { res= SPRdirFramList(This,Entry,Wnd);}
			 break;
		  case EPK_BSP: /*bsp*/
			 what|=SHOWE_SDIR;
			 if(Show>0)
			 { res= BSPtexuDirList(This,Entry,Wnd);}
			 break;
		  case EPK_MDL: /*mdl*/
			 what|=SHOWE_SDIR;
			 if(Show>0)
			 { res= MDLdirSkinList(This, Entry,Wnd);}
			 break;
#endif
#if (DLLFORDUKE)
		  case EDK_VOC:  /*VOC sound*/
			 /*what|=SHOWE_NONE;*/
			 if(Show>0)
			 { res=WADplaySound(This, Entry,WAD_SND_VOC);}
			 break;
		  case EDK_ART: /*Duke ART*/
			 what|=SHOWE_SDIR;
			 if(Show>0)
			 { res=WADartDirList(This,Entry,Wnd);}
			 break;
#endif /*DLLFORDUKE*/

#if (DLLFORDUKE)
		  case EDK_TMB:  /*Duke TMB*/
		  case EDK_DAT: /*Duke DAT*/
		  /*case EDK_MAP:*/ /*Duke MAP*/
		  case EPK_DAT:
#endif
#if (DLLFORQUAK)
		  case EQKLMP:
		  case EPK_LMP:
#endif
		  case ELUMP: /*data lumps*/
			 what|=SHOWE_LIST;
			 if(Show>0)
			 { res=WADshowHex(This,Entry,Wnd);}
			 break;
		  /*
		  ** Text lump
		  */
#if (DLLFORQUAK)
		  case EPK_CFG:  /*Pack Config*/
		  case EPK_RC:   /*Pack Ressources*/
#endif
#if (DLLFORDUKE)
		  case EDK_CON:  /*Duke CON*/
#endif
			 what|=SHOWE_LIST;
			 if(Show>0)
			 { res=WADshowText(This,Entry,Wnd);}
			 break;
		  default:
			 what=SHOWE_NONE;
			 break;
		}
  }
  /*
  ** Show picture if needed
  */
  if((Show>0)&&(picture>=0))
  {
	 res= BMPassignToWindoze(&(This->Bmp),Wnd);
	 BMPfree(&(This->Bmp));
  }
  if(res<0)
  { return (Int16)res;}
  return what;
}
/*
** Show Sub Directory entry
*/
Int16 EXPORT WADsdirShow(Int16 Self,Int16 Entry,Int16 Sdir,pWINDOZE Wnd, Int16 Show)
{ Int32 res;
  IDENT id;
  Int16 what,picture;
  pWADDEF This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  if((Entry<0)||(Entry>This->LstNb))
  { return ERRfault(BAD_PARM);}
  /*get entry params*/
  id=WADDgetEntryI(This,NULL,NULL,Entry);
  /*show nothing, by default*/
  what=SHOWE_NONE;
  res=0;
  picture=-1;
  /**/
  switch(id&EMASK)
  {
#if (DLLFORQUAK)
	 case EPK_SPR:  /*Quake sprites*/
		what|=(SHOWE_PICB|SHOWE_SDIR);
		if(Show>0)
		{ picture=SPRdirToBmp(This, &(This->Bmp), Entry, Sdir);}
		break;
	 case EPK_MDL:  /*Quake sprites*/
		what|=(SHOWE_PICB|SHOWE_SDIR);
		if(Show>0)
		{ picture=MDLdirToBmp(This, &(This->Bmp),Entry, Sdir);}
		break;
	 case EPK_BSP:  /*Quake BSP*/
		what|=(SHOWE_PICB|SHOWE_SDIR);
		if(Show>0)
		{ picture=BSPtexuDirToBmp(This, &(This->Bmp),Entry, Sdir, TRUE);}
		break;
#endif /*DLLFORQUAK*/
#if (DLLFORDUKE)
	 case EDK_ART:  /*Duke Art*/
		what|=(SHOWE_PICB|SHOWE_SDIR);
		if(Show>0)
		{ picture=WADartToBmp(This, &(This->Bmp), Entry, Sdir);}
		break;
#endif /*DLLFORDUKE*/
		default:
		  return ERRfault(ERR_BUG);
  }
  /*
  ** Show picture if needed
  */
  if((Show>0)&&(picture>=0))
  {
	 res= BMPassignToWindoze(&(This->Bmp),Wnd);
	 BMPfree(&(This->Bmp));
  }
  if(res<0)
  { return (Int16)res;}
  return what;
}
/****************************************************\
*
*
*  Save WAD entries (by type)
*
*
\****************************************************/

/*
**
** save any kind of entry into file
**
*/
Int16 EXPORT WADsaveEntry(Int16 Self,Int16 Entry,pInt8 File)
{
  Int32 res;
  pInt8 Lmp;
  Int32 LmpSz;
  IDENT id;
  Int16 OfsX,OfsY;
  /**/
  pWADDEF This=WADgetThis(Self);
  if((This==NULL)||(This->Lst==NULL))
  { return ERRfault(ERR_BUG);}
  /*
  ** get identification
  */
  id=WADDgetEntryI(This,NULL,NULL,Entry);
  /*
  ** map the  Data into the right king of lump
  */
  switch(id)
  {
#if (DLLFORDOOM)
	 case ELVLHDR:  /*level headers, save level*/
		res= WADsaveLevelI(This, Entry, File);
		break;
	 case EBEHAVE: /*level behavior*/
		res= WADBsaveBehav(This, Entry, File);
		break;
	 case ESNDWAV: /*save WAV sound*/
		Lmp=WADreadEntryI(This,&LmpSz,Entry);
		if(Lmp==NULL) { return BAD_PARM;}
		res=SNDdoomWriteWav(File,Lmp, LmpSz);
		Free(Lmp);
		break;
#endif /*DLLFORDOOM*/
	 /*
	 ** Flat lumps: save as flat picture
	 */
#if (DLLFORQUAKE)
	 case EQKCON:   /*Quake console*/
#endif
	 case ELMPPIC:  /*FLAT lump*/
		res= WADflatToBmp(This,&(This->Bmp),Entry,&OfsX,&OfsY);
		if(res<0) return (Int16)res;
		return WADbmpToFile(This,File);
	 /*
	 ** General entry types
	 */
	 default:
		switch(id&EMASK)
		{ /*
		  ** Sprites, patches, graphics: save as BMP
		  */
#if (DLLFORDOOM)
		  case ESPRITE:     /*sprites*/
		  case EPATCH:      /*patches*/
		  case EGRAPHIC:        	/*general Doom pictures*/
			 res= WADpicToBmp(This,&(This->Bmp),Entry,&OfsX,&OfsY);
			 if(res<0) return (Int16)res;
			 return WADbmpToFile(This,File);
		  /*
		  ** Flats: save as BMP
		  */
		  case EFLAT:		/*general Doom flats*/
			 res= WADflatToBmp(This,&(This->Bmp),Entry,&OfsX,&OfsY);
			 if(res<0) return (Int16)res;
			 return WADbmpToFile(This,File);
		  /*
		  ** Music
		  */
		  case EMUSIC:            /*music*/
			 Lmp=WADreadEntryI(This,&LmpSz,Entry);
			 if(Lmp==NULL)  { return BAD_PARM;}
			 res = MUSsaveMidi(Lmp, LmpSz, File);
			 Free(Lmp);
			 break;
#endif /*DLLFORDOOM*/
		 /*
		 ** Duke
		 */
#if (DLLFORDUKE)
		  case EDK_VOC: /*Duke VOC*/
			 Lmp=WADreadEntryI(This,&LmpSz,Entry);
			 if(Lmp==NULL) { return BAD_PARM;}
			 /*save sound*/
			 res=SNDvocWriteWav(File,Lmp, LmpSz);
			 Free(Lmp);
			 break;
#endif /*DLLFORDUKE*/
		  /*
		  ** Quake
		  */
#if (DLLFORQUAK)
		  case EPK_PIC: /*Pack LMP Picture*/
		  case EQKPIC: /*special Quake picture*/
			 res=WADqkpicToBmp(This,&(This->Bmp),Entry);
			 if(res<0) return (Int16)res;
			 return WADbmpToFile(This,File);
#endif /*DLLFORQUAK*/
		  /*
		  ** Quake PACK stuff: save as raw
		  */
		  case EPK_BSP:   /*Pack BSP map entry*/
		  case EPK_DAT:   /*Pack DATa entry*/
		  case EPK_WAV:   /*Pack WAV entry*/
		  case EPK_RC:    /*Pack RC entry*/
		  case EPK_CFG:   /*Pack CFG config*/
		  case EPK_BIN:   /*Pack BIN end screen*/
		  case EPK_LMP:   /*Pack LMP*/
		  case EPK_MDL:   /*Pack MODel entry*/
		  case EPK_SPR:   /*Pack SPRite entry*/
		  case EPK_WAD:   /*Pack WAD entry*/
		  case EPACK:     /*Pack entries*/
		  /*
		  ** Quake WAD2 stuff
		  */
		  case EQKLMP:    /*special Quake lump*/
		  /*
		  ** Duke stuff
		  */
		  case EDK_CON:  /*Duke CON*/
		  case EDK_TMB:  /*Duke TMB*/
		  case EDK_BIN: /*Duke BIN*/
		  case EDK_DAT: /*Duke DAT*/
		  case EDK_MID: /*Duke MID*/
		  case EDK_ART: /*Duke ART*/
		  case EDK_MAP: /*Duke MAP*/
		  /*
		  ** DOOM lumps
		  */
		  case ELEVEL:      /*level parts*/
		  case ETEXTUR:	  /*textures and pnames*/
		  case ELUMP:		  /*general data */
		  default:         /* Unknown entry*/
			 Lmp=WADreadEntryI(This,&LmpSz,Entry);
			 if(Lmp==NULL)  { return BAD_PARM;}
			 /*read data, write it to file*/
			 res= FILEwriteData(Lmp,0,LmpSz,File);
			 Free(Lmp);
			 break;
		}
  }
  /*return */
  if(res<=0) return (Int16)res;
  return 1;
}
/*
** Save Sdir Entry
*/
Int16 EXPORT WADsdirSave(Int16 Self, Int16 Entry, Int16 Sdir, pInt8 File)
{
  Int32 res;
  IDENT id;
  /**/
  pWADDEF This=WADgetThis(Self);
  if((This==NULL)||(This->Lst==NULL))
  { return ERRfault(ERR_BUG);}
  id=WADDgetEntryI(This,NULL,NULL,Entry);
  switch(id&EMASK)
  {
#if (DLLFORDUKE)
	  case EDK_ART:
		 res=WADartToBmp(This, &(This->Bmp),Entry, Sdir);
		 break;
#endif /*DLLFORDUKE*/
#if (DLLFORQUAK)
	  case EPK_SPR:
		 res=SPRdirToBmp(This, &(This->Bmp), Entry, Sdir);
		 break;
	  case EPK_MDL:  /*Quake sprites*/
		 res = MDLdirToBmp(This, &(This->Bmp), Entry, Sdir);
		 break;
	  case EPK_BSP:
		 res=BSPtexuDirToBmp(This, &(This->Bmp),Entry, Sdir, FALSE);
#endif /*DLLFORDUKE*/
  }
  if(res<0) return (Int16)res;
  return WADbmpToFile(This,File);
}
/****************************************************\
*
*
*  Load WAD entries (by type)
*
*
\****************************************************/
/*
** Load any kind of entry into WAD
**
** The indicated type is used to guess how the entry shall
** be handled. The entry is replaced if it exists, or placed
** at Entry is possible. else, it's placed at the end.
*/
Int16 EXPORT WADloadEntry(Int16 Self,Int16 Entry, IDENT Id,pInt8 Name,pInt8 File)
{ Int32 res;
  pInt8 Lmp; Int32 LmpSz;
  pWADDEF This;
  /**/
  This=WADgetThis(Self);
  if((This==NULL)||(This->Lst==NULL))
  { return ERR_BUG;}
  /*
  ** Identify entry
  */
  Id = WADidentEntry(This,Id,Name);
  /*
  ** load level
  */
  if((Id==ELVLHDR)||(Id==ELEVEL))
  {
    res= WADloadLevelI(This,Entry,Name,File,0);
  }
  else
  { res=1;
    /*
    ** map the  Data into the right king of lump
    */
    switch(Id)
    { /*
      ** Flat lumps, load as Bmp
      */
#if (DLLFORDOOM)
      case ELMPPIC:  /*FLAT lump*/
        Lmp = WADloadFlat(This, &(This->Bmp), &LmpSz, File, -1);
        if(Lmp==NULL)
        { return ERR_SURE;}
      	 break;
      /*
      ** Sound card sound: load as Wav
      */
      case ESNDWAV:  /*WAV sound*/
      	/*read Wav file*/
        Lmp=SNDdoomReadWav(File,&LmpSz,-1);
        if(Lmp==NULL) return BAD_FILE;
        break;
#endif /*DLLFORDOOM*/
      default:
        switch(Id&EMASK)
        { /*
          ** Graphic,Sprites and patch: load as Bmp
	  ** with Offsets
	  */
#if (DLLFORDOOM)
	  case ESPRITE:     /*sprites*/
	  case EPATCH:      /*patches*/
	  case EGRAPHIC:    /*general Doom pictures*/
            Lmp = WADloadDoomPic(This,&(This->Bmp), &LmpSz, File, Entry, Id);
            if(Lmp==NULL)
            { return ERR_SURE;}
	    break;
	  /*
	  ** Flat: load as Bmp
	  */
	  case EFLAT:		/*general Doom flats*/
            Lmp = WADloadFlat(This,&(This->Bmp), &LmpSz, File, 1);
            if(Lmp==NULL)
            { return ERR_SURE;}
            break;
#endif /*DLLFORDOOM*/
	  /*
	  ** Unkown entry
	  */
	   default:
	     /*load as lump*/
	     /*
	     ** Quake PACK stuff: load as raw
	     */
	     case EPK_BSP:   /*Pack BSP map entry*/
	     case EPK_DAT:   /*Pack DATa entry*/
	     case EPK_WAV:   /*Pack WAV entry*/
	     case EPK_RC:    /*Pack RC entry*/
	     case EPK_MDL:   /*Pack MODel entry*/
	     case EPK_SPR:   /*Pack SPRite entry*/
	     case EPK_WAD:   /*Pack WAD entry*/
	     case EPACK:     /*Pack entries*/
	      /*
	      ** Level parts, textures, lumps, music:
	      ** load as lumps
	      */
	      case ELEVEL:   /*level part*/
	      case ETEXTUR:	/*textures and pnames*/
	      case ELUMP:		/*general data*/
	      case EMUSIC:            /*music*/
	        LmpSz=FILEgetSize(File);
	        if(LmpSz<0)
	        { return (Int16)LmpSz;} /*no file*/
	          Lmp=Malloc(LmpSz);
		  if(Lmp==NULL)
		  { return ERR_MEM;}
		    LmpSz=FILEreadData(Lmp,0,LmpSz,File);
#if (DLLFORDOOM)
		  switch(Id)
		  { case EBEHAVE:
		      if(WADBcheckBehav(Lmp,LmpSz)<0)
		      { Free(Lmp); return ERR_SURE;}
		      break;
		    case EMUSIC:
		      if(Strncmp(Lmp,"MUS",3)<=0)
		      { Free(Lmp); return ERRfaultWad(ERR_BADMUS);}
		      break;
		   }
#endif /*DLLFORDOOM*/
		   if(LmpSz<0)
		   { Free(Lmp); return ERR_SURE;}
		   break;
	      }
	 }
	 /*
	 ** load entry and return entry position
	 */
	 res= WADmodifyEntryI(This, Entry, Id, Name, Lmp, LmpSz);
	 if(Lmp!=NULL)
	 { Free(Lmp); }
  }
  /*
  ** identify entry is needed
  */
  if(res<0) return (Int16)res;
  if(Entry<0)
  /*
  ** save WAD directory, so that WAD be usable by other tools
  */
  WADHdirSaveI(This,1);
  return (Int16)res;
}
/*
** Re-Load level into WAD
**
*/
#if (DLLFORDOOM)
Int16 EXPORT WADloadLevel(Int16 Self,Int16 Entry, pInt8 File, Int16 What)
{ static Int32 res;
  static IDENT Id;
  static pWADDEF This;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  if(This->Lst==NULL)
  { return ERRfault(ERR_BUG);}
  if((Entry<0)||(Entry>=This->LstNb))
  { return ERRfault(BAD_PARM);}
  /**/
  Id = WADDgetEntryI(This,NULL,NULL,Entry);
  if(Id!=ELVLHDR)
  { return ERRfault(BAD_PARM);}
  /*
  ** re-load level
  ** What = 0 for level
  **        1 for nodes
  **        2 for reject
  */
  res= WADloadLevelI(This,Entry,WADDgetNameEntryI(This,Entry),File,What);
  /*
  ** save directory
  */
  WADHdirSaveI(This,1);
  if(res<=0) return (Int16)res;
  return 1;
}
#endif /*DLLFORDOOM*/
