/*
' Load some data, to be parsed as text
Declare Function TEXTloadData Lib "lb" (ByVal start&,ByVal size&,ByVal file$)
' Free the data
Declare Function TEXTfreeData Lib "lb" ()
' Find end of line, return 0 if not found
Declare Function TEXTgoEndLine Lib "lb" ()
'Find and read a long integer (+-1234567890)
Declare Function TEXTgetLong& Lib "lb" ()
' Find and read a file name (A-Za-z0-9._@)
' Dim Nam$ as string * NamSz%      NamSz%=16
Declare Function TEXTgetFileN% Lib "lb" (ByVal Nam$,ByVal NamSz%)
' Get a whole line of text
' Dim Txt$ as string * TxtSz%      TxtSz%=4096
Declare Function TEXTgetText% Lib "lb" (ByVal Txt$,ByVal TxtSz%)
'
' Check if text exists, reply 1 if ok, -1 if not ok
Declare Function TEXTcheckText% Lib "lb" (ByVal Txt$,ByVal TxtSz%)
'
' put a string in a listbox.
Declare Function LISTBloadString%  Lib "lb" (byval hLst%, byval dta$,byval size&)
' read a listbox into a string, returns length
Declare Function LISTBsaveString&  Lib "lb" (byval hLst%, byval dta$,byval size&)
*/


/* Load some data, to be parsed as text
*/
int  EXPORT TEXTloadData(long Start,long Size, LPCSTR File);
/* Free the data
*/
int  EXPORT TEXTfreeData(void);
/* Find end of line, return 0 if not found
*/
int  EXPORT TEXTgoEndLine(void);
/* Find and read a long integer (+-1234567890)
*/
long EXPORT TEXTgetLong(void);
/* Find and read a file name (A-Za-z0-9._@)
*/
int EXPORT TEXTgetFileN(LPSTR Name,int Size);
/* Get a whole line of text
*/
int  EXPORT TEXTgetText(LPSTR Name,int Size);
/* Check that text exists. Ignore controls, jump
** to text, and reply 1 if ok, -1 if not found
*/
int EXPORT TEXTcheckText(LPSTR Name,int Size);

/* Load a listbox from a string Str, of size=Size.
*/
int EXPORT LISTBloadData(HANDLE LstH, pChar Data,long Size);
/* Write a text listbox to a string, with \n.
** returns size
*/
long EXPORT LISTBsaveData(HANDLE LstH, pChar Data,long Size);

