/************************************************\
* WinTex, Copyright (c) 1995 Olivier Montanuy
*         (montanuy@lannion.cnet.fr)
* With Technical help from M.Mathews and R.Paquay.
*
* All rights reserved. Any commercial  usage is
* prohibited. Parts of this code can be used in
* freeware programs, provided WinTex is credited.
* This code comes with no guaranty whatsoever.
\************************************************/

#define WINTEXMODULE 'T'

/*
** Too slow. Must be made faster
*/


/*
** Warning: due to a bug in Borland C++, using tables
** with huge pointer is dangerous. don't use Foo[n],
** use a pointer to &(Foo[n].
*/

#include "lbwintex.h"
#include "lbcommon.h"
#include <stdlib.h>

#include "lbwad.h"
#include "lbdispl.h"
#include "lbtext.h"

#include "lbwaddef.h"
#include "lbdoom.h"
#include "lbwaddir.h"
#include "lbwadir.h"
#include "lbwadid.h"
#include "lbpatch.h"
#include "lbtexu.h"


#if (DLLFORDOOM)


Int16 WADTfreeI(pTXPOBJ Txp);
  /*
  ** Size
  */
static Int32 WADTsizeI(Int16 TexSz);
  /*
  ** Get texture lump
  */
static Int16 WADTgetTexLmpI(pTXPOBJ Txp, pInt8 Lmp, Int32 LmpSz, Int16 Main, Int16 Which);
  /*
  ** find texture
  */
static Int16 WADTfindTexI(pTXPOBJ Txp, pInt8 Name);
  /*
  ** set texture Texu (Name,szX,szY,TexP patch list)
  ** TexP is swallowed
  */
static Int16 WADTsetTexI(pTXPOBJ Txp, Int16 Texu,pInt8 Name, Int16 SzX, Int16 SzY, pTEXPAT TexP);
  /*
  ** insert texture at position Texu
  ** TexP is swallowed
  */
static Int16 WADTinsTexI(pTXPOBJ Txp, Int16 Texu, pInt8 Name, Int16 SzX, Int16 SzY,pTEXPAT TexP);
  /*
  ** delete texture
  */
static Int16 WADTdelTexI(pTXPOBJ Txp, Int16 Texu);
  /*
  ** Semi-clever add texture, at suggested position Texu
  ** delete exitsting texture with same name
  ** TexP is swallowed here
  */
static Int16 WADTaddTexI(pTXPOBJ Txp, Int16 Texu, pInt8 Name, Int16 SzX, Int16 SzY, pTEXPAT TexP, Int16 Main, Int16 Which);
  /*
  ** Set patch in texture
  ** add(Pat<0), replace(Pat>=0), delete(Name="\0"), move
  */
static Int16 WADTsetPatchI(pTXPOBJ Txp,Int16 Texu, Int16 Pat,pInt8 Name, Int16 OfsX, Int16 OfsY,Int16 Modif);



/****************************************************\
*
*
*  Texture sub-object
*
*
\****************************************************/

/*
** Allocate texture
*/
static Int32 WADTsizeI(Int16 TexSz)
{ return ((((Int32)TexSz+1)+0xFL)&(~0xFL))*(Int32)sizeof(struct TEXTURE);
}

	/*init*/
Int16 WADTinitI(pTXPOBJ Txp)
{
  /*init patch list*/
  Txp->Pat=NULL;Txp->PatNb=0;
  /*init texture*/
  Txp->Tex=NULL;Txp->TexNb=0;
  return 1;
}
/*
** release textures
** stop cacheing patches
** clean up the mess
*/
Int16 WADTfreeI(pTXPOBJ Txp)
{ Int16 i;
  pTEXTURE TTex;
  if(Txp==NULL)
  { return BAD_PARM;}
  /*stop cacheing patches*/
  WADPfreeI(Txp);
  /*stop texture*/
  if(Txp->Tex==NULL)
  { return 0;}
  if(Txp->TexNb>=0)
  { /*free all contained patch lists*/
	 for(i=0,TTex=Txp->Tex; i<Txp->TexNb; i++,TTex+=1)
	 { /*TTex= This->Tex[i]*/
		if(TTex->TexP!=NULL)
		  WADKfreeI(TTex->TexP);
	 }
  }
  /*free texture list*/
  Free(Txp->Tex);
  Txp->Tex=NULL;
  Txp->TexNb=0;
  return 1;
}
/*
** get a texture
*/
static pTEXTURE WADTgetTexI(pTXPOBJ Txp, Int16 Texu)
{
  if((Txp->TexNb<0)||(Txp->Tex==NULL))
  { ERRfault(ERR_BUG); return NULL;}
  if((Texu<0)||(Texu>=Txp->TexNb))
  { ERRfault(BAD_PARM); return NULL;}
  return &(Txp->Tex[Texu]);
}
/*
** find texture
*/
static Int16 WADTfindTexI(pTXPOBJ Txp, pInt8 Name)
{
  Int16 i;
  pTEXTURE TTex;
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { return ERRfault(ERR_BUG);}
  /**/
  for(i=0,TTex=Txp->Tex; i<Txp->TexNb; i++,TTex+=1)
  { /*TTex= This->Tex[i]*/
	 if(Strncmp(TTex->Name,Name,NORMALISELEN)) return i;
  }
  return -1;/*not found*/
}

/*
** set texture
*/
Int16 WADTsetTexI(pTXPOBJ Txp, Int16 Texu,pInt8 Name, Int16 SzX, Int16 SzY, pTEXPAT TexP)
{ pTEXTURE TTex;
  TTex=WADTgetTexI(Txp,Texu);
  if(TTex==NULL)
  { WADKfreeI(TexP); return ERR_BUG;}
  if((Name!=NULL)&&(Name[0]!='\0'))
  { Normalise(TTex->Name,Name);}
  if((SzX>0)&&(SzX<=4096))
  { TTex->SzX =SzX;}
  if((SzY>0)&&(SzY<=256))
  { TTex->SzY =SzY;}
  /*replace existing patch list*/
  if(TexP!=NULL)
  { if(TTex->TexP!=NULL) { WADKfreeI(TTex->TexP);}
	 TTex->TexP=TexP;
  }
  /*
  ** Declare texture is modified
  */
  TTex->Age=TEXNEW;
  return Texu;
}
/*
** insert a new texture
** TexP is swallowed here
*/
static Int16 WADTinsTexI(pTXPOBJ Txp, Int16 Texu, pInt8 Name, Int16 SzX, Int16 SzY,pTEXPAT TexP)
{ Int16 t;
  pTEXTURE TTex;
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { WADKfreeI(TexP); return ERRfault(ERR_BUG);}
  /*insert at the end if needed*/
  if((Texu<0)||(Texu>=Txp->TexNb))
  { Texu=Txp->TexNb;}
  /*add one entry*/
  t=Txp->TexNb;
  Txp->TexNb+=1;
  if(WADTsizeI(Txp->TexNb)>WADTsizeI(t))
  {
	 Txp->Tex=Realloc(Txp->Tex,WADTsizeI(Txp->TexNb));
	 if(Txp->Tex==NULL)
	 { Txp->TexNb=0; WADKfreeI(TexP); return ERR_MEM;}
  }
  /*move if needed*/
  t=Txp->TexNb-1;
  for(TTex=&(Txp->Tex[t]); t>Texu; t--,TTex-=1)
  { Memcpy(TTex,TTex-1,sizeof(struct TEXTURE));
  }
  /*default parameters*/
  TTex=&(Txp->Tex[Texu]);
  TTex->TexP=NULL;  /*still empty*/
  TTex->Age=TEXNEW; /*new texture*/
  TTex->Id=1;    /*Texture1*/
  return WADTsetTexI(Txp, Texu, Name, SzX, SzY,TexP);
}
/*
** delete texture
*/
static Int16 WADTdelTexI(pTXPOBJ Txp, Int16 Texu)
{ Int16 t;
  pTEXTURE TTex;
  TTex=WADTgetTexI(Txp,Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  /*release patch list*/
  WADKfreeI(TTex->TexP);
  /*move textures*/
  t=Texu+1;
  for(TTex=&(Txp->Tex[t]); t<Txp->TexNb; t++,TTex+=1)
  {
	 Memcpy(TTex-1,TTex,sizeof(struct TEXTURE));
  }
  /*remove one texture*/
  Txp->TexNb-=1;
  /*do not realloc*/
  return 1;
}
/*
** replace or create a new texture, allocate reference
** the list of patches, TexP, is swallowed here
*/
static Int16 WADTaddTexI(pTXPOBJ Txp, Int16 Texu, pInt8 Name, Int16 SzX, Int16 SzY,pTEXPAT TexP, Int16 Main, Int16 Which)
{
  Int16 Texu2;
  pTEXTURE TTex;
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { WADKfreeI(TexP); return ERRfault(ERR_BUG);}
  if((Which!=1)&&(Which!=2))
  { WADKfreeI(TexP); return ERRfault(BAD_PARM);}
  /*allocate a new void patch list*/
  if(TexP==NULL)
  { return ERRfault(ERR_BUG);}
 /*try to find the texture*/
  Texu2=WADTfindTexI(Txp, Name);
  if(Texu2>=0)
  {
	 TTex=&(Txp->Tex[Texu2]);
	 /*
	 ** If we duplicate an existing texture, keep the
	 ** old texture defintion, and return.
	 */
	 if((TTex->SzX==SzX)&&(TTex->SzY==SzY))
	 {	if(WADKcmpI(TTex->TexP,TexP))
		{ WADKfreeI(TexP); return Texu2;}
	 }
	 /*
	 ** Modify an existing texture with same name.
	 ** So delete this texture.
	 */
	 if(WADTdelTexI(Txp,Texu2)<0)
	 { WADKfreeI(TexP); return Texu2;}
	 /* Update position, after the deletion */
	 if(Texu2<Texu)
	 { Texu = Texu-1;}
  }
  if(Texu<0)
  { /*
	 ** create a new texture, TexP is swallowed
	 */
	 Texu=WADTinsTexI(Txp,-1,Name,SzX,SzY,TexP);
	 if(Texu<0) { return Texu;}
	 /*
	 ** determine if texture is old or new
	 */
	 TTex=&(Txp->Tex[Texu]);
	 TTex->Id = Which; /*texture 1 or 2*/
	 if(Main==TRUE) { TTex->Age =TEXOLD;}
	 return Texu;
  }
  /*
  ** Modify an existing texture
  ** TexP is swallowed
  */
  return WADTinsTexI(Txp, Texu, Name, SzX, SzY, TexP);
}
/*
** add(Pat<0), replace(Pat>=0), delete(Name="\0"), move
*/
static Int16 WADTsetPatchI(pTXPOBJ Txp,Int16 Texu, Int16 Pat,pInt8 Name, Int16 OfsX, Int16 OfsY,Int16 Modif)
{
  pTEXPAT TexP;
  pTEXTURE TTex;
  TTex=WADTgetTexI(Txp,Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  switch(Modif)
  { case MODIF_INS: /*ins*/
		return ERRfault(ERR_BUG);
	 case MODIF_SET: /*replace*/
		WADKsetPatI(Txp,TTex->TexP,Pat,Name,OfsX,OfsY);
		TexP=TTex->TexP;
		break;
	 case MODIF_DEL: /*delete*/
		TexP=WADKdelPatI(TTex->TexP,Pat);
		break;
	 case MODIF_ADD: /*add*/
		TexP=WADKaddPatI(Txp,TTex->TexP,Name,OfsX,OfsY);
		break;
  }
  if(TexP==NULL) { return BAD_PARM;}
  /*
  ** Declare texture is modified
  */
  TTex->Age=TEXNEW;
  /**/
  TTex->TexP=TexP;
  return 1;
}




/****************************************************\
*
*
* Handles texture lumps
*
*
\****************************************************/
/*
** decode a lump, declare all textures
*/
static Int16 WADTgetTexLmpI(pTXPOBJ Txp, pInt8 Lmp, Int32 LmpSz, Int16 Main, Int16 Which)
{ pDMTEXULMP DmHead;
  pDMTEXU DmTexu;
  pTEXPAT TexP;
  Int16 nbtexu,t,nbpatch;
  Int32 res,texuptr,texusz;
  if((Txp->Tex==NULL)||(Txp->TexNb<0)||(Lmp==NULL))
  { return ERRfault(ERR_BUG);}
  DmHead=(pDMTEXULMP)Lmp;
  nbtexu=(Int16)DmHead->NbTexu;
  if(nbtexu<=0) { return ERRfault(BAD_ENTRY);}
  /*check size of vector is correct*/
  res=(Int32)(sizeof(struct DMTEXULMP)-sizeof(Int32))+((Int32)nbtexu)*sizeof(Int32);
  if(res>LmpSz) { return ERRfault(BAD_ENTRY);}
  /*read textures*/
  for(t=0;t<nbtexu;t++)
  { /*get pointer to texture*/
	 texuptr=DmHead->Texu[t];
	 DmTexu=(pDMTEXU)(&Lmp[texuptr]);
	 /*check valid. if not, take next*/
	 if((texuptr<=0)||(texuptr+sizeof(*DmTexu)>LmpSz))
	 { continue; } /*should also report an error*/
	 /*get texture*/
	 /*get patch list*/
	 nbpatch=DmTexu->NbPat;
	 /*check patch size is valid*/
	 if(nbpatch<0)
	 { continue; } /*should report an error*/
	 /*check patch list fits in lump*/
	 texusz=(sizeof(struct DMTEXU)-sizeof(struct DMPATCH))+((Int32)nbpatch)*sizeof(struct DMPATCH);
	 if(texuptr+texusz>LmpSz)
	 { continue; } /*should report an error*/
	 /*
	 ** decode patch reference
	 ** this supposes that the patch lump PNAMES was loaded
	 */
	 TexP=WADKinitI(Txp,&(DmTexu->Pat[0]),nbpatch);
	 if(TexP==NULL)
	 { continue; } /*should report an error*/
	 /*declare new texture*/
	 res=WADTaddTexI(Txp,-1,DmTexu->Name, DmTexu->SzX, DmTexu->SzY,TexP, Main,Which);
	 if(res<0) {return (Int16)res;}
  }
  return t;
}
/*
** encode the texture list into a lump
** if Main==FALSE, don't include texture from main WAD
*/
static pInt8 WADTsetTexLmpI(pTXPOBJ Txp, pInt32 pLmpSz, Int16 Main, Int16 Which)
{ pDMTEXULMP DmHead;
  pDMTEXU DmTexu;
  pTEXTURE TTex;
  pInt8 Lmp; Int32 LmpSz;
  Int32 texuptr,texusz;
  Int16 nbtexu,nbpatch,t,tt;
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { ERRfault(ERR_BUG); return NULL;}
  if((Which!=1)&&(Which!=2))
  { ERRfault(ERR_BUG); return NULL;}
  /*Evaluate nbtexu and size of lump*/
  for(nbtexu=0,texusz=0,t=0,TTex=Txp->Tex; t<Txp->TexNb; t++,TTex+=1)
  { /*TTex= Txp->Tex[t]*/
	 /*ignore textures from main WAD, if necessary*/
	 if((Main==FALSE)&&(TTex->Age==TEXOLD)) continue;
	 /*ignore texture from other lump*/
	 if(TTex->Id!=Which) continue;
	 /*ignore void textures*/
	 if(TTex->TexP==NULL) continue;
	 /*ignore empty textures*/
	 nbpatch=WADKlengthI(TTex->TexP);
	 if(nbpatch<0) continue;
	 /*sizeof texture*/
	 texusz+=sizeof(*DmTexu)+((Int32)nbpatch-1)*sizeof(*DmTexu->Pat);
	 nbtexu++;
  }
  texuptr=(Int32)sizeof(*DmHead)+((Int32)nbtexu-1)*sizeof(DmHead->Texu);
  LmpSz=texuptr+texusz;
  if(nbtexu<=0) return NULL;
  /*Allocate memory*/
  Lmp=Malloc(LmpSz);
  if(Lmp==NULL) return NULL;
  /*implicitly, the pnames lump will go with this*/
  /*texture lump*/
  /*put all texture in lump*/
  DmHead=(pDMTEXULMP)Lmp;
  DmHead->NbTexu=nbtexu;
  for(t=0,tt=0,TTex=Txp->Tex; t<Txp->TexNb; t++,TTex+=1)
  { /*TTex=Txp->Tex[t]*/
	 /*ignore textures from main WAD, if necessary*/
	 if((Main==FALSE)&&(TTex->Age==TEXOLD)) continue;
	 /*ignore texture from other lump*/
	 if(TTex->Id!=Which) continue;
	 /*ignore void textures*/
	 if(TTex->TexP==NULL) continue;
	 /*ignore empty textures*/
	 nbpatch=WADKlengthI(TTex->TexP);
	 if(nbpatch<0) continue;
	 /*sizeof texture*/
	 texusz=sizeof(*DmTexu)+((Int32)nbpatch-1)*sizeof(*DmTexu->Pat);
	 /*coherency check*/
	 if(texuptr+texusz>LmpSz)
	 { ERRfault(ERR_BUG); break;}
	 /*set pointer*/
	 DmHead->Texu[tt]=texuptr;
	 /*write texture*/
	 DmTexu=(pDMTEXU)(&Lmp[texuptr]);
	 Normalise(DmTexu->Name,TTex->Name);
	 DmTexu->dummy0=0L;
	 DmTexu->SzX= TTex->SzX;
	 DmTexu->SzY= TTex->SzY;
	 DmTexu->dummy00=0L;
	 DmTexu->NbPat=nbpatch;
	 /*copy the patches*/
	 WADKcopyI(Txp,&(DmTexu->Pat[0]),TTex->TexP);  /*&(DmTexu->Pat); *//*BUG*/
	 /*next texture position*/
	 tt++; texuptr+=texusz;
  }
  /*return lump*/
  *pLmpSz=LmpSz;
  return Lmp;
}

/****************************************************\
*
*
*  save all textures and PNAMES
*
*
\****************************************************/

  /* save all texture and PNAME to WAD*/
  /* this must be done before WADTfree*/
Int16 EXPORT WADTsaveAll(Int16 Self)
{ Int16 res,t;
  Bool saveTex1,saveTex2;
  pInt8 Lmp;
  Int32 LmpSz;
  pTEXTURE TTex;
  pWADDEF This;
  pTXPOBJ Txp;
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  Txp=&(This->Txp);
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { return ERRfault(ERR_BUG);}
  /*
  ** Clear up the patch reference count, and prepare to count
  ** only the patches that are in use. This must be done in order
  ** to ensure that the patches references are correct
  */
  WADPusedNoneI(Txp);
  /*
  ** Detect the textures that actually changed
  */
  saveTex1=saveTex2=FALSE;
  for(t=0,TTex=Txp->Tex;t<Txp->TexNb;t++,TTex+=1)
  { /*TTex=Txp->Tex[t]*/
	 if(TTex->Age!=TEXOLD)
	 { /*
		** Save both textures, otherwise modified PNAMES list
		** could bug the non modified texture
		*/
		/*if(TTex->Id==2)*/
		  saveTex2=TRUE;
		/*else*/
		  saveTex1=TRUE;
	 }
  }
  res=0;
  /*
  ** Declare patches used in texture1,so that PNAMES
  ** indexes are corrects
  **   Requires that the patch module be initialised
  */
  Lmp=WADTsetTexLmpI(Txp, &LmpSz, TRUE, 1);
  /*
  ** Save TEXTURE1 if needed
  */
  if(Lmp!=NULL)
  {
	 if(saveTex1==TRUE)
	 { res|=WADmodifyEntryI(This,0,ETEXU1,"TEXTURE1",Lmp,LmpSz);}
	 Free(Lmp);
  }
  else
  { saveTex1=FALSE;}

  /*
  ** Declare patches used in texture2, so that PNAMES
  ** indexes are corrects
  **   Requires that the patch module be initialised
  */
  Lmp=WADTsetTexLmpI(Txp, &LmpSz, TRUE, 2);
  /*
  ** Save TEXTURE2 if needed
  */
  if(Lmp!=NULL)
  {
	 if(saveTex2==TRUE)
	 { res|=WADmodifyEntryI(This,0,ETEXU2,"TEXTURE2",Lmp,LmpSz); }
	 Free(Lmp);
  }
  else
  { saveTex2=FALSE; }
  /*
  ** save PNAMES if needed
  */
  if((saveTex1==TRUE)||(saveTex2==TRUE))
  { res|=WADPsaveAllI(Txp,This);
  }
  /*
  ** save WAD directory, so that WAD be usable by other tools
  */
  WADHdirSaveI(This,1);
  /*returns negative, if failure*/
  return res;
}

/*
** Read texture definitions from lump
**
*/
Int16 EXPORT WADTreadTexLmp(Int16 Self, pInt8 File)
{ pInt8 Lmp;
  Int32 LmpSz,res;
  pWADDEF This;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  {return BAD_PARM;}
  /*
  ** Read File
  */
  LmpSz=FILEgetSize(File);
  if(LmpSz<=0)
  { return ERRfault(BAD_FILE);}
  Lmp=Malloc(LmpSz);
  if(Lmp==NULL) { return ERR_MEM;}
  res=FILEreadData(Lmp,0,LmpSz,File);
  if(res<0)
  { Free(Lmp); return ERR_SURE;}
  /*
  ** Get Tex Lmp
  */
  res=WADTgetTexLmpI(&(This->Txp), Lmp, LmpSz, FALSE,1);
  Free(Lmp);
  return (Int16)res;
}
/*
** decode a lump, report all textures in a list
*/
Int16 WADTshowTexLmpI(pWADDEF This, Int16 Entry, pWINDOZE Wnd)
{ pDMTEXULMP DmHead;
  pDMTEXU DmTexu;
  pInt8 Lmp; Int32 LmpSz;
  Int16 nbtexu,t,nbpatch;
  Int32 res,texuptr;
  TXTOBJ Txt;
  /**/
  if(This==NULL){return BAD_PARM;}
  Lmp=WADreadEntryI(This,&LmpSz,Entry);
  if(Lmp==NULL) {return BAD_PARM;}
  /**/
  DmHead=(pDMTEXULMP)Lmp;
  nbtexu=(Int16)DmHead->NbTexu;
  if(nbtexu<=0)
  { return ERRfault(BAD_ENTRY);}
  /*check that size of vector is correct*/
  res=(Int32)sizeof(*DmHead)+((Int32)nbtexu-1)*sizeof(DmHead->Texu);
  if(res>LmpSz)
  { return ERRfault(BAD_ENTRY);}
  /**/
  TXTinitWnd(&Txt,NORMALISELEN+10,Wnd);
  /*read textures*/
  for(t=0;t<nbtexu;t++)
  { /*get pointer to texture*/
	 texuptr=DmHead->Texu[t];
	 DmTexu=(pDMTEXU)(&Lmp[texuptr]);
	 /*check valid. if not, take next*/
	 if((texuptr<=0)||(texuptr+sizeof(*DmTexu)>LmpSz))
	 { Free(Lmp); return ERRfault(BAD_ENTRY); } /*should also report an error*/
	 /*get texture*/
	 /*get patch list*/
	 nbpatch=DmTexu->NbPat;
	 /*check patch size is valid*/
	 if(nbpatch<0)
	 { Free(Lmp); return ERRfault(BAD_ENTRY); } /*should report an error*/
	 /*check patch list fits in lump*/
	 res=texuptr+sizeof(*DmTexu)+((Int32)nbpatch-1)*sizeof(*DmTexu->Pat);
	 if(res>LmpSz)
	 { Free(Lmp); return ERRfault(BAD_ENTRY); } /*should report an error*/
	 /*
	 ** declare new texture in list
	 */
	 TXTprintName8XY(&Txt,t,DmTexu->Name, DmTexu->SzX, DmTexu->SzY);
  }
  TXTfree(&Txt);
  return t;
}




/****************************************************\
*
*
* Texture clipboard
*
*
\****************************************************/

/*
** Texture copy paste structure
*/
typedef struct TCLIPB PTR *pTCLIPB;
struct TCLIPB
{
  Int32 Check;       /*check: 666*/
  pTCLIPB Next;       /*next*/
  Int8  Name[NORMALISELEN];/*Name of entry*/
  pTEXPAT TexP; /*patches in texture*/
  Int16 SzX;      /*width:  8,16,32,64,128,256,512,1024,2048*/
  Int16 SzY;      /*height: 1 to 128*/
};

static pTCLIPB WADTclipb=NULL;
/*
** Unlink one texture from tclipB
*/
static Int16 WADTclipbRemove(void)
{
  pTCLIPB tclipb;
  tclipb = WADTclipb;
  if((tclipb==NULL)||(tclipb->Check!=666))
  { return 0;}
  WADTclipb = tclipb->Next;
  /* Free data */
  if(tclipb->TexP!=NULL) WADKfreeI(tclipb->TexP);
  /* Free clib structure*/
  Free(tclipb);
  return 1;
}
/*
** Link
*/
static Int16 WADTclipbAdd(pTEXPAT TexP, pInt8 Name, Int16 SzX, Int16 SzY)
{ pTCLIPB tclipb;
  tclipb = Malloc(sizeof(struct TCLIPB));
  if(tclipb==NULL)
  { return 0;}
  /*link with next*/
  tclipb->Next=WADTclipb;
  tclipb->Check=666;
  /*copy data*/
  tclipb->TexP= WADKduplicateI(TexP);
  tclipb->SzX= SzX;
  tclipb->SzY= SzY;
  Normalise(tclipb->Name,Name);
  /*put in front of list*/
  WADTclipb=tclipb;
  return 1;
}
/*
** clear the clipboard
*/
Int16 EXPORT WADTclipbClear(void)
{
  Int16 n;
  for(n=0;n<256;n++)
  {
	 if(WADTclipbRemove() <= 0) break;
  }
  WADTclipb=NULL;
  return 1;
}
/*
** Copy one texture into clipboard
**  entry = reference of texture
*/
Int16 EXPORT WADTclipbCopy(Int16 Self, Int16 Texu)
{
  pWADDEF This;
  pTEXTURE TTex;
  Int8 Name[NORMALISELEN+2];
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return ERR_BUG;}
  /*
  ** Get texture
  */
  TTex=WADTgetTexI(&(This->Txp),Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  Normalise(Name,TTex->Name);
  /*
  ** Add in clipboard
  */
  return WADTclipbAdd(TTex->TexP,Name,TTex->SzX,TTex->SzY);
}
/*
** Paste all entries into WAD
**  Entry = suggested position
** The clipboard is not cleared down after this operation
*/
Int16 EXPORT WADTclipbPaste(Int16 Self, Int16 Texu)
{
  pTCLIPB tclipb;
  pTXPOBJ Txp;
  pTEXPAT TexP;
  pWADDEF This=WADgetThis(Self);
  Int16 n,pat,OfsX,OfsY;
  Int8 Name[NORMALISELEN+2];
  /**/
  if(This==NULL) return ERR_BUG;
  Txp= &(This->Txp);
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { return ERRfault(ERR_BUG);}
  /**/
  for(tclipb= WADTclipb,n=0; n<0x400; n++, tclipb = tclipb->Next)
  {
	 if(tclipb==NULL) break;
	 /*
	 ** Insert texture in texture list
	 */
	 if(tclipb->Check==666)
	 {
		Normalise(Name,tclipb->Name);
		/*void patch list*/
		TexP=WADKinitI(Txp,NULL,0);
		if(TexP!=NULL)
		{ /* TexP is swallowed*/
		  Texu=WADTaddTexI(Txp, Texu, Name, tclipb->SzX, tclipb->SzY, TexP, FALSE, 1);
		  if(Texu<0) break;
		  /*
		  ** List all patches in tclipb->TexP and add them to texture
		  */
		  for(pat=0; pat< WADKlengthI(tclipb->TexP); pat++)
		  {
			 if(pat>64) break; /*security*/
			 WADKgetPatI(tclipb->TexP,pat,Name,&OfsX,&OfsY);
			 WADTsetPatchI(Txp,Texu, pat, Name, OfsX, OfsY,MODIF_ADD);
		  }
		  /* Do not free clipb->TexP*/
		}
	 }
  }
  return n;
}

/****************************************************\
*
*
*  External
*
*
\****************************************************/
/*
** Allocate texture lump
** Start texture, and start cacheing patches
** Read texture lump in main WAD and in PWAD
** Which=1 for Texture1, Which=2 for Texture 2
*/
Int16 EXPORT WADTinit(Int16 Self)
{ Int16 res;
  pInt8 Lmp;
  Int32 LmpSz;
  pWADDEF This;
  pTXPOBJ Txp;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /*
  ** check that Tex was free. if not, free it
  */
  Txp=&(This->Txp);
  if(Txp->Tex!=NULL)
  { WADTfreeI(Txp);}
  /*
  ** Start cacheing actual patches
  */
  res= WADPinitI(Txp,This);
  if(res<0) return res;
  /*
  ** Allocate memory
  */
  Txp->TexNb=0;
  Txp->Tex=Malloc(WADTsizeI(Txp->TexNb));
  if(Txp->Tex==NULL)
  { WADPfreeI(Txp); return ERR_MEM;}
  /*
  ** Read texture lump from WAD or main WAD
  */
  Lmp=WADreadObligEntryI(This,&LmpSz,"TEXTURE1");
  if(Lmp!=NULL)
  {
	 WADTgetTexLmpI(Txp,Lmp,LmpSz,TRUE,1);
	 Free(Lmp);
  }
  Lmp=WADreadObligEntryI(This,&LmpSz,"TEXTURE2");
  if(Lmp!=NULL)
  {
	 WADTgetTexLmpI(Txp,Lmp,LmpSz,TRUE,2);
	 Free(Lmp);
  }
  return 1;
}
/*
** Free Texture
*/
Int16 EXPORT WADTfree(Int16 Self)
{
  pWADDEF This;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return ERR_BUG;}
  /**/
  return WADTfreeI(&(This->Txp));
}
/*
** Find texture
*/
Int16 EXPORT WADTfindTex(Int16 Self, pInt8 Name)
{ pWADDEF This;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return ERR_BUG;}
  if(Name==NULL)
  { return ERRfault(BAD_PARM);}
  /**/
  return WADTfindTexI(&(This->Txp), Name);
}

/*
** return name and size, from reference
** name must be of size NORMALISELEN+2 at least
*/
Int16 EXPORT WADTgetTex(Int16 Self, Int16 Texu, pInt8 Name, pInt16 SzX, pInt16 SzY)
{ pWADDEF This;
  pTEXTURE TTex;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /**/
  TTex=WADTgetTexI(&(This->Txp),Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  /**/
  *SzX=TTex->SzX;
  *SzY=TTex->SzY;
  /*space padded*/
  if(Name!=NULL) return NormalizeS(Name,TTex->Name);
  return 1;
}
/*
** add(Tex<0), replace(Tex>=0), delete(Name="\0")
*/
Int16 EXPORT WADTsetTex(Int16 Self, Int16 Texu, pInt8 Name, Int16 SzX, Int16 SzY, Int16 Modif)
{ pTEXPAT TexP;
  pWADDEF This;
  pTXPOBJ Txp;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /**/
  Txp=&(This->Txp);
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { return ERRfault(ERR_BUG);}
  /**/
  switch(Modif)
  { case MODIF_DEL:
	 case MODIF_SET: /*Texu=position*/
		if(Texu<0)
		{ return ERRfault(BAD_PARM);}
		/* no break;*/
	 case MODIF_INS: /*Texu=-1 end  Texu>0 = position*/
		if(Texu>=Txp->TexNb)
		{ return ERRfault(BAD_PARM);}
		break;
	 case MODIF_ADD:
		if((Name!=NULL)&&(Name[0]!='\0'))
		{ break;}
		/*no break;*/
	 default:
		return ERRfault(BAD_PARM);
  }
  /*replace*/
  switch(Modif)
  { case MODIF_DEL: /*delete*/
		return WADTdelTexI(Txp, Texu);
		/*break;*/
	 case MODIF_ADD:
		Texu=-1;
		/*no break;*/
	 case MODIF_INS:
		/*
		** create an empty patch list
		*/
		TexP=WADKinitI(Txp,NULL,0);
		if(TexP==NULL) { return ERR_MEM;}
		/*
		** add texture in list, killing previous texture
		** TexP is swallowed
		*/
		return WADTaddTexI(Txp, Texu,Name, SzX, SzY, TexP, FALSE,1);
	 case MODIF_SET:
		break;
  }
  /*
  ** Modify texture
  */
  return WADTsetTexI(Txp, Texu, Name, SzX, SzY,NULL);
}

/*
** list all textures into listB.hWnd. report name,ofsx,ofsy,
** texture reference
** which filters texture 1 or 2 (if <0, no filter)
** new filters old 0 and new 1(if <0, no filter)
*/
Int16 EXPORT WADTlistTex(Int16 Self, pWINDOZE Wnd, Int16 Which, Int16 New)
{ Int16 i;
  pTEXTURE TTex;
  pWADDEF This;
  pTXPOBJ Txp;
  TXTOBJ Txt;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  Txp=&(This->Txp);
  if((Txp->Tex==NULL)||(Txp->TexNb<0))
  { return ERRfault(ERR_BUG);}
  /**/
  TXTinitWnd(&Txt,NORMALISELEN+10,Wnd);
  for(i=0,TTex=Txp->Tex; i<Txp->TexNb; i++,TTex+=1)
  { /*TTex= This->Tex[i]*/
	 if((New==0)&&(TTex->Age!=TEXOLD))continue;
	 if((New>0)&&(TTex->Age==TEXOLD))continue;
	 /**/
	 if(Which>0)
	 { if(TTex->Id != Which) continue;}
	 TXTprintName8XY(&Txt,i,TTex->Name,TTex->SzX,TTex->SzY);
  }
  TXTfree(&Txt);
  return 1;
}

/*
** list all patches into listB.hWnd. report name,ofsx,ofsy,
** patch reference
*/
Int16 EXPORT WADTlistPatch(Int16 Self, Int16 Texu, pWINDOZE Wnd)
{ Int16 p,sz;
  pTEXTURE TTex;
  Int8 Name[NORMALISELEN];
  Int16 OfsX; Int16 OfsY;
  pWADDEF This;
  TXTOBJ Txt;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /**/
  TTex=WADTgetTexI(&(This->Txp),Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  /*list all patches in texture*/
  sz=WADKlengthI(TTex->TexP);
  if(sz<0) return sz;
  /**/
  TXTinitWnd(&Txt,NORMALISELEN+10,Wnd);
  for(p=0;p<sz;p++)
  {
	 if(WADKgetPatI(TTex->TexP,p,Name,&OfsX,&OfsY)<0)break;
	 TXTprintName8XY(&Txt,p,Name,OfsX,OfsY);
  }
  TXTfree(&Txt);
  return 1;
}

/*
** add(Pat<0), replace(Pat>=0), delete(Name="\0"), move
*/
Int16 EXPORT WADTsetPatch(Int16 Self,Int16 Texu, Int16 Pat,pInt8 Name, Int16 OfsX, Int16 OfsY,Int16 Modif)
{
  pWADDEF This;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /**/
  switch(Modif)
  { case MODIF_DEL:
		break;
	 case MODIF_SET:
		if(Pat<0)
		{ return ERRfault(BAD_PARM);}
		break;
	 case MODIF_INS:
		if(Pat<0)
		{ return ERRfault(BAD_PARM);}
		/*no break;*/
	 case MODIF_ADD: /*add*/
		if((Name!=NULL)&&(Name[0]!='\0'))
		{ break;}
		/*no break;*/
	 default:
		{ return ERRfault(BAD_PARM);}
  }
  return WADTsetPatchI(&(This->Txp),Texu,Pat,Name,OfsX,OfsY,Modif);
}
/*
** display texture
*/
Int16 EXPORT WADTshowTex(Int16 Self, Int16 Texu, pWINDOZE PicB)
{ Int16 OfsX, OfsY;
  pInt8 Pat;
  Int16 PatSzX,PatSzY;
  pTEXTURE TTex;
  pWADDEF This;
  pTXPOBJ Txp;
  Int16 p,sz,err;
  Int8 Name[NORMALISELEN];
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /**/
  Txp=&(This->Txp);
  TTex=WADTgetTexI(Txp,Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  /*
  ** display all patches in texture
  */
  sz=WADKlengthI(TTex->TexP);
  if(sz<0) return sz;
  /*
  ** make sure all patches are cached
  ** because Bmp will be unusable during texture display
  ** NOT EFFICIENT. Double search in PNAMES!!!
  */
  for(err=0,p=0;p<sz;p++)
  {
	 if(WADKgetPatI(TTex->TexP,p,Name,&OfsX,&OfsY)<0)
	 { break; }
	 Pat=WADPcacheBmpI(Txp,This,&(This->Bmp), Name);
	 if((Pat==NULL)&&(err<=0))
	 { err=1; /*don't repeat error*/
		ERRfaultWad(ERR_PATABSNT);
	 }
  }
  /*allocate a clean SzXxSzY Bmp*/
  BMPinit(&(This->Bmp),TTex->SzX,TTex->SzY,8,NULL,1);
  /*clear Bmp with transp color, set current palette*/
  BMPclear(&(This->Bmp),-1);
  for(p=0;p<sz;p++)
  {
	 if(WADKgetPatI(TTex->TexP,p,Name,&OfsX,&OfsY)<0)break;
	 Pat=WADPgetBmpI(Txp, Name, &PatSzX, &PatSzY);
	 if(Pat==NULL)
	 { continue; }/*no patch?*/
	 BMPputBmp(&(This->Bmp),OfsX,OfsY,Pat,PatSzX,PatSzY);
  }
  /*
  ** display bitmap
  */
  err= BMPassignToWindoze(&(This->Bmp),PicB);
  BMPfree(&(This->Bmp));
  return err;
}
/*
** Check Texture
*/
/*
** get patch Pat from texture Texu. assumes Name[NORMALISELEN+2]
*/
Int16 EXPORT WADTgetPatch(Int16 Self,Int16 Texu, Int16 Pat,pInt8 Name, pInt16 pOfsX, pInt16 pOfsY)
{
  pTEXTURE TTex;
  Int8 Name2[NORMALISELEN];
  pWADDEF This;
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /**/
  TTex=WADTgetTexI(&(This->Txp),Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  /*
  ** Get patch
  */
  WADKgetPatI(TTex->TexP,Pat,Name2,pOfsX,pOfsY);
  return NormalizeS(Name,Name2);
}


/*
** check texture
** return 1 if ok, 2 if meduza feared
**        0 if not ok
*/
#if 0
Int16 EXPORT WADTcheckTex(Int16 Self,Int16 Texu)
{
  pWADDEF This;
  pTEXTURE TTex;
  Int16 OfsX, OfsY;
  Int16 p,sz,err;
  Int8 Name[NORMALISELEN];
  /**/
  This=WADgetThis(Self);
  if(This==NULL)
  { return BAD_PARM;}
  /**/
  TTex=WADTgetTexI(&(This->Txp),Texu);
  if(TTex==NULL)
  { return ERR_BUG;}
  /*
  ** get all patches in texture
  */
  sz=WADKlengthI(TTex->TexP);
  if(sz<0) return sz;
  for(err=0,p=0;p<sz;p++)
  {
	 if(WADKgetPatI(TTex->TexP,p,Name,&OfsX,&OfsY)<0)
	 { break; }
	 Pat=WADPcacheBmpI(Txp,This,&(This->Bmp), Name);
	 if((Pat==NULL)&&(err<=0))
	 { err=1; /*don't repeat error*/
		ERRfaultWad(ERR_PATABSNT);
	 }
  }
  return 1;
}
#endif /*0*/

#endif /*DLLFORDOOM*/
