#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */
/*
** Type of DLL functions supported
*/
	/*
	** 1 for DOOM handling
	*/
#define DLLFORDOOM 1
	/*
	** 1 for Quake handling
	*/
#define DLLFORQUAK 1
	/*
	** 1 for Duke 3D handling
	*/
#define DLLFORDUKE 1
/*
** Games type definition
*/
#define GAM_MASK 0xFF0
#define GAM_NONE 0x000
#define GAM_DOOM 0x010
#define GAM_HTIC 0x020
#define GAM_HEXN 0x040
#define GAM_STRF 0x080
#define GAM_QUAK 0x100
#define GAM_DUKE 0x200
#define GAM_PACK 0x800

#define GAM_SHAR 0x0
#define GAM_REGS 0x1
#define GAM_CMRC 0x2
/*
** Entry identification codes
** low  byte = type
** high byte = subtype
*/
#define EMASK     (0x0FF) /*mask to get the type*/
#define EWHAT	   (0x080) /*unidentified entries*/
   /*
   ** DOOM DOOM2 HERETIC HEXEN
   */
#define EVOID	   (0x010) /*void entrye*/
#define E_STA     (0x011) /*start marker*/
#define E_END     (0x012) /*end marker*/
#define ES_STA    (0x511) /*sprite start S_START*/
#define ES_END    (0x512) /*sprite end   S_END*/
#define EP_STA    (0x611) /*patch start  P_START*/
#define EP_END    (0x612) /*patch end    P_END*/
#define EF_STA    (0x711) /*flat start   F_START*/
#define EF_END    (0x712) /*flat end     F_END*/
#define ETEXNAM   (0x018) /*texture names. not a real type*/
#define ELEVEL	   (0x000) /*0=level, and parts*/
#define  ETHING   (0x100)
#define  ELINEDEF (0x200)
#define  ESIDEDEF (0x300)
#define  EVERTEX  (0x400)
#define  ESEGS    (0x500)
#define  ESSECTOR (0x600)
#define  ENODE    (0x700)
#define  ESECTOR  (0x800)
#define  EREJECT  (0x900)
#define  EBLOCKMP (0xA00)
#define  ELVLHDR  (0xB00) /*Level headers*/
#define  EBEHAVE  (0xC00) /*BEHAVIOUR of Hexen*/
#define  ESCRIPT  (0xD00) /*BEHAVIOUR of Hexen*/
#define ELUMP	   (0x001) /*lumps*/
#define  ELMPTXT  (0x101) /*text lump*/
#define  ELMPPAL  (0x201) /*palette lump*/
#define  ELMPMAP  (0x301) /*color map lump*/
#define  ELMPPIC  (0x401) /*picture lump*/
#define  ELMPSCR  (0x501) /*end screen lump*/
#define  ELMPDMO  (0x601) /*demo*/
#define  ELMPACS  (0x701) /*heretic2 ACS*/
#define ESOUND	   (0x002) /*2=sound*/
#define  ESNDPC	(0x102) /*DOOM PC speaker sound*/
#define  ESNDWAV  (0x202) /*DOOM WAV sound*/
#define ETEXTUR	(0x003) /*Textures*/
#define  ETEXU1   (0x103) /*texture1*/
#define  ETEXU2   (0x203) /*texture2*/
#define  EPNAME	(0x303) /*pnames*/
#define EGRAPHIC  (0x004) /*Graphics*/
#define  EGRAPHSP (0x104) /*special graphic, alternate palette*/
#define ESPRITE	(0x005) /*Sprites*/
#define EPATCH 	(0x006) /*Patches*/
#define EFLAT	   (0x007) /*Flats*/
#define  EFLATH1  (0x107) /*Heretic special 64x65 flat*/
#define  EFLATH2  (0x207) /*Hexen  special 64x128 flats*/
#define EMUSIC	   (0x008) /*Music*/
   /*
   ** Quake PACK
   */
#define EPK_BSP  (0x0A0) /*Pack BSP map entry*/
#define EPK_DAT  (0x0A1) /*Pack DATa entry*/
#define EPK_WAV  (0x0A2) /*Pack WAV entry*/
#define EPK_RC   (0x0A3) /*Pack RC entry*/
#define EPK_MDL  (0x0A4) /*Pack MODel entry*/
#define EPK_SPR  (0x0A5) /*Pack SPRite entry*/
#define EPK_WAD  (0x0A6) /*Pack WAD entry*/
#define EPK_CFG  (0x0A7) /*Pack Config*/
#define EPK_BIN  (0x0A8) /*Pack End Screen*/
#define EPK_LMP  (0x0A9) /*Pack LMP*/
#define EPK_PAL  (0x1A9) /*Pack LMP palette*/
#define EPK_COL  (0x2A9) /*Pack LMP Colormap*/
#define EPK_PIC  (0x0AA) /*Pack LMP picutre*/
#define EPACK    (0x0AF) /*Pack general entry*/
	/*
	** Quake WAD2
	*/
#define EQKLMP   (0x040) /*Quake lump*/
#define EQKPIC   (0x042) /*Quake picture*/
#define EQKTEX   (0x044) /*Quake texture*/
#define EQKCON   (0x045) /*Quake console*/
   /*
   ** Duke Nukem 3D
   */
#define EDK_CON  (0xD1)  /*Duke CON*/
#define EDK_TMB  (0xDA)  /*Duke TMB*/
#define EDK_BIN  (0xDB)  /*Duke BIN*/
#define EDK_DAT  (0xDD)  /*Duke DAT*/
#define EDK_PAL  (0x1DD) /*Duke Palette*/
#define EDK_VOC  (0xD2)  /*Duke VOC*/
#define EDK_MID  (0xD8)  /*Duke MID*/
#define EDK_ART  (0xD4)  /*Duke ART*/
#define EDK_MAP  (0xD0)  /*Duke MAP*/
   /*
   ** Type for Entry Identification
   */
typedef Int16 IDENT;
   /*
   ** Windows handling structure
   */
#define WINDOZE_PICTBOX (666)
#define WINDOZE_LISTBOX (777)
#define WINDOZE_DROPBOX (999)
typedef struct
{ Int16 Type;  /*type WINDOZE_xxx*/
  Int32 hWnd;   /* HWND Handle on a window*/
  Int32 hDC;    /* HDC Handle on a DC*/
  Int32 hBitmap;/* HBITMAP*/
  Int32 hPal;   /* HPALETTE*/
  Int16 SzX;    /* bitmap width*/
  Int16 SzY;    /* bitmap height*/
  Int16 OfsX;   /* offset X*/
  Int16 OfsY;   /* offset Y*/
}WINDOZE;
typedef WINDOZE PTR *pWINDOZE;
   /*
   ** LEVEL  handling structure
   */
typedef struct
{
  Int16 SzX;  /*Screen height,width*/
  Int16 SzY;
  Int32 ScalX;/*Scale X,Y for screen*/
  Int32 ScalY;
  Int32 OfsX; /*Offsets X,Y for screen*/
  Int32 OfsY;
  Int32 Xmin; /*min*/
  Int32 Ymin;
  Int32 Zmin;
  Int32 Xmax; /*max*/
  Int32 Ymax;
  Int32 Zmax;
  Int32 X;    /*viewpoint X*/
  Int32 Y;    /*viewpoint Y*/
  Int32 Z;    /*viewpoint Y*/
  Int32 Phi;  /*in degree*/
  Int32 The;  /*in degree*/
}BOUND;
typedef BOUND PTR *pBOUND;
   /*
   ** BSP LEVEL handling structure
   */
typedef struct
{
  Int32 Id;  /*type of BSP object*/
  Int32 Nb;  /*Nb of elements*/
  Int32 N;   /*Id of element*/
  Int32 N2;
  Int32 PlanType;
  Int32 NodeFront;
  Int32 NodeBack;
  Int32 TinfTexu;
  Float32 TinfSoffs;
  Float32 TinfToffs;
  Int16 FaceLType;
  Int16 FaceShadow;
  Int16 FaceLite1;
  Int16 FaceLite2;
  Int32 LeafType;
  Int32 ModlNode;
  Int32 ModlClip;
  Int32 ModlClip2;
  Int32 ModlClip3;
  Int32 ModlLeafNb;
  Int8  TexuName[16];
}BSPINFOS;
typedef BSPINFOS PTR *pBSPINFOS;


/****************************************************\
*
* WAD/WAD2/PAK/KEN file handling basic services
*
\****************************************************/
	/*
	** Init WAD object (call first!)
	**  File = name of the WAD/WAD2/PAK/KEN file
	**  Main = reference of main WAD object, or <0
	**  Lock = if >0 the WAD cannot be modified
	**  Transparent = transparent color, in windows RGB style
	**  returns object reference, or <0 if error
	*/
#define WAD_LOCK_YES 1
#define WAD_LOCK_NO  -1
Int16 EXPORT WADinit(pInt8  File,Int16 Main,Int16 Lock,Int32 Transparent);
	/*
	** Free the WAD object  (call last!)
	** Save = if > 0, save directory
	**        if <0, cancel any previous modifications
	*/
#define WAD_SAVE_OK  1
#define WAD_SAVE_NO  0
#define WAD_SAVE_RS  -1
Int16 EXPORT WADfree(Int16 Self, Int16 Save);
	/*  Set customs parameters
	**   ErrWnd = error windows
	*/
Int16 EXPORT WADsetCustoms(Int16 Self, Int32 ErrWnd);
	/*
	** check status of a WAD object
	** returns a bit mask that describe what is available
	** or allocated. 0 if the WAD object doesn't exist.
	*/
Int16 EXPORT WADcheck(Int16 Self);
	/*
	** Get information about the WAD
	** pGame =  return identification of the game
	** pMainWad = return ref. of te main wad object
	** pDirDirty = return >0 if WAD dir was modified, not saved
	** File = return name of WAD file (128 characters)
	** returns the exact size of File. <0 if error
	*/
Int16 EXPORT WADgetInfos(Int16 Self, pInt16 pGame, pInt16 pMainWad, pInt16 pDirDirty, pInt8 File);
	/*
	** Save WAD directory, so that WAD becomes usable.
	** take any modification into account
	*/
Int16 EXPORT WADsaveDir(Int16 Self);
	/*
	** Restore a WAD file that was modified
	**  File = name of existing WAD file
	**  Safe = if>0, then restore only add/merge
	** Compatible with DeuTex, DeuSF and WinTex.
	** Not compatible with NWT.
	** returns 0 if safe, and modifs may be lost.
	**         >0 if successful.
	*/
Int16 EXPORT WADrestore(pInt8 File, Int16 Safe);
	/*
	** cleanup PWAD into another WAD
	** ignoring any WAD compression
	*/
Int16 EXPORT WADcleanup(Int16 Self, pInt8 File);
	 /*
	 ** Check WAD
	 ** hList = listbox where to put the result
	 **  THIS FUNCTION IS NOT CODED YET
	 */
Int16 EXPORT WADcheckWad(Int16 Self, pWINDOZE hList);


/****************************************************\
*
* FIND/GET/SET//LIST WAD ENTRIES
*
\****************************************************/
	/*
	** Get information about a WAD entry
	** Entry = ref. of entry in WAD
	** pStart = return start of entry
	** pSize = return size of entry
	** return Identification of entry, <0 if error
	*/
Int16 EXPORT WADgetEntry(Int16 Self, pInt32 pStart, pInt32 pSize, Int16 Entry);
	/*
	** Find a WAD entry
	** Here = position whence to start searching
	** Name = name of the entry
	** returns entry reference in WAd, <0 if error
	*/
Int16 EXPORT WADfindEntry(Int16 Self, Int16 Here, pInt8 Name);
	/*
	** Set a WAD entry
	** Here = position of entry
	** Name = if !=NULL, new name of the entry
	** Start = if > 0 new start of the entry
	** Size = if > 0 new size of the entry
	** Id = if > 0 new identification of the entry
	** Modif= 1=ADD 2=INSERT 3=SET 4=DELETE
	** Modify Start or Size only if >=0
	** returns position of the entry
	** the WAD directory is not updated on file.
	*/
Int16 EXPORT WADsetEntry(Int16 Self, Int16 Here, pInt8 Name, Int32 Start, Int32 Size, Int16 Id, Int16 Modif);
	/*
	** list entries in directory, according to type.
	**  Wnd = listbox where to list entries
	**        ItemData will contain entry id and reference
	**  Type = type of entries to list.
	**        if<0, all entries.
	**        if sub type, only that sub type.
	**  Entry= entry to look for
	** returns position of entry
	*/
Int16 EXPORT WADlistDir(Int16 Self, pWINDOZE Wnd, Int16 Type, Int16 Entry);
	/*
	**  List all PWAD/IWAD entrie with references
	**   if Type has a general type, list that type
	**   in Type has a subtype, list only the subtype
	**  returns 1
	*/
Int16 EXPORT WADlistAll(Int16 Self, pWINDOZE Wnd, Int16 Type);

/****************************************************\
*
* GENERAL PURPOSE WAD API
*  Display, Load, Save, Checks
*
\****************************************************/
	/*
	** Check the name of an entry, warn user if needed.
	** Name = Entry name
	** Type = proposed entry type (general type)
	** Text   = text buffer, for message
	** Textsz = buffer size
	**  return <0 if error or refused, entry Id if accepted
	*/
Int16 EXPORT WADentryCheckId(Int16 Self, Int16 Type, pInt8 Name, pInt8 Text, Int16 TextSz);
	/*
	** Show any entries, depending on type.
	** Entry = reference of the entry
	** Wnd = window for picture/level/lists
	** Show = if <0, then do not display anything
	**			 if >0, then display the relevant data
	** returns the type of what is to be displayed
	** (call first with show<0, set the right window, call again with show>0)
	*/
Int16 EXPORT WADshowEntry(Int16 Self,Int16 Entry, pWINDOZE Wnd, Int16 Show);
	/*returned value of WADshowEntry or WADsdirShow is:*/
#define SHOWE_NONE 0  /*no entry shown*/
#define SHOWE_PICB 1  /*show a picture*/
#define SHOWE_OFFS 2  /*     with offsets*/
#define SHOWE_VIEW 4  /*     with views*/
#define SHOWE_LIST 8  /*show a list */
#define SHOWE_LEVL 16 /*show a level map*/
#define SHOWE_SDIR 32 /*show a entry subdirectory list*/
	/*
	** Show Sub Directory entry
	**  Entry = entry containing the SubDir
	**  Sdir = entry in the subdir
	** Wnd = window for picture/level/lists
	** Show = if <0, then do not display anything
	**			 if >0, then display the relevant data
	** returns the type of what is to be displayed
	** (call first with show<0, set the right window, call again with show>0)
	*/
Int16 EXPORT WADsdirShow(Int16 Self,Int16 Entry,Int16 Sdir,pWINDOZE Wnd, Int16 Show);
	/*
	** Set special parameters
	**  Sound: <0 ignored,=0 no sound, >0 sound
	*/
Int16 EXPORT WADsetParams(Int16 Self, Int16 Sound);
	/*
	** Show an entry, by name rather than by entry ref.
	** PicB = picture box where entry is shown
	** Ident = EPATCH or EFLAT
	** Name = name of the patch or flat
	** Search in PWAD first, then in main WAD.
	*/
Int16 EXPORT WADshowByName(Int16 Self,pWINDOZE PicB,Int16 Id, pInt8 Name);
	/*
	** Save any entry to a file
	** Entry = reference of entry. must be valid.
	** File = name of the file. must be valid.
	** The format of File will depend on the entry type
	*/
Int16 EXPORT WADsaveEntry(Int16 Self,Int16 Entry,pInt8 File);
	/*
	** Save a subdir entry
	** File = file where art is saved
	** Entry = entry containing the ART
	** Sdir =  entry in subdir
	** File = name of the file. must be valid.
	** The format of File will depend on the entry type
	*/
Int16 EXPORT WADsdirSave(Int16 Self, Int16 Entry, Int16 Sdir, pInt8 File);
	/*
	** Load an entry from a file into the directory,
	** replacing existing entry, or inserting a new entry
	** Entry = suggested position of entry, can be <0
	** Id = identification of the entry
	** Name = name for the entry
	** File = file name where the data is.
	**   File will be read depending on entry Id
	**
	*/
Int16 EXPORT WADloadEntry(Int16 Self, Int16 Entry,IDENT Id,pInt8 Name,pInt8 File);
	/*
	** Load a level map, or part of it
	** Entry = position of existing level header
	** File = a WAD file that contains a level
	** What = 0: all level  1:nodes and blockmap 2:only reject
	*/
#define WAD_LEV_ALL 0
#define WAD_LEV_NODE 1
#define WAD_LEV_REJECT 2
Int16 EXPORT WADloadLevel(Int16 Self,Int16 Entry, pInt8 File, Int16 What);
	/*
	** Set offsets of DOOM picture
	** Entry = picture entry (must be sprite or patch or graphic)
	** OfsX = X offset
	** OfsY = Y offset
	*/
Int16 EXPORT WADsetOffsets(Int16 Self, Int16 Entry, Int16 OfsX, Int16 OfsY);
	/*
	** Change colormap for picture display
	** Entry = Colormap entry (if <0, use COLORMAP in main WAD)
	** Mapref = Which colormap (if <0, restore normal one)
	*/
Int16 EXPORT WADcolorMap(Int16 Self,Int16 Entry,Int16 Mapref);
	/*
	** show the bitmap associated to a window
	**  Wnd = Window containing the bitmap
	**  Ops = if >0 init the Wnd object
	**        if == 0 display the bitmap associated to Wnd
	**        if <0 free the Wnd object
	*/
Int16 EXPORT WADshowWindoze(pWINDOZE Wnd, Int16 ops);


/****************************************************\
*
* CLIPBOARD
*
\****************************************************/
   /*
   ** clear clipboard
   */
Int16 EXPORT WADclipbClear(void);
   /*
   ** Copy one entry from WAD into clipboard
   **  Entry = reference of entry
   ** Must copy entries from the end to the start of list
   */
Int16 EXPORT WADclipbCopy(Int16 Self, Int16 Entry);
   /*
   ** Copy all entries from cliboard to WAD
   **  Entry = suggested position
   ** return <=0 if clipboard is empty
   */
Int16 EXPORT WADclipbPaste(Int16 Self, Int16 Entry);

/****************************************************\
*
* DOOM TEXTURE EDITING
*
\****************************************************/
	/*
	** Init Texture object
	**  Start texture, and start cacheing patches
	**  Read textures and PNAMES from PWAD or main WAD
	*/
Int16 EXPORT WADTinit(Int16 Self);
	/*
	** Get texture name and size
	**  Texu = reference of texture
	**  Name = returns name of texutre
	**  pSzX, pSzY = returns size X and Y of texture
	*/
Int16 EXPORT WADTgetTex(Int16 Self, Int16 Texu, pInt8 Name, pInt16 pSzX, pInt16 pSzY);
	/*
	** Set Texture name and size
	**  Modif = type of modification (set, insert, delete, add)
	*/
Int16 EXPORT WADTsetTex(Int16 Self, Int16 Texu, pInt8 Name, Int16 SzX, Int16 SzY, Int16 Modif);
	/*
	** Find a texture
	**  Name = name of texture
	** returns <0 if error, or index of texture
	*/
Int16 EXPORT WADTfindTex(Int16 Self, pInt8 Name);
	/*
	** List textures.
	**  Wnd:   Window where to list textures
	**  Which: 1=TEXTURE1 2=TEXTURE1 if<0, both texture lumps
	**  New:   0=old textures  1=new textures  if<0, all texture
	*/
Int16 EXPORT WADTlistTex(Int16 Self, pWINDOZE Wnd, Int16 Which, Int16 New);
	/*
	** Display a texture
	**  Wnd = window where to list texture
   **  Texu = reference of texture
	*/
Int16 EXPORT WADTshowTex(Int16 Self, Int16 Texu, pWINDOZE PicB);
	/*
	** add(Pat<0), replace(Par>=0), delete(Name="\0"), move
	*/
Int16 EXPORT WADTsetPatch(Int16 Self,Int16 Texu, Int16 Pat,pInt8 Name, Int16 OfsX, Int16 OfsY, Int16 Modif);
	/*
	** get patch Pat in texture Texu, into Name, OfsX, OfsY
	** Name must be string*10
	*/
Int16 EXPORT WADTgetPatch(Int16 Self,Int16 Texu, Int16 Pat,pInt8 Name, pInt16 pOfsX, pInt16 pOfsY);
	/*
	** list patches. Name, OfsX, OfsY. ItemData= patch reference
	*/
Int16 EXPORT WADTlistPatch(Int16 Self, Int16 Texu, pWINDOZE hList);
	/*
	** save all texture and PNAME to WAD
	*/
Int16 EXPORT WADTsaveAll(Int16 Self);
	/*
	** free textures, stop cacheing patches,clean up
	*/
Int16 EXPORT WADTfree(Int16 Self);
	/*
	** Clear texture clipboard
	*/
Int16 EXPORT WADTclipbClear(void);
	/*
	** Copy texture in clipboard
	*/
Int16 EXPORT WADTclipbCopy(Int16 Self, Int16 Texu);
	/*
	**  Paste textures from clipboard
	*/
Int16 EXPORT WADTclipbPaste(Int16 Self, Int16 Texu);


/****************************************************\
*
* DOOM LEVEL DISPLAY
*
\****************************************************/
	/*
   ** get Xmin Xmax Ymin Ymax of a level
   */
Int16 EXPORT WADLboundLevel(Int16 Self, Int16 Entry, pBOUND Bound);
	/*
   ** set Xmin Xmax Ymin Ymax of a boudn box
	** Modif= 0,1= left/right 2,3=up/down
	** 0x10=zoom out 0x11=zoom in
   */
Int16 EXPORT WADLboundScale(pBOUND Bound, Int16 X, Int16 Y, Int16 Modif);
	/*
	** Point to an object of a given type
	** returns the identifier of that object, or -1
	** if Id=ELINDEF, Point to linedef
	** if Id=ESIDEDEF, Point to sidedef
	** if Id=ESECTOR, Point to sector
	** if Id=ENODE, Point to node. return a node, and depth
	** if Id=EREJECT, get reject for sector at X,Y
	*/
Int32 EXPORT WADLpointObject(Int16 Self, Int16 Entry, IDENT Id, Int16 Object, Int16 X, Int16 Y, Int16 OX, Int16 OY);
	/*
	** Modify reject data
	**  Entry = level header
	**  Target = Target sector (player sector)
	**  Sector = monster sector
	**  Ops = 0 toggle Sector can/can't see Target
	**        1 make target safe
	**        2 make target unsafe
	** returns status of reject
	*/
#define WADL_REJ_TOGGLE 0
#define WADL_REJ_SAFE 1
#define WADL_REJ_UNSAFE 2
Int16 EXPORT WADLmodifyReject(Int16 Self, Int16 Entry, Int16 Target, Int16 Sector, Int16 Ops);
	/*
	** Modify sidedef data
	**  Entry = ref. of level header
	**  Obj = Sidedef number or Secotr number
	**  Ops = 0 Set texture names from Texu
	**        1 Get texture names into Texu
	**  Texu[24] = Upper[8]   Lower[8] Middle[8]
	**  Texu[24] = Ceiling[8] Floor[8]
	**        Texu must of size 24 at least.
	** returns >0 if ok
	*/
#define WADL_SIDE_SET 0
#define WADL_SIDE_GET 1
#define WADL_SECT_SET 2
#define WADL_SECT_GET 3
Int16 EXPORT WADLmodifTexu(Int16 Self, Int16 Entry, Int16 Obj, Int16 Ops, pInt8 Texu);
	/*
	** Draw the linedefs, nodes, reject... of a level map
	** Depending on Id, display the object Obj
	** highlighted. Use only level entries for Id
	*/
Int16 EXPORT WADLshowLevel(Int16 Self, Int16 Entry, Int16 Obj, IDENT Id, pBOUND Bound, pWINDOZE PicB);
	/*
	** Save level part
	*/
Int16 EXPORT WADLsaveLevel(Int16 Self, Int16 Entry, IDENT Id);


   /*
   ** Append sprites to a WAD
   **  Force = <0 check if needed,  =0 do not force, >0 force
   ** return <0 if not needed, 0 if dubious(S_END), >0 if needed
   */
Int16 EXPORT WADappSprites(Int16 Self, Int16 Force);

/****************************************************\
*
* QUAKE BSP levels
*
\****************************************************/

   /*
   ** Init BSP model from entry
   */
Int16 EXPORT BSPinit(Int16 Self, Int16 Entry);
   /*
   ** Free BSP model
   */
Int16 EXPORT BSPfree(Int16 Self);
   /*
   ** Save a BSP model
   */
Int16 EXPORT BSPsave(Int16 Self);
   /*
   ** Check BSP model
   **  report problems in windows
   **  return >0 if ok, <0 if problems
   */
Int16 EXPORT BSPcheck(Int16 Self, pWINDOZE Wnd);
   /*
   ** Show BSP level
   **  Wnd = picture box
   **  Bound = Bound box
   **  Obj = ref. of object to check
   **  Type = type of object
   */
Int16 EXPORT BSPshow(Int16 Self, pWINDOZE Wnd, pBOUND Bound, Int32 Obj, Int16 Type);
   /*
   ** Show/Modify BSP element
   */
Int16 EXPORT BSPmodify(Int16 Self, pBSPINFOS Infos, Int16 What);

/****************************************************\
*
* HELP ON ENTRY AND TYPES
*
\****************************************************/
	/*
	** Get Entry/Ident for ItemData
	**  *pId = Entry identification
	**  Code = Entry code = LstB.ItemData(n)
	**  Returns Entry ref in PWAD.
	*/
Int16 EXPORT HELPdecodeEntry(pInt16 pId, Int32 Code);
	/*
	** Get type and Index of button
	**  *pIndex = -1 or Index of the type selection button (0...9)
	**  Game = Current game
	**  Id   = Type of entry, or -1
	**  returns Type and *pIndex
	*/
Int16 EXPORT HELPgetIdxType( pInt16 pIndex,Int16 Game, Int16 Id);
	/*
	** List the entries of the given type into drop box
	**  Type= types of entries listed
	**  Game= which game is it for? 0x10=doom; 0x12=doom2...
	*/
void EXPORT HELPforWad(pWINDOZE hLstB, IDENT Type,Int16 Game);
	/*
	** Find if a given name is matched
	**  Type= types of entries listed
	**  Game= which game is it for? 0x10=doom; 0x12=doom2...
	** returns <0 if name not matched
	** returns 0 if name contains illegal Int8
	** returns 1 if name is matched
	*/
Int16 EXPORT HELPfindName(pInt8 Name, IDENT Type, Int16 Game);
	/*
	** Give help test for a name
	**  Name =  name searched
	**  Type = Type searched  (-1=all)
	**  Game = game searched
	**  Text = buffer
	**  TextSz = size of buffer
	** returns actual size of text, or <0 if error
	*/
Int16 EXPORT HELPforName(pInt8 Name, IDENT Type, Int16 Game,pInt8 Text,Int16 TextSz);
	/*
	** Give the name of a type
	**  Type = entry type to be identified
	**  Text = buffer
	**  TextSz = size of buffer
	** returns actual size of text
	*/
Int16 EXPORT HELPforType(Int16 Type,pInt8 Text,Int16 TextSz);
   /*
   ** HELP for file extension
   **  Id = entry type
   **  Ops = 1:file to load   0:file to save
   **  Ext = string, to write the resulting extension
   **  ExtSz = size of string
   ** returns the type of editor for the file
   */
#define FILE_TXT 0x0 /*text*/
#define FILE_LMP 0x1 /*data lump*/
#define FILE_BMP 0x2
#define FILE_WAV 0x3
#define FILE_VOC 0x4
#define FILE_MID 0x5
#define FILE_RC  0x6
#define FILE_CFG 0x7
#define FILE_WAD 0x10 /*level editor*/
#define FILE_MUS 0x11
#define FILE_SCR 0x12 /*end screen*/
#define FILE_ACS 0x13 /*ACS scripts*/
#define FILE_BSP 0x14 /*bsp map*/
#define FILE_MDL 0x15 /*alias model*/
#define FILE_SPR 0x16 /*sprite model*/
#define FILE_OBJ 0x17 /*.o*/
#define FILE_MAP 0x20 /*Duke levels*/
#define FILE_ART 0x21 /*Duke art*/
#define FILE_DAT 0x22 /*Duke data*/
#define FILE_CON 0x23 /*Duke text*/
#define FILE_TMB 0x24 /*Duke tmb*/
#define FILE_BIN 0x25 /*Duke bin*/
Int16 EXPORT HELPfileForType(Int16 Id, Int16 Ops);

#ifdef __cplusplus
}            /* Assume C declarations for C++ */
#endif  /* __cplusplus */
