'("$Id: DOOM.LSP 1.4 1995/05/30 13:51:38 Reini Exp $")
;;;* DOOM.LSP
;;; (c) URBAN Reinhard 1995
;;;ͻ
;;; URBAN Utilities fr AutoCAD                   V 2.9        
;;; (c) Reinhard URBAN, A-Graz, 1994-95                        
;;; E-Mail: rurban@sbox.tu-graz.ac.at                          
;;; AutoCAD R12 int. + deutsch Zusatzprogramme, 1991-95        
;;;ͼ
;;; Description:
;;;   Writes a Doom (Doom,Doom2,Heretic) WAD with WADOUT
;;;   accepts closed polylines as sectors.
;;;   Edit the default textures, set DOSENV DOOMDIR to DOOM?.EXE
;;;   Reedit the created WAD with DEEP or DCK
;;;   (especially convert overlapping lines to 2-sided... in the error checker)
;;;
;;;   DWDOUT was rejected because of problems with IDBSP,
;;;   DWDIN should work, but not tested again.
;;;   Interface to the DOOM DWD Format
;;;   Works with WAD_DWD.EXE, which converts a WAD to a DWD and
;;;   IDBSP.EXE V1.1, which builds a WAD from a DWD.

;;; Programs:
;;;   WADIN        - reads a WAD File
;;;   WADOUT       - writes a WAD File
;;;   DWDIN        - reads a DWD File
;;;  *EDITSECTOR   - Edit Sector(s)
;;;  *MAKESECTOR   - Joins Lines to a Sector with appr. EED's
;;;  *SPLITSECTOR  - Explodes a secto to lines with appr. EED's
;;;  *EDITLINE     - Edit a Linedef
;;;  *EDITTHING    - Edit Thing(s)
;;;  *CHK2SIDE     - Check two sided Linedefs
;;;  *STAT         - Statistics of objects

;;; Format:
;;;   treats linedefs/sectors as closed polylines
;;;   where
;;;     <flag>: "ImMo2sUpLoScBlInMp"
;;;     <type>: int number
;;;     <tag> : 0 or sector tag
;;;     <xoff> ( <yoff> : <topT> / <botT> / <midT> )
;;;     <floorH> : <floorT> <ceilH> : <ceilT> <light> <type> <tag>
;;;
;;;   3 sections:
;;;     sectors, lines, things
;;;   SECTOR:
;;;     Closed Polyline with EED
;;;     ("DOOM-SECTOR" ((1002 . "{") (1040 floorH) (1000 floorT) (1040 ceilH)
;;;	   (1000 ceilT) (1070 light) (1070 type)   (1070 tag)    (1002 . "}")))
;;;   LINE:
;;;     EED in Vertex of Sector:
;;;     ("DOOM-LINE" ((1002 "{")(1070 flag)(1070 typ) (1070 tag) (1070 xoff)
;;;        (1070 yoff) (1000 topT) (1000 botT) (1000 midT) (1002 "}")))
;;;
;;;   THING:
;;;   things as blocks with the attributes type and when
;;;     <when> = color (def: 7, skill 1-4)
;;;     <type> = blockname, THNG1 - THNG3006
;;;
;;;------------------------------------------------------------
;;; Reading:
;;;   Creates of each sector closed polyline(s)
;;;   Splits 2nd Sidedef from Line
;;;
;;; Writing:
;;;   Closed polylines to SECTORS
;;;   extra Lines and Polylines to LINEDEFS
;;;   extra Points to VERTEXES
;;;
;;;   Merges 2 Sidedefs to 1 Line
;;;     Looks at each line in all next sectors for opposite line (2nd sidedef)
;;;     ignores same lines
;;;
;;; Datatypes:
;;;   secdef:  sector definition
;;;      0      1      2     3     4     5    6
;;;     (floorH floorT ceilH ceilT light type linetag)
;;;   linedef: line definition
;;;       0      1       2    3   4      5        6)
;;;     ((x1 y1) (x2 y2) flag typ sectag sidedef1 [sidedef2])
;;;   sidedef:
;;;      0    1    2    3    4    5
;;;     (xoff yoff topT botT midT [secnum])
;;;   seclst:  list of sectors
;;;     (
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#0
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#1
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#2
;;;     )
;;;   Thing:
;;;      0     1   2   3
;;;     ((x y) ang typ when)
;;;------------------------------------------------------------
;;; Revisions:
;;;   $Log: DOOM.LSP $
;;;   Revision 1.4  1995/05/30 13:51:38  Reini
;;;   better auto-loading, bi4 support
;;;   Revision 1.3  1995/05/30 13:19:23  Reini
;;;   DOOMUTIL-loader
;;;   Revision 1.2  1995/05/30 12:50:01  Reini
;;;   first public release
;;;   Revision 1.1  1995/05/12 18:52:44  Reini
;;;   Initial revision
;;;   Started once again with 1.1
;;;   Revision 1.13  1995/04/01 18:31:52  Reini
;;;   DWDOUT deleted, get_lines extra
;;;   Revision 1.12  1995/03/24 18:38:05  Reini
;;;   DOOM.EXP, loaded msg
;;;   Revision 1.11  1995/03/14 22:49:02  Reini
;;;   WADOUT luft das erste mal (ohne double check)
;;;   Revision 1.10  1995/03/11 01:41:40  Reini
;;;   WADOUT
;;;   Revision 1.9  1995/03/11 00:51:50  Reini
;;;   WADOUT to binary WAD, only vertixes so far
;;;   Revision 1.8  1995/02/21 06:33:44  Reini
;;;   Revision 1.7  1995/02/21 06:05:33  Reini
;;;   updated to DWD Format 1.1
;;;   20.02.95 10:06: doomout reformatted to idbsp11-format:
;;;     sectors:<count>
;;;     lines with secnum
;;;   Revision 1.6  1994/12/31 17:11:05  Reini
;;;   DOOMOUT verbessert (fast fertig)
;;;   Revision 1.5  1994/12/31 13:55:34  Reini
;;;   DOOMIN Fehler bei EED of DOOMSECTOR
;;;   DOOMOUT erweitert
;;;   Revision 1.3  1994/12/30 23:51:57  Reini
;;;   (C:DWDIN) funktioniert jetzt
;;;   Revision 1.2  1994/12/30 23:13:51  Reini
;;;   variuos errors corrected
;;;   Revision 1.1  1994/12/30 19:09:50  Reini
;;;   Initial revision
;;;------------------------------------------------------------
;;;Problems:
;;; check
;;;  0 len lines
;;;  upper - lower textures
;;;  Im flag on 1-sided lines
;;;  stairs textures
;;;  sectors closed error?
;;;  sector direction (clockwise)
;;;  floorH < ceilH (neg. oh) -> ceilH 256 or same as neighbor sector



;;; Format of the DWD File, accepted by IDBSP.EXE
;;; see DOOM.DOC

;;define dynamic (global) symbols (only for Lisp Compiler)
(if bd4a nil (defun special (s) nil))
(special '(pts sectors things lines sides exe dirname len))

(defun C:DOOM ()(acad_helpdlg "DOOM" ""))

(if (not ur_default)
  (if (and bd4a	(eq (type C:DOOM) 'CSUBR)) ;doom.bi4 has it all
    nil
    (if (not (findfile "DOOMUTIL.LSP"))
      (load (getfiled "need location of DOOMUTIL" "DOOMUTIL.LSP" "LSP" 2)
           '(princ "need DOOMUTIL to work properly"))
      (load "DOOMUTIL")
    )
  )
)

(if (not ur_xfputint)
  (if (wcmatch (getvar "PLATFORM") "*Windows")
    nil				;binary wad output not supported yet
    (if (not (findfile "DOOM.EXP"))
      (xload (getfiled "need location of DOOM.EXP" "DOOM.EXP" "EXP" 2)
           '(princ "need DOOM.EXP to work properly"))
      (xload "DOOM")
    )
  )
)

;;;******************************************
;;;Defaultwerte
(setq defmidT "GRAY5"       ;smooth uneven
      deftopT "-"
      defbotT "-"
      deffloorT "FLAT1_1"   ;grey w/ grooves
      defceilT  "CEIL1_1"   ;br. wood panel squares
)
;;;             x1 y1 x2 y2  flag type when
(setq deflin '((0  0)(0  0)  0    0    0))
;;;            xoff yoff                         secnum
(setq defside (list  0    0  deftopT defbotT defmidT 0))
;;; if side (nil num) then assume the values as in defside
;;;                flag type when xoff yoff
(setq deftxt (list 0    0    0    0    0    deftopT defbotT defmidT))
;;;                     flag type when
(setq deftxtempty (list 0    0    0))
;;; if txt nil then assume the values as in deftxt

;;;            floorH floorT     ceilH ceilT    light type tag
(setq defsec (list 0  deffloorT 256 defceilT 255   0    0))
;;;             x y ang type when
(setq defthng '((0 0) 0   1    7))
;;;Defaultliste fr Gesamtlinie
(setq defall (append deflin deftxt defsec deftxt defsec))


(setq doomdir
  (if (not doomdir)
    (if (not (findfile "DOOM2.EXE"))
      (if (setq exe (getfiled "Enter DOOM homedirectory" "DOOM2.EXE" "EXE" 2))
        (setq doomdir (ur_filepath exe))
        (ur_exit "DOOM2.EXE not found")
      )
    )
    (ur_fpslash doomdir)
  )
)

(ur_deftype 'doomdir "")
(ur_default 'doomwad    (strcat doomdir "ARS/E1M1d3.WAD"))
(ur_default 'waddwd_exe (strcat doomdir "BSP/WAD_DWD.EXE"))
(ur_default 'idbsp_exe  (strcat doomdir "BSP/IDBSP11.EXE"))

;;; converts Doom-units to AutoCAD-units (Pixel/M/CM)
;;; if in<>nil Pixel -> AutoCAD (WAD In)
;;; else       AutoCAD -> Pixel (WAD Out)
(defun doom_point (pt in)
  (cond
    ((= units "Pixel")
      (if in
	(trans (append (ur_3to2d pt)
	  (list (if (caddr pt) (caddr pt) 0.0))) 1 0)
        (mapcar 'fix (ur_3to2d (trans pt 0 1)))
      )
    )
    ((= units "Meter")
      (if in
        ;;convert Pixel to M
        (trans (append (mapcar '* (ur_3to2d pt) '(0.01905 0.01905))
	  (list (if (caddr pt) (doom_height (caddr pt) 1) 0.0))) 1 0)
        ;;convert M to Pixel
        (mapcar 'fix (mapcar '* (ur_3to2d (trans pt 0 1)) '(52.49 52.49)))
      )
    )
    ((= units "CM")
      (if in
        ;;convert Pixel to CM
        (trans (append (mapcar '* (ur_3to2d pt) '(1.905 1.905))
	  (list (if (caddr pt) (doom_height (caddr pt) 1) 0.0))) 1 0)
        ;;convert CM to Pixel
        (mapcar 'fix (mapcar '* (ur_3to2d (trans pt 0 1)) '(0.5249 0.5249)))
      )
    )
    (T (ur_exit "Error: units not set"))
  )
)

;; converts Doom-height to AutoCAD-units (Pixel/M/CM)
;;; if in<>nil Pixel -> AutoCAD (WAD In)
;;; else       AutoCAD -> Pixel (WAD Out)
(defun doom_height (n in)
  (cond
    ((= units "Pixel") n)
    ((= units "Meter")
      ;;convert Pixel to M
      (if in
        (* n 0.03048)
        (fix (/ n 0.03048))
      )
    )
    ((= units "CM")
      (if in
        (* n 30.48)
        (fix (/ n 30.48))
      )
    )
    (T (ur_exit "Error: units not set"))
  )
)

;;;*************************************************************************

(defun C:WADIN (/ in out exe)
  ;;(ur_varini '(		;;my error envelope
  ;;	("CLAYER" . nil)
  ;;	("CECOLOR" . nil)
  ;;	("THICKNESS" . 0)
  ;;	("OSMODE" . 0)
  ;;))
  ;;(if *BREAK* nil (setq *ERROR* ur_err))
  ;;(ur_betatest)
  (if (not (setq exe (findfile waddwd_exe)))
    (if (not (setq exe (getfiled "Enter path of WAD_DWD.EXE" waddwd_exe "EXE" 2)))
      (ur_exit "WAD_DWD.EXE not found")
    )
  )
  (setq waddwd_exe exe)
  ;; wenn WAD, dann konvertiere mittels WAD_DWD.EXE <wad> <dwd>
  (if (and (setq in (getfiled "Read DOOM WAD File" doomwad "WAD" 2))
	   (findfile in))
    (progn
      (setq doomwad in)
      (setq out (ur_ffname doomwad "WAD"))
      (if (setq out (getfiled "Write DOOM DWD File" out "DWD" 3))
	(progn
          (command "SH" (strcat exe " " in out))
	  (doomin out)
	)
      )
    )
  )
  ;;(ur_varres)
)

(defun C:DWDIN (/ in)
  ;;(ur_varini '(
  ;;	("CLAYER" . nil)
  ;;	("CECOLOR" . nil)
  ;;	("THICKNESS" . 0)
  ;;	("OSMODE" . 0)
  ;;))
  ;;(if *BREAK* nil (setq *ERROR* ur_err))
  ;;(ur_betatest)
  (setq doomdir
    (if (not doomdir)
      (if (not (findfile "DOOM2.EXE"))
        (if (setq exe (getfiled "Enter DOOM homedirectory" "DOOM2.EXE" "EXE" 2))
          (setq doomdir (ur_filepath exe))
          (ur_exit "DOOM2.EXE not found")
        )
      )
      (ur_fpslash doomdir)
    )
  )
  (if (and (setq in (getfiled "Read DOOM DWD File" (ur_ffname doomwad "DWD") "DWD" 2))
	   (findfile in))
    (progn
      (setq doomwad (ur_ffname in "WAD"))
      (doomin in)
    )
  )
  ;;(ur_varres)
)

;;; erzeugt Thing Block THNGxxxx where xxxx=type
;;; with the attributes TYPE and WHEN
(defun create_thing (typ / desc hor vert l name)
  (ur_breakn "erzeuge THING" '("typ"))
  ;;(setq type (ur_tostr type))
  (setq name (strcat "THNG" typ))
  (if (setq l (assoc (read typ) doom_thnglst))
    (setq desc (nth 1 l)
	  hor (nth 2 l)
	  vert (nth 3 l))
    (setq desc ""	;assume a simple 5/5 block
	  hor 5
	  vert 5)
  )
  (setq hor (* hor 0.5))
  (if (entmake (list
      '(0 . "BLOCK") (cons 2 name)
      '(66 . 1)       ; Attribute folgen
      '(70  . 2)      ; Block gesetzt, und mit Attributen
      '(3  . "") '(10 0.0 0.0 0.0)))
    (progn
      (entmake (list '(0 . "LINE")
                 (cons 10 (doom_point (list (- hor) (- hor) 0.0) 1))
                 (cons 11 (doom_point (list (- hor)    hor  0.0) 1))
		 (cons 39 (doom_height vert 1))
                 ))
      (entmake (list '(0 . "LINE")
                 (cons 10 (doom_point (list (- hor)    hor  0.0) 1))
                 (cons 11 (doom_point (list    hor     hor  0.0) 1))
		 (cons 39 (doom_height vert 1))
                 ))
      (entmake (list '(0 . "LINE")
                 (cons 10 (doom_point (list    hor     hor  0.0) 1))
                 (cons 11 (doom_point (list    hor  (- hor) 0.0) 1))
		 (cons 39 (doom_height vert 1))
                 ))
      (entmake (list '(0 . "LINE")
                 (cons 10 (doom_point (list    hor  (- hor) 0.0) 1))
                 (cons 11 (doom_point (list (- hor) (- hor) 0.0) 1))
		 (cons 39 (doom_height vert 1))
                 ))
      (entmake (list '(0 . "LINE")
                 (cons 10 (doom_point '(0.0 0.0 0.0) 1))
                 (cons 11 (doom_point '(5.0 0.0 0.0) 1));Arrow to the right for angle
		 '(62 . 1)
                 ))
      (entmake (list '(0 . "LINE")
                 (cons 10 (doom_point '(3.5 1.0 0.0) 1))
                 (cons 11 (doom_point '(5.0 0.0 0.0) 1));Arrow to the right for angle
		 '(62 . 1)
                 ))
      (entmake (list '(0 . "LINE")
                 (cons 10 (doom_point '(3.5 -1.0 0.0) 1))
                 (cons 11 (doom_point '(5.0 0.0 0.0) 1));Arrow to the right for angle
		 '(62 . 1)
                 ))
      (entmake (list '(0 . "ATTDEF") '(8 . "0")
                 '(10 0.0 2.0 0.0) '(40 . 0.5)
                 '(2 . "TYPE") (cons 1 typ) '(3 . "") '(70 . 0) '(50 . 0)))
      (entmake (list '(0 . "ATTDEF") '(8 . "0")
                 '(10 0.0 1.0 0.0) '(40 . 0.5)
                 '(2 . "WHEN") '(1 . "7") '(3 . "") '(70 . 0) '(50 . 0)))
      (entmake (list '(0 . "ATTDEF") '(8 . "0")
                 '(10 0.0 3.0 0.0) '(40 . 0.5)
                 '(2 . "DESC") (cons 1 desc) '(3 . "") '(70 . 0) '(50 . 0)))
      (if (entmake '((0 . "ENDBLK")))   ;Entmake the block end.
        (ur_breakn " block defined " nil)
      )
    )
  )
)
;;(defun C:TEST ()(create_thing "1"))


;;; creates a thing
(defun doom_thing_in (lst / p0 ang typ when name l desc)
  (ur_breakn "setze THING" '("lst"))
  (setq p0   (doom_point (ur_head lst 1) 1))
  (setq ang  (nth 2 lst))
  (setq typ  (ur_tostr (nth 3 lst)))
  (setq when (ur_tostr (nth 4 lst)))
  (setq name (strcat "THNG" typ))
  (if (not (tblsearch "BLOCK" name))
    (create_thing typ)
  )
  (if (setq l (assoc (read typ) doom_thnglst))
    (setq desc (nth 1 l))
    (setq desc "")
  )
  (if (entmake (list
      '(0 . "INSERT")
      (cons 10 p0)
      (cons 2 name)
      (cons 50 (ur_dtr ang))
      '(66 . 1)       ; Attribute folgen
    ))
    (progn
      (entmake (list
        '(0 . "ATTRIB")
	'(8 . "THNGTYPE")
        (cons 10 (mapcar '+ p0 '(0 1.5)))
	'(40 . 0.4)
        '(2 . "TYPE")
        (cons 1 typ)
        '(70 . 0)
        '(50 . 0.0)))
      (entmake (list
        '(0 . "ATTRIB")
	'(8 . "THNGDESC")
        (cons 10 (mapcar '+ p0 '(0 1)))
	'(40 . 0.4)
        '(2 . "DESC")
        (cons 1 desc)
        '(70 . 0)
        '(50 . 0.0)))
      (entmake (list
        '(0 . "ATTRIB")
	'(8 . "THNGWHEN")
        (cons 10 (mapcar '+ p0 '(0 0.5)))
	'(40 . 0.4)
        '(2 . "WHEN")
        (cons 1 when)
        '(70 . 0)
        '(50 . 0.0)))
      (if (entmake '((0 . "SEQEND")))    ; Entmake the INSERT end.
        (ur_breakn " insert created " nil)
      )
    )
  )
)
;;; creates a line
;;;  (2840,1476) to (669,0) : <flag> : <type> : <tag>
;;;  <floorH> : <floorT> <ceilH> : <ceilT> <light> <type> <tag>
;;;  <xoff> ( <yoff> : <topT> / <botT> / <midT> )
(defun doom_line_in (lst / p0 p1 flag typ tag objh ceilh floorh ele)
  (ur_breakn "setze LINE" '("lst"))
  (setq flag (nth 4 lst))	;"ImMo2sUpLoScBlInMp"; im=1,2s=4
  (setq typ  (nth 5 lst))	;special function number
  (setq tag  (nth 6 lst))	;0 or connected with a sector
  (setq floorh (nth 7 lst))	;floorH
  (setq ceilh  (nth 9 lst))
  (setq objh (doom_height (- ceilh floorh) 1))
  (setq ele nil)
  (setq p0 (doom_point (append (ur_head lst 1) (list floorh)) 1))
  (setq p1 (doom_point (append (ur_sublst lst 2 3) (list floorh)) 1))
  (if (< (length lst) 18)
    nil
    (setq ele (list
      '(0 . "LINE")
      (cons 10 p0)
      (cons 11 p1)
      (cons 39 objh)
      (cons -3 (list
        (cons "DOOM-LINE" (list
         '(1002 . "{")
	  (cons 1070 flag)	  	  ;flag
	  (cons 1070 typ)         	  ;type
	  (cons 1070 tag)         	  ;tag
	  (cons 1070 (nth 14 lst))	  ;xoff
	  (cons 1070 (nth 15 lst))        ;yoff
	  (cons 1000 (nth 16 lst))        ;topT
	  (cons 1000 (nth 17 lst))        ;botT
	  (cons 1000 (nth 18 lst))        ;midT
         '(1002 . "}"))
        )
        (cons "DOOM-SECTOR" (list
         '(1002 . "{")
	  (cons 1040 (float (nth 7 lst)))   ;floorH
	  (cons 1000 (nth 8 lst))           ;floorT
	  (cons 1040 (float (nth 9 lst)))   ;ceilH
	  (cons 1000 (nth 10 lst))          ;ceilT
	  (cons 1070 (nth 11 lst))          ;light
	  (cons 1070 (nth 12 lst))          ;type
	  (cons 1070 (nth 13 lst))          ;tag
         '(1002 . "}"))
	)
      ))
    ))
  )
  (if (and ele (entmake ele))
    (ur_breakn " line created " nil)
  )
)

;;; converts the acad eed-linedef to the list used by calculations
;;; not useable in freeware
(defun eed_line (ele / txt sec floorh ceilh lin lines txtl p0 p1
		       secl txts secs objh
		)
  ;;linedef = vertex of polyline or line
  (cond
    ((= (ur_gettyp ele) "LINE")
      (setq p0 (doom_point (ur_getpt ele) nil))
      (setq p1 (doom_point (ur_getendpt ele) nil))
    )
;;;    ((= (ur_gettyp ele) "POLYLINE")
;;;      (ur_load "ur_nextpolypt" "POLY")
;;;      (setq p0 (doom_point (ur_getpt ele) nil))
;;;      (setq p1 (doom_point (ur_nextpolypt ele) nil))
;;;    )
  )
  (setq txt (ur_eed_getlist ele "DOOM-LINE"))
  (setq sec (ur_eed_getlist ele "DOOM-SECTOR"))
  ;(ur_breaks "LINE out" '("(entget b)" "txt" "sec"))
  (setq floorh (doom_height (caddr (ur_getpt ele)) nil))
  (setq objh (if (ur_getval 39 ele)(ur_getval 39 ele) 0.0))
  (setq ceilh  (doom_height (+ (caddr (ur_getpt ele))objh) nil))
  (setq lin (list (car p0) (cadr p0) (car p1) (cadr p1)))
  (ur_deftype 'lin deflin)
  (setq lines (cons lin lines))
  (setq txtl (list
	  (cdr (nth 1 txt))(cdr (nth 2 txt))(cdr (nth 3 txt))
	  (cdr (nth 4 txt))(cdr (nth 5 txt))
	  (check_texture_name (cdr (nth 6 txt)))
	  (check_texture_name (cdr (nth 7 txt)))
	  (check_texture_name (cdr (nth 8 txt)))
  ))
  (ur_deftype 'txtl deftxt)
  (setq txts (cons txtl txts))
  (setq secl (list
	  floorh (check_texture_name (cdr (nth 2 sec)))
	  ceilh  (check_texture_name (cdr (nth 4 sec)))
	  (cdr (nth 5 sec))(cdr (nth 6 sec))(cdr (nth 7 sec))
  ))
  (ur_deftype 'secl defsec)
  (setq secs (cons secl secs))
  ;(ur_breaks "lists" '("lin" "txtl" "secl"))
)
;;; converts the list used by calculations to acad eed-linedef
(defun line_eed (lst)
  (cons "DOOM-LINE"
    (mapcar
      'cons
      '(1002 1070 1070 1070 1070 1070 1000 1000 1000 1002)
      (append '("{") lst '("}"))
    )
  )
)
;;; converts the acad eed-secdef to assoc-list used by calculations
(defun eed_sector (ele)
  nil
)
;;; converts the assoc-list used by calculations to acad eed-secdef
(defun sector_eed (lst)
  (cons "DOOM-SECTOR"
    (mapcar
      'cons
      '(1002 1040 1000 1040 1000 1070 1070 1070 1002)
      (append '("{") lst '("}"))
    )
  )
)
;;; converts the acad thing-block to assoc-list used by calculations
(defun acad_thing (ele)
  nil
)
;;; converts the assoc-list used by calculations to acad thing-block
(defun thing_acad (lst)
  nil
)

;;;creates a sector
;;;from DWD V1.1:  WorldServer version 4
;;; Datatypes:
;;;   sector:
;;;     ((secdef) (linedef's)...)
;;;   secdef:  sector definition
;;;      0      1      2     3     4     5    6       7
;;;     (floorH floorT ceilH ceilT light type linetag [secnum])
;;;     secnum for multiple closed plines, eg. within sectors
;;;   linedef: line definition
;;;      0  1  2  3  4    5   6      7        8 (if 2s)
;;;     (x1 y1 x2 y2 flag typ sectag sidedef1 [sidedef2])
;;;   sidedef:
;;;      0    1    2    3    4    5
;;;     (xoff yoff topT botT midT [secnum])
;;;   seclst:  list of sectors
;;;     (
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#0
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#1
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#2
;;;     )
;;;   thing:
;;;      0 1 2   3   4
;;;     (x y ang typ when)
;;; creates closed polyline

;;;move any 2nd sidedef of a sector to the appropriate sector
(defun move_2nd_sidedef (secnum seclst / n sector lines line i 2ndside sn l1)
  (setq sector (nth secnum seclst)
	lines  (cdr sector))
  (setq n (length lines) i 0)
  (repeat n
    (setq line (nth i lines))
    (if (and (setq 2ndside (nth 8 line)) ;list for 2nd side exists
             (setq sn (nth 5 2ndside))   ;sector number to change
	     (/= sn secnum))
      ;;copy linedef to this sector
      ;;flip this line
      (setq l1 (append
        (ur_sublst line 2 3) (ur_head line 1)
        (ur_sublst line 4 6) (list 2ndside)
      ))
      ;;does this line already exists
      (if (member l1 (nth sn seclst))
        nil
        (ur_rplace 'seclst sn       ;append it to the sector
          (append (nth sn seclst) l1)
        )
      )
    )
    (if (and (logand 2 (nth 4 line))	;2s flag is set
	     (not 2ndside))
      (progn
        (princ "2s flag is deleted, cause 2nd sidedef is missing!")
	(ur_rplace 'seclst secnum
	  (ur_rplace sector (1+ i)   ;i-th line
	    (- (nth 4 line) 2)))     ;del 2s flag
      )
    )
    (setq i (1+ i))
  )
  seclst
)
;;;check if the sector is a simple closed polyline,
;;;if multiple polylines, create a new one with a explicit secnum to the old
(defun check_simple_sector (sector / lines l startpts endpts i pt p line)
  (setq	lines  (cdr sector) l (length lines))
  ;;startpoints (a1 a2 a3...)
  (setq startpts (mapcar
    '(lambda (line) (ur_head line 1))
    lines))
  ;;endpoints (e1 e2 e3...) e1: (x y)
  (setq endpts (mapcar
    '(lambda (line) (ur_sublst line 2 3))
    lines))
  ;; each startpoint must have the same endpoint
  (setq i 0)
  (repeat (1- (length endpts))
    (setq pt (nth i endpts))
    (if (= -1 (setq p (ur_pos pt startpts)))
      (progn
        (princ "\nno successor found for: ")
	(princ pt) (princ " in: ")(princ startpts)
      )
      (if (/= p (1+ i))
	(progn
	  ;;change order in poly: e0=a1,... move (nth p lines) to pos i
	  (ur_lst_swap 'lines    (1+ i) p) ;tausche (i+1) mit p-tem Element
	  (ur_lst_swap 'startpts (1+ i) p)
	  (ur_lst_swap 'endpts   (1+ i) p)
	)
      )
    )
    (setq i (1+ i))
  )
  (cons (car sector) lines)
)

;;;(defun create_sector (sector / lst p0 p1 flag typ tag objh ceilh floorh)
;;;  (ur_breakn "create sector" '("lst"))
;;;  (setq lst (car sector))
;;;  (setq floorh (float (nth 0 lst)))	;floorH
;;;  (setq ceilh  (float (nth 2 lst)))
;;;  (setq objh (doom_height (- ceilh floorh) 1))
;;;  ;;check if the sector is a simple closed polyline,
;;;  ;;or multiple polylines
;;;  (entmake)
;;;  (if (entmake
;;;    (list
;;;      (cons 0 "POLYLINE")
;;;      (cons 10 (list 0 0 floorH))
;;;      (cons 39 objh)
;;;      (66 . 1)
;;;      (70 . 0)
;;;      (40 . 0.0)
;;;      (41 . 0.0)
;;;      (cons 210 '(0.0 0.0 1.0))
;;;      (cons -3 (list
;;;        (cons "DOOM-SECTOR" (list
;;;          (cons 1002 "{")
;;;          (cons 1040 floorH)   		;floorH
;;;          (cons 1000 (nth 1 lst))       ;floorT
;;;          (cons 1040 ceilH)   		;ceilH
;;;          (cons 1000 (nth 3 lst))       ;ceilT
;;;          (cons 1070 (nth 4 lst))       ;light
;;;          (cons 1070 (nth 5 lst))       ;type
;;;          (cons 1070 (nth 6 lst))       ;tag
;;;          (cons 1002 "}")
;;;        ))
;;;      ))
;;;    ))
;;;    (ur_breakn " poly-header created " nil)
;;;  )
;;;  (foreach lst (cdr sector)
;;;    (setq p0 (doom_point (append (ur_head lst 1)     (list floorh)) 1))
;;;    ;; this point == next point?
;;;    (setq p1 (doom_point (append (ur_sublst lst 2 3) (list floorh)) 1))
;;;    (setq flag (nth 4 lst))	;"ImMo2sUpLoScBlInMp"; im=1,2s=4
;;;    (setq typ  (nth 5 lst))	;special function number
;;;    (setq tag  (nth 6 lst))	;0 or connected with a sector
;;;    (setq side (nth 7 lst))
;;;    (setq side2 (nth 8 lst))
;;;    (if (entmake (list
;;;        (cons 0 "VERTEX")
;;;        (cons 10 p0)
;;;        (cons 42 0.0)
;;;        (cons -3 (list
;;;          (cons "DOOM-LINE" (list
;;;            (cons 1002 "{")
;;;            (cons 1070 flag)        	;flag
;;;            (cons 1070 typ)             ;type
;;;            (cons 1070 tag)             ;tag
;;;            (cons 1070 (nth 0 side))    ;xoff
;;;            (cons 1070 (nth 1 side))    ;yoff
;;;            (cons 1000 (nth 2 side))    ;topT
;;;            (cons 1000 (nth 3 side))    ;botT
;;;            (cons 1000 (nth 4 side))    ;midT
;;;            (cons 1002 "}")
;;;          ))
;;;        ))
;;;      ))
;;;      (ur_breakn " poly-vertex created " nil)
;;;    )
;;;  )
;;;  (if (entmake (list (cons 0 "SEQEND")))
;;;    (ur_breakn " sector completed " nil)
;;;  )
;;;)

;;;reads list of (<type> "description" <horsize> <versize>)
(defun doom_init_things (/ f s lst fn)
  (if (and
        (not (setq fn (findfile "THINGS.LST")))
        (not (setq fn (getfiled "Enter path of THINGS.LST" "THINGS.LST" "LST" 2)))
      )
    (princ "\nWarning: THINGS.LST not found!\n  Wrong appearance of thing blocks\n")
    (progn
      (setq f (open fn "r"))
      (setq doom_thnglst nil)
      (while (setq s (read-line f))
        (if (and (/= ";" (substr s 1 1))
	         (/= "" s))
          (setq lst (read (strcat "(" s ")"))
                doom_thnglst (cons lst doom_thnglst))
        )
      )
      (close f)
    )
  )
  ;;(setq doom_thnglst (reverse doom_thnglst))
)

(defun check_texture_name (_$sym / _$tmp)
  (if (= (type _$sym) 'SYM) (setq _$tmp _$sym _$sym (eval _$sym)))
  (if (or (not (ur_string-not-empty _$sym))
          (wcmatch _$sym "*[^#@_]*"))
    (setq _$sym "-"))
  (if _$tmp (set _$tmp _$sym) _$sym)
)

;;;  <floorH> : <floorT> <ceilH> : <ceilT> <light> <type> <tag>
(defun read_sector ($s / floorh floort ceilh ceilt light styp stag)
  (sscanf '($s " %d : %s %d : %s %d %d %d" 'floorh 'floort 'ceilh 'ceilt 'light 'styp 'stag))
  (check_texture_name 'floort)
  (check_texture_name 'ceilt)
  (ur_deftyplst (list floorh floort ceilh ceilt light styp stag) defsec)
)

;;; read sidedef
;;;  <xoff> ( <yoff> : <topT> / <botT> / <midT> )
(defun read_sidedef_10 ($s / xoff yoff topt bott midt)
  (sscanf '($s " %d ( %d : %s / %s / %s )" 'xoff 'yoff 'topt 'bott 'midt))
  (ur_default 'xoff 0)
  (ur_default 'yoff 0)
  (check_texture_name 'topt)
  (check_texture_name 'bott)
  (check_texture_name 'midt)
  (list xoff yoff topt bott midt)
)
;;; read sidedef
;;;  <xoff> ( <yoff> : <topT> / <botT> / <midT> ) <secnum>
(defun read_sidedef_11 ($s / xoff yoff topt bott midt secn)
  (sscanf '($s " %d ( %d : %s / %s / %s ) %d" 'xoff 'yoff 'topt 'bott 'midt 'secn))
  (ur_default 'xoff 0)
  (ur_default 'yoff 0)
  (check_texture_name 'topt)
  (check_texture_name 'bott)
  (check_texture_name 'midt)
  (list xoff yoff topt bott midt secn)
)
(setq turtle-i 0)
(defun turtle ()
  (if (= turtle-i 4)
    (setq turtle-i 1)
    (setq turtle-i (1+ turtle-i)))
  (princ "\r")
  (princ (substr "|/-\\" turtle-i 1))
  (princ)
)
;;; read dwd-file s
;;; builds 2 main-lists:
;;; secdef, sectordefinitions of each sector
;;; seclst, lines of each sector
(defun doomin (fn / f s object-type lst txt sec vert sec-num lin-num line)
  (if (not sscanf) (include "scanf" '(sscanf)))
  (setq vert 10)	;erst wenn "sectors:" gefunden wird, dann -> 11
  (if (not (tblsearch "APPID" "DOOM-LINE"))   (regapp "DOOM-LINE"))
  (if (not (tblsearch "APPID" "DOOM-SECTOR")) (regapp "DOOM-SECTOR"))
  (setq f (open fn "r"))
  (setq object-type nil)
  (prompt "\nreading DOOM object, units in Pixel")
  (prompt "\n16 Pixel = 1' or 30.48cm, 1 Unit = 0.01905 m")
  (initget 1 "Pixel M CM")
  (setq units (getkword  "AutoCAD units in Pixel/Meter or CM"))
  (if (not doom_thnglst) (doom_init_things))
  (terpri)
  (setq line 0)
  (while (setq s (read-line f))
    (setq line (1+ line))
    (cond
      ((= (substr s 1 6) "level:")
        (command "_LAYER" "_M" (substr s 7) "")
	(turtle)
	(princ (substr s 7))(princ " level\n")
	(setq lst nil)
      )
      ((= (substr s 1 8) "sectors:")
	(setq object-type "SECTOR" vert 11)	;Version 1.1 !!!
	(turtle)
	(princ (substr s 9))(princ " sectors\n")
	(setq lst nil)
      )
      ((= (substr s 1 6) "lines:")
	(setq object-type "LINE")
	(turtle)
	(princ (substr s 7))(princ " lines\n")
	(setq lst nil)
      )
      ((= (substr s 1 7) "things:")
	(setq object-type "THING")
	(turtle)
	(princ (substr s 8))(princ " things\n")
	(setq lst nil)
      )
      ((and (= (substr s 1 1) "(")
	    (= object-type "LINE")
	    (= vert 10))
;;;(2840,1476) to (669,0) : <flag> : <type> : <tag>
;;;    <xoff> ( <yoff> : <topT> / <botT> / <midT> )
;;;    <floorH> : <floorT> <ceilH> : <ceilT> <light> <type> <tag>
	(turtle)(princ " 1.Sidedef  \r")
	(setq lst (mapcar 'read (ur_strdlst s "(),: to")))
	(ur_breakn "Linedef" '("s" "lst"))

	(setq txt (read_sidedef_10 (setq s (read-line f))))
	(ur_breakn "1.Sidedef" '("s" "txt"))

	(setq sec (read_sector (setq s (read-line f))))
	(ur_breaks "1.Sectordef" '("s" "sec"))
	(doom_line_in (append lst sec txt))
      )
      ((and (= (substr s 1 1) "(")
	    (= object-type "LINE")
	    (= vert 11))
;;;(2840,1476) to (669,0) : <flag> : <type> : <tag>
;;;    <xoff> ( <yoff> : <topT> / <botT> / <midT> )
;;;    <floorH> : <floorT> <ceilH> : <ceilT> <light> <type> <tag>
	(turtle)(princ " 1.Sidedef  \r")
	(setq lst (mapcar 'read (ur_strdlst s "(),: to")))
	(ur_breakn "Linedef" '("s" "lst"))

	(setq txt (read_sidedef_11 (setq s (read-line f))))
	(ur_breakn "1.Sidedef" '("s" "txt"))
	;;get sector info...
	;;(doom_line_in (append lst sec txt))
      )
      ((and (= object-type "SECTOR")
            (wcmatch (substr s 1 2) "[~( \t]*")
	    (= vert 11))
	;;sector info
	(setq sec (read_sector (setq s (read-line f))))
	(ur_breaks "Sectordef" '("s" "sec"))
      )
      ((and (= object-type "LINE")
            (wcmatch (substr s 1 2) "[ \t]*")
	    lst
	    (= vert 10))
	;;2nd Linedef
	(turtle)(princ " 2.Sidedef \r")
	;; flip points:
	(setq lst (append
	  (ur_sublst lst 2 3) (ur_head lst 1) (ur_tail lst 3)))
	(ur_breakn "flipped line" '("lst"))
	(setq txt (read_sidedef_10 s))
	(ur_breakn "2.Sidedef" '("s" "txt"))

	(setq sec (read_sector (setq s (read-line f))))
	(ur_breaks "2.Sectordef" '("s" "sec"))
	(doom_line_in (append lst sec txt))
	(setq lst nil)
      )
      ((and (= object-type "LINE")
            (wcmatch (substr s 1 2) "[ \t]*")
	    lst
	    (= vert 11))
	;;2nd Linedef
	(turtle)(princ " 2.Sidedef \r")
	;; flip points:
	(setq lst (append
	  (ur_sublst lst 2 3) (ur_head lst 1) (ur_tail lst 3)))
	(ur_breakn "flipped line" '("lst"))
	(setq txt (read_sidedef_11 s))
	(ur_breakn "2.Sidedef" '("s" "txt"))

	;;get sector info...
	;;(doom_line_in (append lst sec txt))
	(setq lst nil)
      )
      ((and (= (substr s 1 1) "(")
	    (= object-type "THING"))
;;;(550,457, 0) :2035, 7
	(turtle)(princ " Thing  \r")
	(setq lst (mapcar 'read (ur_strdlst s "(),: ")))
	(ur_breaks "THING" '("s" "lst"))
	(doom_thing_in lst)
	(setq lst nil)
      )
      (T
        (setq lst nil)
	(turtle)(princ " line ") (princ line)
	(princ " has unknown format... \r")
      )
    )
  )
  (princ "\r fertig!    \n")
  (close f)
)
;;;*************************************************************************


;;; checks all 2-sided linedefs for the 2nd sidedef,
;;; and all duplicate lines for the 2-sided flag (4)
(defun C:CHK2SIDE ()
  nil
  ;;(ur_varini '())
  ;;(setq *ERROR* ur_err)
  ;;
  ;;(ur_varres)
)
(defun init_sectypes ()
  ;;"sectype"
  (setq sectypes ())
  (start_list "sectype")(mapcar 'add_list sectypes)(end_list)
)

;;;(defun C:EDITSECTOR (/ a)
;;;  ;;(ur_varini '())
;;;  ;;(if (not *BREAK*) (setq *ERROR* ur_err))
;;;  (ur_load "ur_dcl" "DCL_UTIL")
;;;  (setq a (ur_ssget "Choose Sector to edit: "))
;;;
;;;  (setq what_next 10)
;;;  (while (> what_next 1)
;;;    (setq dcl_id (ur_dcl "DOOMEDITSECTOR" "DOOM"))
;;;    (action_tile "help" "(acad_helpdlg \"DOOM\" \"EDITSECTOR\")")
;;;
;;;    (setq what_next (start_dialog))
;;;  )
;;;  (if (= what_next 1)
;;;    (princ)
;;;    ;; change it
;;;    ;;
;;;  )
;;;  (ur_unload_dialog dcl_id)
;;;  (ur_varres)
;;;)
;;;(defun C:EDITLINE ()
;;;  (ur_varini '())
;;;  (if (not *BREAK*) (setq *ERROR* ur_err))
;;;  (ur_load "ur_dcl" "DCL_UTIL")
;;;
;;;  (setq what_next 10)
;;;  (while (> what_next 1)
;;;    (setq dcl_id (ur_dcl "DOOMEDITLINE" "DOOM"))
;;;    (action_tile "help" "(acad_helpdlg \"DOOM\" \"EDITLINE\")")
;;;
;;;    (setq what_next (start_dialog))
;;;  )
;;;  (if (= what_next 1)
;;;    (princ)
;;;    ;; change it
;;;    ;;
;;;  )
;;;  (ur_unload_dialog dcl_id)
;;;  (ur_varres)
;;;)
;;;(defun C:EDITTHING ()
;;;  (ur_varini '())
;;;  (if (not *BREAK*) (setq *ERROR* ur_err))
;;;  (ur_load "ur_dcl" "DCL_UTIL")
;;;  (setq dcl_id (ur_dcl "DOOMEDITTHING" "DOOM"))
;;;  (action_tile "help" "(acad_helpdlg \"DOOM\" \"EDITTHING\")")
;;;
;;;  (setq what_next (start_dialog))
;;;  (ur_unload_dialog dcl_id)
;;;  (ur_varres)
;;;)
;;;MAKEPOLY (with Line-EED's)
;;; build list sectors ((pa1 pe1 pe2...)...) of points (pa1 pe1 pa2 pe2)
;;;(defun C:MAKESECTOR (/ l a b s points sectors found lines lst i
;;;		       sectmp point-dist)
;;;  (ur_varini  '(("OSMODE" . 0)))
;;;  (if *BREAK* nil (setq *error* ur_err))
;;;  (setq l (entlast) point-dist 5E-3)	;Ungenauigkeit 0.005 = 5cm
;;;  (setq a (ur_ssget "Choose lines to make sector(s) of: "))
;;;  (setq sectmp nil sectors nil lines nil)
;;;  (foreach b (ur_sslist a)
;;;    (setq i 0 found nil)
;;;    ;;accept lines and open polylines
;;;    (if (= (ur_gettyp b) "LINE")
;;;      ;;search both line points at end of sectors to append
;;;      (repeat (length sectmp)
;;;	(setq s (nth i sectmp))
;;;        (cond
;;;	  ;; Line start at Sector end
;;;	  ((equal (ur_getpt b) (last s) point-dist)	;startpoint found
;;;	    (setq s (append s (list (ur_getendpt b))))
;;;	    (if (equal (ur_getendpt b) (car s) point-dist)
;;;	      (setq sectmp (ur_delpos i sectmp)		;close sector
;;;		    sectors (cons s sectors)
;;;		    found t
;;;	      )
;;;	      (setq sectmp (ur_rplace sectmp i s)		;add point to sec
;;;		    found t
;;;	      )
;;;	    )
;;;	  )
;;;	  ;; Line end at Sector end
;;;          ((equal (ur_getendpt b) (last s) point-dist)	;endpoint found
;;;	    (setq s (append s (list (ur_getpt b))))
;;;	    (if (equal (ur_getpt b) (car s) point-dist)
;;;	      (setq sectmp (ur_delpos i sectmp)		;close sector
;;;		    sectors (cons s sectors)
;;;		    found t
;;;	      )
;;;	      (setq sectmp (ur_rplace sectmp i s)		;add point to sec
;;;		    found t
;;;	      )
;;;	    )
;;;	  )
;;;	  ;; Line start at Sector begin
;;;	  ((equal (ur_getpt b) (car s) point-dist)	;startpoint found
;;;	    (setq s (append (list (ur_getendpt b)) s))
;;;	    (if (equal (ur_getendpt b) (last s) point-dist)
;;;	      (setq sectmp (ur_delpos i sectmp)		;close sector
;;;		    sectors (cons s sectors)
;;;		    found t
;;;	      )
;;;	      (setq sectmp (ur_rplace sectmp i s)		;add point to sec
;;;		    found t
;;;	      )
;;;	    )
;;;	  )
;;;	  ;; Line end at Sector begin
;;;          ((equal (ur_getendpt b) (car s) point-dist)	;endpoint found
;;;	    (setq s (append (list (ur_getpt b)) s))
;;;	    (if (equal (ur_getpt b) (last s) point-dist)
;;;	      (setq sectmp (ur_delpos i sectmp)		;close sector
;;;		    sectors (cons s sectors)
;;;		    found t
;;;	      )
;;;	      (setq sectmp (ur_rplace sectmp i s)		;add point to sec
;;;		    found t
;;;	      )
;;;	    )
;;;	  )
;;;	  ;;couldn't append to any sector, start new sector
;;;	)
;;;	(setq i (1+ i))
;;;      )
;;;      (if (member (ur_getpt b) points)	;Punkt vorhanden, lsche
;;;	;;(setq points (ur_remove (ur_getpt b) points))
;;;	nil
;;;      )
;;;    )
;;;  )
;;;  (foreach b lst
;;;    (command "_PEDIT" b "_y" "_j" a "" "")	;Convert and JOIN
;;;  )
;;;  (if (and (/= l (entlast))
;;;           (entget (setq b (ur_entmlast))))
;;;    (progn
;;;      (if (not (ur_filter 1 b))
;;;        (command "_PEDIT" b "_C" "")	;schliee Polyline
;;;      )
;;;    )
;;;  )
;;;  (ur_varres)
;;;)

;;;*************************************************************************

(defun get_things (a / b p0 ang typ when lst)
  (princ "\rprocessing things ...\r")
  (setq things nil)
  (foreach b (ur_sslist a)
    (if (and
          (= "INSERT" (ur_gettyp b))
          (wcmatch (ur_getval 2 b) "THNG*")
          (= 1 (ur_getval 66 b)))
      (progn
	(setq p0   (doom_point (ur_getpt b) nil))
	(setq ang  (fix (ur_rtd (ur_getval 50 b))))
	(setq typ  (read (ur_getval 1 (ur_attele b "TYPE"))))
	(setq when (read (ur_getval 1 (ur_attele b "WHEN"))))
	(setq lst  (list (car p0) (cadr p0) ang typ when))
	(ur_deftype 'lst defthng)
	(setq things (cons lst things))
      )
    )
  )
  (princ "\rgot ")(princ (length things)) (princ " things\n")
  things
)
;;; Rules for merging the same linepts with two adjacent sectors
;;;	merge line, side1 to sec1, side2 to sec2, lineflag 2s
;;; Possibilities:
;;;	Doors, Stairs, 2s (Invisible), Impassable
;;; Door:
;;;   anyone: ceilH = floorH, member door-type
;;; Stair:
;;;   diff floorH
;;; Impassable:
;;;   anyone: Im flag, midT <> "-"
;;; 2s:
;;;   anyone: 2s flag, midT = "-"

;;; search for same line coords in all next sectors
;;; either same or flipped line
(defun search_adj_sector (line sectors)
  ()
)

(defun merge_adj_sectors ()
  ()
)
;;; checks if act. sector is inside any other sector
;;; if inner sec is clockwise, it's a new sector
;;;   2 sided, with 2nd sidedefs pointing to the outer sector
;;;   (check diff floorH and Textures)
;;; if inner sec is counter-clockwise, it belongs
;;;   to the outer sector (1 sided)
;;;   (check diff floorH and Textures)
(defun sector_inside? (sector sectors)
  ()
)

;;; get lines from lines and simple polylines
;;; if 2-sided, search for 2.sidedef
;;;(2840,1476) to (669,0) : <flag> : <type> : <tag>
;;;    <xoff> ( <yoff> : <topT> / <botT> / <midT> )
;;;    <floorH> : <floorT> <ceilH> : <ceilT> <light> <type> <tag>
;;; store line-info in lines, textures in txt, sectordef's in sec
;;; eed of txt: ((1002 "{")(1070 flag)(1070 typ) (1070 tag) (1070 xoff)
;;;        (1070 yoff) (1000 topT) (1000 botT) (1000 midT) (1002 "}"))
;;; eed of sector: ((1002 . "{") (1040 floorH) (1000 floorT) (1040 ceilH)
;;;	   (1000 ceilT) (1070 light) (1070 type) (1070 tag) (1002 . "}"))
;;;----------------------------------------------------------------------
;;; linedef: line definition
;;;      0      1       2    3   4      5        6)
;;;     (x1 y1) (x2 y2) flag typ sectag sidedef1 [sidedef2])
;;; sidedef:
;;;      0    1    2    3    4    5
;;;     (xoff yoff topT botT midT [secnum])
(defun get_lines (a / typ lines txts secs txt txtl sec secl lin b i n lst
		      floorh ceilh p0 p1 objh line side linidx)
  (princ "\rprocessing lines ...\r")
  ;;(ur_load "ur_eed_getlist" "EED")
  (ur_load "ur_nextpolypt" "POLY")

  (setq sectors nil lines nil linidx 0)
  (foreach b (ur_sslist a)
    ;;(ur_mctrl-c-interceptor)
    (setq lines nil)
    (cond
      ((and (= "LINE" (setq typ (ur_gettyp b)))
	    ;;(setq txt (ur_eed_getlist b "DOOM-LINE"))
	    ;;(setq sec (ur_eed_getlist b "DOOM-SECTOR"))
       )
        (setq floorh (doom_height (caddr (ur_getpt b)) nil))
  	(setq objh (if (ur_getval 39 b)(ur_getval 39 b) 0.0))
        (setq ceilh  (doom_height (+ (caddr (ur_getpt b))objh) nil))
	(setq secl (append (list floorh deffloorT ceilH defceilT)
		  	   (ur_tail defsec 3)))
	;;check EED for textures and sector
	;;(if (setq txt (ur_eed_getlist b "DOOM-LINE"))
	;;  (setq txtl (list
	;;    (cdr (nth 1 txt))(cdr (nth 2 txt))(cdr (nth 3 txt))
	;;    (cdr (nth 4 txt))(cdr (nth 5 txt))
	;;    (check_texture_name (cdr (nth 6 txt)))
	;;    (check_texture_name (cdr (nth 7 txt)))
	;;    (check_texture_name (cdr (nth 8 txt)))
	;;    (ur_deftype 'txtl deftxt)
	;;  ))
	  (setq txtl nil)	;;in freeware only default textures
	;;)
	;;only one sided
	(setq side (if txtl
	  (ur_tail txtl 2)))	;3,...

	;;straight line
        (setq line (append
          (list (doom_point (ur_getpt b) nil)
                (doom_point (ur_getendpt b) nil)
          )
          (if txtl (ur_head txtl 2) (list 0 0 0))    ;0,1,2
          (list side)
        ))
        ;;(ur_breaks "lists" '("line" "side" "txtl"))
	;;check for 0 length
	(if (not (equal (car line) (cadr line)))
	  (progn
	    ;;suche hnlichen sector
	    (setq i 0 n (length sectors))
	    (while (< i n)
	      (if (equal secl (car (nth i sectors)))
		(setq sectors
			(ur_rplace sectors i
			  (cons (nth i sectors) (list line)))
		      i n
		)
	      )
	      (setq i (1+ i))
	    )
	    (if (/= i (1+ n))	;or (= i n)
	      ;;not found, new sector
	      (setq sectors (cons (cons secl (list line)) sectors))
	    )
	    (setq linidx (1+ linidx))
	  )
	)
      )
      ((= "POINT" typ)
        (setq pts (cons (doom_point (ur_getpt b) nil) pts))
      )
      ((and (= "POLYLINE" typ)
            (not (ur_filter 1 b))	;open POLYLINE
       )
	(setq lines nil)
        (setq floorh (doom_height (caddr (ur_getpt b)) nil))
  	(setq objh (if (ur_getval 39 b)(ur_getval 39 b) 0.0))
        (setq ceilh  (doom_height (+ (caddr (ur_getpt b))objh) nil))
	(setq secl (append (list floorh deffloorT ceilH defceilT)
		  	   (ur_tail defsec 3)))
	;;check EED for textures and sector
	;;(if (setq txt (ur_eed_getlist b "DOOM-LINE"))
	;;  (setq txtl (list
	;;    (cdr (nth 1 txt))(cdr (nth 2 txt))(cdr (nth 3 txt))
	;;    (cdr (nth 4 txt))(cdr (nth 5 txt))
	;;    (check_texture_name (cdr (nth 6 txt)))
	;;    (check_texture_name (cdr (nth 7 txt)))
	;;    (check_texture_name (cdr (nth 8 txt)))
	;;    (ur_deftype 'txtl deftxt)
	;;  ))
	  (setq txtl nil)
	;;)
        ;(ur_breaks "lists" '("txtL" "secL"))
        (while (/= "SEQEND" (ur_gettyp (setq b (entnext b))))
	  (if (zerop (ur_getval 40 b))	;only straight lines
	    (progn
              ;;check EED for textures and sector
              ;;(if (setq txt (ur_eed_getlist b "DOOM-LINE"))
              ;;  (setq txtl (list	;0-2 -> linedef
              ;;    (cdr (nth 1 txt))(cdr (nth 2 txt))(cdr (nth 3 txt))
              ;;    (cdr (nth 4 txt))(cdr (nth 5 txt))	;-> sidedef
              ;;    (check_texture_name (cdr (nth 6 txt)))
              ;;    (check_texture_name (cdr (nth 7 txt)))
              ;;    (check_texture_name (cdr (nth 8 txt)))
              ;;    (ur_deftype 'txtl deftxt)
              ;;  ))
                (setq txtl nil)
              ;;)
	      ;;only one sided
	      (setq side (if txtl (ur_tail txtl 2)))	;3,...
	      ;;straight line
	      (setq line (append
	        (list (doom_point (ur_getpt b) nil)
	              (doom_point (ur_nextpolypt b) nil)
		)
		(if txtl (ur_head txtl 2) (list 0 0 0))		;0,1,2
		(list side)
	      ))
              ;;(ur_breaks "lists" '("line" "side" "txtl"))
	      ;;check for 0 length
	      (if (not (equal (car line) (cadr line)))
		(setq lines (cons line lines)
	              linidx (1+ linidx))
	      )
	    )
	  )
        )
	;;suche hnlichen sector
  	;;(setq sectors (cons (cons secl (reverse lines)) sectors))
        ;;suche hnlichen sector
        (setq i 0 n (length sectors))
        (while (< i n)
          (if (equal secl (car (nth i sectors)))
            (setq sectors
              (ur_rplace sectors i
                (cons (nth i sectors) (reverse lines)))
                  i n
            )
          )
          (setq i (1+ i))
        )
        (if (/= i (1+ n))
          ;;not found, new sector
          (setq sectors (cons (cons secl (reverse lines)) sectors))
        )
      )
    )
  )
  (princ "\rgot ")(princ linidx) (princ " lines\n")
  ;;check for 2.sidedef (line with flipped point)
  ;;if found line-i, flip line-i and expand txt-i and sec-i
  ;; ..
  ;;return single connected list of all lines, txts and secs
  ;; ((append line1 txt1 sec1)(append line2 txt2 sec2)...)
  ;;(setq lines (reverse lines)
  ;;	txts (reverse txts)
  ;;	secs (reverse secs))
  ;;(setq i 0 lst nil)
  ;;(repeat (length lines)
  ;;  (setq lst (cons (append (nth i lines)(nth i txts)(nth i secs)) lst)
  ;;	  i (1+ i))
  ;;)
  ;;lst
  sectors
)


;;; Datatypes:
;;;   sector:
;;;     ((secdef) (linedef's)...)
;;;   secdef:  sector definition
;;;      0      1      2     3     4     5    6       7
;;;     (floorH floorT ceilH ceilT light type linetag [secnum])
;;;     secnum for multiple closed plines, eg. within sectors
;;;   linedef: line definition
;;;      0      1       2    3   4      5        6)
;;;     (x1 y1) (x2 y2) flag typ sectag sidedef1 [sidedef2])
;;;   sidedef:
;;;      0    1    2    3    4    5
;;;     (xoff yoff topT botT midT [secnum])
;;;     or (nil)
;;;   seclst:  list of sectors
;;;     (
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#0
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#1
;;;	 ((secdef)(linedef#0)(linedef#1)(linedef#2)...)   ;sec#2
;;;     )
;;; get simple sectors (only closed polylines)
;;; return seclst, global: lines, pts
(defun get_sectors (a / sectors txt txtl secdef secl line lines
			b lst floorh ceilh side objh)
  (princ "\rprocessing sectors ...\r")
  ;;(ur_load "ur_eed_getlist" "EED")
  ;;(ur_load "ur_nextpolypt"  "POLY")
  (setq sectors nil)
  (foreach b (ur_sslist a)
    ;;(ur_mctrl-c-interceptor)
    (setq lines nil)
    (if (and (= "POLYLINE" (ur_gettyp b))
	     (ur_filter 1 b)			;only closed
	)
      (progn
	;;(setq lines nil)
	;;(ur_load "ur_firstpolypt" "POLY")
        (setq floorh (doom_height (caddr (ur_getpt b)) nil))
  	(setq objh (if (ur_getval 39 b)(ur_getval 39 b) 0.0))
        (setq ceilh  (doom_height (+ (caddr (ur_getpt b))objh) nil))
;;;	(if (setq secdef (ur_eed_getlist b "DOOM-SECTOR"))
;;;   	  (setq secl (list
;;;	                floorh (check_texture_name (cdr (nth 2 secdef)))
;;;	                ceilh  (check_texture_name (cdr (nth 4 secdef)))
;;;	    		(cdr (nth 5 secdef))(cdr (nth 6 secdef))(cdr (nth 7 secdef))
;;;	  ))
	  (setq secl (append (list floorh deffloorT ceilH defceilT)
	  		     (ur_tail defsec 3)))
;;;	)
	(ur_deftype 'secl defsec)
        ;(ur_breaks "lists" '("txtL" "secL"))
        (while (/= "SEQEND" (ur_gettyp (setq b (entnext b))))
	  (if (zerop (ur_getval 40 b))	;only straight lines
	    (progn
              ;;check EED for textures and sector
;;;              (if (setq txt (ur_eed_getlist b "DOOM-LINE"))
;;;                (setq txtl (list	;0-2 -> linedef
;;;                  (cdr (nth 1 txt))(cdr (nth 2 txt))(cdr (nth 3 txt))
;;;                  (cdr (nth 4 txt))(cdr (nth 5 txt))	;-> sidedef
;;;                  (check_texture_name (cdr (nth 6 txt)))
;;;                  (check_texture_name (cdr (nth 7 txt)))
;;;                  (check_texture_name (cdr (nth 8 txt)))
;;;                  (ur_deftype 'txtl deftxt)
;;;                ))
                (setq txtl nil)
;;;              )
	      ;;only one sided
	      (setq side (if txtl (ur_tail txtl 2)))	;3,...
	      ;;straight line
	      (setq line (append
	        (list (doom_point (ur_getpt b) nil)
	              (doom_point (ur_nextpolypt b) nil)
		)
		(if txtl (ur_head txtl 2) (list 0 0 0))		;0,1,2
		(list side)
	      ))
              ;;(ur_breaks "lists" '("line" "side" "txtl"))
	      ;;check for 0 length
	      (if (not (equal (car line) (cadr line)))
	        (setq lines (cons line lines))
	      )
	    )
	  )
        )
	(setq sectors (cons (cons secl (reverse lines)) sectors))
      )
    )
  )
  (princ "\rgot ")(princ (length sectors)) (princ " sectors\n")
  sectors
)

;;;searches for (x y) in pts, changes (x y) to index in pts
;;;builds quoted lists 'lines 'pts
;;; ((x y) ...) -> (i ...)
(defun change_point (lst lstsym ptsym / p pt $pts $lines)
  (setq $pts (eval ptsym) $lines (eval lstsym))
  ;;(ur_breaks "change_point" '("lst" "lines" "pts"))
  ;;check 1. point
  (if (minusp (setq p (ur_pos (setq pt (car lst)) $pts)))
    ;;not found: new point
    (progn
      (set lstsym (cons (cons (length pts) (cdr lst)) $lines))
      (set ptsym  (append $pts (list pt)))
    )
    ;;found: old point
    (set lstsym (cons (cons p (cdr lst)) $lines))
  )
  $lines
)

;;;searches for 2nd point in pts, changes (x y) to index in pts
;;;builds quoted lists 'lines bzw. 'things and 'pts
;;; (p1 (x y) ...) -> (i ...)
(defun change_point2 (lst lstsym ptsym / p pt $pts $lines)
  (setq $pts (eval ptsym) $lines (eval lstsym))
  ;;(ur_breaks "change_point2" '("lst" "lstsym" "ptsym"))
  ;;check 1. point
  (if (minusp (setq p (ur_pos (setq pt (cadr lst)) $pts)))
    ;;not found: new point
    (progn
      (setq lst (ur_rplace lst 1 (length pts)))
      (set lstsym (cons lst $lines))
      (set ptsym  (append $pts (list pt)))
    )
    ;;found: old point
    (set lstsym (cons (ur_rplace lst 1 (length pts)) $lines))
  )
  $lines
)
;;;and now the real program!
;;;break sectors in lines, sides and sectors
(defun split_sectors (sectors / secidx line p1 p2 sec p lst linidx side)
  (princ "\rsplitting ")(princ (length sectors))(princ " sectors:\n")
  ;;(ur_breaks "sectors" '("sectors" "pts"))
  ;; 1) change line coords to indices of pts
  (setq lines nil sides nil)
  (setq secidx 0)
  (foreach sec sectors
    (setq linidx 0)
    (foreach line (cdr sec)
      (princ "\rS")(princ secidx)(princ "L")(princ linidx)(princ "   \r")
      ;;(ur_mctrl-c-interceptor)
      ;;(ur_breaks "vor change_point1:" '("line" "lines" "pts"))
      (setq p1 (car line) p2 (cadr line))
      ;;check 1. point
      (if (minusp (setq p (ur_pos p1 pts)))
        ;;not found: new point
        (progn                   ;1.linie      1.ele, neuer index
          (setq line  (cons (length pts) (cdr line)))
          (setq pts   (append pts (list p1)))
	  ;;(ur_breakn "new" '("line" "pts"))
        )
        ;;found: old point     ;1.linie        1.ele, gefundener index
        (setq line    (cons p (cdr line)))
      )
      ;;(change_point  line 'lines 'pts)
      ;;(ur_breaks "vor change_point2:" '("line" "pts"))
      ;;check 2. point
      (if (minusp (setq p (ur_pos p2 pts)))
        ;;not found: new point
        (progn                   ;1.linie     2.element, neuer index
          (setq line (ur_rplace line 1 (length pts)))
          (setq pts   (append pts (list p2)))
	  ;;(ur_breakn "new" '("line" "pts"))
        )
        ;;found: old point     ;1.linie        2.ele, gefundener index
        (setq line (ur_rplace line 1 p))
        ;;(setq lines (ur_rplace lines 0 (ur_rplace line 1 p)))
      )
      ;;2) append sector index to sidedefs
      ;;  5th side element must be the sector number (secidx)
      ;;  5th (and 6th) elements of linedef are the sidedefs
      ;;1st sidedef
      (setq side (nth 5 line))
      ;;(ur_breaks "split_sectors: side 5?" '("line" "side" "secidx"))
      ;;(if (= (length side) 5)
      (setq side (if side (append side (list secidx)) secidx))
      (setq sides (cons side sides))
      ;;(ur_breakn "1st side" '("line" "side" "sides"))
      (setq line (ur_rplace line 5 (1- (length sides))))

      ;;2nd sidedef? or -1
      (if (> (length line) 6)
        (progn
          (if (>= (length (setq side (nth 6 line))) 5)
            (setq side (if side (ur_rplace side 5 secidx) secidx))
            (setq side secidx)
	  )
          (setq line (ur_rplace line 6 (1- (length sides))))

	  ;;if sector heights of adjacent sectors are different set the
          ;;upper/lower textures
          ;;set upper texture, if ceilH > ceilH-adj
	  ;;(if (> (nth 2 sec) (nth 2 (nth secidx sectors)))
          ;;  (setq side (ur_rplace side 2 (nth 4 side))))	;topT
          ;;;;set lower texture, if floorH > floorH-adj
	  ;;(if (> (nth 0 sec) (nth 0 (nth secidx sectors)))
          ;;  (setq side (ur_rplace side 3 (nth 4 side))) 	 ;botT
	  ;;)
          (setq side (cons side sides))
        )
	(progn
	  ;;2nd sidedef -1
          (setq line (append line '(-1)))
	  ;;set Im flag (1-tes)
          (setq line (ur_rplace line 2 (logior (nth 2 line) 1)))
	)
      )
      (ur_breakn "2nd side" '("line" "side" "sides"))
      (setq lines (cons line lines))
      (setq linidx (1+ linidx))
    )
    (setq secidx (1+ secidx)) ;sector index
  )
  (setq sides (reverse sides))
  (setq lines (reverse lines))
  ;;(ur_breaks "ready: lines+sides" '("lines" "pts" "sides" "sectors"))
  (list lines sides pts sectors)
)

;;;writes binary PWAD
;;;see UDS.	 (Matt Fell's "Unofficial Doom Specs")
;;;"PWAD<numb dirs><pos 1st dir>
;;;<dirs>...
;;;0c 0  E1M1
;;;ie:
;;;NAME____  SIZE__  START____  END______
;;;E1M1           0  x0000000c  x0000000b
;;;THINGS         0  x0000000c  x0000000b
;;;LINEDEFS      98  x0000000c  x0000006d
;;;SIDEDEFS     210  x0000006e  x0000013f
;;;VERTEXES      36  x00000140  x00000163
;;;not needed:
;;;SEGS          84  x00000164  x000001b7
;;;SSECTORS       4  x000001b8  x000001bb
;;;NODES          0  x000001bc  x000001bb
;;;SECTORS       26  x000001bc  x000001d5
;;;REJECT         1  x000001d6  x000001d6
;;;BLOCKMAP    3702  x000001d7  x0000104c

;;; writes the WAD directly, needs URBAN.EXP
(defun C:WADOUT (/ a dirs direntry x p
		   start len l dirname
		   thinglst sectmp pt lst
;;;		   things sides lines sectors pts
		)
  ;;(ur_varini '())
  ;;(if *BREAK* nil (setq *ERROR* ur_err))
  (ur_default 'doomdir (getenv "DOOMDIR"))

  (setq doomdir
    (if (not doomdir)
      (if (not (findfile "DOOM2.EXE"))
        (if (setq exe (getfiled "Enter DOOM homedirectory" "DOOM2.EXE" "EXE" 2))
          (setq doomdir (ur_filepath exe))
          (ur_exit "DOOM2.EXE not found")
        )
      )
      (ur_fpslash doomdir)
    )
  )
  (setq mapname
    (if (findfile (strcat doomdir "DOOM2.EXE"))
      "MAP01" ;; Doom 2
      "E1M1"))    ;; Doom 1 or Heretic

  (setq things nil sides nil lines nil sectors nil pts nil)
  (UR_DEFAULT 'units "Meter")
  (if (wcmatch (getvar "PLATFORM") "*Windows")
    (alert (strcat " Windows Version of DOOM.EXE not available yet! \n"
	   " (unknown problems with my Watcom Linker, REXX format) \n"
	   " Only test the functions, creating the WAD will not work! "

    ))
    (progn
      (ur_xload? "ur_xfputint" "DOOM")
      (if (not ur_xfputint) (ur_exit "DOOM.EXP or URBAN.EXP not found"))
    )
  )

  ;;(setq units (ur_ukword 0 "Pixel M CM" "AutoCAD units in Pixel/Meter or CM" units))
  ;;(setq mapname (ur_getstring 0 "Map name" mapname nil))
  ;;(ur_deftype 'mapname "E1M1")
  (initget 0 "Pixel Meter CM")
  (if (not (setq units (getkword "AutoCAD units in Pixel/<Meter>/CM: ")))
    (setq units "Meter"))

  (if (or (not (setq mapname (getstring "Map name <MAP01>: ")))
    (= mapname "")) (setq mapname "MAP01"))
  ;;(ur_deftype 'mapname "MAP01")
  (if (and (setq doomwad (getfiled "Write DOOM WAD File" doomwad "WAD" 3))
           (setq a (ur_ssget "Select sectors")))
    (progn
      (if (< (strlen (ur_fnameonly doomwad)) 4)
	(alert " It's recommended to use\nat least a 4 character filename "))
      (setq lines nil pts nil sectors nil sides nil)
      (setq things (get_things a))
      ;; get simple one-sided linedefs and vertexes as sectors
      (setq lines (get_lines a))
      ;; get sectors from closed polylines
      ;; (if 2-sided, check for 2.sidedef
      ;;  split lines to lines and sides
      (setq sectors (get_sectors a))
      ;;Vertexes are the first 2 elements of the lines and things
      ;;merge points, change absolut coords to rel. position in pts
      ;;(setq lines nil pts nil things nil)
      ;;(foreach x thinglst
      ;;	(change_point x 'things 'pts)
      ;;)
      ;;(ur_breaks "things" '("things" "pts"))

      (split_sectors sectors)	;->sectors,sides,lines,pts
				;  (global)
      (if (wcmatch (getvar "PLATFORM") "*Windows")
        (alert " writing the WAD skipped ")
        (wadout)
      )
    )
  )
  (princ)
  ;;(ur_varres)
)

;;;***********************************************************************
;;; AutoLISP cannot write 0x00 to a file!!
;;; so all those functions became useless
;;; its implemented in DOOM.EXP
;;; (where the formattiing and converting is done too)
;;;***********************************************************************
;;; String in Ascii-Liste
;;; "PWAD" -> '(50 57 41 44)
;;;(defun ur_s2al (_$str)
;;;  (mapcar 'ascii (ur_s2l _$str))
;;;)
;;;;;; String in Ascii-Liste with len bytes (filled with 0)
;;;;;; "PWAD" -> '(50 57 41 44 0 0 0 0)
;;;(defun ur_strout (s len)
;;;  (append (ur_s2al s) (ur_mklst nil (- len (strlen s)) 0)))
;;;
;;; converts number to 4 byte hex integer (INTEL order)
;;; AutoLISP kennt nur 16-bit Integer (31-bit ??)
;;;(defun nl (num)
;;;  (if (minusp num)
;;;    (progn
;;;      (setq num (+ (1+ num)(lsh -1 (- 31 32))))
;;;      (list
;;;            (abs (rem (lsh num   0) 256))
;;;            (abs (rem (lsh num  -8) 256))
;;;            (abs (rem (lsh num -16) 256))
;;;            255
;;;      )
;;;    )
;;;    (list
;;;    	  (abs (rem num 256))
;;;          (abs (rem (lsh num  -8) 256))
;;;          (abs (rem (lsh num -16) 256))
;;;          (abs (rem (lsh num -31) 256))
;;;)))
;;;;; converts number to 2 byte hex integer (INTEL order)
;;;(defun ni (num)
;;;  (if (minusp num)
;;;    (progn
;;;      (setq num (+ (1+ num)(lsh -1 (- 16 32))))
;;;      (list
;;;            (abs (rem (lsh num  0) 256))
;;;            (abs (rem (lsh num -8) 256))
;;;      )
;;;    )
;;;    (list
;;;	  (abs (rem num 256))
;;;          (abs (rem (lsh num -8) 256))
;;;    )
;;;  )
;;;)
;;;
;;;(defun num-to-int-intel  (n) (ni n))
;;;(defun num-to-long-intel (n) (nl n))
;;;***********************************************************************

(defun wadout ( / start dirs direntry lst l)
      ;; header size: 3x4 byte
      (setq start 12.0)
      ;;build directory, assoc list of
      ;; len name
      (setq dirs (list
        (cons 0 mapname)
        ;;here I got strange errors, because AutoLISP 'INT
        ;;can only handle 16-bit signed integer (<= 32767)
        ;;so I had to convert everything to reals
        ;;cause sometimes the directories get really big!
        (cons (* 10.0 (length things)) "THINGS")
        (cons (* 14.0 (length lines))  "LINEDEFS")
        (cons (* 30.0 (length sides))  "SIDEDEFS")
        (cons (* 4.0  (length pts))    "VERTEXES")
        '(0 . "SEGS")
        '(0 . "SSECTORS")
        '(0 . "NODES")
        (cons (* 26.0 (length sectors)) "SECTORS")
        '(0 . "REJECT")
        '(0 . "BLOCKMAP")))
      (setq direntry (+ start
        (apply '+
          (mapcar 'car dirs))))
      (ur_breaks "dirs" '("dirs" "direntry"))
      (princ "writing header\n")
      (if (not (ur_xfopen doomwad "wb"))
	(ur_exit "Couldn't open doomwad"))
      (ur_xfputs "PWAD" 4)            ;Kennung
      (ur_xfputlong (length dirs))    ;number of dir entries
      (ur_xfputlong direntry)         ;ptr to start of dirs

      (princ "writing sections\n")
      (thngout things)
      (lineout lines)
      (sideout sides)
      (vtxout  pts)
      (sectorout sectors)

      (princ "writing directories\n")
      (foreach l dirs
        (setq len     (car l)
              dirname (cdr l))
        (ur_xfputlong start)
        (ur_xfputlong len)
        (ur_xfputs dirname 8)
        (setq start (+ len start))
      )
      (ur_xfclose)
      (princ "finished!\n")
)


;;; writing the VERTEXES
(defun vtxout (pts / pt)
  (princ "write ")(princ (length pts))(princ " verteces, ")
  (foreach pt pts
    ;;(ur_mctrl-c-interceptor)
    (ur_xfputint (car pt))      ;X
    (ur_xfputint (cadr pt))     ;Y
  )
)
;;; writing the THINGS
(defun thngout (lst / l)
  (princ "write ")(princ (length lst))(princ " things, ")
  (foreach l lst
    (ur_xfputint l)
    ;;(ur_mctrl-c-interceptor)
    ;;(ur_xfputint (car   l))     ;point x
    ;;(ur_xfputint (nth 1 l))     ;point y
    ;;(ur_xfputint (nth 2 l))     ;angle
    ;;(ur_xfputint (nth 3 l))     ;type
    ;;(ur_xfputint (nth 4 l))     ;options
  )
)
;;; writing the LINEDEFS
(defun lineout (lst / pt)
  (princ "write ")(princ (length lst))(princ " linedefs, ")
  (foreach l lst
    (ur_xfputint l)
    ;;(ur_mctrl-c-interceptor)
    ;;(ur_xfputint (nth 0 l))     ;from vtx
    ;;(ur_xfputint (nth 1 l))     ;to vtx
    ;;(ur_xfputint (nth 2 l))     ;flags
    ;;(ur_xfputint (nth 3 l))     ;type
    ;;(ur_xfputint (nth 4 l))     ;tag
    ;;(ur_xfputint (nth 5 l))     ;right sidedef
    ;;(if (>= (length l) 6)       ;2nd sidedef defined
    ;;  (ur_xfputint (nth 6 l))   ;left sidedef or -1
    ;;  (ur_xfputint -1)
    ;;)
  )
)
;;; writing the SIDEDEFS
(defun sideout (lst / pt)
  (princ "write ")(princ (length lst))(princ " sidedefs, ")
  (foreach l lst
    (ur_breaks "side" '("l" "defside"))
    (if (not (listp l))
      (setq l (append (ur_head defside 4) (list l))))
    ;;(ur_mctrl-c-interceptor)
    (ur_xfputint (nth 0 l))     ;X offset
    (ur_xfputint (nth 1 l))     ;Y offset
    (ur_xfputs   (nth 2 l) 8)   ;lower
    (ur_xfputs   (nth 3 l) 8)   ;upper
    (ur_xfputs   (nth 4 l) 8)   ;middle
    (ur_xfputint (nth 5 l))     ;sector#
  )
)
;;; writing the SECTORS
(defun sectorout (lst / pt)
  (princ "write ")(princ (length lst))(princ " sectors, ")
  (foreach l (mapcar 'car lst)
    ;;(ur_mctrl-c-interceptor)
    (ur_xfputint (nth 0 l))     ;floor height
    (ur_xfputint (nth 2 l))     ;ceiling height
    (ur_xfputs   (nth 1 l) 8)   ;floor texture
    (ur_xfputs   (nth 3 l) 8)   ;ceiling texture
    (ur_xfputint (nth 4 l))     ;light
    (ur_xfputint (nth 5 l))     ;type
    (ur_xfputint (nth 6 l))     ;tag
  )
)

;;;(ur_chkdel '(
;;;	"C:DWDIN" "C:DWDOUT" "C:WADIN" "C:WADOUT" "doomin" "doomout"
;;;	"doomwad" "doomdir" "waddwd_exe" "idbsp_exe"
;;;  	"create_thing" "DOOM_INIT_THINGS" "DOOM_POINT" "DOOM_HEIGHT"
;;;	"doom_thing_in" "DOOM_LINE_in" "get_lines" "get_things"
;;;	"doom_line_out" "doom_thing_out"
;;;	"vtxout" "units"
;;;))

'("$Id: DOOM.LSP 1.4 1995/05/30 13:51:38 Reini Exp $ loaded")
