// Edit Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"
#include <math.h>

#ifndef PI
#define PI              3.141592654
#endif       

#ifndef PI180
#define PI180           0.017453292
#endif

int EXPORT DialogRotateScale(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);

void DoomEdEditUndo(void)
{
}

void DoomEdEditRedo(void)
{
}

void DoomEdEditCut(void)
{
}

void DoomEdEditCopy(void)
{
}

void DoomEdEditPaste(void)
{
}

void DoomEdEditDelete(void)
{
  int   i;
  BOOL  turf;
  // remove currently selected item(s)
  switch(Tool) {
    case T_LINE:
      for(i=0; i<LineDefsNum; i++)
        if(eLineDef[i].Used)
          eLineDef[i].Used = (!eLineDef[i].Selected);
      UnSelectAll();
      RepaintMap();
      break;

    case T_SECTOR:
      // remove EVERYTHING, including attached lines:
      // DetachSectors();
      for(i = 0; i < LineDefsNum; i++) {
        turf = FALSE;
        if(eLineDef[i].Used) {
          if(LineDef[i].sidedef1 != Nothing)
            if(eSector[SideDef[LineDef[i].sidedef1].sector].Selected)
              turf = TRUE;
          if(LineDef[i].sidedef2 != Nothing)
            if(eSector[SideDef[LineDef[i].sidedef2].sector].Selected)
              turf = TRUE;
          if(turf)
            eLineDef[i].Used = FALSE;
          }
        }
      for(i=0; i<SectorsNum; i++)
        if(eSector[i].Used)
          eSector[i].Used = (!eSector[i].Selected);
      UnSelectAll();
      RepaintMap();
      break;

    case T_VERTEX:
      break;

    case T_THING:
      for(i=0; i<ThingsNum; i++)
        if(eThing[i].Selected)
          eThing[i].Used = !eThing[i].Selected;
      UnSelectAll();
      RepaintMap();
      break;
    }
}

void DoomEdEditPartDelete(void)
{
  int   i;
  // remove currently selected item(s)
  switch(Tool) {
    case T_LINE:
      for(i=0; i<LineDefsNum; i++)
        if(eLineDef[i].Used)
          eLineDef[i].Used = (!eLineDef[i].Selected);
      UnSelectAll();
      RepaintMap();
      break;

    case T_SECTOR:
      DetachSectors();
      for(i=0; i<VertexNum; i++)
        if(eVertex[i].Used)
          eVertex[i].Used = (!eVertex[i].Moving);
      for(i=0; i<LineDefsNum; i++)
        if(eLineDef[i].Used)
          eLineDef[i].Used = (!eLineDef[i].Moving);
      for(i=0; i<SectorsNum; i++)
        if(eSector[i].Used)
          eSector[i].Used = (!eSector[i].Selected);
      UnSelectAll();
      RepaintMap();
      break;

    case T_VERTEX:
      break;

    case T_THING:
      for(i=0; i<ThingsNum; i++)
        if(eThing[i].Selected)
          eThing[i].Used = !eThing[i].Selected;
      UnSelectAll();
      RepaintMap();
      break;
    }
}

void DoomEdEditAttributes(void)
{
}

void DoomEdScale(void)
{
}

void DoomEdRotate(void)
{
}

static RECT      re; // rotation extent
static POINT     rc; // rotation center

void SectorRotateScale(void)
{
  if(SelectedSectors == 0) {
    ErrorMessage(IDS_NOSECTORS);
    return;
    }
  
  re.left = re.bottom = MAXINT;
  re.right = re.top = MININT;
  GetSectorExtents();
  for(int i = 0; i < SectorsNum; i++)
    if(eSector[i].Used && eSector[i].Selected) {
      re.left   = min(re.left,   eSector[i].Extent.left);
      re.right  = max(re.right,  eSector[i].Extent.right);
      re.top    = max(re.top,    eSector[i].Extent.top);
      re.bottom = min(re.bottom, eSector[i].Extent.bottom);
      }
  rc.x = re.left + ((re.right - re.left) / 2);
  rc.y = re.bottom + ((re.top - re.bottom) / 2);

  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogRotateScale, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_ROTATE),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hXScale, hYScale, hRotate;
static int  xscale, yscale, degrees;

int EXPORT DialogRotateScale(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  BOOL  XlateErr = FALSE;
  switch(wMsg) {
    case WM_INITDIALOG:
      hXScale = GetDlgItem(hDlg, IDC_XSCALE);
      hYScale = GetDlgItem(hDlg, IDC_YSCALE);
      hRotate = GetDlgItem(hDlg, IDC_DEGREES);
      SetDlgItemInt(hDlg, IDC_XSCALE,  100, FALSE);
      SetDlgItemInt(hDlg, IDC_YSCALE,  100, FALSE);
      SetDlgItemInt(hDlg, IDC_DEGREES,   0, TRUE);
      return FALSE;
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          // here's where the work is done:
          xscale  = GetDlgItemInt(hDlg, IDC_XSCALE,   &XlateErr, FALSE);
          yscale  = GetDlgItemInt(hDlg, IDC_YSCALE,   &XlateErr, FALSE);
          degrees = GetDlgItemInt(hDlg, IDC_DEGREES,  &XlateErr, TRUE);
          if((xscale != 100) || (yscale != 100) || (degrees != 0)) {
            double x, y;
            DetachSectors();
            for(int i = 0; i < VertexNum; i++)
              if(eVertex[i].Used && eVertex[i].Moving) {
                // this vertex must change:
                // FIRST: scale (really easy)
                if(xscale != 100) {
                  x = Vertex[i].x - rc.x;
                  x = (x * (double)xscale) / (double)100;
                  Vertex[i].x = rc.x + (int)x;
                  } // endif xscale != 100
                if(yscale != 100) {
                  y = Vertex[i].y - rc.y;
                  y = (y * (double)yscale) / (double)100;
                  Vertex[i].y = rc.y + (int)y;
                  } // endif yscale != 100
                // NEXT: rotate (still pretty simple)
                if(degrees != 0) {
                  x = Vertex[i].x - rc.x;   // distance to center point
                  y = Vertex[i].y - rc.y;
                  double dd2 = (double)(atan2((double)y, (double)x) / PI180);
                  double dd1 = (double)_hypot((double)x, (double)y);
                  dd2 -= (double)degrees;
                  dd2 *= (double)PI180;
                  Vertex[i].x = rc.x + (int)(cos(dd2) * dd1);
                  Vertex[i].y = rc.y + (int)(sin(dd2) * dd1);
                  }
                }
            ProcessJoins();
            RepaintMap();
            }
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          return FALSE;
        }
    default:
      return FALSE;
    }
}
