// File Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void PurgeWad(void);
void BuildReject(void);
void DoSave(void);

void DoomEdFileOpen(void)
{
  int   i;
  char  szTemp[4];
  if(OpenAFile()) {
    // check extension to determine what it is
    for(i=0; i<(int)strlen(szPrevFile1); i++)
      if(szPrevFile1[i] == '.')
        break;
    szTemp[0] = szPrevFile1[i+1];
    szTemp[1] = szPrevFile1[i+2];
    szTemp[2] = szPrevFile1[i+3];
    szTemp[3] = '\0';
    AnsiLower(szTemp);  // convert to lower case
    if(strcmp(szTemp, "wad") == 0) {
      LoadWad(szPrevFile1);
      DoDirectory();
      }
//    if(strcmp(szTemp, "pro") == 0)
//      LoadProject(szPrevFile1);
//    if(strcmp(szTemp, "map") == 0)
//      LoadMap(szPrevFile1);
//    if(strcmp(szTemp, "blk") == 0)
//      LoadBlock(szPrevFile1);
    }
}

void DoomEdFileClose(void)
{
}

void DoomEdFileSave(void)
{
  // This routine saves the current map over an existing map:

  int       i, j;
  long      DirOffset,      // where directory is in our WAD file
            Entries = 1;
  OFSTRUCT  ff;             // openfile structure
  HFILE     WadFile;        // file handles

  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    MapEdited = MapNodes = FALSE;
    Button_Enable(hCBSave, FALSE);
    return;
    }

  if(MapNodes) {
    DoSave();
    PackMap();
    BuildBlockmap();
    BuildReject();
    BspBuild();
    }

  MapEntry = Nothing;
  j = strlen(szMapName);
  
  for(i = 0; i < DirEntries; i++)
    if(strncmp(szMapName, Dir[i].Title, j) == 0) {
      MapEntry = i;
      break;
      }
  
  WadFile = OpenFile(szPrevFile1, &ff, OF_READWRITE);
  // get critical information from Wad file:
  _llseek(WadFile, 8L, 0);          // offset to directory
  _lread(WadFile, &DirOffset, 4);   // where directory is now

  if(MapEntry == Nothing) {
    MapEntry = DirEntries;
    }
  else {
    if(((Dir[MapEntry].Title[0] == 'E') &&
        (Dir[MapEntry].Title[2] == 'M')) ||
       ((Dir[MapEntry].Title[0] == 'M') &&
        (Dir[MapEntry].Title[1] == 'A') &&
        (Dir[MapEntry].Title[2] == 'P'))) {
      for(i = MapEntry + 1; i < MapEntry + 12; i++) 
        if((Dir[i].Type != WD_THINGS) &&
           (Dir[i].Type != WD_LINEDEFS) &&
           (Dir[i].Type != WD_SIDEDEFS) &&
           (Dir[i].Type != WD_VERTEXES) &&
           (Dir[i].Type != WD_SEGS) &&
           (Dir[i].Type != WD_SSECTORS) &&
           (Dir[i].Type != WD_NODES) &&
           (Dir[i].Type != WD_SECTORS) &&
           (Dir[i].Type != WD_REJECT) &&
           (Dir[i].Type != WD_BLOCKMAP) &&
           (Dir[i].Type != WD_ID) &&
           (Dir[i].Type != WD_TAG))
          break;
        else
          Entries++;

      DirEntries -= (int)Entries;    // delete from end.

      for(j = MapEntry; j < DirEntries; j++)
        Dir[j] = Dir[j + Entries];
      // now have deleted the old directory pointers (if required)
      }
    // insert at start or middle
    DirEntries += 12;
    for(j = DirEntries; j > MapEntry; j--)
      if(j > 12)
        Dir[j] = Dir[j - 12];
    }
  
  Dir[MapEntry].Length = 0;
  Dir[MapEntry].Offset = DirOffset;
  strcpy(Dir[MapEntry].Title, szMapName);

  _llseek(WadFile, DirOffset, 0);   // where we start adding

  Dir[MapEntry + 1].Length = (DWORD)ThingsNum * sizeof(WadThings);
  Dir[MapEntry + 1].Offset = Dir[MapEntry].Offset + Dir[MapEntry].Length;
  strcpy(Dir[MapEntry + 1].Title, "THINGS");
  _hwrite(WadFile, Thing, Dir[MapEntry + 1].Length);

  Dir[MapEntry + 2].Length = (DWORD)LineDefsNum * sizeof(WadLineDefs);
  Dir[MapEntry + 2].Offset = Dir[MapEntry + 1].Offset +
                             Dir[MapEntry + 1].Length;
  strcpy(Dir[MapEntry + 2].Title, "LINEDEFS");
  _hwrite(WadFile, LineDef, Dir[MapEntry + 2].Length);

  Dir[MapEntry + 3].Length = (DWORD)SideDefsNum * sizeof(WadSideDefs);
  Dir[MapEntry + 3].Offset = Dir[MapEntry + 2].Offset +
                             Dir[MapEntry + 2].Length;
  strcpy(Dir[MapEntry + 3].Title, "SIDEDEFS");
  _hwrite(WadFile, SideDef, Dir[MapEntry + 3].Length);

  Dir[MapEntry + 4].Length = (DWORD)VertexNum * sizeof(POINT);
  Dir[MapEntry + 4].Offset = Dir[MapEntry + 3].Offset +
                             Dir[MapEntry + 3].Length;
  strcpy(Dir[MapEntry + 4].Title, "VERTEXES");
  _hwrite(WadFile, Vertex, Dir[MapEntry + 4].Length);

  Dir[MapEntry + 5].Length = (DWORD)SegsNum * sizeof(WadSegs);
  Dir[MapEntry + 5].Offset = Dir[MapEntry + 4].Offset +
                             Dir[MapEntry + 4].Length;
  strcpy(Dir[MapEntry + 5].Title, "SEGS");
  _hwrite(WadFile, Seg, Dir[MapEntry + 5].Length);

  Dir[MapEntry + 6].Length = (DWORD)SSectorsNum * sizeof(WadSSectors);
  Dir[MapEntry + 6].Offset = Dir[MapEntry + 5].Offset +
                             Dir[MapEntry + 5].Length;
  strcpy(Dir[MapEntry + 6].Title, "SSECTORS");
  _hwrite(WadFile, SSector, Dir[MapEntry + 6].Length);

  Dir[MapEntry + 7].Length = (DWORD)NodesNum * sizeof(WadNodes);
  Dir[MapEntry + 7].Offset = Dir[MapEntry + 6].Offset +
                             Dir[MapEntry + 6].Length;
  strcpy(Dir[MapEntry + 7].Title, "NODES");
  _hwrite(WadFile, Node, Dir[MapEntry + 7].Length);

  Dir[MapEntry + 8].Length = (DWORD)SectorsNum * sizeof(WadSectors);
  Dir[MapEntry + 8].Offset = Dir[MapEntry + 7].Offset +
                             Dir[MapEntry + 7].Length;
  strcpy(Dir[MapEntry + 8].Title, "SECTORS");
  _hwrite(WadFile, Sector, Dir[MapEntry + 8].Length);

  Dir[MapEntry + 9].Length = (DWORD)RejectSize;
  Dir[MapEntry + 9].Offset = Dir[MapEntry + 8].Offset +
                             Dir[MapEntry + 8].Length;
  strcpy(Dir[MapEntry + 9].Title, "REJECT");
  _hwrite(WadFile, Reject, Dir[MapEntry + 9].Length);

  Dir[MapEntry + 10].Length = (DWORD)BlockMapSize;
  Dir[MapEntry + 10].Offset = Dir[MapEntry + 9].Offset +
                              Dir[MapEntry + 9].Length;
  strcpy(Dir[MapEntry + 10].Title, "BLOCKMAP");
  _hwrite(WadFile, BlockMap, Dir[MapEntry + 10].Length);

  Dir[MapEntry + 11].Offset = Dir[MapEntry + 10].Offset +
                              Dir[MapEntry + 10].Length;
  strcpy(Dir[MapEntry + 11].Title, "TAGDESC");
  Dir[MapEntry + 11].Length = (DWORD)(TagsNum - 1) * sizeof(WadTags);
  _hwrite(WadFile, &Tag[1], Dir[MapEntry + 11].Length);

  DirOffset = Dir[MapEntry + 11].Offset +
              Dir[MapEntry + 11].Length;
    
  Entries = (long)DirEntries;
  _llseek(WadFile, 4L, 0);          // seek to entries
  _lwrite(WadFile, &Entries, 4);    // write how many there are
  _llseek(WadFile, 8L, 0);          // seek to dir offset
  _lwrite(WadFile, &DirOffset, 4);  // write directory location
  _llseek(WadFile, DirOffset, 0);   // seek to what is now the directory

  for(i=0; i<DirEntries; i++)       // now write directory
    _lwrite(WadFile, &Dir[i], 16);  // first 16 bytes of each record

  _lclose(WadFile);

  // reload the wad file
  LoadWad(szPrevFile1);
  if(DirEntries < 200) {
    PurgeWad();
    LoadWad(szPrevFile1);
    }
  MapEdited = MapNodes = FALSE;
  Button_Enable(hCBSave, FALSE);
  return;
}

void DoomEdFileSaveAs(void)
{
  int           cbString, i;
  char          szFilter[128], chReplace;
  OPENFILENAME  ofn;

  strcpy(szExportFile, "*.wad");
  cbString = LoadString(hinst, IDS_FILTER_WAD,
                        szFilter, sizeof(szFilter));
  chReplace = szFilter[cbString - 1];
  for(i = 0; szFilter[i] != '\0'; i++)
    if(szFilter[i] == chReplace)
      szFilter[i] = '\0';
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize     = sizeof(OPENFILENAME);
  ofn.hwndOwner       = hwnd;
  ofn.lpstrFilter     = szFilter;
  ofn.nFilterIndex    = 1;
  ofn.lpstrFile       = szExportFile;
  ofn.nMaxFile        = sizeof(szExportFile);
  ofn.lpstrFileTitle  = NULL;
  ofn.nMaxFileTitle   = 0;
  ofn.lpstrInitialDir = szExportDir;
  ofn.Flags           = OFN_OVERWRITEPROMPT;
  ofn.lpstrTitle      = "Save As...";
  if(GetSaveFileName(&ofn)) {
    OFSTRUCT ff;
    HFILE WadFile = OpenFile(ofn.lpstrFile, &ff, OF_CREATE | OF_WRITE);
    DWORD tword = 0;
    _llseek(WadFile, 0L, 0);
    _lwrite(WadFile, "PWAD", 4);    // patch wad indicator
    _lwrite(WadFile, &tword, 4);    // no records
    tword = 12;
    _lwrite(WadFile, &tword, 4);    // offset to directory
    _lclose(WadFile);
    // copy old file to new file
    CopyWad(ofn.lpstrFile, szPrevFile1);
    strcpy(szPrevFile1, ofn.lpstrFile);
    DoomEdFileSave();
    }
}


void DoomEdFileNew(void)
{
  int           cbString, i;
  char          szFilter[128], chReplace;
  OPENFILENAME  ofn;

  strcpy(szExportFile, "*.wad");
  cbString = LoadString(hinst, IDS_FILTER_WAD,
                        szFilter, sizeof(szFilter));
  chReplace = szFilter[cbString - 1];
  for(i = 0; szFilter[i] != '\0'; i++)
    if(szFilter[i] == chReplace)
      szFilter[i] = '\0';
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize     = sizeof(OPENFILENAME);
  ofn.hwndOwner       = hwnd;
  ofn.lpstrFilter     = szFilter;
  ofn.nFilterIndex    = 1;
  ofn.lpstrFile       = szExportFile;
  ofn.nMaxFile        = sizeof(szExportFile);
  ofn.lpstrFileTitle  = NULL;
  ofn.nMaxFileTitle   = 0;
  ofn.lpstrInitialDir = szExportDir;
  ofn.Flags           = OFN_OVERWRITEPROMPT;
  ofn.lpstrTitle      = "New Wad File";
  if(GetSaveFileName(&ofn)) {
    strcpy(szPrevFile1, ofn.lpstrFile);
    OFSTRUCT ff;
    HFILE WadFile = OpenFile(szPrevFile1, &ff, OF_CREATE | OF_WRITE);
    DWORD tword = 0;
    _llseek(WadFile, 0L, 0);
    _lwrite(WadFile, "PWAD", 4);    // patch wad indicator
    _lwrite(WadFile, &tword, 4);    // no records
    tword = 12;
    _lwrite(WadFile, &tword, 4);    // offset to directory
    _lclose(WadFile);
    DirEntries = 0;
    }
}

void DoomEdFilePrint(void)
{
}

void DoomEdFileExport(void)
{
  ExportDWD();
}

void DoomEdFileExit(void)
{
}

void LoadPreviousFile(WPARAM wParam)
{
  int   i;
  char  szTemp[80];
  HMENU hMenu;
  
  switch(wParam) {
    case ID_FILE_FILE1:
      goto IsOk;
      break;
    case ID_FILE_FILE2:
      strcpy(szTemp, szPrevFile2);
      strcpy(szPrevFile2, szPrevFile1);
      strcpy(szPrevFile1, szTemp);
      goto IsOk;
      break;
    case ID_FILE_FILE3:
      strcpy(szTemp, szPrevFile3);
      strcpy(szPrevFile3, szPrevFile2);
      strcpy(szPrevFile2, szPrevFile1);
      strcpy(szPrevFile1, szTemp);
      goto IsOk;
      break;
    case ID_FILE_FILE4:
      strcpy(szTemp, szPrevFile4);
      strcpy(szPrevFile4, szPrevFile3);
      strcpy(szPrevFile3, szPrevFile2);
      strcpy(szPrevFile2, szPrevFile1);
      strcpy(szPrevFile1, szTemp);
      goto IsOk;
      break;
    default:
      return;
    }
IsOk:
  // update the File menu to reflect the change(s)
  hMenu = GetSubMenu(GetMenu(hwnd), 0);
  RemoveMenu(hMenu, ID_FILE_FILE1, MF_BYCOMMAND);
  RemoveMenu(hMenu, ID_FILE_FILE2, MF_BYCOMMAND);
  RemoveMenu(hMenu, ID_FILE_FILE3, MF_BYCOMMAND);
  RemoveMenu(hMenu, ID_FILE_FILE4, MF_BYCOMMAND);
  if(szPrevFile1[0] != '\0')
    AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE1, szPrevFile1);
  if(szPrevFile2[0] != '\0')
    AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE2, szPrevFile2);
  if(szPrevFile3[0] != '\0')
    AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE3, szPrevFile3);
  if(szPrevFile4[0] != '\0')
    AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE4, szPrevFile4);

  // find the extension of the file and load as required
  for(i=0; i<(int)strlen(szPrevFile1); i++)
    if(szPrevFile1[i] == '.')
      break;
  szTemp[0] = szPrevFile1[i+1];
  szTemp[1] = szPrevFile1[i+2];
  szTemp[2] = szPrevFile1[i+3];
  szTemp[3] = '\0';
  AnsiLower(szTemp);  // convert to lower case
  if(strcmp(szTemp, "wad") == 0) {
    LoadWad(szPrevFile1);
    DoDirectory();
    }
//  if(strcmp(szTemp, "pro") == 0)
//    LoadProject(szPrevFile1);
//  if(strcmp(szTemp, "map") == 0)
//    LoadMap(szPrevFile1);
//  if(strcmp(szTemp, "blk") == 0)
//    LoadBlock(szPrevFile1);
}

// The following routines are called to mark map changes:

void MapChange(void)
{
  // called when something requires a save
  if(!MapEdited) {
    MapEdited = TRUE;
    Button_Enable(hCBSave, TRUE);
    }
}

void MapChangeNode(void)
{
  // called when something requires nodes building
  MapChange();
  MapNodes = TRUE;
}

// Save Options dialog:

int EXPORT DialogSave(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);

void DoSave(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogSave, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_SAVE),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hNone, hInternal, hExternal, hIdBsp, hQuick, hFull;

int EXPORT DialogSave(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  switch(wMsg) {
    case WM_INITDIALOG:
      hNone     = GetDlgItem(hDlg, IDC_NODE_NONE);
      hInternal = GetDlgItem(hDlg, IDC_NODE_INTERNAL);
      hExternal = GetDlgItem(hDlg, IDC_NODE_EXTERNAL);
      hIdBsp    = GetDlgItem(hDlg, IDC_NODE_IDBSP);
      hQuick    = GetDlgItem(hDlg, IDC_REJECT_QUICK);
      hFull     = GetDlgItem(hDlg, IDC_REJECT_THOROUGH);
      switch(NodeBuilderAction) {
        case NODE_NONE:
          Button_SetCheck(hNone, TRUE);
          break;
        case NODE_INTERNAL:
          Button_SetCheck(hInternal, TRUE);
          break;
        case NODE_EXTERNAL:
          Button_SetCheck(hExternal, TRUE);
          break;
        case NODE_IDBSP:
          Button_SetCheck(hIdBsp, TRUE);
          break;
        default:
          break;
        }
      if(RejectAction == REJECT_QUICK)
        Button_SetCheck(hQuick, TRUE);
      else
        Button_SetCheck(hFull, TRUE);
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDOK:
          if(Button_GetCheck(hNone))
            NodeBuilderAction = NODE_NONE;
          if(Button_GetCheck(hInternal))
            NodeBuilderAction = NODE_INTERNAL;
          if(Button_GetCheck(hExternal))
            NodeBuilderAction = NODE_EXTERNAL;
          if(Button_GetCheck(hIdBsp))
            NodeBuilderAction = NODE_IDBSP;
          if(Button_GetCheck(hQuick))
            RejectAction = REJECT_QUICK;
          if(Button_GetCheck(hFull))
            RejectAction = REJECT_FULL;
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}

int EXPORT StubDlgProc(HWND hDlg,
                       WORD wMsg,
                       WORD wParam,
                       DWORD lParam);

void CopyWad(char *dest, char *source)
{
  char      szTemp[16];
  int       i, j = 0, Percent, OldPercent = 0, ProgWidth;
  long      MaxLen = 0,
            CurPos = 12,
            CurLen;
  OFSTRUCT  ff;
  HFILE     fi,     // file in (.bak file)
            fo;     // file out (.wad file)
  unsigned  char __huge *fbuf;
  HGLOBAL   hglb;
  HWND      hWndDlg, hPercent, hEntry, hEntries;
  FARPROC   lpfnStubDlgProc;
  HDC       rDC;
  RECT      ProgRect;
  HBRUSH    hProgressBrush, hOldBrush;
  HPEN      hProgressPen,   hOldPen;
  
  if(SharewareVersion) {
    ErrorMessage(IDS_SHAREWARE);
    return;
    }

  // if the destination file exists, delete it.
  if(OpenFile(dest, &ff, OF_EXIST))
    OpenFile(dest, &ff, OF_DELETE);

  for(i = 0; i < DirEntries; i++) // find maximum length
    MaxLen = max(Dir[i].Length, MaxLen);

  hglb = GlobalAlloc(GMEM_FIXED, MaxLen);
  fbuf = (unsigned char __huge *)GlobalLock(hglb);
  
  fi = _lopen(source, READ);
  _llseek(fi, 0L, 0);
  _lread(fi, &szTemp, 4);           // signature
  fo = OpenFile(dest, &ff, OF_CREATE);
  _lwrite(fo, &szTemp, 4);          // signature
  CurLen = (long)DirEntries;
  _lwrite(fo, &CurLen, 4);          // number of entries
  _lwrite(fo, &CurLen, 4);          // placeholder for dir offset

  hWndDlg = NULL;                   // handle for destroying
  lpfnStubDlgProc = MakeProcInstance((FARPROC) StubDlgProc, hinst);
  if(lpfnStubDlgProc)
    hWndDlg = CreateDialog(hinst,
                           MAKEINTRESOURCE(IDD_UPDATE_STATUS),
                           hwnd,
                           lpfnStubDlgProc);
  // Graphic location:
  ProgRect.top    = 42;
  ProgRect.bottom = 56;
  ProgRect.left   = 11;
  ProgRect.right  = 143;
  MapDialogRect(hWndDlg, &ProgRect);
  ProgRect.top++;
  ProgWidth = ProgRect.right - ProgRect.left;
  hProgressBrush = CreateSolidBrush(ColorMarked);
  hProgressPen   = CreatePen(PS_NULL, NULL, NULL);

  hPercent = GetDlgItem(hWndDlg, IDC_PERCENT);
  hEntry   = GetDlgItem(hWndDlg, IDC_ITEMNUMBER);
  hEntries = GetDlgItem(hWndDlg, IDC_TOTALITEMS);
  
  // display total entries in dialog
  wsprintf(szTemp, "%i", DirEntries);
  Static_SetText(hEntries, szTemp);
  
  for(i = 0; i < DirEntries; i++) {
    // display current entry in dialog
    wsprintf(szTemp, "%i", (i + 1));
    Static_SetText(hEntry, szTemp);

    // display percent remaining in dialog
    Percent = (int)(((long)(DirEntries - i) * 100) /
                     (long)DirEntries);
    if(Percent != OldPercent) {
      wsprintf(szTemp, "%u", Percent);
      Static_SetText(hPercent, szTemp);
      OldPercent = Percent;
      // update graphic to reflect progress:
      rDC = GetDC(hWndDlg);
      hOldBrush = SelectBrush(rDC, hProgressBrush);
      hOldPen   = SelectPen(rDC, hProgressPen);
      Rectangle(rDC, ProgRect.left, ProgRect.top,
                     ProgRect.left + ((ProgWidth * (100 - Percent)) / 100),
                     ProgRect.bottom);
      SelectBrush(rDC, hOldBrush);
      SelectPen(rDC, hOldPen);
      ReleaseDC(hWndDlg, rDC);
      }

    if(Dir[i].Length) {           // allow for zero-length
      // seek to old file location:
      _llseek(fi, Dir[i].Offset, 0);
      // read data chunk
      _hread(fi, fbuf, Dir[i].Length);
      // write to new file location:
      _hwrite(fo, fbuf, Dir[i].Length);
      }
    // do this even if nothing was written:
    // set the Offset:
    Dir[i].Offset = CurPos;
    // keep current location current
    CurPos += Dir[i].Length;
    }

  WadUsed = WadSize = CurPos;
  for(i = 0; i < DirEntries; i++)   // now write directory
    _lwrite(fo, &Dir[i], 16);   // first 16 bytes of each record (clever!)
  _llseek(fo, 8, 0);            // offset to directory
  _lwrite(fo, &CurPos, 4);      // CurPos is where directory was written
  
  _lclose(fo);
  _lclose(fi);

  GlobalUnlock(hglb);
  GlobalFree(hglb);
  
  DeleteBrush(hProgressBrush);
  DeletePen(hProgressPen);
  DestroyWindow(hWndDlg);
  FreeProcInstance(lpfnStubDlgProc);
}

