// Initialization for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"
#include <toolhelp.h>

BOOL DoomWadValid = FALSE;

BOOL DoomEdInit(HANDLE hInstance,
                HANDLE hPrevInstance,
                LPSTR lpszCmdLine,
                int nCmdShow)
{
  int   i;
  char  szTemp[128], szNum[32];
  int   Splashx, Splashy;   // position for splash panel
  RECT  rDesktop, rSplash, trect;
  HMENU hMenu;
  
  hinst = hInstance;        // set global hinst

  // get out if we're already running
  if(hPrevInstance) {
    // give user a stern lecture
    Message(IDS_ERROR_INSTANCES);
    // reactivate the previous instance
    BringWindowToTop(FindWindow(ProgName, NULL));
    return FALSE;
   }

  // change to hour glass to show we mean business:
  CURSOR_BUSY
  
  // display splash screen during startup
  // get size of desktop (ie. screen size)
  GetWindowRect(GetDesktopWindow(), &rDesktop);
  // set up for a modeless dialog box
  lpfnDialogSplash = MakeProcInstance((int (__far __pascal *)
                                      (void))DialogSplash, hInstance);
  hwndDialogSplash = CreateDialog(hInstance,
                                  MAKEINTRESOURCE(IDD_SPLASH),
                                  GetDesktopWindow(),
                                  lpfnDialogSplash);
  // find out how big the splash screen is
  GetWindowRect(hwndDialogSplash, &rSplash);
  // center it in the desktop
  Splashx = (rDesktop.right / 2) - (rSplash.right / 2);
  Splashy = (rDesktop.bottom / 2) - (rSplash.bottom / 2);
  SetWindowPos(hwndDialogSplash, HWND_TOPMOST, Splashx, Splashy,
               0, 0, SWP_NOSIZE | SWP_DRAWFRAME);
  // show splash
  ShowWindow(hwndDialogSplash, SW_NORMAL);
  // force the bitmap to be drawn
  InvalidateRect(hwndDialogSplash, NULL, TRUE);
  SendMessage(hwndDialogSplash, WM_PAINT, (WPARAM)0, (LPARAM)0);
  
  // set the memory limitations:
  MAX_THING   = 1;
  MAX_LINEDEF = 1;
  MAX_SIDEDEF = 1;
  MAX_VERTEX  = 1;
  MAX_SEG     = 1;
  MAX_SSECTOR = 1;
  MAX_NODE    = 1;
  MAX_SECTOR  = 1;

  MAX_TAG     = 100;
  MAX_STYLE   = 32;
  MAX_BUILDER = 16;

  // get the default colors from the ini file:
  GetPrivateProfileString("Colors", "Background", "0",
                          szTemp, 128, IniFile);
  sscanf(szTemp, "%lx", &(COLORREF)ColorBackground);
  hPenBackground = CreatePen(PS_SOLID, 0, ColorBackground);
  hBrushBackground = CreateSolidBrush(ColorBackground);
  GetPrivateProfileString("Colors", "MapLines", "FF",
                          szTemp, 128, IniFile);
  sscanf(szTemp, "%lx", &(COLORREF)ColorMapLines);
  hPenMapLines = CreatePen(PS_SOLID, 0, ColorMapLines);
  hBrushMapLines = CreateSolidBrush(ColorMapLines);
  GetPrivateProfileString("Colors", "MapInnerLines", "FFFF",
                          szTemp, 128, IniFile);
  sscanf(szTemp, "%lx", &(COLORREF)ColorMapInnerLines);
  hPenMapInnerLines = CreatePen(PS_SOLID, 0, ColorMapInnerLines);
  hBrushMapInnerLines = CreateSolidBrush(ColorMapInnerLines);
  GetPrivateProfileString("Colors", "Selected", "FF00FF",
                          szTemp, 128, IniFile);
  sscanf(szTemp, "%lx", &(COLORREF)ColorSelected);
  hPenSelected = CreatePen(PS_SOLID, 0, ColorSelected);
  hBrushSelected = CreateSolidBrush(ColorSelected);
  GetPrivateProfileString("Colors", "Marked", "FF00",
                          szTemp, 128, IniFile);
  sscanf(szTemp, "%lx", &(COLORREF)ColorMarked);
  hPenMarked = CreatePen(PS_SOLID, 0, ColorMarked);
  hBrushMarked = CreateSolidBrush(ColorMarked);
  GetPrivateProfileString("Colors", "Grid", "C0C0C0",
                          szTemp, 128, IniFile);
  sscanf(szTemp, "%lx", &(COLORREF)ColorGrid);
  hPenGrid = CreatePen(PS_SOLID, 0, ColorGrid);
  hBrushGrid = CreateSolidBrush(ColorGrid);
  GetPrivateProfileString("Colors", "UserGrid", "833FC0",
                          szTemp, 128, IniFile);
  sscanf(szTemp, "%lx", &(COLORREF)ColorUserGrid);
  hPenUserGrid = CreatePen(PS_SOLID, 0, ColorUserGrid);
  hBrushUserGrid = CreateSolidBrush(ColorUserGrid);
  
  hPenDrag = CreatePen(PS_SOLID, 0, 0xFF00FF);
  hBrushNull = GetStockObject(NULL_BRUSH);
  
  // get options selectable using Options dialog
  oVerifyExit =
  GetPrivateProfileInt("Options", "VerifyExit", 1,                   IniFile);
  oShowSnapToGrid =
  GetPrivateProfileInt("Options", "ShowSnapToGrid", 0,               IniFile);
  oShow64x64Grid =
  GetPrivateProfileInt("Options", "Show64x64Grid", 1,                IniFile);
  oBuildNodesAtEverySave =
  GetPrivateProfileInt("Options", "BuildNodesAtEverySave", 0,        IniFile);
  oAutoStitchDuringConstruction =
  GetPrivateProfileInt("Options", "AutoStitchDuringConstruction", 1, IniFile);
  oAutoLoadMostRecentFile = TRUE;
  oVerifyAfterEdit =
  GetPrivateProfileInt("Options", "VerifyAfterEdit", 0,              IniFile);
  NodeBuilderAction =
  GetPrivateProfileInt("Options", "NodeBuilder", NODE_INTERNAL,      IniFile);
  RejectAction =
  GetPrivateProfileInt("Options", "RejectBuilder", REJECT_FULL,      IniFile);
  GridSize =
  GetPrivateProfileInt("Options", "GridSize", 16,                    IniFile);
  // get recent files:
  GetPrivateProfileString("Files", "RecentFile1", "\0",
                          szPrevFile1, 128, IniFile);
  GetPrivateProfileString("Files", "RecentFile2", "\0",
                          szPrevFile2, 128, IniFile);
  GetPrivateProfileString("Files", "RecentFile3", "\0",
                          szPrevFile3, 128, IniFile);
  GetPrivateProfileString("Files", "RecentFile4", "\0",
                          szPrevFile4, 128, IniFile);

  // get editors:
  GetPrivateProfileString("Editors", "Graphics", "pbrush",
                          szEditorGraphics, 128, IniFile);
  GetPrivateProfileString("Editors", "Text", "notepad",
                          szEditorText, 128, IniFile);
  GetPrivateProfileString("Editors", "Ansi", "\0",
                          szEditorAnsi, 128, IniFile);
  GetPrivateProfileString("Editors", "Sound", "soundrec",
                          szEditorSound, 128, IniFile);
  GetPrivateProfileString("Editors", "Music", "\0",
                          szEditorMusic, 128, IniFile);
  
  //  Register Main window class:
  rClass.lpszClassName = ProgName;
  rClass.hInstance     = hInstance;
  rClass.lpfnWndProc   = DoomEdWindowProc;
  rClass.hCursor       = LoadCursor(NULL, IDC_ARROW);   // standard
  rClass.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_MAINICON));
  rClass.lpszMenuName  = MAKEINTRESOURCE(IDR_MAINMENU);
  rClass.hbrBackground = hBrushBackground;              // our color
  rClass.style         = CS_HREDRAW | CS_VREDRAW |      // redraw on resize
                         CS_OWNDC | CS_DBLCLKS;         // our own DC
  rClass.cbClsExtra    = 0;                             // no extra words
  rClass.cbWndExtra    = 0;
  if(!RegisterClass(&rClass)) {
    // give user a heart attack:
    ErrorMessage(IDS_ERROR_DOOMEDCLASS);
    // get rid of hourglass before leaving
    CURSOR_NOTBUSY
    return FALSE;
    }
  // Register our custom dialog class:
  dClass.lpszClassName = "DoomEdDialog";    // its name
  dClass.hInstance     = hInstance;         // only for this program
  dClass.lpfnWndProc   = CustomDialogProc;  // the dialog procedure
  dClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  dClass.hIcon         = NULL;              // can't minimize, no icon
  dClass.lpszMenuName  = NULL;              // no menus
  dClass.hbrBackground = hBrushBackground;  // our chosen color
  dClass.style         = CS_SAVEBITS;       // attempt to save background
  dClass.cbClsExtra    = 0;                 // nothing extra
  dClass.cbWndExtra    = DLGWINDOWEXTRA;    // standard Windows dialog class
  if(!RegisterClass(&dClass)) {
    // another way to give the user a heart attack
    ErrorMessage(IDS_ERROR_DIALOGCLASS);
    CURSOR_NOTBUSY
    return FALSE;
    }

    // create the actual Main window
    hwnd = CreateWindow(ProgName,
                        "Doom Editor for Windows",
                        WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN |
                        WS_HSCROLL | WS_VSCROLL,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        NULL,
                        NULL,
                        hInstance,
                        NULL);
    
    // stick the recent files list onto the File menu (if required...)
    hMenu = GetSubMenu(GetMenu(hwnd), 0);   // handle of "file" menu
    if(szPrevFile1[0] != '\0') {
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE1, szPrevFile1);
    if(szPrevFile2[0] != '\0')
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE2, szPrevFile2);
    if(szPrevFile3[0] != '\0')
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE3, szPrevFile3);
    if(szPrevFile4[0] != '\0')
      AppendMenu(hMenu, MF_ENABLED, ID_FILE_FILE4, szPrevFile4);
      }

    // Modeless Dialog support: lpfn's:
    lpfnDialogThing   = MakeProcInstance((int (__far __pascal *)
                                         (void))DialogThing, hInstance);
    lpfnDialogSector  = MakeProcInstance((int (__far __pascal *)
                                         (void))DialogSector, hInstance);
    lpfnDialogLineDef = MakeProcInstance((int (__far __pascal *)
                                         (void))DialogLineDef, hInstance);
    lpfnControlBar    = MakeProcInstance((int (__far __pascal *)
                                         (void))ControlBar, hInstance);
    lpfnControlBot    = MakeProcInstance((int (__far __pascal *)
                                         (void))ControlBot, hInstance);
    lpfnTileViewer    = MakeProcInstance((int (__far __pascal *)
                                         (void))DialogTileViewer, hInstance);
    lpfnTextureViewer = MakeProcInstance((int (__far __pascal *)
                                         (void))DialogTextureViewer, hInstance);
    lpfnProblems      = MakeProcInstance((int (__far __pascal *)
                                         (void))DialogMapCheck, hInstance);
    if((lpfnDialogThing    == NULL) ||
       (lpfnDialogSector   == NULL) ||
       (lpfnDialogLineDef  == NULL) ||
       (lpfnControlBar     == NULL) ||
       (lpfnControlBot     == NULL) ||
       (lpfnTileViewer     == NULL) ||
       (lpfnProblems       == NULL) ||
       (lpfnTextureViewer  == NULL)) {
      // hey, still another way to give the user a heart attack
      ErrorMessage(IDS_ERROR_LPFN);
      CURSOR_NOTBUSY
      return FALSE;
      }
    hwndControlBar    = CreateDialog(hinst,
                                     MAKEINTRESOURCE(IDD_CONTROLBAR),
                                     hwnd,
                                     lpfnControlBar);
    hwndControlBot    = CreateDialog(hinst,
                                     MAKEINTRESOURCE(IDD_CONTROLBOT),
                                     hwnd,
                                     lpfnControlBot);

    // Still more modeless support: show control bars
    GetClientRect(hwnd, &trect);    // relocate bottom bar:
    SetWindowPos(hwndControlBot, hwndControlBar, 0, trect.bottom - 20,
                 trect.right, trect.bottom,
                 SWP_NOACTIVATE);
    ShowWindow(hwndControlBot, SW_NORMAL);
    ShowWindow(hwndControlBar, SW_NORMAL);
    
    BottomMessage("");  // make sure copyright message is placed
    
    hAccel = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDR_ACCELERATOR1));

    // another routine which does initializing:
    Initialize();
    
    // get styles (needed to wait 'til memory was allocated):
    StylesNum = GetPrivateProfileInt("Styles", "NumberOfStyles", 0, IniFile);
    for(i=0; i<StylesNum; i++) {
      sprintf(szNum, "Style%u", i);
      GetPrivateProfileString(szNum, "Name", "null",
                              szTemp, 128, IniFile);
      strcpy(Style[i].Name, szTemp);
      GetPrivateProfileString(szNum, "Floor", "null",
                              szTemp, 128, IniFile);
      CopyWall(Style[i].Floor, szTemp);
      GetPrivateProfileString(szNum, "Ceiling", "null",
                              szTemp, 128, IniFile);
      CopyWall(Style[i].Ceiling, szTemp);
      GetPrivateProfileString(szNum, "Walls", "null",
                              szTemp, 128, IniFile);
      CopyWall(Style[i].Walls, szTemp);
      }
    if(StylesNum == 0) {
      // no styles in .ini file, add some default styles.
      strcpy(  Style[0].Name,    "Stone floor, Stone walls");
      CopyWall(Style[0].Walls,   "GRAY1");
      CopyWall(Style[0].Floor,   "FLOOR0_5");
      CopyWall(Style[0].Ceiling, "FLAT9");
      strcpy(  Style[1].Name,    "Gray floor, Wood walls");
      CopyWall(Style[1].Walls,   "WOOD1");
      CopyWall(Style[1].Floor,   "FLOOR0_5");
      CopyWall(Style[1].Ceiling, "CEIL3_6");
      strcpy(  Style[2].Name,    "Window frame");
      CopyWall(Style[2].Walls,   "DOORTRAK");
      CopyWall(Style[2].Floor,   "FLAT20");
      CopyWall(Style[2].Ceiling, "FLAT20");
      StylesNum = 3;
      }

    // get the current default sector and wall info:
    GetPrivateProfileString("DefaultSettings", "Walls", "null",
                            szTemp, 9, IniFile);
    if(strncmp(szTemp, "null", 4) == 0) {
      CopyWall(DefaultSectorWall, Style[0].Walls); }
    else {
      CopyWall(DefaultSectorWall, szTemp); }
    GetPrivateProfileString("DefaultSettings", "Floor", "null",
                            szTemp, 9, IniFile);
    if(strncmp(szTemp, "null", 4) == 0) {
      CopyWall(DefaultSectorFloor, Style[0].Floor); }
    else {
      CopyWall(DefaultSectorFloor, szTemp); }
    GetPrivateProfileString("DefaultSettings", "Ceiling", "null",
                            szTemp, 9, IniFile);
    if(strncmp(szTemp, "null", 4) == 0) {
      CopyWall(DefaultSectorCeil, Style[0].Ceiling); }
    else {
      CopyWall(DefaultSectorCeil, szTemp); }
    DefaultSectorBottom =
    GetPrivateProfileInt("DefaultSettings", "FloorHeight", 0, IniFile);
    DefaultSectorTop =
    GetPrivateProfileInt("DefaultSettings", "CeilingHeight", 128, IniFile);
    DefaultSectorLight =
    GetPrivateProfileInt("DefaultSettings", "Light", 200, IniFile);

    
    // get Builders
    BuildersNum = GetPrivateProfileInt("Builders", "NumberOfBuilders", 0, IniFile);
    for(i=0; i<BuildersNum; i++) {
      sprintf(szNum, "Builder%u", i);
      GetPrivateProfileString(szNum, "Name", "null",
                              szTemp, 128, IniFile);
      strcpy(Builder[i].Name, szTemp);
      GetPrivateProfileString(szNum, "Command", "null",
                              szTemp, 128, IniFile);
      strcpy(Builder[i].Command, szTemp);
      Builder[i].Format =
      GetPrivateProfileInt(szNum, "Format", 0, IniFile);
      }

    // More modeless support: hwnd's
    hwndDialogThing   = CreateDialog(hinst,
                                     MAKEINTRESOURCE(IDD_THING),
                                     hwnd,
                                     lpfnDialogThing);
    hwndDialogLineDef = CreateDialog(hinst,
                                     MAKEINTRESOURCE(IDD_LINEDEF),
                                     hwnd,
                                     lpfnDialogLineDef);
    hwndDialogSector  = CreateDialog(hinst,
                                     MAKEINTRESOURCE(IDD_SECTOR),
                                     hwnd,
                                     lpfnDialogSector);
    hwndTextureViewer = CreateDialog(hinst,
                                     MAKEINTRESOURCE(IDD_TEXTUREVIEWER),
                                     hwnd,
                                     lpfnTextureViewer);
    hwndProblems      = CreateDialog(hinst,
                                     MAKEINTRESOURCE(IDD_MAPCHECK),
                                     hwnd,
                                     lpfnProblems);
    if((hwndDialogThing    == NULL) ||
       (hwndDialogSector   == NULL) ||
       (hwndDialogLineDef  == NULL) ||
       (hwndControlBar     == NULL) ||
       (hwndControlBot     == NULL) ||
       (hwndProblems       == NULL) ||
       (hwndTextureViewer  == NULL)) {
      // yet another way to give the user a heart attack
      ErrorMessage(IDS_ERROR_HWND);
      CURSOR_NOTBUSY
      return FALSE;
      }

    // load the last wad if option is set:
    if(oAutoLoadMostRecentFile)
      if(szPrevFile1[0] != '\0')
        LoadWad(szPrevFile1);

    PopupSetup();
    // Change the title on the splash
    SendMessage(hwndDialogSplash, WM_SETTEXT, 0, (LPARAM)(LPCSTR)"Initialization Complete!");
    SetActiveWindow(hwnd);    // activate window
    DefThing.face = 0;        // facing east
    DefThing.item = 0x7f3;    // barrel
    DefThing.lev = 7;         // always by default
      
    DefSideDef.x = 0;         // texture offsets
    DefSideDef.y = 0;
    NullWall(DefSideDef.t1);  // above
    NullWall(DefSideDef.t2);  // below
    CopyWall(DefSideDef.t3, DefaultSectorWall);  // main
    DefSideDef.sector = 0;    // attached
    
    DefLineDef.solidity = ML_BLOCKING;
    DefLineDef.special = 0;   // normal
    DefLineDef.tag = 0;       // no tag
    DefLineDef.sidedef1 = Nothing;
    DefLineDef.sidedef2 = Nothing;
    
    DefSector.floorZ = DefaultSectorBottom;
    DefSector.ceilZ  = DefaultSectorTop;
    DefSector.light  = DefaultSectorLight;
    DefSector.flash  = 0;
    CopyWall(DefSector.Floor, DefaultSectorFloor);
    CopyWall(DefSector.Ceil, DefaultSectorCeil);

    BottomMapName("");    // erase "Init..."

    ShowWindow(hwnd, nCmdShow);

    CURSOR_NOTBUSY
    return hwnd;
}

void Initialize(void)
{
  int   i;
  
  // Allocate huge amount of memory for fixed data store:
  hgDoom      = GlobalAlloc(GHND, sizeof(WadDir));
  hgDir       = GlobalAlloc(GHND, sizeof(WadDir));
  hgReject    = GlobalAlloc(GHND, 64000);
  hgBlockMap  = GlobalAlloc(GHND, 64000);
  hgLineDef   = GlobalAlloc(GHND, sizeof(WadLineDefs));
  hgSideDef   = GlobalAlloc(GHND, sizeof(WadSideDefs));
  hgSSector   = GlobalAlloc(GHND, sizeof(WadSSectors));
  hgSector    = GlobalAlloc(GHND, sizeof(WadSectors));
  hgVertex    = GlobalAlloc(GHND, sizeof(POINT));
  hgThing     = GlobalAlloc(GHND, sizeof(WadThings));
  hgNode      = GlobalAlloc(GHND, sizeof(WadNodes));
  hgSeg       = GlobalAlloc(GHND, sizeof(WadSegs));
  hgTag       = GlobalAlloc(GHND, (DWORD)MAX_TAG * sizeof(WadTags));
  hgeLineDef  = GlobalAlloc(GHND, sizeof(ExtraLineDefs));
  hgeSideDef  = GlobalAlloc(GHND, sizeof(ExtraSideDefs));
  hgeSector   = GlobalAlloc(GHND, sizeof(ExtraSectors));
  hgeVertex   = GlobalAlloc(GHND, sizeof(ExtraVertex));
  hgeThing    = GlobalAlloc(GHND, sizeof(ExtraThings));
  hgStyle     = GlobalAlloc(GHND, (DWORD)MAX_STYLE * sizeof(Styles));
  hgBuilder   = GlobalAlloc(GHND, (DWORD)MAX_BUILDER * sizeof(Builders));
  hgProblem   = GlobalAlloc(GHND, (DWORD)50 * sizeof(prob));

  // lock the memory and get pointers:
  Doom     = (WadDir FAR *)             GlobalLock(hgDoom);
  Dir      = (WadDir FAR *)             GlobalLock(hgDir);
  LineDef  = (WadLineDefs __huge *)     GlobalLock(hgLineDef);
  SideDef  = (WadSideDefs __huge *)     GlobalLock(hgSideDef);
  Sector   = (WadSectors __huge *)      GlobalLock(hgSector);
  Vertex   = (POINT __huge *)           GlobalLock(hgVertex);
  Thing    = (WadThings __huge *)       GlobalLock(hgThing);
  Node     = (WadNodes __huge *)        GlobalLock(hgNode);
  SSector  = (WadSSectors __huge *)     GlobalLock(hgSSector);
  Seg      = (WadSegs __huge *)         GlobalLock(hgSeg);
  Tag      = (WadTags FAR *)            GlobalLock(hgTag);
  Reject   = (BYTE FAR *)               GlobalLock(hgReject);
  BlockMap = (int FAR *)                GlobalLock(hgBlockMap);
  Style    = (Styles FAR *)             GlobalLock(hgStyle);
  Builder  = (Builders FAR *)           GlobalLock(hgBuilder);
  eLineDef = (ExtraLineDefs __huge *)   GlobalLock(hgeLineDef);
  eSideDef = (ExtraSideDefs __huge *)   GlobalLock(hgeSideDef);
  eSector  = (ExtraSectors __huge *)    GlobalLock(hgeSector);
  eVertex  = (ExtraVertex __huge *)     GlobalLock(hgeVertex);
  eThing   = (ExtraThings __huge *)     GlobalLock(hgeThing);
  Problem  = (prob FAR *)               GlobalLock(hgProblem);

  // Default settings for options:
  MapLoaded = FALSE;
  MapEdited = FALSE;
  Paradigm  = P_SECTOR;
  Tool      = T_THING;

  // if no Doom.Wad, ask.
FindDoomWad:
  GetPrivateProfileString("Files", "DoomWad", "null",
                          szDoomWad, 128, IniFile);
  if(strcmp(szDoomWad, "null") == 0) {
    SplashDown();
    Message(IDS_FILE_DOOMWAD);
    DefineDoomWad();
    WritePrivateProfileString("Files", "DoomWad", szDoomWad, IniFile);
    }
  else
    if(!ReadDoomWadDirectory())
      TerminateApp(NULL, NO_UAE_BOX);
  if(!DoomWadValid)
    goto FindDoomWad;

  // if no game directory is found, use the path from szDoomWad
  GetPrivateProfileString("Directories", "Game", "null",
                           szDoomDir, 128, IniFile);
  if(strcmp(szDoomDir, "null") == 0) {
    strcpy(szDoomDir, szDoomWad);
    for(i=strlen(szDoomDir); TRUE; i--) {
      if(szDoomDir[i]=='\\') {
        szDoomDir[i] = '\0';
        break;
        }
      else
        szDoomDir[i] = '\0';
      }
    WritePrivateProfileString("Directories", "Game", szDoomDir, IniFile);
    }                           

  // if no export directory is found, use the game directory
  GetPrivateProfileString("Directories", "Export", "null",
                           szExportDir, 128, IniFile);
  if(strcmp(szExportDir, "null") == 0) {
    strcpy(szExportDir, szDoomDir);
    WritePrivateProfileString("Directories", "Export", szExportDir, IniFile);
    }

  ReadTextures();

  BottomMessage("");    // put copyright message
  return;                                                      
}


BOOL ReadDoomWadDirectory(void)
{
  HFILE  WadFile;
  char          szTemp[128], szTemp1[128];
  DWORD         DirOffset, TempDWORD;
  int           i, j;
  LOGPALETTE   *pLogPalette;
  BOOL          InSprites = FALSE, InPanels = FALSE, InTiles = FALSE;
  
  WadFile = _lopen(szDoomWad, OF_READ);
  if(WadFile == HFILE_ERROR) {
    SplashDown();
    GetWindowsDirectory(szTemp1, sizeof(szTemp1));
    strcat(szTemp1, "\\DoomEd30.Ini");
    sprintf(szTemp, "Critical Error: Can\'t open\n"
                    "file %s\n"
                    "(change this in %s).\n"
                    "Does this file exist?", szDoomWad, szTemp1);
    MessageBox(hwnd, szTemp, ProgErr, MB_ICONSTOP | MB_OK);
    return FALSE;
    }
  _lread(WadFile, szTemp, 4);            // read ID
  szTemp[4] = '\0';
  if ((strcmp(szTemp, "IWAD")==0) || (strcmp(szTemp, "PWAD")==0))
    {
    _lread(WadFile, &TempDWORD, 4);
    
    DoomEntries = (int)TempDWORD;
    GlobalUnlock(hgDoom);
    GlobalFree(hgDoom);
    hgDoom = GlobalAlloc(GMEM_MOVEABLE, (DWORD)DoomEntries * sizeof(WadDir));
      Doom = (WadDir *)GlobalLock(hgDoom);
    _lread(WadFile, &DirOffset, 4);         // find out where directory is
    _llseek(WadFile, DirOffset, 0);         // seek to directory area
    for(i=0; i<DoomEntries; i++) {          // read all directory entries
      _lread(WadFile, &Doom[i], 16);        // 16 bytes / record
      Doom[i].Title[8] = '\0';              // null term the string
      // Classify the object type:
      if(Doom[i].Length > 0) {
        if(InSprites) {
          Doom[i].Type = WD_SPRITE;
          continue;
          }
        if(InPanels) {
          Doom[i].Type = WD_PANEL;
          continue;
          }
        if(InTiles) {
          Doom[i].Type = WD_TILE;
          continue;
          }
        }
      if(strncmp(Doom[i].Title, "DS", 2) == 0) {
        Doom[i].Type = WD_SOUND;
        continue;
        }
      if(strncmp(Doom[i].Title, "DP", 2) == 0) {
        Doom[i].Type = WD_BEEP;
        continue;
        }
      if(strncmp(Doom[i].Title, "D_", 2) == 0) {
        Doom[i].Type = WD_MUSIC;
        continue;
        }
      if(strncmp(Doom[i].Title, "WI", 2) == 0) {
        Doom[i].Type = WD_LEVEL;
        continue;
        }
      if(strncmp(Doom[i].Title, "M_", 2) == 0) {
        Doom[i].Type = WD_MENU;
        continue;
        }
      if(strncmp(Doom[i].Title, "ST", 2) == 0) {
        Doom[i].Type = WD_STATUS;
        continue;
        }
      if(strncmp(Doom[i].Title, "DEMO", 4) == 0) {
        Doom[i].Type = WD_DEMO;
        continue;
        }
      if(strncmp(Doom[i].Title, "PNAM", 4) == 0) {
        Doom[i].Type = WD_PNAMES;
        continue;
        }
      if(strcmp(Doom[i].Title, "PLAYPAL") == 0) {
        Doom[i].Type = WD_PLAYPAL;
        continue;
        }
      if(strcmp(Doom[i].Title, "COLORMAP") == 0) {
        Doom[i].Type = WD_COLORMAP;
        continue;
        }
      if(strncmp(Doom[i].Title, "TEXTUR", 6) == 0) {
        Doom[i].Type = WD_TEXTURE;
        continue;
        }
      if(strcmp(Doom[i].Title, "THINGS") == 0) {
        Doom[i].Type = WD_THINGS;
        continue;
        }
      if(strcmp(Doom[i].Title, "LINEDEFS") == 0) {
        Doom[i].Type = WD_LINEDEFS;
        continue;
        }
      if(strcmp(Doom[i].Title, "SIDEDEFS") == 0) {
        Doom[i].Type = WD_SIDEDEFS;
        continue;
        }
      if(strcmp(Doom[i].Title, "VERTEXES") == 0) {
        Doom[i].Type = WD_VERTEXES;
        continue;
        }
      if(strcmp(Doom[i].Title, "SEGS") == 0) {
        Doom[i].Type = WD_SEGS;
        continue;
        }
      if(strcmp(Doom[i].Title, "SSECTORS") == 0) {
        Doom[i].Type = WD_SSECTORS;
        continue;
        }
      if(strcmp(Doom[i].Title, "NODES") == 0) {
        Doom[i].Type = WD_NODES;
        continue;
        }
      if(strcmp(Doom[i].Title, "SECTORS") == 0) {
        Doom[i].Type = WD_SECTORS;
        continue;
        }
      if(strcmp(Doom[i].Title, "REJECT") == 0) {
        Doom[i].Type = WD_REJECT;
        continue;
        }
      if(strcmp(Doom[i].Title, "BLOCKMAP") == 0) {
        Doom[i].Type = WD_BLOCKMAP;
        continue;
        }
      if((strncmp(Doom[i].Title, "PLATFORM", 8) == 0) ||
         (strncmp(Doom[i].Title, "TAGDESC", 7) == 0)) {
        Doom[i].Type = WD_TAG;
        continue;
        }
      if(strcmp(Doom[i].Title, "ENDOOM") == 0) {
        Doom[i].Type = WD_ENDOOM;
        continue;
        }
      if(strncmp(Doom[i].Title, "DMX", 3) == 0) {
        Doom[i].Type = WD_DRIVER;
        continue;
        }
      if(strncmp(Doom[i].Title, "GENMIDI", 7) == 0) {
        Doom[i].Type = WD_DRIVER;
        continue;
        }
      Doom[i].Type = WD_GRAPHIC;
      if(Doom[i].Length == 0) {
        if(((Doom[i].Title[0] == 'E') &&
            (Doom[i].Title[2] == 'M') &&
            (Doom[i].Title[4] == '\0')) ||
           ((Doom[i].Title[0] == 'M') &&
            (Doom[i].Title[1] == 'A') &&
            (Doom[i].Title[2] == 'P')))
            {
          Doom[i].Type = WD_MAP;
          continue;
          }
        Doom[i].Type = WD_ID;
        if(strncmp(Doom[i].Title, "S_START", 7) == 0)
          InSprites = TRUE;
        if(strncmp(Doom[i].Title, "S_END", 5) == 0)
          InSprites = FALSE;
        if(strncmp(Doom[i].Title, "P_START", 7) == 0)
          InPanels = TRUE;
        if(strncmp(Doom[i].Title, "P_END", 5) == 0)
          InPanels = FALSE;
        if(strncmp(Doom[i].Title, "F_START", 7) == 0)
          InTiles = TRUE;
        if(strncmp(Doom[i].Title, "F_END", 5) == 0)
          InTiles = FALSE;
        continue;
        }
      }
    if(DoomEntry("E2M1") != NotFound) {
      RegisteredVersion = TRUE;
      DoomVersion = 1;
      }
    if(DoomEntry("MAP20") != NotFound) {
      RegisteredVersion = TRUE;
      DoomVersion = 2;
      }

    // load palette
    i = DoomEntry("PLAYPAL");
    if(i != NotFound) {
      DoomWadValid = TRUE;
      // MS-Windows 3.0 Guide to Programming - pp.19-5 "Color Palettes"
      hgPalette = GlobalAlloc(GHND, sizeof(LOGPALETTE) + 256 *
                                    sizeof(PALETTEENTRY));
      pLogPalette = (LOGPALETTE *)GlobalLock(hgPalette);
      pLogPalette->palVersion = 0x0300;
      pLogPalette->palNumEntries = 256;
      _llseek(WadFile, Doom[i].Offset, 0);  // seek to main palette
      for(j=0; j<256; j++) {                // do all entries
        _lread(WadFile, &Pal[j], 3);        // load 3 bytes (RGB)
        Pal[j].peFlags = NULL;              // make normal pal entry
        pLogPalette->palPalEntry[j] = Pal[j];// set it up
        }
      hPalette = CreatePalette(pLogPalette); // create that puppy
      PaletteLoaded = TRUE;
      GlobalUnlock(hgPalette);
      hdc = GetDC(hwnd);                    // get device context
      SelectPalette(hdc, hPalette, 0);      // select the palette
      RealizePalette(hdc);                  // make the changes
      hOriginalPen = SelectObject(hdc, hPenMapLines);
      hOriginalBrush = SelectObject(hdc, hBrushBackground);
      ReleaseDC(hwnd, hdc);                 // give back DC
      }
    else
      DoomWadValid = FALSE;
    }
  else
    DoomWadValid = FALSE;
  
  _lclose(WadFile);
  return TRUE;
}
