// Linedef dialog for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"
#include <math.h>

// major change: Nov 8 / 94 GLA
// update all linedefs as changes are made (better multiple support)

static HWND hNum, hLen, hFrom, hTo, hExpand,
            hSolidity, hSpecial, hTag,
            hOffsetX, hOffsetY, hTexture1, hTexture2, hTexture3,
            hHeight, hSdSector,
            hOffsetX2, hOffsetY2, hTexture12, hTexture22, hTexture32,
            hHeight2, hSdSector2;
static BOOL Expanded = FALSE;

static int  OldTag, OldSolidity, NewSolidity;

#if defined(HideDialog)
#undef HideDialog
#undef ShowDialog
#endif
#define HideDialog  PostMessage(hwnd, DOOMED_HIDE_LINEDEF, 0, 0L);
#define ShowDialog  PostMessage(hwnd, DOOMED_SHOW_LINEDEF, 0, 0L);
#define HideBack  { ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE0), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE1), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE2), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE3), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE4), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE5), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE6), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE7), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE8), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE9), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_OFFSETX2),  SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_OFFSETY2),  SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_SIDEDEFSECTOR2), SW_HIDE); \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_SIDEDEFHEIGHT2), SW_HIDE); \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_TEXTURE12), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_TEXTURE22), SW_HIDE);      \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_TEXTURE32), SW_HIDE); }

#define ShowBack  { ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE0), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE1), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE2), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE3), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE4), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE5), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE6), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE7), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE8), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_BACKSIDE9), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_OFFSETX2),  SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_OFFSETY2),  SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_SIDEDEFSECTOR2), SW_NORMAL); \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_SIDEDEFHEIGHT2), SW_NORMAL); \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_TEXTURE12), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_TEXTURE22), SW_NORMAL);    \
                    ShowWindow(GetDlgItem(hwndDialogLineDef, IDC_TEXTURE32), SW_NORMAL); }

void PutLineDefInDialog(int num)
{
  int    i, j, dx, dy;
  double dTemp, ddx, ddy;
  char   szTemp[10];

  // if adding "nothing", hide the dialog
  if(num == Nothing) {
    if(IsWindowVisible(hwndDialogLineDef))
      HideDialog;
    if(IsWindowVisible(hwndTextureViewer))
      PutTextureInViewer(Nothing);
    return;
    }
  else
    if(!IsWindowVisible(hwndDialogLineDef))
      ShowDialog;

  if(num == DialogClear) {
    if(IsWindowVisible(hwndTextureViewer))
      PutTextureInViewer(Nothing);
    SetWindowText(hwndDialogLineDef, "Line Definition");
    ShowBack;
    // blank all entries
    Static_SetText(hNum, "");
    Static_SetText(hFrom, "");
    Static_SetText(hTo, "");
    Static_SetText(hLen, "");
    ListBox_SetSel(hSolidity, FALSE, -1); // no selections
    ComboBox_SetCurSel(hSpecial, Nothing);
    ComboBox_SetCurSel(hTag, Nothing);
    // sidedef1
    Edit_SetText(hOffsetX, "");
    Edit_SetText(hOffsetY, "");
    Static_SetText(hSdSector, "");
    ComboBox_SetCurSel(hTexture1, Nothing);
    ComboBox_SetCurSel(hTexture2, Nothing);
    ComboBox_SetCurSel(hTexture3, Nothing);
    Static_SetText(hHeight, "");
    // sidedef2
    Edit_SetText(hOffsetX2, "");
    Edit_SetText(hOffsetY2, "");
    Static_SetText(hSdSector2, "");
    ComboBox_SetCurSel(hTexture12, Nothing);
    ComboBox_SetCurSel(hTexture22, Nothing);
    ComboBox_SetCurSel(hTexture32, Nothing);
    Static_SetText(hHeight2, "");
    return;
    }

   OldSolidity = 0;
   OldTag = 0;
   
   if(SelectedLineDefs > 1) {
    // multiple lines:
    wsprintf(szTemp, "%i Line Definitions", SelectedLineDefs);
    SetWindowText(hwndDialogLineDef, szTemp);
    ShowBack;
    // blank not-applicable entries
    Static_SetText(hNum, "");
    Static_SetText(hFrom, "");
    Static_SetText(hTo, "");
    Static_SetText(hLen, "");
    ListBox_SetSel(hSolidity, FALSE, -1); // start with no selections
    ComboBox_SetCurSel(hSpecial, Nothing);
    ComboBox_SetCurSel(hTag, Nothing);
    // sidedef1
    Edit_SetText(hOffsetX, "");
    Edit_SetText(hOffsetY, "");
    Static_SetText(hSdSector, "");
    ComboBox_SetCurSel(hTexture1, Nothing);
    ComboBox_SetCurSel(hTexture2, Nothing);
    ComboBox_SetCurSel(hTexture3, Nothing);
    Static_SetText(hHeight, "");
    // sidedef2
    Edit_SetText(hOffsetX2, "");
    Edit_SetText(hOffsetY2, "");
    Static_SetText(hSdSector2, "");
    ComboBox_SetCurSel(hTexture12, Nothing);
    ComboBox_SetCurSel(hTexture22, Nothing);
    ComboBox_SetCurSel(hTexture32, Nothing);
    Static_SetText(hHeight2, "");
    }
  else {    // SelectedLineDefs == 1
    if(LineDef[num].sidedef2 == Nothing)
      { HideBack; }
    else
      { ShowBack; }
    wsprintf(szTemp, "Line Definition %i", num);
    SetWindowText(hwndDialogLineDef, szTemp);
    wsprintf(szTemp,"%i", num);
    Static_SetText(hNum, szTemp);
    wsprintf(szTemp,"%i", LineDef[num].from);
    Static_SetText(hFrom, szTemp);
    wsprintf(szTemp,"%i", LineDef[num].to);
    Static_SetText(hTo, szTemp);
    dx = abs(Vertex[LineDef[num].to].x -
             Vertex[LineDef[num].from].x);
    ddx = (double)dx;
    dy = abs(Vertex[LineDef[num].to].y -
             Vertex[LineDef[num].from].y);
    ddy = (double)dy;
    if(dx==0 && dy==0)
      i = 0;
    else {
      dTemp = sqrt(ddx * ddx + ddy * ddy);
      i = (int)dTemp;
      }
    wsprintf(szTemp,"%i", i);
    Static_SetText(hLen, szTemp);
  
    OldSolidity = LineDef[num].solidity;
    
    ListBox_SetSel(hSolidity, FALSE, -1); // start with no selections
    if(TestLineBit(num, ML_BLOCKING))
      ListBox_SetSel(hSolidity, TRUE, 0);
    if(TestLineBit(num, ML_BLOCKMONSTERS))
      ListBox_SetSel(hSolidity, TRUE, 1);
    if(TestLineBit(num, ML_TWOSIDED))
      ListBox_SetSel(hSolidity, TRUE, 2);
    if(TestLineBit(num, ML_DONTPEGTOP))
      ListBox_SetSel(hSolidity, TRUE, 3);
    if(TestLineBit(num, ML_DONTPEGBOTTOM))
      ListBox_SetSel(hSolidity, TRUE, 4);
    if(TestLineBit(num, ML_SECRET))
      ListBox_SetSel(hSolidity, TRUE, 5);
    if(TestLineBit(num, ML_SOUNDBLOCK))
      ListBox_SetSel(hSolidity, TRUE, 6);
    if(TestLineBit(num, ML_DONTDRAW))
      ListBox_SetSel(hSolidity, TRUE, 7);
    if(TestLineBit(num, ML_MAPPED))
      ListBox_SetSel(hSolidity, TRUE, 8);
  
    if(LineDef[num].special > 0) {
      j = ComboBox_GetCount(hSpecial);
      for(i=0; i < j; i++)
        if(ComboBox_GetItemData(hSpecial, i) == LineDef[num].special) {
          ComboBox_SetCurSel(hSpecial, i);
          break;
          }
      }
    else
      ComboBox_SetCurSel(hSpecial, Nothing);

    FillComboWithPlatforms(hTag);
    if(LineDef[num].tag > 0) {
      j = ComboBox_GetCount(hTag);
      for(i=0; i < j; i++)
        if(ComboBox_GetItemData(hTag, i) == LineDef[num].tag) {
          ComboBox_SetCurSel(hTag, i);
          CurrentTag = i;
          break;
          }
      }
    else {
      ComboBox_SetCurSel(hTag, Nothing);
      CurrentTag = Nothing;
      }
    OldTag = LineDef[num].tag;
    // mark all sectors with this tag
    TagSector(LineDef[num].tag);

    // setup sidedef 1
    if(LineDef[num].sidedef1 == Nothing) {
      Edit_SetText(hOffsetX, "");
      Edit_SetText(hOffsetY, "");
      Static_SetText(hSdSector, "");
      ComboBox_SetCurSel(hTexture1, Nothing);
      ComboBox_SetCurSel(hTexture2, Nothing);
      ComboBox_SetCurSel(hTexture3, Nothing);
      Static_SetText(hHeight, "");
      }
    else {
      wsprintf(szTemp, "%i", SideDef[LineDef[num].sidedef1].x);
      Edit_SetText(hOffsetX, szTemp);
      wsprintf(szTemp, "%i", SideDef[LineDef[num].sidedef1].y);
      Edit_SetText(hOffsetY, szTemp);
      j = SideDef[LineDef[num].sidedef1].sector;
      wsprintf(szTemp, "%i", j);
      Static_SetText(hSdSector, szTemp);
      wsprintf(szTemp, "%i", 
               Sector[SideDef[LineDef[num].sidedef1].sector].ceilZ -
               Sector[SideDef[LineDef[num].sidedef1].sector].floorZ);
      Static_SetText(hHeight, szTemp);
      szTemp[8] = '\0';
      CopyWall(szTemp, SideDef[LineDef[num].sidedef1].t1);
      j = ComboBox_FindString(hTexture1, 0, szTemp);
      ComboBox_SetCurSel(hTexture1, j);
      CopyWall(szTemp, SideDef[LineDef[num].sidedef1].t2);
      j = ComboBox_FindString(hTexture2, 0, szTemp);
      ComboBox_SetCurSel(hTexture2, j);
      CopyWall(szTemp, SideDef[LineDef[num].sidedef1].t3);
      j = ComboBox_FindString(hTexture3, 0, szTemp);
      ComboBox_SetCurSel(hTexture3, j);
      }
    // setup sidedef 2
    if(LineDef[num].sidedef2 == Nothing) {
      Edit_SetText(hOffsetX2, "");
      Edit_SetText(hOffsetY2, "");
      Static_SetText(hSdSector2, "");
      ComboBox_SetCurSel(hTexture12, Nothing);
      ComboBox_SetCurSel(hTexture22, Nothing);
      ComboBox_SetCurSel(hTexture32, Nothing);
      Static_SetText(hHeight2, "");
      }
    else {
      wsprintf(szTemp, "%i", SideDef[LineDef[num].sidedef2].x);
      Edit_SetText(hOffsetX2, szTemp);
      wsprintf(szTemp, "%i", SideDef[LineDef[num].sidedef2].y);
      Edit_SetText(hOffsetY2, szTemp);
      j = SideDef[LineDef[num].sidedef2].sector;
      wsprintf(szTemp, "%i", j);
      Static_SetText(hSdSector2, szTemp);
      wsprintf(szTemp, "%i", 
               Sector[SideDef[LineDef[num].sidedef2].sector].ceilZ -
               Sector[SideDef[LineDef[num].sidedef2].sector].floorZ);
      Static_SetText(hHeight2, szTemp);
      szTemp[8] = '\0';
      CopyWall(szTemp, SideDef[LineDef[num].sidedef2].t1);
      j = ComboBox_FindString(hTexture12, 0, szTemp);
      ComboBox_SetCurSel(hTexture12, j);
      CopyWall(szTemp, SideDef[LineDef[num].sidedef2].t2);
      j = ComboBox_FindString(hTexture22, 0, szTemp);
      ComboBox_SetCurSel(hTexture22, j);
      CopyWall(szTemp, SideDef[LineDef[num].sidedef2].t3);
      j = ComboBox_FindString(hTexture32, 0, szTemp);
      ComboBox_SetCurSel(hTexture32, j);
      }
    }   // endif SelectedLineDefs == 1
  return;
}

int EXPORT DialogLineDef(HWND  hDlg,
                         WORD  wMsg,
                         WORD  wParam,
                         DWORD lParam)
{
  RECT  dSize;
  int   i;

  switch(wMsg) {
    case WM_ACTIVATE:
      if(wParam==WA_INACTIVE)
        Frontmost = NULL;
      else
        Frontmost = hwndDialogLineDef;
      break;

    case WM_INITDIALOG:
      // get variables for item HWNDs:
      hNum      = GetDlgItem(hDlg, IDC_LINEDEFNUM);
      hLen      = GetDlgItem(hDlg, IDC_LINEDEFLEN);
      hFrom     = GetDlgItem(hDlg, IDC_FROMVERTEX);
      hTo       = GetDlgItem(hDlg, IDC_TOVERTEX);
      hSolidity = GetDlgItem(hDlg, IDC_SOLIDITY2);
      hSpecial  = GetDlgItem(hDlg, IDC_SPECIAL2);
      hTag      = GetDlgItem(hDlg, IDC_PLATFORM2);
      hExpand   = GetDlgItem(hDlg, IDC_EXPAND);
      hOffsetX  = GetDlgItem(hDlg, IDC_OFFSETX);
      hOffsetY  = GetDlgItem(hDlg, IDC_OFFSETY);
      hTexture1 = GetDlgItem(hDlg, IDC_TEXTURE1);
      hTexture2 = GetDlgItem(hDlg, IDC_TEXTURE2);
      hTexture3 = GetDlgItem(hDlg, IDC_TEXTURE3);
      hHeight   = GetDlgItem(hDlg, IDC_SIDEDEFHEIGHT);
      hHeight2  = GetDlgItem(hDlg, IDC_SIDEDEFHEIGHT2);
      hSdSector = GetDlgItem(hDlg, IDC_SIDEDEFSECTOR);
      hSdSector2= GetDlgItem(hDlg, IDC_SIDEDEFSECTOR2);
      hOffsetX2 = GetDlgItem(hDlg, IDC_OFFSETX2);
      hOffsetY2 = GetDlgItem(hDlg, IDC_OFFSETY2);
      hTexture12= GetDlgItem(hDlg, IDC_TEXTURE12);
      hTexture22= GetDlgItem(hDlg, IDC_TEXTURE22);
      hTexture32= GetDlgItem(hDlg, IDC_TEXTURE32);
      // setup multi-select list box:
      FillListWithLineAttributes(hSolidity);
      // setup single select combo box:
      FillListWithLineDefActions(hSpecial);
      // setup sidedef combo-boxes:
      FillComboWithTextures(hTexture1);
      FillComboWithTextures(hTexture2);
      FillComboWithTextures(hTexture3);
      FillComboWithTextures(hTexture12);
      FillComboWithTextures(hTexture22);
      FillComboWithTextures(hTexture32);
      // and tags:
      FillComboWithPlatforms(hTag);
      return TRUE;
      break;

    case WM_COMMAND:
      switch (wParam)
        {
        case IDC_EXPAND:
          if(Expanded) {
            Expanded = FALSE;
            Button_SetText(hExpand, "SideDefs >>");
            dSize.left = 0; dSize.right  = 186;
            dSize.top  = 0; dSize.bottom = 160;
            MapDialogRect(hDlg, &dSize);
            SetWindowPos(hDlg, (HWND) NULL, 0, 0,
                         dSize.right + 2, dSize.bottom + 22,
                         SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOMOVE);
            }
          else {
            Expanded = TRUE;
            Button_SetText(hExpand, "SideDefs <<");
            dSize.left = 0; dSize.right  = 354;
            dSize.top  = 0; dSize.bottom = 172;
            MapDialogRect(hDlg, &dSize);
            SetWindowPos(hDlg, (HWND) NULL, 0, 0,
                         dSize.right + 2, dSize.bottom + 22,
                         SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOMOVE);
            }
          break;

        case IDC_OFFSETX:       // texture offset:
          if(HIWORD(lParam) == EN_CHANGE) {
            BOOL xx;
            int xxx = GetDlgItemInt(hDlg, IDC_OFFSETX, &xx, TRUE);
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef1 != Nothing))
                  SideDef[LineDef[i].sidedef1].x = xxx;
            MapChange();
            }
          break;

        case IDC_OFFSETY:       // texture offset:
          if(HIWORD(lParam) == EN_CHANGE) {
            BOOL xx;
            int xxx = GetDlgItemInt(hDlg, IDC_OFFSETY, &xx, TRUE);
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef1 != Nothing))
                  SideDef[LineDef[i].sidedef1].y = xxx;
            MapChange();
            }
          break;

        case IDC_OFFSETX2:       // texture offset:
          if(HIWORD(lParam) == EN_CHANGE) {
            BOOL xx;
            int xxx = GetDlgItemInt(hDlg, IDC_OFFSETX2, &xx, TRUE);
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef2 != Nothing))
                  SideDef[LineDef[i].sidedef2].x = xxx;
            MapChange();
            }
          break;

        case IDC_OFFSETY2:       // texture offset:
          if(HIWORD(lParam) == EN_CHANGE) {
            BOOL xx;
            int xxx = GetDlgItemInt(hDlg, IDC_OFFSETY2, &xx, TRUE);
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef2 != Nothing))
                  SideDef[LineDef[i].sidedef2].y = xxx;
            MapChange();
            }
          break;

        case IDC_SOLIDITY2:
          if(HIWORD(lParam) == LBN_SELCHANGE) {
            int SetBits = 0, ResetBits = 0;
            NewSolidity = 0;
            if(ListBox_GetSel(hSolidity, 0))
              NewSolidity |=   ML_BLOCKING;
            if((OldSolidity &  ML_BLOCKING) !=
               (NewSolidity &  ML_BLOCKING)) {
              if(NewSolidity & ML_BLOCKING)
                SetBits |=     ML_BLOCKING;
              else
                ResetBits |=   ML_BLOCKING;
              }

            if(ListBox_GetSel(hSolidity, 1))
              NewSolidity |=   ML_BLOCKMONSTERS;
            if((OldSolidity &  ML_BLOCKMONSTERS) !=
               (NewSolidity &  ML_BLOCKMONSTERS)) {
              if(NewSolidity & ML_BLOCKMONSTERS)
                SetBits |=     ML_BLOCKMONSTERS;
              else
                ResetBits |=   ML_BLOCKMONSTERS;
              }

            if(ListBox_GetSel(hSolidity, 2))
              NewSolidity |=   ML_TWOSIDED;
            if((OldSolidity &  ML_TWOSIDED) !=
               (NewSolidity &  ML_TWOSIDED)) {
              if(NewSolidity & ML_TWOSIDED)
                SetBits |=     ML_TWOSIDED;
              else
                ResetBits |=   ML_TWOSIDED;
              }

            if(ListBox_GetSel(hSolidity, 3))
              NewSolidity |=   ML_DONTPEGTOP;
            if((OldSolidity &  ML_DONTPEGTOP) !=
               (NewSolidity &  ML_DONTPEGTOP)) {
              if(NewSolidity & ML_DONTPEGTOP)
                SetBits |=     ML_DONTPEGTOP;
              else
                ResetBits |=   ML_DONTPEGTOP;
              }

            if(ListBox_GetSel(hSolidity, 4))
              NewSolidity |=   ML_DONTPEGBOTTOM;
            if((OldSolidity &  ML_DONTPEGBOTTOM) !=
               (NewSolidity &  ML_DONTPEGBOTTOM)) {
              if(NewSolidity & ML_DONTPEGBOTTOM)
                SetBits |=     ML_DONTPEGBOTTOM;
              else
                ResetBits |=   ML_DONTPEGBOTTOM;
              }

            if(ListBox_GetSel(hSolidity, 5))
              NewSolidity |=   ML_SECRET;
            if((OldSolidity &  ML_SECRET) !=
               (NewSolidity &  ML_SECRET)) {
              if(NewSolidity & ML_SECRET)
                SetBits |=     ML_SECRET;
              else
                ResetBits |=   ML_SECRET;
              }

            if(ListBox_GetSel(hSolidity, 6))
              NewSolidity |=   ML_SOUNDBLOCK;
            if((OldSolidity &  ML_SOUNDBLOCK) !=
               (NewSolidity &  ML_SOUNDBLOCK)) {
              if(NewSolidity & ML_SOUNDBLOCK)
                SetBits |=     ML_SOUNDBLOCK;
              else
                ResetBits |=   ML_SOUNDBLOCK;
              }

            if(ListBox_GetSel(hSolidity, 7))
              NewSolidity |=   ML_DONTDRAW;
            if((OldSolidity &  ML_DONTDRAW) !=
               (NewSolidity &  ML_DONTDRAW)) {
              if(NewSolidity & ML_DONTDRAW)
                SetBits |=     ML_DONTDRAW;
              else
                ResetBits |=   ML_DONTDRAW;
              }

            if(ListBox_GetSel(hSolidity, 8))
              NewSolidity |=   ML_MAPPED;
            if((OldSolidity &  ML_MAPPED) !=
               (NewSolidity &  ML_MAPPED)) {
              if(NewSolidity & ML_MAPPED)
                SetBits |=     ML_MAPPED;
              else
                ResetBits |=   ML_MAPPED;
              }

            if(SetBits)
              for(i = 0; i < LineDefsNum; i++)
                if(eLineDef[i].Used && eLineDef[i].Selected)
                  LineDef[i].solidity |= SetBits;

            if(ResetBits)
              for(i = 0; i < LineDefsNum; i++)
                if(eLineDef[i].Used && eLineDef[i].Selected) {
                  LineDef[i].solidity |= ResetBits;
                  LineDef[i].solidity ^= ResetBits;
                  }
            MapChange();
            OldSolidity = NewSolidity;
            }
          break;
    
        case IDC_SPECIAL2:      // action for tag:
          if(HIWORD(lParam) == LBN_SELCHANGE) {
            int xxx = (int)ComboBox_GetItemData(hSpecial, 
                           ComboBox_GetCurSel(hSpecial));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected)
                if(LineDef[i].special != xxx)
                  LineDef[i].special = xxx;
            MapChange();
            }
          break;

        case IDC_PLATFORM2:
          if(HIWORD(lParam) == LBN_SELCHANGE) {
            int xxx = (int)ComboBox_GetItemData(hTag, 
                           ComboBox_GetCurSel(hTag));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected)
                if(LineDef[i].tag != xxx) {
                  UnTagSector(LineDef[i].tag);
                  LineDef[i].tag = xxx;
                  TagSector(LineDef[i].tag);
                  }
            MapChange();
            }
          break;
    
        case IDC_REVERSE:
          for(i = 0; i < LineDefsNum; i++)
            if(eLineDef[i].Used &&
               eLineDef[i].Selected &&
               TwoSided(i)) {
              int x = LineDef[i].sidedef1;
              LineDef[i].sidedef1 = LineDef[i].sidedef2;
              LineDef[i].sidedef2 = x;
              x = LineDef[i].from;
              LineDef[i].from = LineDef[i].to;
              LineDef[i].to = x;
              }   // endif Used, Selected, and TwoSided
          RepaintMap(); // force redraw to show changes
          return TRUE;
          break;

        case IDC_TEXTURE1:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN)) {
            char szT[10];
            ComboBox_GetText(hTexture1, szT, 9); 
            PutTextureInViewer((int)ComboBox_GetItemData(hTexture1,
                               ComboBox_GetCurSel(hTexture1)));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef1 != Nothing))
                CopyWall(SideDef[LineDef[i].sidedef1].t1, szT);
            }
          break;

        case IDC_TEXTURE2:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN)) {
            char szT[10];
            ComboBox_GetText(hTexture2, szT, 9); 
            PutTextureInViewer((int)ComboBox_GetItemData(hTexture2,
                               ComboBox_GetCurSel(hTexture2)));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef1 != Nothing))
                CopyWall(SideDef[LineDef[i].sidedef1].t2, szT);
            }
          break;

        case IDC_TEXTURE3:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN)) {
            char szT[10];
            ComboBox_GetText(hTexture3, szT, 9); 
            PutTextureInViewer((int)ComboBox_GetItemData(hTexture3,
                               ComboBox_GetCurSel(hTexture3)));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef1 != Nothing))
                CopyWall(SideDef[LineDef[i].sidedef1].t3, szT);
            }
          break;

        case IDC_TEXTURE12:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN)) {
            char szT[10];
            ComboBox_GetText(hTexture12, szT, 9); 
            PutTextureInViewer((int)ComboBox_GetItemData(hTexture12,
                               ComboBox_GetCurSel(hTexture12)));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef2 != Nothing))
                CopyWall(SideDef[LineDef[i].sidedef2].t1, szT);
            }
          break;

        case IDC_TEXTURE22:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN)) {
            char szT[10];
            ComboBox_GetText(hTexture22, szT, 9); 
            PutTextureInViewer((int)ComboBox_GetItemData(hTexture22,
                               ComboBox_GetCurSel(hTexture22)));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef2 != Nothing))
                CopyWall(SideDef[LineDef[i].sidedef2].t2, szT);
            }
          break;

        case IDC_TEXTURE32:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN)) {
            char szT[10];
            ComboBox_GetText(hTexture32, szT, 9); 
            PutTextureInViewer((int)ComboBox_GetItemData(hTexture32,
                               ComboBox_GetCurSel(hTexture32)));
            for(i = 0; i < LineDefsNum; i++)
              if(eLineDef[i].Used &&
                 eLineDef[i].Selected &&
                 (LineDef[i].sidedef2 != Nothing))
                CopyWall(SideDef[LineDef[i].sidedef2].t3, szT);
            }
          break;

        case IDCANCEL:          // Close window
          PutLineDefInDialog(Nothing);
          return TRUE;
          break;
        default:
          return FALSE;
          break;
        }
      
    default:
      return FALSE;
    }
    return FALSE;
}

int EXPORT DialogLineDefs(HWND  hDlg,
                          WORD  wMsg,
                          WORD  wParam,
                          DWORD lParam)
{
  return 0;
}

