// File Load Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

// LOAD - loads the file structures

void LoadWad(char *szFileName)
{
  // Wad files can have multiple maps, and other objects
  HFILE  WadFile;
  char   szTempStr[8];
  long   DirOffset;
  long   TempLong;
  int    i;
  BOOL   InSprites = FALSE, InPanels = FALSE, InTiles = FALSE; // for classifying
  
  WadFile = _lopen(szFileName, OF_READ);
  _lread(WadFile, szTempStr, 4);            // read ID
  szTempStr[4] = '\0';
  if ((strcmp(szTempStr, "IWAD")==0) || (strcmp(szTempStr, "PWAD")==0)) {
    _lread(WadFile, &TempLong, 4);
    
    DirEntries = (int)TempLong;
    GlobalUnlock(hgDir);
    GlobalFree(hgDir);
    hgDir = GlobalAlloc(GMEM_FIXED, (DWORD)(DirEntries + 100) * sizeof(WadDir));
      Dir = (WadDir *)GlobalLock(hgDir);
    _lread(WadFile, &DirOffset, 4);        // find out where directory is
    _llseek(WadFile, DirOffset, 0);        // seek to directory area
    WadSize = DirOffset;                   // data ends where directory starts
    WadUsed = 12;
    for(i=0; i<DirEntries; i++) {          // read all directory entries
      _lread(WadFile, &Dir[i], 16);        // 16 bytes / record
      WadUsed += Dir[i].Length;            // track actual usage
      Dir[i].Title[8] = '\0';              // null term the string
      // Classify the object type:
      if(Dir[i].Length > 0) {
        if(InSprites) {
          Dir[i].Type = WD_SPRITE;
          continue;
          }
        if(InPanels) {
          Dir[i].Type = WD_PANEL;
          continue;
          }
        if(InTiles) {
          Dir[i].Type = WD_TILE;
          continue;
          }
        }
      if((Dir[i].Title[0] == 'D') && (Dir[i].Title[1] == 'S')) {
        Dir[i].Type = WD_SOUND;
        continue;
        }
      if((Dir[i].Title[0] == 'D') && (Dir[i].Title[1] == 'P')) {
        Dir[i].Type = WD_BEEP;
        continue;
        }
      if((Dir[i].Title[0] == 'D') && (Dir[i].Title[1] == '_')) {
        Dir[i].Type = WD_MUSIC;
        continue;
        }
      if((Dir[i].Title[0] == 'W') && (Dir[i].Title[1] == 'I')) {
        Dir[i].Type = WD_LEVEL;
        continue;
        }
      if((Dir[i].Title[0] == 'M') && (Dir[i].Title[1] == '_')) {
        Dir[i].Type = WD_MENU;
        continue;
        }
      if((Dir[i].Title[0] == 'S') && (Dir[i].Title[1] == 'T')) {
        Dir[i].Type = WD_STATUS;
        continue;
        }
      if((Dir[i].Title[0] == 'D') && (Dir[i].Title[1] == 'E') &&
         (Dir[i].Title[2] == 'M') && (Dir[i].Title[3] == 'O')) {
        Dir[i].Type = WD_DEMO;
        continue;
        }
      if((Dir[i].Title[0] == 'P') && (Dir[i].Title[1] == 'N') &&
         (Dir[i].Title[2] == 'A') && (Dir[i].Title[3] == 'M')) {
        Dir[i].Type = WD_PNAMES;
        continue;
        }
      if(strcmp(Dir[i].Title, "PLAYPAL") == 0) {
        Dir[i].Type = WD_PLAYPAL;
        continue;
        }
      if(strcmp(Dir[i].Title, "COLORMAP") == 0) {
        Dir[i].Type = WD_COLORMAP;
        continue;
        }
      if((Dir[i].Title[0] == 'T') && (Dir[i].Title[1] == 'E') &&
         (Dir[i].Title[2] == 'X') && (Dir[i].Title[3] == 'T') &&
         (Dir[i].Title[4] == 'U') && (Dir[i].Title[5] == 'R')) {
        Dir[i].Type = WD_TEXTURE;
        continue;
        }
      if(strcmp(Dir[i].Title, "THINGS") == 0) {
        Dir[i].Type = WD_THINGS;
        continue;
        }
      if(strcmp(Dir[i].Title, "LINEDEFS") == 0) {
        Dir[i].Type = WD_LINEDEFS;
        continue;
        }
      if(strcmp(Dir[i].Title, "SIDEDEFS") == 0) {
        Dir[i].Type = WD_SIDEDEFS;
        continue;
        }
      if(strcmp(Dir[i].Title, "VERTEXES") == 0) {
        Dir[i].Type = WD_VERTEXES;
        continue;
        }
      if(strcmp(Dir[i].Title, "SEGS") == 0) {
        Dir[i].Type = WD_SEGS;
        continue;
        }
      if(strcmp(Dir[i].Title, "SSECTORS") == 0) {
        Dir[i].Type = WD_SSECTORS;
        continue;
        }
      if(strcmp(Dir[i].Title, "NODES") == 0) {
        Dir[i].Type = WD_NODES;
        continue;
        }
      if(strcmp(Dir[i].Title, "SECTORS") == 0) {
        Dir[i].Type = WD_SECTORS;
        continue;
        }
      if(strcmp(Dir[i].Title, "REJECT") == 0) {
        Dir[i].Type = WD_REJECT;
        continue;
        }
      if(strcmp(Dir[i].Title, "BLOCKMAP") == 0) {
        Dir[i].Type = WD_BLOCKMAP;
        continue;
        }
      if((strcmp(Dir[i].Title, "PLATFORM") == 0) ||
         (strcmp(Dir[i].Title, "TAGDESC") == 0)) {
        Dir[i].Type = WD_TAG;
        continue;
        }
      if(strcmp(Dir[i].Title, "ENDOOM") == 0) {
        Dir[i].Type = WD_ENDOOM;
        continue;
        }
      if(Dir[i].Length == 0) {
        if(((Dir[i].Title[0] == 'E') && (Dir[i].Title[2] == 'M') &&
           (Dir[i].Title[4] == '\0')) || 
           ((Dir[i].Title[0] == 'M') &&
            (Dir[i].Title[1] == 'A') &&
            (Dir[i].Title[2] == 'P'))) {
          Dir[i].Type = WD_MAP;
          continue;
          }
        Dir[i].Type = WD_ID;
        if(strcmp(Dir[i].Title, "S_START") == 0)
          InSprites = TRUE;
        if(strcmp(Dir[i].Title, "S_END") == 0)
          InSprites = FALSE;
        if(strcmp(Dir[i].Title, "P_START") == 0)
          InPanels = TRUE;
        if(strcmp(Dir[i].Title, "P_END") == 0)
          InPanels = FALSE;
        if(strcmp(Dir[i].Title, "F_START") == 0)
          InTiles = TRUE;
        if(strcmp(Dir[i].Title, "F_END") == 0)
          InTiles = FALSE;
        continue;
        }
      Dir[i].Type = WD_GRAPHIC;
      }     // next i
    }       // test for IWAD/PWAD
  _lclose(WadFile);
  return;
}

void LoadProject(char *szFileName)
{
  // project file format not yet determined
}

void LoadMap(char *szFileName)
{
  // Map files have only one map
}

void LoadBlock(char *szBlockName)
{
  // blocks can be any lump in a wad file
}

HBITMAP LoadBmp(char *szFileName)
{
  // load a bitmap from a file and return the handle
  HANDLE    hDib;
  hDib = OpenDIB(szFileName);
  return BitmapFromDib(hDib, hPalette);
}

