// File Load Routines for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

void ClearProblems(void);

// READ - reads the file lumps as required

RECT GetMapExtents(void)
{
  RECT  temp;
  int   i;
  // find the min and max for x and y
  FindVertexesInUse();
  temp.left=MAXINT; temp.right =MININT;
  temp.top =MININT; temp.bottom=MAXINT;
  for(i=1; i<VertexNum; i++)
    if(eVertex[i].Used) {
      temp.left  = min(Vertex[i].x, temp.left);
      temp.right = max(Vertex[i].x, temp.right);
      temp.top   = max(Vertex[i].y, temp.top);
      temp.bottom= min(Vertex[i].y, temp.bottom);
      }
  // Add a small border
  temp.left   -= 50; temp.right  += 50;
  temp.top    += 50; temp.bottom -= 50;
  DoomEdScrollInit();
  DoomEdScrollNewView();
  return temp;
}

void FindVertexesInUse(void)
{
  int   i;
  // clear all vertex statistics:
  _fmemset(eVertex, 0, (size_t)GlobalSize(hgeVertex));
  // make list of which vertexes are part of linedefs
  for(i = 0; i < LineDefsNum; i++)
    if(eLineDef[i].Used) {
      eVertex[LineDef[i].from].Used = TRUE;
      eVertex[LineDef[i].to].Used = TRUE;
      }
}

void ReadMap(int where, int which)
{   // ignore DD_INTERNAL - never any need
  int       i, j, k;
  HFILE     WadFile;
  BOOL      FoundTag = FALSE, DontAdd;
  int       Highest;
  int       count;
  
  // for plat additions: NOT zero...
  NextTag = 1;
  
  // flush out the old flags:
  _fmemset(eThing,   0, (size_t)GlobalSize(hgeThing));
  _fmemset(eSector,  0, (size_t)GlobalSize(hgeSector));
  _fmemset(eVertex,  0, (size_t)GlobalSize(hgeVertex));
  _fmemset(eLineDef, 0, (size_t)GlobalSize(hgeLineDef));
  _fmemset(eSideDef, 0, (size_t)GlobalSize(hgeSideDef));
  ClearProblems();

  // we always work with the file in szPrevFile1.
  WadFile = _lopen(szPrevFile1, OF_READ);
  
  Highest = min(DirEntries, which + 12);

  for(i = which; i < Highest; i++)
    if(strcmp("THINGS", Dir[i].Title) == 0) {
      count = (int)(Dir[i].Length / sizeof(WadThings));
      AllocateThings(count + 50);
      ThingsNum = count;
      for(j=0; j<ThingsNum; j++)
        eThing[j].Used = TRUE;
      break;                                // gets out of for loop
      }
  _llseek(WadFile, Dir[i].Offset, 0);       // seek to data
  _hread(WadFile, Thing, Dir[i].Length);    // read chunk
  
  for(i = which; i < Highest; i++)
    if(strcmp("VERTEXES", Dir[i].Title) == 0) {
      count = (int)(Dir[i].Length / sizeof(POINT));
      AllocateVertex(count + 100);
      VertexNum = count;
      for(j=0; j<VertexNum; j++)
        eVertex[j].Used = TRUE;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, Vertex, Dir[i].Length);
  
  for(i = which; i < Highest; i++)
    if(strcmp("LINEDEFS", Dir[i].Title) == 0) {
      count = (int)(Dir[i].Length / sizeof(WadLineDefs));
      AllocateLineDefs(count + 20);
      LineDefsNum = count;
      for(j=0; j<LineDefsNum; j++)
        eLineDef[j].Used = TRUE;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, LineDef, Dir[i].Length);
  
  for(i = which; i < Highest; i++)
    if(strcmp("SIDEDEFS", Dir[i].Title) == 0) {
      count = (int)((DWORD)Dir[i].Length / (DWORD)sizeof(WadSideDefs));
      AllocateSideDefs(count + 20);
      SideDefsNum = count;
      for(j=0; j<SideDefsNum; j++)
        eSideDef[j].Used = TRUE;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, SideDef, Dir[i].Length);
  
  for(i = which; i < Highest; i++)
    if(strcmp("SEGS", Dir[i].Title) == 0) {
      count = (int)(Dir[i].Length / sizeof(WadSegs));
      AllocateSegs(count + 20);
      SegsNum = count;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, Seg, Dir[i].Length);
  
  for(i = which; i < Highest; i++)
    if(strcmp("SSECTORS", Dir[i].Title) == 0) {
      count = (int)(Dir[i].Length / sizeof(WadSSectors));
      AllocateSSectors(count + 20);
      SSectorsNum = count;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, SSector, Dir[i].Length);
  
  for(i = which; i < Highest; i++)
    if(strcmp("NODES", Dir[i].Title) == 0) {
      count = (int)(Dir[i].Length / sizeof(WadNodes));
      AllocateNodes(count + 20);
      NodesNum = count;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, Node, Dir[i].Length);
  
  for(i = which; i < Highest; i++)
    if(strcmp("SECTORS", Dir[i].Title) == 0) {
      count = (int)(Dir[i].Length / sizeof(WadSectors));
      AllocateSectors(count + 20);
      SectorsNum = count;
      for(j=0; j<SectorsNum; j++)
        eSector[j].Used = TRUE;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, Sector, Dir[i].Length);
  
  // make the first tag blank
  Tag[0].Num = 0;
  strcpy(Tag[0].Name, "0");
  strcpy(Tag[0].Desc, "No Tag Number");
  TagsNum = 1;

  for(i = which; i < Highest; i++) {
    if((strcmp("PLATFORM", Dir[i].Title) == 0) ||
       (strcmp("TAGDESC", Dir[i].Title) == 0)) {
      FoundTag = TRUE;
      TagsNum = (int)(Dir[i].Length / sizeof(WadTags)) + 1;
      _llseek(WadFile, Dir[i].Offset, 0);
      _hread(WadFile, &Tag[1], Dir[i].Length);
      // delete any unused tags:
      if(TagsNum > 0)
        for(j = 1; j < TagsNum; j++)
          if(Tag[j].Num == 0)
            for(int jj = j; jj < (TagsNum - 1); jj++)
              Tag[jj] = Tag[jj + 1];
      for(j = 0; j < TagsNum; j++)
        NextTag = max(NextTag, Tag[j].Num);
      break;
      }
    } // next i

  // setup tags if none were in the map
  if(!FoundTag) {
    for(k = 0; k < SectorsNum; k++) {
      if(Sector[k].tag > 0) {
        DontAdd = FALSE;
        if(TagsNum > 1)
          for(j = 1; j < TagsNum; j++)
            if(Tag[j].Num == Sector[k].tag)
              DontAdd = TRUE;
        if(!DontAdd) {
          NextTag = max(NextTag, Sector[k].tag);
          Tag[TagsNum].Num = Sector[k].tag;
          sprintf(Tag[TagsNum].Name, "Tag%i", Sector[k].tag);
          strcpy(Tag[TagsNum++].Desc,"");
          }     // endif Add Tag
        }       // endif Sector.tag>0
      }         // next k (Sector)
    }           // if(!FoundTag)
  // the next one will be one higher than the current highest
  NextTag++;
  
  for(i = which; i < Highest; i++)
    if(strcmp("REJECT", Dir[i].Title) == 0) {
      RejectSize = Dir[i].Length;
      break;
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, Reject, RejectSize);

  for(i = which; i < Highest; i++)
    if(strcmp("BLOCKMAP", Dir[i].Title) == 0) {
      BlockMapSize=Dir[i].Length;
      break;  // gets out of for loop
      }
  _llseek(WadFile, Dir[i].Offset, 0);
  _hread(WadFile, BlockMap, BlockMapSize);

  _lclose(WadFile);

  FindVertexesInUse();
  MapExtent = GetMapExtents();
  DoomEdScrollInit();
  RepaintMap();
  MapExtent = GetMapExtents();
  
  DoomEdScrollNewView();
  MapLoaded = TRUE;

  return;
}

void ReadGraphic(int where, int which)
{   // where is DD_INTERNAL for Doom.Wad
    //          DD_EXTERNAL for loaded file

  HBRUSH    hBrushTemp;
  
  if(where == DD_INTERNAL) {
    if(Doom[which].Type == WD_TILE) {
      hBitmap = TileFromDoom(which);
      return;
      }
    hBitmap = BitmapFromDoom(which);
    return;
    }

  if(Dir[which].Type == WD_TILE) {
    hBitmap = TileFromDir(which);
    return;
    }
  
  // purpose:
  //   read a bitmap from the external file
  //   convert transparency to ugly purple for editing
  //   set hBitmap to the bitmap
  hBrushTemp = hBrushBackground;
  hBrushBackground = CreateSolidBrush(PALETTERGB(192, 0, 192));    // ugly purple
  hBitmap = BitmapFromDir(which);
  DeleteBrush(hBrushBackground);
  hBrushBackground = hBrushTemp;
}


