// ScrollBar and zoom support for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

static int      PageSize, LineSize;
static POINT    MapCenter;

void DoomEdVScroll(WPARAM wParam)
{
  long  tlong;
  
  MapCenter.x = (MapExtent.right - MapExtent.left) / 2;
  MapCenter.y = (MapExtent.top - MapExtent.bottom) / 2;
  LineSize = (MapExtent.bottom - MapExtent.top) / 10;
  PageSize = (MapExtent.bottom - MapExtent.top) / 2;
  switch (wParam) {
    case SB_LINEDOWN:
      tlong = (long)MapExtent.top + (long)LineSize;
      if(tlong > 32000)
        break;
      MapExtent.top    += LineSize;
      MapExtent.bottom += LineSize;
      RepaintMap();
      break;
    case SB_PAGEDOWN:
      tlong = (long)MapExtent.top + (long)PageSize;
      if(tlong > 32000)
        break;
      MapExtent.top    += PageSize;
      MapExtent.bottom += PageSize;
      RepaintMap();
      break;
    case SB_LINEUP:
      tlong = (long)MapExtent.bottom - (long)LineSize;
      if(tlong < -32000)
        break;
      MapExtent.top    -= LineSize;
      MapExtent.bottom -= LineSize;
      RepaintMap();
      break;
    case SB_PAGEUP:
      tlong = (long)MapExtent.bottom - (long)PageSize;
      if(tlong < -32000)
        break;
      MapExtent.top    -= PageSize;
      MapExtent.bottom -= PageSize;
      RepaintMap();
      break;
    default:
      break;
    }
  return;
}

void DoomEdHScroll(WPARAM wParam)
{
  long tlong;
  
  MapCenter.x = (MapExtent.right - MapExtent.left) / 2;
  MapCenter.y = (MapExtent.top - MapExtent.bottom) / 2;
  LineSize = (MapExtent.right - MapExtent.left)/10;
  PageSize = (MapExtent.right - MapExtent.left)/2;
  switch (wParam) {
    case SB_LINELEFT:
      tlong = (long)MapExtent.left - (long)LineSize;
      if(tlong < -30000)
        break;
      MapExtent.left  -= LineSize;
      MapExtent.right -= LineSize;
      RepaintMap();
      break;
    case SB_PAGELEFT:
      tlong = (long)MapExtent.left - (long)PageSize;
      if(tlong < -30000)
        break;
      MapExtent.left  -= PageSize;
      MapExtent.right -= PageSize;
      RepaintMap();
      break;
    case SB_LINERIGHT:
      tlong = (long)MapExtent.right + (long)LineSize;
      if(tlong > 30000)
        break;
      MapExtent.left  += LineSize;
      MapExtent.right += LineSize;
      RepaintMap();
      break;
    case SB_PAGERIGHT:
      tlong = (long)MapExtent.right + (long)PageSize;
      if(tlong > 30000)
        break;
      MapExtent.left  += PageSize;
      MapExtent.right += PageSize;
      RepaintMap();
      break;
    default:
      break;
    }
  return;
}

void DoomEdScrollInit(void)
{
  // call this when map extent changes
  MapCenter.x = (MapExtent.right - MapExtent.left) / 2;
  MapCenter.y = (MapExtent.top - MapExtent.bottom) / 2;
  SetScrollRange(hwnd, SB_HORZ, MapExtent.left, MapExtent.right, TRUE);
  SetScrollRange(hwnd, SB_VERT, -MapExtent.top, -MapExtent.bottom, TRUE);
  return;
}

void DoomEdScrollNewView(void)
{
  // call this on redraw to set the thumb positions
  SetScrollPos(hwnd, SB_HORZ, MapExtent.left + 
               ((MapOnScreen.right - MapOnScreen.left) / 2), TRUE);
  SetScrollPos(hwnd, SB_VERT, -(MapExtent.bottom + 
               ((MapOnScreen.top - MapOnScreen.bottom) / 2)), TRUE);
  return;
}

void DoomEdZoomOut(void)
{
  int       changeY, changeX;
  long      lMax;

  changeY = (MapExtent.top - MapExtent.bottom) / 3;
  MapExtent.top      += changeY;
  MapExtent.bottom   -= changeY;
  lMax = (long)MapExtent.top - (long)MapExtent.bottom;
  if((lMax > 32000) ||
     (MapExtent.top    >  10000) ||
     (MapExtent.bottom < -10000) ||
     (MapExtent.bottom >  MapExtent.top)) {
    // undo and return
    MapExtent.top    -= changeY;
    MapExtent.bottom += changeY;
    return;
    }
  changeX = (MapExtent.right - MapExtent.left) / 3;
  MapExtent.left     -= changeX;
  MapExtent.right    += changeX;
  lMax = (long)MapExtent.right - (long)MapExtent.left;
  if((lMax > 32000) ||
     (MapExtent.right >  10000) ||
     (MapExtent.left  < -10000) ||
     (MapExtent.left  >  MapExtent.right)) {
    // undo and return
    MapExtent.top    -= changeY;
    MapExtent.bottom += changeY;
    MapExtent.left   += changeX;
    MapExtent.right  -= changeX;
    return;
    }
  RepaintMap();
}

void DoomEdZoomIn(void)
{
  int       changeY, changeX;
  long      lMin;
  POINT     center, offset;
  HDC       rDC;
          
  rDC = GetDC(hwnd);
  center.x = MapOnScreen.left + ((MapOnScreen.right - MapOnScreen.left) / 2);
  center.y = MapOnScreen.bottom + ((MapOnScreen.top - MapOnScreen.bottom) / 2);
  // convert mouse to logical coordinate
  DPtoLP(rDC, &MouseOnScreen, 1);
  // offset for zoom
  offset.x = MouseOnScreen.x - center.x;
  offset.y = MouseOnScreen.y - center.y;
  // move center
  MapExtent.left   += offset.x;
  MapExtent.right  += offset.x;
  MapExtent.top    += offset.y;
  MapExtent.bottom += offset.y;
  // put mouse value back to device coordinates
  LPtoDP(rDC, &MouseOnScreen, 1);
  ReleaseDC(hwnd, rDC);

  changeY = (MapExtent.top - MapExtent.bottom) / 4;
  MapExtent.top      -= changeY;
  MapExtent.bottom   += changeY;
  lMin = (long)MapExtent.top - (long)MapExtent.bottom;
  if(lMin < 64) {
    // undo and return
    MapExtent.top    += changeY;
    MapExtent.bottom -= changeY;
    return;
    }
  changeX = (MapExtent.right - MapExtent.left) / 4;
  MapExtent.left     += changeX;
  MapExtent.right    -= changeX;
  lMin = (long)MapExtent.right - (long)MapExtent.left;
  if(lMin < 64) {
    // undo and return
    MapExtent.top    += changeY;
    MapExtent.bottom -= changeY;
    MapExtent.left   -= changeX;
    MapExtent.right  += changeX;
    return;
    }

  MapExtent.left   -= (offset.x / 2);
  MapExtent.right  -= (offset.x / 2);
  MapExtent.top    -= (offset.y / 2);
  MapExtent.bottom -= (offset.y / 2);

  RepaintMap();
}


