// Sector dialog for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

#if defined(HideDialog)
#undef HideDialog
#undef ShowDialog
#endif
#define HideDialog  PostMessage(hwnd, DOOMED_HIDE_SECTOR, 0, 0L);
#define ShowDialog  PostMessage(hwnd, DOOMED_SHOW_SECTOR, 0, 0L);

static  HWND hFloor, hCeiling, hFloorTile, hCeilingTile,
             hBrightness, hAttrib, hTag, hEditTag, hExpand;
static  BOOL Expanded = FALSE, SectorLoading = FALSE;
static  HBITMAP hBitmapFloor = NULL, hBitmapCeiling = NULL;
static  RECT    rFloor, rCeiling;
static  int     whichFloor = NULL, whichCeiling = NULL,
                whereFloor = NULL, whereCeiling = NULL;

void PutSectorInDialog(int num)
{
  char  szTemp[16];
  int   i, j;
  int   which, where;

  if(num == DialogClear) {
    SetWindowText(hwndDialogSector, "Sector");
    strcpy(szTemp, "");
    SectorLoading = TRUE;
    Edit_SetText(hFloor, szTemp);
    Edit_SetText(hCeiling, szTemp);
    Edit_SetText(hBrightness, szTemp);
    ComboBox_SetCurSel(hFloorTile, Nothing);
    ComboBox_SetCurSel(hCeilingTile, Nothing);
    ComboBox_SetCurSel(hAttrib, Nothing);
    FillComboWithPlatforms(hTag);
    ComboBox_SetCurSel(hTag, Nothing);
    Button_Enable(hEditTag, FALSE);
    if(Expanded) {
      if(hBitmapFloor)
        DeleteBitmap(hBitmapFloor);
      if(hBitmapCeiling)
        DeleteBitmap(hBitmapCeiling);
      hBitmapFloor = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_NOTILE));
      hBitmapCeiling = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_NOTILE));
      InvalidateRect(hwndDialogSector, &rFloor, FALSE);
      InvalidateRect(hwndDialogSector, &rCeiling, FALSE);
      whichFloor = NotFound;
      whichCeiling = NotFound;
      }
    SectorLoading = FALSE;
    return;
    }

  if(num == Nothing) {
    if(IsWindowVisible(hwndDialogSector))
      HideDialog;
    return;
    }
  else
    if(!IsWindowVisible(hwndDialogSector))
      ShowDialog;
  
  SectorLoading = TRUE;
  // set the variables
  if(SelectedSectors > 1) {
    sprintf(szTemp, "%i Sectors", SelectedSectors);
    SetWindowText(hwndDialogSector, szTemp);
    strcpy(szTemp, "");
    Edit_SetText(hFloor, szTemp);
    Edit_SetText(hCeiling, szTemp);
    Edit_SetText(hBrightness, szTemp);
    ComboBox_SetCurSel(hFloorTile, Nothing);
    ComboBox_SetCurSel(hCeilingTile, Nothing);
    ComboBox_SetCurSel(hAttrib, Nothing);
    FillComboWithPlatforms(hTag);
    ComboBox_SetCurSel(hTag, Nothing);
    Button_Enable(hEditTag, FALSE);
    }
  else {
    sprintf(szTemp, "Sector %i", num);
    SetWindowText(hwndDialogSector, szTemp);
    sprintf(szTemp, "%i", Sector[num].floorZ);
    Edit_SetText(hFloor, szTemp);
    sprintf(szTemp, "%i", Sector[num].ceilZ);
    Edit_SetText(hCeiling, szTemp);
    CopyWall(szTemp, Sector[num].Floor);
    szTemp[8]='\0';  
    j = ComboBox_FindString(hFloorTile, 0, szTemp);
    ComboBox_SetCurSel(hFloorTile, j);
    CopyWall(szTemp, Sector[num].Ceil);
    szTemp[8]='\0';  
    j = ComboBox_FindString(hCeilingTile, 0, szTemp);
    ComboBox_SetCurSel(hCeilingTile, j);
    sprintf(szTemp, "%i", Sector[num].light);
    Edit_SetText(hBrightness, szTemp);
    ComboBox_SetCurSel(hAttrib, Sector[num].flash);
    FillComboWithPlatforms(hTag);
    TagLineDef(Sector[num].tag);
    if(Sector[num].tag > 0) {
      Button_Enable(hEditTag, TRUE);
      for(i = 0; i < TagsNum; i++)
        if(ComboBox_GetItemData(hTag, i) == Sector[num].tag) {
          ComboBox_SetCurSel(hTag, i);
          CurrentTag = i;
          break;
          }
      }
    else
      Button_Enable(hEditTag, FALSE);

    if(Expanded) {
      strncpy(szTemp, Sector[num].Floor, 8);
      szTemp[8] = '\0';
      where = DD_EXTERNAL;
      if((which = DirEntry(szTemp)) == NotFound) {
        where = DD_INTERNAL;
        if((which = DoomEntry(szTemp)) == NotFound) {
          if(hBitmapFloor)
            DeleteBitmap(hBitmapFloor);
          hBitmapFloor = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_NOTILE));
          InvalidateRect(hwndDialogSector, &rFloor, FALSE);
          goto DoneFloor;
          }
        }
      if((which != whichFloor) || (where != whereFloor)) {
        if(hBitmapFloor)
          DeleteBitmap(hBitmapFloor);
        if(where == DD_INTERNAL)
          hBitmapFloor = TileFromDoom(which);
        else
          hBitmapFloor = TileFromDir(which);
        InvalidateRect(hwndDialogSector, &rFloor, FALSE);
        whichFloor = which;
        whereFloor = where;
        }
DoneFloor:
      strncpy(szTemp, Sector[num].Ceil, 8);
      szTemp[8] = '\0';
      where = DD_EXTERNAL;
      if((which = DirEntry(szTemp)) == NotFound) {
        where = DD_INTERNAL;
        if((which = DoomEntry(szTemp)) == NotFound) {
          if(hBitmapCeiling)
            DeleteBitmap(hBitmapCeiling);
          hBitmapCeiling = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_NOTILE));
          InvalidateRect(hwndDialogSector, &rCeiling, FALSE);
          goto DoneCeiling;
          }
        }
      if((which != whichCeiling) || (where != whereCeiling)) {
        if(hBitmapCeiling)
          DeleteBitmap(hBitmapCeiling);
        if(where == DD_INTERNAL)
          hBitmapCeiling = TileFromDoom(which);
        else
          hBitmapCeiling = TileFromDir(which);
        InvalidateRect(hwndDialogSector, &rCeiling, FALSE);
        whichCeiling = which;
        whereCeiling = where;
        }
      }
    }
DoneCeiling:
  SectorLoading = FALSE;
  return;
}

int EXPORT DialogSector(HWND  hDlg,
                        WORD  wMsg,
                        WORD  wParam,
                        DWORD lParam)
{
  int           i;
  RECT          dSize;      // for dialog expansion
  PAINTSTRUCT   ps;

  switch(wMsg) {
    case WM_ACTIVATE:
      if(wParam==WA_INACTIVE)
        Frontmost = NULL;
      else
        Frontmost = hwndDialogSector;
      break;

    case WM_INITDIALOG:
      // simplified setup for dialogs - much less error prone.
      // dialogs are pre-loaded at startup.
      hFloor       = GetDlgItem(hDlg, IDC_FLOOR);
      hCeiling     = GetDlgItem(hDlg, IDC_CEILING);
      hFloorTile   = GetDlgItem(hDlg, IDC_FLOORTILE);
      hCeilingTile = GetDlgItem(hDlg, IDC_CEILINGTILE);
      hBrightness  = GetDlgItem(hDlg, IDC_BRIGHTNESS);
      hAttrib      = GetDlgItem(hDlg, IDC_ATTRIB);
      hTag         = GetDlgItem(hDlg, IDC_PLATFORM);
      hEditTag     = GetDlgItem(hDlg, IDC_PLATFORMEDIT);
      hExpand      = GetDlgItem(hDlg, IDC_EXPAND);
      FillComboWithTiles(hFloorTile);
      FillComboWithTiles(hCeilingTile);
      FillComboWithSectorAttributes(hAttrib);
      // this provides device independence: first numbers
      // are dialog units, 64's are pixels.
      rFloor.top = 73;
      rFloor.left = 161;    // values from DoomEd.rc
      MapDialogRect(hDlg, &rFloor);
      rFloor.right = rFloor.left + 64;
      rFloor.bottom = rFloor.top + 64;
      rCeiling.top = 14;
      rCeiling.left = 161;
      MapDialogRect(hDlg, &rCeiling);
      rCeiling.right = rCeiling.left + 64;
      rCeiling.bottom = rCeiling.top + 64;
      return TRUE;
      break;

    case WM_PAINT:
      if(!Expanded)
        return FALSE;
      BeginPaint(hDlg, &ps);
      if(hBitmapFloor) {
        HDC hMemoryDC;
        BITMAP    bm;

        hMemoryDC = CreateCompatibleDC(ps.hdc);
        GetObject(hBitmapFloor, sizeof(BITMAP), (LPSTR)&bm);
        SelectObject(hMemoryDC, hBitmapFloor);
        BitBlt(ps.hdc, rFloor.left, rFloor.top, bm.bmWidth, bm.bmHeight,
               hMemoryDC, 0, 0, SRCCOPY);
        DeleteDC(hMemoryDC);
        }
      if(hBitmapCeiling) {
        HDC hMemoryDC;
        BITMAP    bm;

        hMemoryDC = CreateCompatibleDC(ps.hdc);
        GetObject(hBitmapCeiling, sizeof(BITMAP), (LPSTR)&bm);
        SelectObject(hMemoryDC, hBitmapCeiling);
        BitBlt(ps.hdc, rCeiling.left, rCeiling.top, bm.bmWidth, bm.bmHeight,
               hMemoryDC, 0, 0, SRCCOPY);
        DeleteDC(hMemoryDC);
        }
      EndPaint(hDlg, &ps);
      return TRUE;
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_CEILING:
          // don't update when placing new values into dialog:
          if(SectorLoading)
            break;
          // check if notification of change
          if(HIWORD(lParam) == EN_CHANGE) {
            // if so:
            BOOL xx;
            // get the new value:
            int xxx = GetDlgItemInt(hDlg, IDC_CEILING, &xx, TRUE);
            // update all selected sectors:
            for(i = 0; i < SectorsNum; i++)
              if(eSector[i].Used &&
                 eSector[i].Selected)
                Sector[i].ceilZ = xxx;
            // enable save button:
            MapChange();
            }
          break;

        case IDC_FLOOR:
          if(SectorLoading)
            break;
          if(HIWORD(lParam) == EN_CHANGE) {
            BOOL xx;
            int xxx = GetDlgItemInt(hDlg, IDC_FLOOR, &xx, TRUE);
            for(i = 0; i < SectorsNum; i++)
              if(eSector[i].Used &&
                 eSector[i].Selected)
                Sector[i].floorZ = xxx;
            MapChange();
            }
          break;

        case IDC_BRIGHTNESS:
          if(SectorLoading)
            break;
          if(HIWORD(lParam) == EN_CHANGE) {
            BOOL xx;
            int xxx = GetDlgItemInt(hDlg, IDC_BRIGHTNESS, &xx, TRUE);
            for(i = 0; i < SectorsNum; i++)
              if(eSector[i].Used &&
                 eSector[i].Selected)
                Sector[i].light = xxx;
            MapChange();
            }
          break;

        case IDC_ATTRIB:
          if(SectorLoading)
            break;
          if(HIWORD(lParam) == CBN_SELCHANGE) {
            int xx = ComboBox_GetCurSel(hAttrib);
            for(i = 0; i < SectorsNum; i++)
              if(eSector[i].Used &&
                 eSector[i].Selected)
                Sector[i].flash = xx;
            MapChange();
            }
          break;
        
        case IDC_PLATFORM:
          if(SectorLoading)
            break;
          // change marked lines if tag number changes:
          if(HIWORD(lParam) == CBN_SELCHANGE) {
            int xx =  (int)ComboBox_GetItemData(hTag, 
                           ComboBox_GetCurSel(hTag));
            if(xx == Nothing)
              xx = 0;
            for(i = 0; i < SectorsNum; i++)
              if(eSector[i].Used &&
                 eSector[i].Selected) {
                UnTagLineDef(Sector[i].tag);
                Sector[i].tag = xx;
                if(Sector[i].tag)
                  TagLineDef(Sector[i].tag);
                }
            }
          break;

        case IDC_FLOORTILE:
          if(SectorLoading)
            break;
          if(HIWORD(lParam) == CBN_SELCHANGE) {
            char    Search[10];
            int     which, where;
            
            ComboBox_GetText(hFloorTile, Search, 10);
            where = DD_EXTERNAL;
            if((which = DirEntry(Search)) == NotFound) {
              where = DD_INTERNAL;
              if((which = DoomEntry(Search)) == NotFound) {
                if(hBitmapFloor)
                  DeleteBitmap(hBitmapFloor);
                hBitmapFloor = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_NOTILE));
                InvalidateRect(hDlg, &rFloor, FALSE);
                whichFloor = Nothing;
                break;
                }
              }

            if((which != whichFloor) || (where != whereFloor)) {
              if(hBitmapFloor)
                DeleteBitmap(hBitmapFloor);
              if(where == DD_INTERNAL)
                hBitmapFloor = TileFromDoom(which);
              else
                hBitmapFloor = TileFromDir(which);
              InvalidateRect(hDlg, &rFloor, FALSE);
              whichFloor = which;
              whereFloor = where;
              for(i = 0; i < SectorsNum; i++)
                if(eSector[i].Used &&
                   eSector[i].Selected)
                  CopyWall(Sector[i].Floor, Search);
              }
            }
          break;

        case IDC_CEILINGTILE:
          if(SectorLoading)
            break;
          if(HIWORD(lParam) == CBN_SELCHANGE) {
            char    Search[10];
            int     which, where;
            
            ComboBox_GetText(hCeilingTile, Search, 10);
            where = DD_EXTERNAL;
            if((which = DirEntry(Search)) == NotFound) {
              where = DD_INTERNAL;
              if((which = DoomEntry(Search)) == NotFound) {
                if(hBitmapCeiling)
                  DeleteBitmap(hBitmapCeiling);
                hBitmapCeiling = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_NOTILE));
                InvalidateRect(hDlg, &rCeiling, FALSE);
                whichCeiling = Nothing;
                break;
                }
              }
            if((which != whichCeiling) || (where != whereCeiling)) {
              if(hBitmapCeiling)
                DeleteBitmap(hBitmapCeiling);
              if(where == DD_INTERNAL)
                hBitmapCeiling = TileFromDoom(which);
              else
                hBitmapCeiling = TileFromDir(which);
              InvalidateRect(hDlg, &rCeiling, FALSE);
              whichCeiling = which;
              whereCeiling = where;
              for(i = 0; i < SectorsNum; i++)
                if(eSector[i].Used &&
                   eSector[i].Selected)
                  CopyWall(Sector[i].Ceil, Search);
              }
            }
          break;
    
        case IDC_PLATFORMEDIT:
          {
          FARPROC lpfnDlgProc;
          lpfnDlgProc = MakeProcInstance((FARPROC)DialogPlatform, hinst);
          if(lpfnDlgProc) {
            DialogBox(hinst,
                      MAKEINTRESOURCE(IDD_PLATFORM),
                      hDlg,
                      lpfnDlgProc);
            FreeProcInstance(lpfnDlgProc);
            }
          }
          FillComboWithPlatforms(hTag);
          ComboBox_SetCurSel(hTag, CurrentTag);
          break;
          
        case IDC_PLATFORMADD:
          {
          FARPROC lpfnDlgProc;
          CurrentTag = Nothing;
          lpfnDlgProc = MakeProcInstance((FARPROC)DialogPlatform, hinst);
          if(lpfnDlgProc) {
            DialogBox(hinst,
                      MAKEINTRESOURCE(IDD_PLATFORM),
                      hDlg,
                      lpfnDlgProc);
            FreeProcInstance(lpfnDlgProc);
            }
          FillComboWithPlatforms(hTag);
          }
          // if CurrentPlatform is Nothing, then unselect all
          ComboBox_SetCurSel(hTag, CurrentTag);
          {
          int xx = (int)ComboBox_GetItemData(hTag, 
                        ComboBox_GetCurSel(hTag));
          if(xx == Nothing)
            xx = 0;
          for(i = 0; i < SectorsNum; i++)      
            if(eSector[i].Used &&
               eSector[i].Selected) {
              UnTagLineDef(Sector[i].tag);
              Sector[i].tag = xx;
              if(Sector[i].tag)
                TagLineDef(Sector[i].tag);
              }
          }
          break;

        case IDC_EXPAND:
          if(Expanded) {
            Expanded = FALSE;
            Button_SetText(hExpand, ">>");
            dSize.left = 0; dSize.right  = 154;
            dSize.top  = 0; dSize.bottom = 160;
            MapDialogRect(hDlg, &dSize);
            SetWindowPos(hDlg, (HWND) NULL, 0, 0, dSize.right+2, dSize.bottom+22,
                         SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOMOVE);
            }
          else {
            Expanded = TRUE;
            Button_SetText(hExpand, "<<");
            dSize.left = 0; dSize.right  = 210;
            dSize.top  = 0; dSize.bottom = 160;
            MapDialogRect(hDlg, &dSize);
            SetWindowPos(hDlg, (HWND) NULL, 0, 0, dSize.right+2, dSize.bottom+22,
                         SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOMOVE);
            // force redraw of pictures:
            PostMessage(hDlg, WM_COMMAND, IDC_FLOORTILE, MAKELONG(0, CBN_SELCHANGE));
            PostMessage(hDlg, WM_COMMAND, IDC_CEILINGTILE, MAKELONG(0, CBN_SELCHANGE));
            }
          break;
        
        case IDCANCEL:          // Close button
          // this will cause data to be written:
          PutSectorInDialog(Nothing);
          return TRUE;
          break;
        default:
          return FALSE;
          break;
        }
      
    default:
      return FALSE;
    }
    return FALSE;
}

void PutValueInFloorAndCeiling(int num, int val)
{
  // called when creating doors
  char  szTemp[16];

  if(SelectedSectors == 1) {
    SectorLoading = TRUE;
    sprintf(szTemp, "%i", val);
    Edit_SetText(hFloor, szTemp);
    sprintf(szTemp, "%i", val);
    Edit_SetText(hCeiling, szTemp);
    SectorLoading = FALSE;
    }
}

int EXPORT DialogSectors(HWND  hDlg,
                         WORD  wMsg,
                         WORD  wParam,
                         DWORD lParam)
{
  return 0;
}

void DetachSectors(void)
{
  // detaches all selected sectors from other sectors, closing
  // up any holes or gaps created. On exit, only vertexes and
  // linedefs marked MOVE are associated with this sector or sectors.

  int i, Sec1, Sec2;

  // clear move arrays:
  for(int tt = 0; tt < MAX_VERTEX; tt++)
    eVertex[tt].Moving = FALSE;
  for(tt = 0; tt < MAX_LINEDEF; tt++)
    eLineDef[tt].Moving = FALSE;
  // do it:
  for(i = 0; i < LineDefsNum; i++)
    if(eLineDef[i].Used) {
      // determine which sector(s) touch this line:
      if(LineDef[i].sidedef1 != Nothing)
        Sec1 = SideDef[LineDef[i].sidedef1].sector;
      else
        Sec1 = Nothing;
      if(LineDef[i].sidedef2 != Nothing)
        Sec2 = SideDef[LineDef[i].sidedef2].sector;
      else
        Sec2 = Nothing;
      // determine if this line needs to be broken:
      // is this is a two sided line?
      if((Sec1 != Nothing) && (Sec2 != Nothing)) {
        // is only one side part of a selected sector?
        if((eSector[Sec1].Selected || eSector[Sec2].Selected) &&
           (eSector[Sec1].Selected != eSector[Sec2].Selected)) {
          // only one side is selected, so we
          // create a new line to move
          int newl, newv1, newv2;
           // get new objects
          newl = LineDefNew();
          newv1 = VertexNew();
          newv2 = VertexNew();
          Vertex[newv1] = Vertex[LineDef[i].from];
          Vertex[newv2] = Vertex[LineDef[i].to];
          // fix bits 1&4
          SetLineBit(i, ML_BLOCKING);
          ClearLineBit(i, ML_TWOSIDED);
          // copy old linedef
          LineDef[newl] = LineDef[i];
          // copy 2nd sidedef to new linedef
          LineDef[newl].sidedef1 = LineDef[i].sidedef2;
          // clear unused sidedefs
          LineDef[i].sidedef2 = Nothing;
          LineDef[newl].sidedef2 = Nothing;
          // stick a texture into the openings
          if(SideDef[LineDef[i].sidedef1].t3[0] == '-') {
            if(SideDef[LineDef[i].sidedef1].t2[0] != '-')
              CopyWall(SideDef[LineDef[i].sidedef1].t3,
                       SideDef[LineDef[i].sidedef1].t2);
            if(SideDef[LineDef[i].sidedef1].t1[0] != '-')
              CopyWall(SideDef[LineDef[i].sidedef1].t3,
                       SideDef[LineDef[i].sidedef1].t1);
            // if still nothing, put default there:
            if(SideDef[LineDef[i].sidedef1].t3[0] == '-')
              CopyWall(SideDef[LineDef[i].sidedef1].t3,
                       DefaultSectorWall);
            }
          // second opening
          if(SideDef[LineDef[newl].sidedef1].t3[0] == '-') {
            if(SideDef[LineDef[newl].sidedef1].t2[0] != '-')
              CopyWall(SideDef[LineDef[newl].sidedef1].t3,
                       SideDef[LineDef[newl].sidedef1].t2);
            if(SideDef[LineDef[newl].sidedef1].t1[0] != '-')
              CopyWall(SideDef[LineDef[newl].sidedef1].t3,
                       SideDef[LineDef[newl].sidedef1].t1);
            if(SideDef[LineDef[newl].sidedef1].t3[0] == '-')
              CopyWall(SideDef[LineDef[newl].sidedef1].t3,
                       DefaultSectorWall);
            }
          // new vertexes are moving
          eVertex[newv1].Moving = ADDED;
          eVertex[newv2].Moving = ADDED;
          // determine if new or old line is moving:
          if(eSector[Sec1].Selected) {
            eLineDef[i].Moving = TRUE;
            LineDef[newl].from = LineDef[i].to;
            LineDef[newl].to = LineDef[i].from;
            LineDef[i].from = newv1;
            LineDef[i].to = newv2;
            }     // endif first sector
          else {
            eLineDef[newl].Moving = TRUE;
            LineDef[newl].to = newv1;
            LineDef[newl].from = newv2;
            }     // endif second sector
          }     // endif not both selected
        else if(eSector[Sec1].Selected && eSector[Sec2].Selected) {
          // if both sides selected,
          // add it to the movelist.
          int   newv;

          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].from];
          LineDef[i].from = newv;
          eVertex[newv].Moving = ADDED;
          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].to];
          LineDef[i].to = newv;
          eVertex[newv].Moving = ADDED;

          eLineDef[i].Moving = TRUE;
          }     // endif both selected
        }       // endif two sided
      else {    // one sided
        if(((Sec1 != Nothing) && eSector[Sec1].Selected) ||
           ((Sec2 != Nothing) && eSector[Sec2].Selected)) {
          // if this linedef is part of a selected
          // sector, just add it to the movelist.
          int   newv;
                      
          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].from];
          LineDef[i].from = newv;
          eVertex[newv].Moving = ADDED;
          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].to];
          LineDef[i].to = newv;
          eVertex[newv].Moving = ADDED;

          eLineDef[i].Moving = TRUE;
          }     // endif either side
        }       // endif one sided
      }         // endif linedefused
}

void ExtractSectors(void)
{
  // similar to Detach Sectors, but removes other lines.
  int i, Sec1, Sec2;

  // clear move arrays:
  for(int tt = 0; tt < MAX_VERTEX; tt++)
    eVertex[tt].Moving = FALSE;
  for(tt = 0; tt < MAX_LINEDEF; tt++)
    eLineDef[tt].Moving = FALSE;
  // do it:
  for(i = 0; i < LineDefsNum; i++)
    if(eLineDef[i].Used) {
      // determine which sector(s) touch this line:
      if(LineDef[i].sidedef1 != Nothing)
        Sec1 = SideDef[LineDef[i].sidedef1].sector;
      else
        Sec1 = Nothing;
      if(LineDef[i].sidedef2 != Nothing)
        Sec2 = SideDef[LineDef[i].sidedef2].sector;
      else
        Sec2 = Nothing;
      // determine if this line needs to be broken:
      // is this is a two sided line?
      if((Sec1 != Nothing) && (Sec2 != Nothing)) {
        // is only one side part of a selected sector?
        if((eSector[Sec1].Selected || eSector[Sec2].Selected) &&
           (eSector[Sec1].Selected != eSector[Sec2].Selected)) {
          // only one side is selected, so we
          // fix bits 1&4
          SetLineBit(i, ML_BLOCKING);
          ClearLineBit(i, ML_TWOSIDED);
          if(eSector[Sec1].Selected) {
            // delete back
            eSideDef[LineDef[i].sidedef2].Used = FALSE;
            LineDef[i].sidedef2 = Nothing;
            }
          else {
            // delete front
            // reverse line so sidedef1 is used:
            eSideDef[LineDef[i].sidedef1].Used = FALSE;
            LineDef[i].sidedef1 = LineDef[i].sidedef2;
            LineDef[i].sidedef2 = Nothing;
            int swaptemp = LineDef[i].from;
            LineDef[i].from = LineDef[i].to;
            LineDef[i].to = swaptemp;
            }
          // stick a texture into the openings
          if(SideDef[LineDef[i].sidedef1].t3[0] == '-') {
            if(SideDef[LineDef[i].sidedef1].t2[0] != '-')
              CopyWall(SideDef[LineDef[i].sidedef1].t3,
                       SideDef[LineDef[i].sidedef1].t2);
            if(SideDef[LineDef[i].sidedef1].t1[0] != '-')
              CopyWall(SideDef[LineDef[i].sidedef1].t3,
                       SideDef[LineDef[i].sidedef1].t1);
            // if still nothing, put default there:
            if(SideDef[LineDef[i].sidedef1].t3[0] == '-')
              CopyWall(SideDef[LineDef[i].sidedef1].t3,
                       DefaultSectorWall);
            }
          int newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].from];
          LineDef[i].from = newv;
          eVertex[newv].Moving = ADDED;
          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].to];
          LineDef[i].to = newv;
          eVertex[newv].Moving = ADDED;
          eLineDef[i].Moving = TRUE;
          }     // endif not both selected
        else if(eSector[Sec1].Selected && eSector[Sec2].Selected) {
          // if both sides selected,
          // add it to the movelist.
          int   newv;

          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].from];
          LineDef[i].from = newv;
          eVertex[newv].Moving = ADDED;
          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].to];
          LineDef[i].to = newv;
          eVertex[newv].Moving = ADDED;

          eLineDef[i].Moving = TRUE;
          }     // endif both selected
        }       // endif two sided
      else {    // one sided
        if(((Sec1 != Nothing) && eSector[Sec1].Selected) ||
           ((Sec2 != Nothing) && eSector[Sec2].Selected)) {
          // if this linedef is part of a selected
          // sector, just add it to the movelist.
          int   newv;
                      
          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].from];
          LineDef[i].from = newv;
          eVertex[newv].Moving = ADDED;
          newv = VertexNew();
          Vertex[newv] = Vertex[LineDef[i].to];
          LineDef[i].to = newv;
          eVertex[newv].Moving = ADDED;

          eLineDef[i].Moving = TRUE;
          }     // endif either side
        }       // endif one sided
      }         // endif linedefused
}



