// Style Dialogs for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

int EXPORT DialogSectorDefault(HWND hDlg, WORD wMsg,
                               WORD wParam, DWORD lParam);

int     WhichStyle;

void DoStyles(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogStyles, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_STYLES),
              hwnd,
              lpfnDlgProc);
    FreeProcInstance(lpfnDlgProc);
    PutTextureInViewer(Nothing);
    }
}

HWND    hList2;

int EXPORT DialogStyles(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  int   i;
  switch(wMsg) {
    case WM_INITDIALOG:
      hList2 = GetDlgItem(hDlg, IDC_STYLE_LIST);
      FillListWithStyles(hList2);
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_STYLE_LIST:
          switch(HIWORD(lParam)) {
            case LBN_DBLCLK:
              // the first click selected the right one...
              SendMessage(hDlg, WM_COMMAND, IDC_STYLE_EDIT, 0L);
              return TRUE;
              break;
            case LBN_SELCHANGE:
              WhichStyle = ListBox_GetCurSel(hList2);
              Button_Enable(GetDlgItem(hDlg, IDC_STYLE_EDIT), TRUE);
              Button_Enable(GetDlgItem(hDlg, IDC_STYLE_DELETE), TRUE);
              return TRUE;
              break;
            default:
              return TRUE;
              break;
            }
        case IDC_STYLE_ADD:
          WhichStyle = Nothing;
          SendMessage(hDlg, WM_COMMAND, IDC_STYLE_EDIT, 0L);
          return TRUE;
          break;
        case IDC_STYLE_DELETE:
          {
            char szTemp[128];
            sprintf(szTemp, "Are you sure you want to delete the\n"
                            "style \"%s\"?", Style[WhichStyle].Name);
            if(MessageBox(hDlg, szTemp, ProgName, MB_YESNO |
                          MB_ICONQUESTION) == IDYES) {
              for(i=WhichStyle; i<StylesNum; i++)
                Style[i] = Style[i + 1];
              StylesNum--;
              }
          }
          FillListWithStyles(hList2);
          PopupSetup();
          return TRUE;
          break;
        case IDC_STYLE_EDIT:
          {
          FARPROC lpfnDlgProc;
          lpfnDlgProc = MakeProcInstance((FARPROC)DialogStyle, hinst);
          if(lpfnDlgProc) {
            DialogBox(hinst,
                      MAKEINTRESOURCE(IDD_STYLE),
                      hDlg,
                      lpfnDlgProc);
            FreeProcInstance(lpfnDlgProc);
            }
          }
          FillListWithStyles(hList2);
          PopupSetup();
          return TRUE;
          break;
        case IDOK:
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}

static HWND    hName2, hWalls, hFloor, hCeiling;

int EXPORT DialogStyle(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
  switch(wMsg) {
    case WM_INITDIALOG:
      hName2   = GetDlgItem(hDlg, IDC_STYLE_NAME);
      hWalls   = GetDlgItem(hDlg, IDC_STYLE_WALLS);
      hFloor   = GetDlgItem(hDlg, IDC_STYLE_FLOOR);
      hCeiling = GetDlgItem(hDlg, IDC_STYLE_CEILING);
      Edit_LimitText(hName2, 32);
      FillComboWithTextures(hWalls);
      FillComboWithTiles(hFloor);
      FillComboWithTiles(hCeiling);
      if(WhichStyle != Nothing) {
        Edit_SetText(hName2, Style[WhichStyle].Name);
        ComboBox_SetCurSel(hWalls,
        ComboBox_FindString(hWalls, 0, Style[WhichStyle].Walls));
        ComboBox_SetCurSel(hFloor,
        ComboBox_FindString(hFloor, 0, Style[WhichStyle].Floor));
        ComboBox_SetCurSel(hCeiling,
        ComboBox_FindString(hCeiling, 0, Style[WhichStyle].Ceiling));
        }
      else {
        Edit_SetText(hName2, "noname");
        ComboBox_SetCurSel(hWalls, Nothing);
        ComboBox_SetCurSel(hFloor, Nothing);
        ComboBox_SetCurSel(hCeiling, Nothing);
        }
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_STYLE_WALLS:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN))
            PutTextureInViewer((int)ComboBox_GetItemData(hWalls,
                               ComboBox_GetCurSel(hWalls)));
          break;

        case IDOK:
          if(WhichStyle == Nothing)
            WhichStyle = StylesNum++;
          NullWall(Style[WhichStyle].Walls);
          NullWall(Style[WhichStyle].Floor);
          NullWall(Style[WhichStyle].Ceiling);
          if(ComboBox_GetCurSel(hWalls) != Nothing)
            strcpy(Style[WhichStyle].Walls,
                   Texture[ComboBox_GetItemData(hWalls, 
                   ComboBox_GetCurSel(hWalls))].name);
          else  
            { NullWall(Style[WhichStyle].Walls); }
          if(ComboBox_GetCurSel(hFloor) != Nothing)
            strcpy(Style[WhichStyle].Floor,
                   Doom[ComboBox_GetItemData(hFloor, 
                   ComboBox_GetCurSel(hFloor))].Title);
          else  
            { NullWall(Style[WhichStyle].Floor); }
          if(ComboBox_GetCurSel(hCeiling) != Nothing)
            strcpy(Style[WhichStyle].Ceiling,
                   Doom[ComboBox_GetItemData(hCeiling, 
                   ComboBox_GetCurSel(hCeiling))].Title);
          else  
            { NullWall(Style[WhichStyle].Ceiling); }
          Edit_GetText(hName2, Style[WhichStyle].Name, 32);
          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}

void DoSectorDefault(void)
{
  FARPROC lpfnDlgProc;
  lpfnDlgProc = MakeProcInstance((FARPROC)DialogSectorDefault, hinst);
  if(lpfnDlgProc) {
    DialogBox(hinst,
              MAKEINTRESOURCE(IDD_SECTORSTYLE),
              hwnd,
              lpfnDlgProc);
    PutTextureInViewer(Nothing);
    FreeProcInstance(lpfnDlgProc);
    }
}

static HWND hPre, hSWall, hSCeil, hSFloor, hHCeil, hHFloor, hBrite;

int EXPORT DialogSectorDefault(HWND hDlg, WORD wMsg,
                               WORD wParam, DWORD lParam)
{
  char  szTemp[10];
  BOOL  XlateErr = FALSE;
  
  switch(wMsg) {
    case WM_INITDIALOG:
      hPre    = GetDlgItem(hDlg, IDC_PREDEFINED);
      hSWall  = GetDlgItem(hDlg, IDC_STYLEWALL);
      hSCeil  = GetDlgItem(hDlg, IDC_STYLECEILING);
      hSFloor = GetDlgItem(hDlg, IDC_STYLEFLOOR);
      hHCeil  = GetDlgItem(hDlg, IDC_CEILING);
      hHFloor = GetDlgItem(hDlg, IDC_FLOOR);
      hBrite  = GetDlgItem(hDlg, IDC_BRIGHTNESS);
      FillComboWithStyles(hPre);
      FillComboWithTextures(hSWall);
      FillComboWithTiles(hSFloor);
      FillComboWithTiles(hSCeil);
      NullWall(szTemp);
      szTemp[8] = '\0';
      CopyWall(szTemp, DefSideDef.t3);
      ComboBox_SetCurSel(hSWall,  ComboBox_FindStringExact(hSWall,
                                  Nothing, szTemp));
      CopyWall(szTemp, DefSector.Floor);
      ComboBox_SetCurSel(hSFloor, ComboBox_FindStringExact(hSFloor,
                                  Nothing, szTemp));
      CopyWall(szTemp, DefSector.Ceil);
      ComboBox_SetCurSel(hSCeil,  ComboBox_FindStringExact(hSCeil,
                                  Nothing, szTemp));
      SetDlgItemInt(hDlg, IDC_FLOOR,      DefSector.floorZ, TRUE);
      SetDlgItemInt(hDlg, IDC_CEILING,    DefSector.ceilZ,  TRUE);
      SetDlgItemInt(hDlg, IDC_BRIGHTNESS, DefSector.light,  TRUE);
      break;

    case WM_COMMAND:
      switch(wParam) {
        case IDC_STYLEWALL:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN))
            PutTextureInViewer((int)ComboBox_GetItemData(hSWall,
                               ComboBox_GetCurSel(hSWall)));
          break;

        case IDC_PREDEFINED:
          if((HIWORD(lParam) == CBN_SELCHANGE) ||
             (HIWORD(lParam) == CBN_DROPDOWN)) {
            int i = ComboBox_GetCurSel(hPre);
            if(i != Nothing) {
              NullWall(szTemp);
              szTemp[8] = '\0';
              CopyWall(szTemp, Style[i].Walls);
              ComboBox_SetCurSel(hSWall,  ComboBox_FindStringExact(hSWall,
                                          Nothing, szTemp));
              CopyWall(szTemp, Style[i].Floor);
              ComboBox_SetCurSel(hSFloor, ComboBox_FindStringExact(hSFloor,
                                          Nothing, szTemp));
              CopyWall(szTemp, Style[i].Ceiling);
              ComboBox_SetCurSel(hSCeil,  ComboBox_FindStringExact(hSCeil,
                                          Nothing, szTemp));
              }
            }
          break;

        case IDOK:
          DefaultSectorBottom = GetDlgItemInt(hDlg, IDC_FLOOR,
                                &XlateErr, TRUE);
          DefaultSectorTop    = GetDlgItemInt(hDlg, IDC_CEILING,
                                &XlateErr, TRUE);
          DefaultSectorLight  = GetDlgItemInt(hDlg, IDC_BRIGHTNESS,
                                &XlateErr, TRUE);
          if(ComboBox_GetCurSel(hSWall) != Nothing)
            strcpy(DefaultSectorWall,
                   Texture[ComboBox_GetItemData(hSWall,
                   ComboBox_GetCurSel(hSWall))].name);
          if(ComboBox_GetCurSel(hSFloor) != Nothing)
            strcpy(DefaultSectorFloor,
                   Doom[ComboBox_GetItemData(hSFloor, 
                   ComboBox_GetCurSel(hSFloor))].Title);
          if(ComboBox_GetCurSel(hSCeil) != Nothing)
            strcpy(DefaultSectorCeil,
                   Doom[ComboBox_GetItemData(hSCeil, 
                   ComboBox_GetCurSel(hSCeil))].Title);
            // set these defaults:
            CopyWall(DefSideDef.t3, DefaultSectorWall);
            CopyWall(DefSector.Floor, DefaultSectorFloor);
            CopyWall(DefSector.Ceil, DefaultSectorCeil);
            DefSector.floorZ = DefaultSectorBottom;
            DefSector.ceilZ  = DefaultSectorTop;
            DefSector.light  = DefaultSectorLight;
            // note: defaults will be saved into ini file

          EndDialog(hDlg, IDOK);
          return TRUE;
          break;
        case IDCANCEL:
          EndDialog(hDlg, IDCANCEL);
          return TRUE;
          break;
        default:
          break;
      }
    default:
      return FALSE;
    }
    return FALSE;
}

void ApplyStyle(int num)
{
  for(int i = 0; i < SideDefsNum; i++)
    if(eSideDef[i].Used &&
       eSector[SideDef[i].sector].Selected) {
      if((SideDef[i].t1[0] != '-') && (SideDef[i].t1[0] != '\0'))
        CopyWall(SideDef[i].t1, Style[num].Walls);
      if((SideDef[i].t2[0] != '-') && (SideDef[i].t2[0] != '\0'))
        CopyWall(SideDef[i].t2, Style[num].Walls);
      if((SideDef[i].t3[0] != '-') && (SideDef[i].t3[0] != '\0'))
        CopyWall(SideDef[i].t3, Style[num].Walls);
      }
  for(i = 0; i < SectorsNum; i++)
    if(eSector[i].Used && eSector[i].Selected) {
      CopyWall(Sector[i].Floor, Style[num].Floor);
      CopyWall(Sector[i].Ceil, Style[num].Ceiling);
      }
}