// Thing dialog for DoomEd 4.0
// 
// Copyright  1995 by Geoff Allan
// All Rights Reserved. Unauthorised distribution of this source
// is a violation of Canadian and International Copyright laws.

#include "DoomEd40.hpp"

static  int     bmX, bmY, ThingUnknown, oldThing, oldLev;
static  HWND    hThing, hFacing, hLevels, hExpand;
static  BOOL    Expanded = FALSE, ThingLoading = FALSE;
static  HBITMAP hBitmapThing;
static  RECT    pSize;  // for picture location
static  int     PictureItem = Nothing;

#if defined(HideDialog)
#undef HideDialog
#undef ShowDialog
#endif
#define HideDialog  PostMessage(hwnd, DOOMED_HIDE_THING, 0, 0L);
#define ShowDialog  PostMessage(hwnd, DOOMED_SHOW_THING, 0, 0L);

void PutBitmapInDialog(HBITMAP bmp)
{
  HDC       hMemoryDC, hMemoryDC2, dDC;
  BITMAP    bm;
  int       tx, ty;

  if(hBitmapThing)
    DeleteObject(hBitmapThing);

  if(!bmp)
    bmp = LoadBitmap(hinst, MAKEINTRESOURCE(IDB_NOTILE));

  GetObject(bmp, sizeof(BITMAP), (LPSTR)&bm);

  tx = (bmX / 2) - (bm.bmWidth / 2);
  ty = (bmY / 2) - (bm.bmHeight / 2);
  
  // this creates the new bitmap and DCs
  dDC = GetDC(hwndDialogThing);
  hMemoryDC = CreateCompatibleDC(dDC);
  hMemoryDC2 = CreateCompatibleDC(dDC);
  SelectPalette(hMemoryDC, hPalette, 0);  // for 8bit color support
  RealizePalette(hMemoryDC);
  // create the actual bitmap to fit within our rectangle
  HBRUSH greybrush = CreateSolidBrush(PALETTERGB(192, 192, 192));
  hBitmapThing = CreateCompatibleBitmap(dDC, bmX, bmY);
  SelectObject(hMemoryDC, hBitmapThing);
  SelectObject(hMemoryDC2, bmp);
  SelectObject(hMemoryDC, greybrush);             // background color
  PatBlt(hMemoryDC, 0, 0, bmX, bmY, WHITENESS);   // clear new bitmap
  PatBlt(hMemoryDC, 0, 0, bmX, bmY, PATCOPY);     // color the background
  BitBlt(hMemoryDC, tx, ty, bm.bmWidth, bm.bmHeight,
         hMemoryDC2, 0, 0, SRCCOPY);
  // get rid of the temporary bitmap
  DeleteDC(hMemoryDC);
  DeleteDC(hMemoryDC2);
  DeleteObject(bmp);
  DeleteBrush(greybrush);
  ReleaseDC(hwndDialogThing, dDC);
  InvalidateRect(hwndDialogThing, &pSize, TRUE);   // force redraw
}

void PutThingInDialog(int num)
{
  int     j, k, n;
  char    szTemp[40];
  
  if(num == DialogClear) {
    ThingLoading = TRUE;
    SetWindowText(hwndDialogThing, "Thing");
    ComboBox_SetCurSel(hThing, Nothing);
    ComboBox_SetCurSel(hFacing, Nothing);
    ListBox_SetSel(hLevels, FALSE, Nothing);
    if(Expanded)
      PutBitmapInDialog(NULL);  // no-tile
    ThingLoading = FALSE;
    return;
    }

  if(num == Nothing) {
    if(IsWindowVisible(hwndDialogThing))
      HideDialog;
    return;
    }
  else
    if(!IsWindowVisible(hwndDialogThing))
      ShowDialog;

  oldLev = 0;
  
  ThingLoading = TRUE;
  if(SelectedThings > 1) {
    sprintf(szTemp, "%i Things", SelectedThings);
    SetWindowText(hwndDialogThing, szTemp);
    ComboBox_SetCurSel(hThing, Nothing);
    ComboBox_SetCurSel(hFacing, Nothing);
    ListBox_SetSel(hLevels, FALSE, Nothing);
    if(Expanded)
      PutBitmapInDialog(NULL);
    }
  else {
    sprintf(szTemp, "Thing %i", num);
    SetWindowText(hwndDialogThing, szTemp);
    j = ComboBox_GetCount(hThing);
    n = NotFound;
    for(k = 0; k < j; k++)
      if(ComboBox_GetItemData(hThing, k) == Thing[num].item) {
        n = k;
        break;  // skip for
        }
    if(n == NotFound)
      ComboBox_SetCurSel(hThing, Nothing);
    else
      ComboBox_SetCurSel(hThing, n);
    for(k = 0; k < j; k++)
      if(ComboBox_GetItemData(hFacing, k) == Thing[num].face) {
        ComboBox_SetCurSel(hFacing, k);
        break;  // skip for
        }
    ListBox_SetSel(hLevels, FALSE, Nothing); // clear selections
    if(Thing[num].lev & 1)
      ListBox_SetSel(hLevels, TRUE, 0);
    if(Thing[num].lev & 2)
      ListBox_SetSel(hLevels, TRUE, 1);
    if(Thing[num].lev & 4)
      ListBox_SetSel(hLevels, TRUE, 2);
    if(Thing[num].lev & 8)
      ListBox_SetSel(hLevels, TRUE, 3);
    if(Thing[num].lev & 16)
      ListBox_SetSel(hLevels, TRUE, 4);

    if(Expanded)
      for(j=0; ThingDesc[j].num > 0; j++)
        if(ThingDesc[j].num == Thing[num].item)
          PutBitmapInDialog(BitmapFromDoom(DoomEntry(ThingDesc[j].image)));
    }   // endif single item
  return;
}

int EXPORT DialogThing(HWND  hDlg,
                       WORD  wMsg,
                       WORD  wParam,
                       DWORD lParam)
{
  RECT    dSize;        // for dialog expansion
  int     i, j;

  switch(wMsg)
    {
    case WM_PAINT:
      {
      PAINTSTRUCT ps;
      
      BeginPaint(hDlg, &ps);
      if(Expanded && hBitmapThing) {
        HDC hMemoryDC;
        
        hMemoryDC = CreateCompatibleDC(ps.hdc);
        SelectObject(hMemoryDC, hBitmapThing);
        BitBlt(ps.hdc, pSize.left, pSize.top, bmX, bmY,
               hMemoryDC, 0, 0, SRCCOPY);
        DeleteDC(hMemoryDC);
        }
      EndPaint(hDlg, &ps);
      return TRUE;
      break;
      }

    case WM_INITDIALOG:
      hFacing   = GetDlgItem(hDlg, IDC_FACING);
      hThing    = GetDlgItem(hDlg, IDC_THINGTYPE);
      hLevels   = GetDlgItem(hDlg, IDC_LEVELS);
      hExpand   = GetDlgItem(hDlg, IDC_EXPAND);
      
      FillComboWithDirections(hFacing);
      ComboBox_SetCurSel(hFacing, Nothing);

      ThingUnknown = FillComboWithThings(hThing);
      ComboBox_SetCurSel(hThing, Nothing);
      
      ListBox_ResetContent(hLevels);
      ListBox_AddString(hLevels, "One/Two");
      ListBox_AddString(hLevels, "Three");
      ListBox_AddString(hLevels, "Four");
      ListBox_AddString(hLevels, "Deaf");
      ListBox_AddString(hLevels, "Multi");

      // get size of bitmap area:
      pSize.left = 6; pSize.right  = 136;
      pSize.top  = 80; pSize.bottom = 167;
      MapDialogRect(hDlg, &pSize);
      bmX = (pSize.right - pSize.left);
      bmY = (pSize.bottom - pSize.top);
      return TRUE;
      break;

    case WM_ACTIVATE:
      if(wParam==WA_INACTIVE)
        Frontmost = NULL;
      else
        Frontmost = hwndDialogThing;
      break;
      
    case WM_COMMAND:
      switch (wParam) {
        case IDC_EXPAND:
          if(Expanded) {
            Expanded = FALSE;
            Button_SetText(hExpand, ">>");
            dSize.left = 0; dSize.right  = 150;
            dSize.top  = 0; dSize.bottom = 80;
            MapDialogRect(hDlg, &dSize);
            SetWindowPos(hDlg, (HWND) NULL, 0, 0, dSize.right+2, dSize.bottom+22,
                         SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOMOVE);
            }
          else {
            Expanded = TRUE;
            Button_SetText(hExpand, "<<");
            dSize.left = 0; dSize.right  = 150;
            dSize.top  = 0; dSize.bottom = 174;
            MapDialogRect(hDlg, &dSize);
            SetWindowPos(hDlg, (HWND) NULL, 0, 0, dSize.right+2, dSize.bottom+22,
                         SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOMOVE);
            PictureItem = Nothing;
            for(i = 0; i < ThingsNum; i++)
              if(eThing[i].Used &&
                 eThing[i].Selected)
                PictureItem = Thing[i].item;
            for(j = 0; ThingDesc[j].num > 0; j++)
              if(ThingDesc[j].num == PictureItem)
                PutBitmapInDialog(BitmapFromDoom(DoomEntry(ThingDesc[j].image)));
            }
          break;

        case IDC_THINGTYPE:
          if(HIWORD(lParam)==LBN_SELCHANGE) {
            i = ComboBox_GetCurSel(hThing);
            int newthing = (int)ComboBox_GetItemData(hThing, i);
            for(j = 0; ThingDesc[j].num > 0; j++)
              if(ThingDesc[j].num == newthing)
                PutBitmapInDialog(BitmapFromDoom(DoomEntry(ThingDesc[j].image)));
            for(i = 0; i < ThingsNum; i++)
              if(eThing[i].Used &&
                 eThing[i].Selected)
                Thing[i].item = newthing;
            MapChange();
            }
          break;

        case IDC_FACING:
          if(HIWORD(lParam)==LBN_SELCHANGE) {
            i = ComboBox_GetCurSel(hFacing);
            int newface = (int)ComboBox_GetItemData(hFacing, i);
            for(i = 0; i < ThingsNum; i++)
              if(eThing[i].Used &&
                 eThing[i].Selected)
                Thing[i].face = newface;
            MapChange();
            }
          break;
        
        case IDC_LEVELS:
          if(HIWORD(lParam)==LBN_SELCHANGE) {
            int SetBits = 0, ResetBits = 0;
            int newLev = 0;
            if(ListBox_GetSel(hLevels, 0))
              newLev |=      1;
            if((oldLev &     1) !=
               (newLev &     1)) {
              if(newLev &    1)
                SetBits |=   1;
              else
                ResetBits |= 1;
              }

            if(ListBox_GetSel(hLevels, 1))
              newLev |=      2;
            if((oldLev &     2) !=
               (newLev &     2)) {
              if(newLev &    2)
                SetBits |=   2;
              else
                ResetBits |= 2;
              }

            if(ListBox_GetSel(hLevels, 2))
              newLev |=      4;
            if((oldLev &     4) !=
               (newLev &     4)) {
              if(newLev &    4)
                SetBits |=   4;
              else
                ResetBits |= 4;
              }

            if(ListBox_GetSel(hLevels, 3))
              newLev |=      8;
            if((oldLev &     8) !=
               (newLev &     8)) {
              if(newLev &    8)
                SetBits |=   8;
              else
                ResetBits |= 8;
              }

            if(ListBox_GetSel(hLevels, 4))
              newLev |=      16;
            if((oldLev &     16) !=
               (newLev &     16)) {
              if(newLev &    16)
                SetBits |=   16;
              else
                ResetBits |= 16;
              }

            if(SetBits)
              for(i = 0; i < ThingsNum; i++)
                if(eThing[i].Used && eThing[i].Selected)
                  Thing[i].lev |= SetBits;

            if(ResetBits)
              for(i = 0; i < ThingsNum; i++)
                if(eThing[i].Used && eThing[i].Selected) {
                  Thing[i].lev |= ResetBits;
                  Thing[i].lev ^= ResetBits;
                  }
            MapChange();
            oldLev = newLev;
            }
          return FALSE;
          break;
        
        case IDC_THINGCLOSE:
          PutThingInDialog(Nothing);
          return FALSE;
          break;
          
        default:
          return FALSE;
          break;
        }
      
    default:
      return FALSE;
    }
    return FALSE;
}

int EXPORT DialogThings(HWND  hDlg,
                        WORD  wMsg,
                        WORD  wParam,
                        DWORD lParam)
{
  return 0;
}
