#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <conio.h>
#include <dos.h>

#include "doomnet.h"
#include "ipxstr.h"
//#include "ipx_frch.h"		// FRENCH VERSION
#include "ipxsetup.h"

const char szRspFile[] = "@network.rsp";
char *pszGame = 0;
char *pszMsg = 0;
char *pszDehack = 0;

doomcom_t doomcom;
int vectorishooked;
void (far interrupt *olddoomvect) (void);

void CreateResponseFile(char *args)
	{
	char *pArg;
	FILE *fRsp;
	long flatadr;
	struct _SREGS sregs;
	int bNoTurbo = 0;

	fRsp = fopen(szRspFile+1, "w");

	pArg = strtok(args, " ");

	while (pArg)
		{
//Don't pass IPXSETUP-only arguments to the game
		if (stricmp(pArg, PARM_MSG) == 0) //get message as one argument
			pszMsg = pArg = strtok(0, "\"");
		else if (stricmp(pArg, PARM_DEHACK) == 0)
			pszDehack = pArg = strtok(0, " ");
		else if (stricmp(pArg, PARM_LAUNCH) == 0)
			pszGame = pArg = strtok(0, " ");
		else if (stricmp(pArg, PARM_NOTURBO) == 0)
			bNoTurbo = 1;
/*
		else if (stricmp(pArg, PARM_CONFIG) == 0) //ignore master's -config
			pArg = strtok(0, " ");
		else if (stricmp(pArg, PARM_CLASS) == 0) //ignore master's -class
			pArg = strtok(0, " ");
		else if	(stricmp(pArg, PARM_MASTER) != 0)
			fprintf(fRsp, "%s\n", pArg);
*/			
		else
			fprintf(fRsp, "%s\n", pArg);
		pArg = strtok(0, " ");
		}

//add local command arguments
	if (bNoJoy)
	 	fprintf (fRsp, "-nojoy\n");
	if (bNoMouse)
	 	fprintf (fRsp, "-nomouse\n");
	if (bNoMusic)
	 	fprintf (fRsp, "-nomusic\n");
	if (bNoSound)
	 	fprintf (fRsp, "-nosound\n");
	if (bNoSFX)
	 	fprintf (fRsp, "-nosfx\n");
	if ((pszTurbo) && (!bNoTurbo)) //Don't let anyone turbo if master says no!
	 	fprintf (fRsp, "-turbo %s\n", pszTurbo);
	if (pszClass)
	 	fprintf (fRsp, "-class %s\n", pszClass);
	if (bRndClass)
	 	fprintf (fRsp, "-rndclass\n");
	if (pszConfig)
	 	fprintf (fRsp, "-config %s\n", pszConfig);

	//add "-net &doomcom"
	_segread(&sregs);
 	flatadr = (long)sregs.ds*16 + (unsigned)&doomcom;
 	fprintf (fRsp, "-net %lu\n",flatadr);

	fclose(fRsp);
	}
/*
=============
=
= LaunchDOOM
=
These fields in doomcom should be filled in before calling:

short	numnodes;      // console is allways node 0
short	ticdup;        // 1 = no duplication, 2-5 = dup for slow nets
short	extratics;     // 1 = send a backup tic in every packet

short	consoleplayer; // 0-3 = player number
short	numplayers;    // 1-4
short	angleoffset;   // 1 = left, 0 = center, -1 = right
short	drone;         // 1 = drone
=============
*/

void LaunchDOOM (char *masterArgs)
	{
	int rc;

// prepare for DOOM
	 doomcom.id = DOOMCOM_ID;

// hook the interrupt vector
	olddoomvect = (void (interrupt far *)(void))_dos_getvect (doomcom.intnum);
	_dos_setvect (doomcom.intnum, NetISR);
	vectorishooked = 1;

//Create the response file to pass to the game 
	CreateResponseFile(masterArgs);

//Run Dehacked if requested by master
	if (pszDehack)
		spawnl(P_WAIT, "dehacked", "dehacked.exe", "-load", pszDehack, 0);

//Display Master's message if there is one
	if (pszMsg)
		{
		printf("\n\n\a%s\n\n", pszMsg); 
		printf(STR_CONTINUE);
		getch();	
		printf("\n");
		}

#ifndef DEBUG
	if (!pszGame)
		{
		if (!access("doom.exe",0))	
			pszGame = "doom";
		else if (!access("doom2.exe",0))	
			pszGame = "doom2";
		else if (!access("heretic.exe",0))	
			pszGame = "heretic";
		else if (!access("hexen.exe",0))	
			pszGame = "hexen";
		}

	if (pszGame)
		rc = spawnl(P_WAIT, pszGame, pszGame, szRspFile, NULL);
#endif

	if (rc == -1)
		printf(STR_SPAWNERROR"\n", strupr(pszGame));
	else
		printf (STR_RETURNED"\n", strupr(pszGame));
	}
