@echo off

if "%1"=="" goto usage
if "%2"=="" goto usage
if "%3"=="" goto usage
if "%2"=="%3" goto same

if not exist %1 goto mnf
if not exist %2 goto snf
if not exist %3 goto dnf
  echo.
  echo WARNING: file %3 already exists.
  echo If you choose to continue, it will be overwritten.
  echo (Press Ctrl-Break or Ctrl-C to exit)
  pause

:dnf
rem destination does not exist yet

list %1 D_E3M9 >nul
if errorlevel 1 goto badmain
list %2 S_START >nul
if errorlevel 1 goto nosprites

mkdir TMP6043A
extract %1 * -AS_START -BS_END TMP6043A
if errorlevel 1 goto extrerr1
extract %2 * -AS_START -BS_END TMP6043A
if errorlevel 1 goto extrerr2
wadcomp %3 TMP6043A\*.*
if errorlevel 1 goto comperr

echo.
echo Done.  Removing the temorary directory...
del TMP6043A\*.*
rd TMP6043A
goto end



:usage
  echo.
  echo Usage: %0 main.wad source.wad dest.wad
  echo.
  echo Merges the sprite sections from main.wad and source.wad and stores the
  echo result in dest.wad.  Does NOT work with DOOM2.
  echo.
  echo All three arguments are necessary.  Main.wad and source.wad will not be
  echo modified.  Dest.wad and source.wad cannot be the same.
  echo.
  echo Example: %0 doom.wad barney.wad barn.wad
  echo.
goto end

:same
  echo.
  echo ***ERROR*** source.wad and dest.wad cannot be the same
  echo.
goto end

:mnf
rem main not found
  echo.
  echo ***ERROR*** file %1 does not exist
  echo.
goto end

:snf
rem source not found
  echo.
  echo ***ERROR*** file %2 does not exist
  echo.
goto end


:badmain
rem main.wad does not contain S2_END -- either not registered or not an IWAD
  echo.
  echo ***ERROR*** %1 is not a valid registered IWAD.
  echo.
goto end

:nosprites
rem no sprites in source.wad
  echo.
  echo ***ERROR*** no sprites found in %2.
  echo.
goto end

:extrerr1
  echo.
  echo ***ERROR*** extracting sprites from %1
  echo.
goto end

:extrerr2
  echo.
  echo ***ERROR*** extracting sprites from %2
  echo.
goto end

:comperr
  echo.
  echo ***ERROR*** compiling %3
  echo.
goto end

:end
