
// This module provides an interface to tty/vga graphics for a variety
// of real interfaces

#include <stdio.h>

#include "graphics.h"

TTY_Graphics:: TTY_Graphics() 
{
	keyboard = new TTY_Keyboard;

	lastmode=mode=TEXT25;
}

TTY_Graphics:: ~TTY_Graphics()
{
	delete keyboard;
}

int
TTY_Graphics:: ibm_charset(void)
{
	return(0);
}

void
TTY_Graphics:: flush(void)
{
	fflush(stdout);
}

void
TTY_Graphics:: setcursor(int on)
{
	if ( on == _NOCURSOR )
		printf("\033[?25l");
	else
		printf("\033[?25h");
	fflush(stdout);
}

void
TTY_Graphics:: set_default_colors(void)
{
	printf("\033[0m");
}

void
TTY_Graphics:: set_colors(int bright, int fg, int bg)
{
	printf("\033[%d;%d;%dm", bright, fg+FOREGROUND, bg+BACKGROUND);
}

void
TTY_Graphics:: clear(void)
{
	printf("\033[H\033[J");
}

void
TTY_Graphics:: clrbox(int x, int y, int width, int height)
{
	char *spaces = new char[width+1];
	int i;

	TTY_Graphics::gotoxy(x,y);
	for ( i=0; i<width; ++i )
		spaces[i] = ' ';
	spaces[i] = '\0';

	for ( i=0; i<height; ++i )
		printf("%s\033[%dD\033[B", spaces, width);
	delete[] spaces;
}

void
TTY_Graphics:: clreol(void)
{
	printf("\033[K");
}

void
TTY_Graphics:: gotoxy(int x, int y)
{
	printf("\033[%d;%dH", y, x);
}

void
TTY_Graphics:: putch(int ch)
{
	putchar(ch);
}


// Actual graphics routines.  Not available in a TTY.
int
TTY_Graphics:: has_graphics(void)
{
	return(0);
}

void
TTY_Graphics:: set_grmode(int newmode)
{
  checkmode:
	switch (newmode) {
		case TEXT25:	// Ignore text modes.
		case TEXT50:
				break;
		case GRAPHICS:	// No graphics mode in tty.
				fprintf(stderr,
			"TTY doesn't support graphics mode.\n");
				break;
		case LASTMODE:	// Switch to the previous mode.
				newmode=lastmode;
				goto checkmode;
		default:	// Huh? 
				fprintf(stderr,
			"Unknown graphics mode: %d\n", newmode);
				break;
	}
	lastmode=mode;
	mode=newmode;
}

int
TTY_Graphics:: get_grmode(void)
{
	return(mode);
}

void
TTY_Graphics:: set_colormap(struct color colormap[256])
{
	return;
}

void
TTY_Graphics:: clr_grscreen(void)
{
	return;
}

void
TTY_Graphics:: put_graphics_txt(int x, int y, char *string, 
						unsigned char color)
{
	return;
}

void
TTY_Graphics:: drawpoint(int x, int y, unsigned char color)
{
	return;
}
