
// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Updated for Linux by Sam Lantinga   (3/16/95).
// I'm hard-coding vt100 escape sequences into this module.

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>

#include "dehacked.h"
#include "linux.h"

#undef TEXT
#undef WIDTH
#undef HEIGHT
#include "ttyobj.h"

TTY console(50,80);

int IBM_CHARSET=0;


void Screen_Refresh(void)
{
	console.refresh();
}

/* Really, this should never fail.  But just in case, return an int. */
int linux_init(void)
{
	// Find out if display has ibm_charset.
	IBM_CHARSET = console.graphics->ibm_charset();

	// Set up the keyboard for raw input.
	console.keyboard->set_refresh_f(Screen_Refresh);
	tty_raw(YES);
	return(0);
}

void linux_end(void)
{
	// Fix up the keyboard.
	tty_raw(NO);
	// And the screen.
	_setcursortype(_NORMALCURSOR);
	console.graphics->set_default_colors();
}

void tty_raw(int raw)
{
	console.keyboard->raw(raw);
}

int pending_input(float do_wait)
{
	return(console.keyboard->pending_input(do_wait));
}

int getch(void)
{
	return(console.keyboard->getch());
}

void wherexy(int *x, int *y)
{
	console.curpos(x,y);
}

void gotoxy(int x, int y)
{
	console.moveto(x,y);
}

void cls(void)
{
	console.clear();
}

void clreol(void)
{
	console.clreol();
}

void clrbox(int x, int y, int width, int height)
{
	console.clrbox(x, y, width, height);
}

void textattr(int attr)
{
	console.attrib(attr);
}

void highlight_loc(int x, int y, int attr)
{
	console.highlight(x, y, attr);
}

void pokew(int x, int y, unsigned ch)
{
	console.moveto(x,y);
	console.putch(ch);
}

void putch(int c)
{
	console.putch(c);
	console.flush();
}

void cputs(char *s)
{
	int i;
	char buffer[512];

	sprintf(buffer, "%s", s);
	for ( i=0; buffer[i]; ++i )
		console.putch(buffer[i]);
	console.flush();
}

void cprintf(char *s, ...)
{
	va_list ap;
	char buffer[512];

	va_start(ap, s);
	vsprintf(buffer, s, ap);
	cputs(buffer);
	va_end(ap);
}

void gettext(int left, int top, int right, int bottom, int *buffer)
{
	console.gettext(left, top, right, bottom, (char *)buffer);
}
void puttext(int left, int top, int right, int bottom, int *buffer)
{
	console.puttext(left, top, right, bottom, (char *)buffer);
}

int stricmp(char *s1, char *s2)
{
	return(strcasecmp(s1,s2));
}

// What is this function in DOS?
int strcmpi(char *s1, char *s2)
{
	return(strcasecmp(s1, s2));
}

char *strupr(char *s)
{
	int i;
	static char buffer[512];

	for ( i=0; *s; ++s )
		buffer[i++]=toupper(*s);
	buffer[i]='\0';
	return(buffer);
}

int has_graphics(void)
{
	return(console.graphics->has_graphics());
}

void textmode(int mode)
{
	switch (mode) {
		case C80:	console.graphics->set_grmode(TEXT25);
				break;
		case C4350:	console.graphics->set_grmode(TEXT50);
				break;
	}
}

void toMCGA(void)
{
	console.graphics->set_grmode(GRAPHICS);
}

void set_colormap(struct color colormap[256])
{
	console.graphics->set_colormap(colormap);
}

void clsMCGA(void)
{
	console.graphics->clr_grscreen();
}

// Outputs a string to the MCGA screen at x,y, with a given color and
// background color.

void MCGAPutsXY (int x, int y, char *string, unsigned char color)
{
	x *= 8;
	y *= 8;
	console.graphics->put_graphics_txt(x, y, string, color);
}

void drawpoint(int x, int y, unsigned char color)
{
	console.graphics->drawpoint(x, y, color);
}
void totext(void)
{
	console.graphics->set_grmode(LASTMODE);

	/* Put the keyboard in back into raw mode -- after what?
         * (Are the tty modes reset after graphics switching?)
	 * ( -- Yup.  Who knows why?)
	 */
	tty_raw(YES);
}

void flush(void)
{
	console.flush();
}

void  _setcursortype(int type)
{
	console.graphics->setcursor(type);
}

int spawn(char *exe, char **args)
{
	char command[256];

	strcpy(command, exe);
	while ( *args ) {
		strcat(command, " ");
		strcat(command, *args);
		++args;
	}
	return(system(command));
}
