// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

#include <sys/types.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dehacked.h"
#include "print.h"
#include "linux_text.h"

#undef TEXT
#undef WIDTH
#undef HEIGHT
#include "ttyobj.h"

// Gets the frame name and puts it into string.

void Getframename(int framenum, char *string)
{
	char sprite[5];

	if (framenum == 0)
		strcpy(string, "none");
	else if (framenum > 0 && framenum <= numobj[FRAME][version]) {
		if ( Lnx_DOOM ) {
			Getspritename((int)framedata[framenum][SPRITENUM], sprite);
			sprintf(string, "%s%c", sprite, (char)(framedata[framenum][SPRITESUB] + 'A'));
		} else
			sprintf(string, "%s%c", &(textdatap[spritedata[framedata[framenum][SPRITENUM]] - toff[version]]),
										(char)(framedata[framenum][SPRITESUB] + 'A'));
	} else
		strcpy(string, "ERROR");
}

// Gets the sound name and puts it into string.

void Getsoundname(int soundnum, char *string)
{
	soundnum--;

#ifdef DEBUG
fprintf(stderr, "Looking up sound number %d..\n", soundnum);
if ( soundnum >= 0 )
	fprintf(stderr, "Offset = %ld\n", sounddata[soundnum][TEXTP]);
#endif
	if (soundnum == -1)
		strcpy(string, "none");
	else if (soundnum < 0 || soundnum > numobj[SOUND][version])
		strcpy(string, "ERROR");
	else if ( Lnx_DOOM )
		strncpy(string, lnx_strings[SOUND_NAMES].text[numobj[SOUND][version]-soundnum-1], 6);
	else if (sounddata[soundnum][TEXTP] < toff[version])
		strcpy(string, "ERROR");
	else if (sounddata[soundnum][TEXTP] > toff[version] + size[TXT][version])
		strcpy(string, "ERROR");
	else
		strncpy(string, &(textdatap[(sounddata[soundnum][TEXTP]) - toff[version]]), 6);
	string[6] = 0;
}

// Gets the sprite name and puts it into a string

void Getspritename(int spritenum, char *string)
{
	if (spritenum < 0 || spritenum > numobj[SPRITE][version])
		strcpy(string, "ERROR");
	else if ( Lnx_DOOM )
		strncpy(string, lnx_strings[SPRITE_NAMES].text[numobj[SPRITE][version]-spritenum-1], 4);
	else if (spritedata[spritenum] < toff[version])
		strcpy(string, "ERROR");
	else if (spritedata[spritenum] > toff[version] + size[TXT][version])
		strcpy(string, "ERROR");
	else
		strncpy(string, &(textdatap[spritedata[spritenum] - toff[version]]), 4);
	string[4] = 0;
}

// Gets the thing name from the array of names

void Getthingname(int thingnum, char *string)
{
	if (version == DOOM1_2)
		strcpy(string, namelist[thingconvar[thingnum]]);
	else
		strcpy(string, namelist[thingnum]);
}

// Gets a text number from a text offset
// Needs to work with Linux.  FIXME!!
int Gettextnum(int offset)
{
	int i = 0, stringlen, current = 0;

	offset -= (int)toff[version];

	while (current < offset)
	{
		stringlen = strlen(&(textdatap[current]));
		current += (stringlen & (~3)) + 4;
		i++;
	}

	return i;
}

// Turn strings certain colors if they are "none" or "ERROR".

void Highlightname(char *name)
{
	if (strcmp(name, "ERROR") == 0)
		textattr(NERROR);
	else if (strcmp(name, "none") == 0)
		textattr(NGRAY);
	else
		textattr(NORMAL);
}

// Prints the ammo screen

void Printammo(void)
{
	char order[5] = {BOB1FRAME, BOB2FRAME, BOB3FRAME, SHOOTFRAME, FIREFRAME};
	char temp[10];
	char na[9] = "N/A     ";
	int curweapon = global[AMMO_EDIT][CUR];
	int i;

	textattr(NORMAL);

	if (redraw == ALL)
	{
		Drawframe(0, NORMAL, 20, 18, 60, 32);
		CPutsXY(arrows[AMMO_EDIT][0], arrows[AMMO_EDIT][1], up_arrows[IBM_CHARSET]);
		CPutsXY(arrows[AMMO_EDIT][2], arrows[AMMO_EDIT][3], down_arrows[IBM_CHARSET]);
	}

	CPutsXY(22, 20, "Weapon number");
	CPutsXY(22, 21, "Weapon name");
	CPutsXY(22, 22, "Ammo type");


	for (i=0; i<11; i++)
	{
		textattr(NORMAL);
		switch (redraw)
		{
			case ALL:
				if (i > 2)
					CPutsXY(22, i+20, fullwepfields[i-3]);
				if (i > 5)
				{
					CPutsXY(52, i+20, "[");
					CPutsXY(58, i+20, "]");
				}
			case ALLDATA:
			case DATA:
				gotoxy(39, i+20);
				switch (i)
				{
					case 0:
						cprintf("%-2d", curweapon+1);
						break;
					case 1:
						cprintf("%-16s", weaponlist[curweapon]);
						break;
					case 2:
						if (weapondata[curweapon][AMMOTYPE] > numobj[AMMO][version]+1)
							cputs(na);
						else
							cprintf("%-9s", ammolist[weapondata[curweapon][AMMOTYPE]]);
						break;
					case 3:
						cprintf("%-11ld", weapondata[curweapon][AMMOTYPE]);
						break;
					case 4:
						if (weapondata[curweapon][AMMOTYPE] >= numobj[AMMO][version])
							cputs(na);
						else
							cprintf("%-11ld", maxammodata[weapondata[curweapon][AMMOTYPE]]);
						break;
					case 5:
						if (weapondata[curweapon][AMMOTYPE] >= numobj[AMMO][version])
							cputs(na);
						else
							cprintf("%-11ld", perammodata[weapondata[curweapon][AMMOTYPE]]);
						break;
					case 6:
					case 7:
					case 8:
					case 9:
					case 10:
						cprintf("%-11ld", weapondata[curweapon][order[i-6]]);

						Getframename((int)weapondata[curweapon][order[i-6]], temp);
						Highlightname(temp);
						CPrintfXY(53, i+20, "%-5s", temp);
				}
			case NOT:	// Don't do any redraw.
				break;
		}
	}
}

// Prints the frame screen

void Printframe(void)
{
	int i, j, current, start = 0, end = 38;
	char buffer[6];
	char xloc[6] = {22, 28, 35, 42, 52, 61};
	char pformat[6][5] = {"%5ld", "%3ld", "", "%5ld", "%8ld", "%8ld"};
	char order[6] = {SPRITENUM, SPRITESUB, SPRITESUB, NEXTFRAME, DURATION, ACTIONPTR};

	current = global[FRAME_EDIT][TOPROW];

	if (redraw == DATA)
	{
		if (current == global[FRAME_EDIT][CUR])
			end = 2;
		else if (current + 37 == global[FRAME_EDIT][CUR])
		{
			start = 35;
			current += 35;
		}
		else
		{
			start = (global[FRAME_EDIT][CUR] - current) - 1;
			end = (global[FRAME_EDIT][CUR] - current) + 2;
			current = global[FRAME_EDIT][CUR] - 1;
		}
	}

	textattr(NORMAL);

	if (redraw == ALL)
	{
		Drawframe(0, NORMAL, 4, 3, 76, 47);
						// 567890123456789012345678901234567890123456789012345678901234567890
		CPutsXY(7, 5, "Frame             Sprite   Bright   Next                  Code");
		CPutsXY(7, 6, "Number   Name     # sub#   Sprite  Frame #   Duration   Pointer");
		CPutsXY(arrows[FRAME_EDIT][0], arrows[FRAME_EDIT][1], up_arrows[IBM_CHARSET]);
		CPutsXY(arrows[FRAME_EDIT][2], arrows[FRAME_EDIT][3], down_arrows[IBM_CHARSET]);
	}

	for (i=start; i<end; current++, i++)
	{
		CPrintfXY(7, i+8, "%4d", current);

		Getframename(current, buffer);
		Highlightname(buffer);
		CPrintfXY(16, i+8, "%-5s", buffer);

		textattr(NORMAL);

		for (j=0; j<6; j++)
		{
			gotoxy(xloc[j], i+8);
			if (j == 2)
			{
				CPutsXY(35, i+8, "[ ]");
				gotoxy(36, i+8);
				if (framedata[current][SPRITESUB] & 32768L)
					putch('X');
			}
			else if (j == 1)
				cprintf(pformat[j], framedata[current][order[j]] & 255);
			else
				cprintf(pformat[j], framedata[current][order[j]]);
		}
	}
}

// Prints the help screen.

void Printhelp(void)
{
	char *keys[21] = {"Esc", "Enter", "Space", "a", "c", "g", "j",	"l", "o",
							"r", "s", "u", "w", "z", "F2", "F3", "F4", "F5", "F6",
							"F7", "F8"};
	char *effects[21] = {"quit DeHackEd",
								"edit the current field",
								"view/play the current field",
								"about DeHackEd",
								"copy from one object to another",
								"go to a specific object",
								"jump to the current item in its editor",
								"load a patch file into DeHackEd",
								"save an old-format patch file",
								"run Doom",
								"save a patch file (new text format)",
								"undo all changes--reload hacked Doom exe",
								"write current changes to hacked Doom exe",
								"zap all changes; reload original exe",
								"Thing editor",
								"Frame editor",
								"Ammo/Weapon editor",
								"Sound editor",
								"Sprite editor",
								"Text editor",
								"Thing list"};
	int i;
	int *image;

	image = new int[2170];

	if (image == NULL)
		AbortProg("in Help");

	gettext(10, 8, 71, 41, image);

	Drawframe(1, INFO, 10, 8, 70, 40);
	textattr(INFO);

	CPutsXY(35, 10, "Help Screen");
	CPutsXY(14, 12, "Refer to the DEHACKED.HLP file for general user help");
	CPutsXY(12, 13, "and complete key information.  Use arrow keys or mouse");
	CPutsXY(12, 14, "to move between fields.  The left mouse button selects,");
	CPutsXY(12, 15, "and the right mouse button is Escape.");
	CPutsXY(14, 16, "Here is a list of available keys:");

	for (i=0; i<21; i++)
		CPrintfXY(18, i+18, "%-7s- %s", keys[i], effects[i]);

	Waitforevent(YES);

	puttext(10, 8, 71, 41, image);

	delete image;
}

// Prints the intro window

void Printintro(void)
{
	int *image;
	int *image2;
	char *about[14] = {"DeHackEd 2.3",
						  "The premiere Doom exe Hack Editor",
						  "",
						  "Written by Greg Lewis (Tree)",
						  "Email: gregl@umich.edu",
						  "",
						  "Ported to Linux by Sam Lantinga",
						  "Email: slouken@cs.ucdavis.edu",
						  "",
						  "Special thanks to:",
						  "The cool guys of iD, for Doom",
						  "Matt Fell, for the Doom.exe specs",
						  "The many others who have helped",
						  "in the creation of this program!"};
	int xloc[14] = {34, 23, 1, 25, 28, 1, 23, 24, 1, 22, 24, 24, 24, 26};
	char *vers[10] = {"Doom 1 v1.2",
						  "Doom 1 v1.666",
						  "Doom 2 v1.666",
						  "Doom 2 v1.7",
						  "Doom 2 v1.7a",
						  "Doom v1.8",
						  "Doom v1.9",
						  "Linux X11 Doom v1.8",
						  "Linux SVGA Doom v1.8",
						  "User Defined"};
	char *stats[4] = {"Version:",
							"EXE name:",
							"WAD name:",
							"Patch directory:"};
	int i;

	image = new int[672];
	image2 = new int[676];

	if (image == NULL || image2 == NULL)
		AbortProg("in About");

	gettext(20, 12, 61, 30, image);
	gettext(15, 33, 66, 41, image2);

	Drawframe(1, INFO, 20, 12, 60, 29);
	Drawframe(1, INFO, 15, 33, 65, 40);
	textattr(INFO);

	for (i=0; i<14; i++)
		CPutsXY(xloc[i], i+14, about[i]);

	for (i=0; i<4; i++)
		CPutsXY(18, i+35, stats[i]);

	CPutsXY(35, 35, vers[truever]);
	CPutsXY(35, 36, doomexe);
	CPutsXY(35, 37, doomwad);
	CPutsXY(35, 38, patchdir);

	Waitforevent(YES);

	puttext(20, 12, 61, 30, image);
	puttext(15, 33, 66, 41, image2);

	delete image;
	delete image2;
}

// Prints a text intro

void Printtextintro(void)
{
	puts("\nWelcome to DeHackEd v2.3\n");
	puts("Written by Greg Lewis (\"Tree\"), gregl@umich.edu.");
	puts("Vital Doom exe specs written by Matt Fell, msfell@aol.com.");
	puts("Special thanks to iD for creating such a wonderful game!\n");
}

// Prints command line options.

void Printoptions(void)
{
	puts("\n  Here is the proper command line syntax for DeHackEd:\n");
	puts("\tdehacked [path] [-reload] [-load <patch1> ...] [-save <patch>]\n");
	puts("  path             specify a different directory for doom(2).exe");
	puts("  -reload          load original exe data into hacked exe");
	puts("  -load patch(es)  load one or more patch files into the Doom exe file.");
	puts("  -save patch      save the current Doom exe to a patch file");
}

// Prints the sound screen

void Printsound(void)
{
	int i, current = global[SOUND_EDIT][TOPROW];
	int start = 0, end = 38;
	char buffer[7];

	if (redraw == DATA)
	{
		if (current == global[SOUND_EDIT][CUR])
			end = 2;
		else if (current + 37 == global[SOUND_EDIT][CUR])
		{
			start = 35;
			current += 35;
		}
		else
		{
			start = (global[SOUND_EDIT][CUR] - current) - 1;
			end = (global[SOUND_EDIT][CUR] - current) + 2;
			current = global[SOUND_EDIT][CUR] - 1;
		}
	}

	textattr(NORMAL);

	if (redraw == ALL)
	{
		Drawframe(0, NORMAL, 16, 3, 64, 47);
		CPutsXY(19, 5, "Sound            Text");
		CPutsXY(19, 6, "Number  Name     Offset   0 / 1    \"Value\"");
		CPutsXY(arrows[SOUND_EDIT][0], arrows[SOUND_EDIT][1], up_arrows[IBM_CHARSET]);
		CPutsXY(arrows[SOUND_EDIT][2], arrows[SOUND_EDIT][3], down_arrows[IBM_CHARSET]);
	}

	for (i=start; i<end; current++, i++)
	{
		Getsoundname(current+1, buffer);
		Highlightname(buffer);
		CPrintfXY(27, i+8, "%-6s", buffer);

		textattr(NORMAL);
		CPrintfXY(19, i+8, "%4d", current+1);
		CPrintfXY(36, i+8, "%5ld", sounddata[current][TEXTP] - toff[version]);
		CPrintfXY(44, i+8, "%4ld", sounddata[current][ZERO_ONE]);
		CPrintfXY(55, i+8, "%4ld", sounddata[current][VALUE]);
	}
}

// Prints the Sprite list

void Printsprite(void)
{
	int i, current = global[SPRITE_EDIT][TOPROW];
	int start = 0, end = 38;
	char buffer[5];

	if (redraw == DATA)
	{
		if (current == global[SPRITE_EDIT][CUR])
			end = 2;
		else if (current + 37 == global[SPRITE_EDIT][CUR])
		{
			start = 35;
			current += 35;
		}
		else
		{
			start = (global[SPRITE_EDIT][CUR] - current) - 1;
			end = (global[SPRITE_EDIT][CUR] - current) + 2;
			current = global[SPRITE_EDIT][CUR] - 1;
		}
	}

	textattr(NORMAL);

	if (redraw == ALL)
	{
		Drawframe(0, NORMAL, 26, 3, 54, 47);
		CPutsXY(29, 5, "Sprite   Text    Sprite");
		CPutsXY(29, 6, "Number   Offset  Name");
		CPutsXY(arrows[SPRITE_EDIT][0], arrows[SPRITE_EDIT][1], up_arrows[IBM_CHARSET]);
		CPutsXY(arrows[SPRITE_EDIT][2], arrows[SPRITE_EDIT][3], down_arrows[IBM_CHARSET]);
	}

	for (i=start; i<end; current++, i++)
	{
		textattr(NORMAL);
		CPrintfXY(29, i+8, "%4d", current);
		CPrintfXY(38, i+8, "%5ld", spritedata[current] - toff[version]);

		Getspritename(current, buffer);
		Highlightname(buffer);
		CPrintfXY(46, i+8, "%-4s", buffer);
	}
}

// Prints the text section of doom.exe

void Printtext(void)
{
	int i, j, current = global[TEXT_EDIT][TOPROW];
	int start = 0, end = 38;
	int convcur = 0;
	int stringlen;
	char buffer[64];

	for (i=0; i<global[TEXT_EDIT][CUR]; i++)
	{
		stringlen = strlen(&(textdatap[convcur]));
		if ( Lnx_DOOM )
			convcur += stringlen + 1;
		else
			convcur += (stringlen & (~3)) + 4;
	}

	if (redraw == DATA)
	{
		if (current == global[TEXT_EDIT][CUR])
			end = 2;
		else if (current + 37 == global[TEXT_EDIT][CUR])
		{
			start = 35;
			current += 35;
		}
		else
		{
			start = (global[TEXT_EDIT][CUR] - current) - 1;
			end = (global[TEXT_EDIT][CUR] - current) + 2;
			current = global[TEXT_EDIT][CUR] - 1;
		}
	}

	current = 0;

	for (i=0; i<global[TEXT_EDIT][TOPROW]+start; i++)
	{
		stringlen = strlen(&(textdatap[current]));
		if ( Lnx_DOOM )
			current += stringlen + 1;
		else
			current += (stringlen & (~3)) + 4;
	}

	textattr(NORMAL);

	if (redraw == ALL)
	{
		Drawframe(0, NORMAL, 3, 3, 77, 47);
		CPutsXY(5, 5, "Text");
		CPutsXY(5, 6, "Offset   Text");
		CPutsXY(arrows[TEXT_EDIT][0], arrows[TEXT_EDIT][1], up_arrows[IBM_CHARSET]);
		CPutsXY(arrows[TEXT_EDIT][2], arrows[TEXT_EDIT][3], down_arrows[IBM_CHARSET]);
	}

	for (i=start; i<end; i++)
	{
		CPrintfXY(5, i+8, "%6d", current);

		strncpy(buffer, &(textdatap[current]), 59);
		if (strlen(&(textdatap[current])) > 58)
		{
			buffer[58] = 0;
			strcat(buffer, "...");
		}
		for (j=0; j<strlen(buffer); j++)
			if (buffer[j] == '\n' || buffer[j] == '\r' || buffer[j] == '\b' ||
				 buffer[j] == '\f' || buffer[j] == '\t')
				buffer[j] = '~';
		CPrintfXY(14, i+8, "%-62s", buffer);

		stringlen = strlen(&(textdatap[current]));
		if ( Lnx_DOOM )
			current += stringlen + 1;
		else
			current += (stringlen & (~3)) + 4;
	}
}

// Prints all of the Thing data in the correct places.

void Printthing(void)
{
	Printthingmisc();
	Printthingsound();
	Printthingframe();
	Printthingbits();
	Printthinginfo();
	CPutsXY(arrows[THING_EDIT][0], arrows[THING_EDIT][1], up_arrows[IBM_CHARSET]);
	CPutsXY(arrows[THING_EDIT][2], arrows[THING_EDIT][3], down_arrows[IBM_CHARSET]);
}

void Printthingbits(void)
{
						  //12345678901234567890
	char *data[32] = {"Gettable Thing",
							"Obstacle",
							"Shootable Thing",
							"Total Invisibility",
							"'Automatics'",
							"Semi-Deaf",
							"In Pain",
							"Unknown",
							"Hangs from Ceiling",
							"No Gravity",
							"Travels over Cliffs",
							"Can pick up items",
							"No Clipping",
							"Unknown",
							"Floating",
							"Semi-No Clipping",
							"Projectiles",
							"Disappearing Weapon",
							"Partial Invisibility",
							"Puffs (vs. bleeds)",
							"Sliding Helpless",
							"Unknown",
							"Counts for Kill %",
							"Counts for Item %",
							"Running",
							"Not in Deathmatch",
							"Color 1 (grey/red)",
							"Color 2 (brown/red)",
							"Unknown",
							"Unknown",
							"Unknown",
							"Unknown"};
	char brackets[4] = "[ ]";
	int i;

	if (redraw == ALL)
		Drawframe(0, NORMAL, 10, 28, 70, 47);

	for (i=0; i<16; i++)
	{
		textattr(NORMAL);
		switch (redraw)
		{
			case ALL:
				CPrintfXY(12, 30+i, "%2d", i);
				CPutsXY(19, 30+i, data[i]);
			case ALLDATA:
			case DATA:
				CPutsXY(15, 30+i, brackets);
				gotoxy(16, 30+i);
				if (thingdata[global[THING_EDIT][CUR]][BITS] & (1L << i))
					putch('X');
			case NOT:
				break;
		}
	}

	for (i=16; i<32; i++)
	{
		switch (redraw)
		{
			case ALL:
				CPrintfXY(42, 14+i, "%2d", i);
				CPutsXY(49, 14+i, data[i]);
			case ALLDATA:
			case DATA:
				CPutsXY(45, 14+i, brackets);
				gotoxy(46, 14+i);
				if (thingdata[global[THING_EDIT][CUR]][BITS] & (1L << i))
					putch('X');
			case NOT:
				break;
		}
	}
}

// Prints out the frame part of the Thing editing screen

void Printthingframe(void)
{
	char temp[6];
	int i = 25;
	int end = 8;

	if (version == DOOM1_2)
	{
		i = 24;
		end = 7;
	}

	if (redraw == ALL)
		Drawframe(0, NORMAL, 36, 14, 77, i);

	for (i=0; i<end; i++)
	{
		textattr(NORMAL);
		switch (redraw)
		{
			case ALL:
				CPutsXY(38, i+16, thingfields[thingorder[i+15]]);
				CPutsXY(69, i+16, "[");
				CPutsXY(75, i+16, "]");
			case ALLDATA:
			case DATA:
				CPrintfXY(57, i+16, "%-11ld", thingdata[global[THING_EDIT][CUR]][thingorder[i+15]]);
				textattr(NORMAL);

				Getframename((int)thingdata[global[THING_EDIT][CUR]][thingorder[i+15]], temp);
				Highlightname(temp);
				CPrintfXY(70, i+16, "%-5s", temp);
			case NOT:
				break;
		}
	}
}

// Prints out the little info part of the Thing editing screen

void Printthinginfo(void)
{
	char *info[2] = {"Thing Number:",
						  "Thing Name:"};
	int i;
	char buffer[20];

	if (redraw == ALL)
		Drawframe(0, NORMAL, 3, 3, 36, 8);
	textattr(NORMAL);

	if (redraw == ALL)
		for (i=0; i<2; i++)
			CPutsXY(5, i+5, info[i]);

	CPrintfXY(19, 5, "%-5d", global[THING_EDIT][CUR]+1);

	Getthingname(global[THING_EDIT][CUR], buffer);
	CPrintfXY(17, 6, "%-18s", buffer);
}

// Prints all the Thing info, list style

void Printthinglist(void)
{
	int i, j, current = global[THING_LIST][TOPROW];
	int start = 0, end = 38, tempspeed;
	char buffer[20];
	char xloc[4] = {32, 40, 52, 61};
	char pformat[4][5] = {"%8ld", "%8ld", "%4d", "%4ld"};
	char order[4] = {IDNUM, HP, SPEED, MISSILEDAMAGE};

	if (redraw == DATA)
	{
		if (current == global[THING_LIST][CUR])
			end = 2;
		else if (current + 37 == global[THING_LIST][CUR])
		{
			start = 35;
			current += 35;
		}
		else
		{
			start = (global[THING_LIST][CUR] - current) - 1;
			end = (global[THING_LIST][CUR] - current) + 2;
			current = global[THING_LIST][CUR] - 1;
		}
	}

	textattr(NORMAL);

	if (redraw == ALL)
	{
		Drawframe(0, NORMAL, 4, 3, 76, 47);
						// 7890123456789012345678901234567890123456789012345678901234567890
		CPutsXY(7, 5, "Thing                      Thing     Hit             Missile");
		CPutsXY(7, 6, "Number  Name               ID #     Points   Speed   Damage");
		CPutsXY(arrows[THING_LIST][0], arrows[THING_LIST][1], up_arrows[IBM_CHARSET]);
		CPutsXY(arrows[THING_LIST][2], arrows[THING_LIST][3], down_arrows[IBM_CHARSET]);
	}

	for (i=start; i<end; current++, i++)
	{
		textattr(NORMAL);
		CPrintfXY(7, i+8, "%4d", current+1);

		Getthingname(current, buffer);
		CPrintfXY(14, i+8, "%-19s", buffer);

		textattr(NORMAL);

		for (j=0; j<4; j++)
		{
			gotoxy(xloc[j], i+8);
			if (j == 2)
			{
				if ((current == 0) || !(thingdata[current][BITS] & 65536L))
					tempspeed = (int)thingdata[current][SPEED];
				else
					tempspeed = (int)(thingdata[current][SPEED] >> 16);
				cprintf(pformat[j], tempspeed);
			}
			else
				cprintf(pformat[j], thingdata[current][order[j]]);
		}
	}

}

// Prints out the miscellaneous part of the Thing editing screen

void Printthingmisc(void)
{
	int i;

	if (redraw == ALL)
		Drawframe(0, NORMAL, 3, 12, 33, 25);

	for (i=0; i<10; i++)
	{
		textattr(NORMAL);
		switch (redraw)
		{
			case ALL:
				CPutsXY(6, i+14, thingfields[thingorder[i]]);
			case ALLDATA:
			case DATA:
				gotoxy(21, i+14);
				if (thingorder[i] == CWIDTH || thingorder[i] == CHEIGHT ||
					((thingorder[i] == SPEED) &&
					((global[THING_EDIT][CUR] != 0) && 
					(thingdata[global[THING_EDIT][CUR]][BITS] & 1024L))))
					cprintf("%-11ld", thingdata[global[THING_EDIT][CUR]][thingorder[i]] >> 16);
				else
					cprintf("%-11ld", thingdata[global[THING_EDIT][CUR]][thingorder[i]]);
			case NOT:
				break;
		}
	}
}

// Prints out the sound portion of the Thing editing screen

void Printthingsound(void)
{
	char temp[7];
	int i;

	if (redraw == ALL)
		Drawframe(0, NORMAL, 39, 3, 77, 11);

	for (i=0; i<5; i++)
	{
		textattr(NORMAL);
		switch (redraw)
		{
			case ALL:
				CPutsXY(41, i+5, thingfields[thingorder[i+10]]);
				CPutsXY(68, i+5, "[");
				CPutsXY(75, i+5, "]");
			case ALLDATA:
			case DATA:
				CPrintfXY(56, i+5, "%-11ld", thingdata[global[THING_EDIT][CUR]][thingorder[i+10]]);
				textattr(NORMAL);

				Getsoundname((int)thingdata[global[THING_EDIT][CUR]][thingorder[i+10]], temp);
				Highlightname(temp);
				CPrintfXY(69, i+5, "%-6s", temp);
			case NOT:
				break;
		}
	}
}

// Prints a message, color is dependant on content.

EBool Printwindow(char *message, int type)
{
	int *image;
	int x1, x2;
	int c;
	EBool escape = NO;

	if (batch == YES)
	{
		puts(message);
		return NO;
	}

	x1 = 40 - (4+strlen(message))/2;
	x2 = 40 + (4+strlen(message))/2;

	// If x1 is < 1, x2 must be greater than 80.
	if (x1 < 1)
	{
		x1 = 1;
		x2 = 80;
	}

	// Just get the whole screen (horiz) since we don't wanna bother
	// figuring out how much exactly to do.
	image = new int[480];

	if (image == NULL)
		AbortProg("in Printwindow");

	gettext(1, 23, 80, 28, image);

	Drawframe(1, type, x1, 23, x2, 27);
	textattr(type);

	CPutsXY(x1+2, 25, message);

	if (Waitforevent(NO)) {
		if ( (c=getch()) == 0 )
			getch();
		else if ( c == ESC )
			escape=YES;
	}

	puttext(1, 23, 80, 28, image);

	delete image;

	return escape;
}
