
// Nice to use C++ for object orientedness for once. ;)
// 
// A class describing and giving access to a frame-buffered screen. :)
//
//	-Sam Lantinga		3/18/95

#include "graphics.h"

class TTY {

public:
	TTY(int lines, int cols);
	~TTY();
	void moveto(int x, int y);
	void curpos(int *x, int *y);
	void clear(void);
	void refresh(void);
	void clrbox(int x, int y, int width, int height);
	void clreol(void);
	void putch(char ch);
	void attrib(int attr);
	void gettext(int left, int top, int right, int bottom, char *buffer);
	void puttext(int left, int top, int right, int bottom, char *buffer);
	void highlight(int x, int y, int attr);
	void flush(void);

	TTY_Graphics *graphics;
	TTY_Keyboard *keyboard;

private:
	char **memory;
	char currattr;
	int curx, cury;
	int oldx, oldy;
	int maxx, maxy;

#ifdef NOT_FINISHED
	void scroll(void);
#endif
};
