;---------------------------------------------------------------------------
;
; DKS   v0.50  7/21/95  Instant 180-degree Keyboard Turns in DOOM
;                       Gary Gesmundo        
;                       Phil Pattengale - philpatt@tgsbbs.org
; 
; Based upon DMS v0.15  - Modifications made by Lincoln Yeoh
; Based upon DMS v0.12  - (c) Tom Klok and Dave 'Zoid' Kirsch  August, 1994
;    Contact Tom Klok:           a344@mindlink.bc.ca, tom@auggy.mlnet.com
;    Contact Dave 'Zoid' Kirsch: zoid@mindlink.bc.ca, zoid@grog.mlnet.com
;
;   Freely distributable as long as copyright and attributions
;   are maintained.
;
;---------------------------------------------------------------------------

		.286

bk              equ     8
ht              equ     9
lf              equ     10
ff              equ     12
cr              equ     13
eof             equ     26
eos             equ     '$'

mouse_vector    equ     033h
_mickeys        equ     0000Bh
_query          equ     0DEADh
chk_response    equ     0D00Dh
chk_version     equ     0012Ah

dos_vector      equ     021h
_outstr         equ     00900h
_getvec         equ     03500h + mouse_vector
_setvec         equ     02500h + mouse_vector
_tsr            equ     03100h
_free           equ     04900h
_exit           equ     04C00h
_exit1          equ     _exit + 1

env_offset      equ     0002ch
tail_buff       equ     00081h

turn_180        equ     2925            ; was 2875 almost!
					; was 2850 short barely
					; was 2645 short
					; was 2615 short
					; was 3926 too much
					
msdos           macro   name, val
		ifdef   &name
		mov     ax, &name
		ifdef   &val
		mov     dx, offset &val
		endif
		endif
		int     dos_vector
		endm

;---------------------------------------------------------------------------

code_seg        segment public
		assume  cs:code_seg, ds:nothing, es:nothing
		org     00100h

dks:            jmp     install

;---------------------------------------------------------------------------

		align   4
old_vector:     db      'oldv'
newmickeysx     dw      0               

;DON'T CHANGE ORDER OF FOLLOWING LINES OR INSERT ANYTHING IN BETWEEN

button          db      0
flipkeydwn      db      52              ;Default set to .
flipkeyup       db      52+128
keypressed      db      0
;---------------------------------------------------------------------------

dks_proc:
		cmp     ax, _mickeys            ; Is this a get mickeys call?
		jne     NotGetMickeys           ; Nope - check for key change
		jmp     getmickeys              ; yup - jump to our code.

NotGetMickeys:
		cmp     ax, _query              ; installation check?
		jne     old_handler             ; Nope, pass on to Mouse Drvr
		mov     ax, chk_response        ; Else, yes, we're here!
		mov     bx, chk_version
		mov     di, offset button
		iret

old_handler:
		jmp     dword ptr cs:[old_vector]


getmickeys:     ; Our "getmickeys" code

		in      al,060h                 ; get a key from port A
		push    ax                      ; store ax
		in      al,061h                 ; get value from port B
		or      al,0f0h                 ; set bit 7
		out     061h,al                 ; store back to port B
		and     al,07Fh                 ; clear bit 7
		out     061h,al                 ; store back to port B
		pop     ax                      ; get original key again
		cmp     al,flipkeydwn           ; is the flipkey down?
		jne     notit                   
		cmp     cs:[keypressed], 0      ; Still or a new keypress?
		jnz     Flipit                  ; If key hasn't been lifted since 
						; the last flip, don't keep flipping!
		
		mov     cs:[newmickeysx], turn_180 ; set up the newmickeysx
		inc     cs:[keypressed]          ; Set Keypressed as on
		jmp     Flipit
notit:
		cmp     al,flipkeyup            ; Flip Key released?
		jne     Flipit                  
		mov     cs:[keypressed], 0       ; clear keypressed

Flipit:
		;pushf
		;call    dword ptr cs:[old_vector]       
		;popf
		xor     cx,cx                   ; clear mickeys-x
		xor     dx,dx                   ; clear mickeys-y
		add     cx, cs:[newmickeysx]    ; zoot!  do the turn
		mov     cs:[newmickeysx], 0     ; clear newmickeys again.
			    
doiret:         iret

end_of_tsr:

;---------------------------------------------------------------------------

ttl:            db      "DKS v0.50 (c) 07/21/95 - Phil Pattengale & Gary Gesmundo",cr,lf
		db      "DMS v0.13      06/19/95 - Lincoln Yeoh - keyboard support added",cr,lf
		db      "DMS v0.12 (c) 08/??/94 - Tom Klok/Dave 'Zoid' Kirsch",cr,lf,cr,lf
		db      "Freely distributable.  ",cr,lf
		db      "Queries or comments to philpatt@tgsbbs.org",cr,lf,eos
keypls:         db      cr,lf,"Please press your 180-flip key or press Esc for the default '.' "
		db      cr,lf,eos
keynotok:       db      "Sorry, extended keys not supported!",cr,lf,eos
keyset:         db      "Alright! Let's get going!",cr,lf,eos
welcome:        db      ': installed!',cr,lf,eos
crlfeos         db      cr,lf,eos
		db      cr,lf,eos

;---------------------------------------------------------------------------

install:
		msdos   _outstr, ttl

moreinstall:
		msdos   _outstr, keypls
waitup:
		in      al,060h
		cmp     al,128
		jb     waitup
		cmp     al,224
		je      waitk
waitdwn:
		in      al,060h
		cmp     al,224
		je      waitk
		cmp     al,128
		jnb     waitdwn
		jmp     keyok
waitk:
		in      al,060h
		cmp     al,224
		je      waitk
		msdos   _outstr, keynotok
		jmp     moreinstall
keyok:
		cmp     al,1
		je      waitup2
		mov     cs:[flipkeydwn],al
		add     al,128
		mov     cs:[flipkeyup],al
waitup2:
		in      al,060h
		cmp     al,128
		jb     waitup2
		msdos   _outstr, keyset

		mov     ax, _query
		int     mouse_vector
		cmp     ax, chk_response
		je      change_button
		
		msdos   _outstr, welcome
		msdos   _getvec                 ; es:bx <- int 33h pointer
		mov     word ptr [old_vector], bx
		mov     word ptr [old_vector + 2], es
		msdos   _setvec, dks_proc       ; int 33h pointer <- ds:dx
		mov     ax, ds:[env_offset]     ; get envt segment
		mov     es, ax
		msdos   _free
		mov     dx, offset end_of_tsr
		add     dx, 15
		shr     dx, 4
		msdos   _tsr

change_button:
		push    di
		msdos   _getvec                 ; es:bx <- int 33h pointer
		mov     al, cs:[button]
		pop     di
		mov     es:[di], al
		mov     al, cs:[flipkeydwn]
		mov     es:[di+1], al
		mov     al, cs:[flipkeyup]
		mov     es:[di+2], al
		msdos   _exit1



;---------------------------------------------------------------------------

code_seg        ends
		end     dks

