/*
 * Config file for various tings
 * $Id: config.h,v 1.3 1996/04/23 01:55:54 toor Exp $
 * $Log: config.h,v $
 * Revision 1.3  1996/04/23 01:55:54  toor
 * Fixed up so that it works on sparcstations.
 *
 * Revision 1.2  1996/04/22 07:28:09  toor
 * Corrected error in conv routines.
 *
 * Revision 1.1  1996/04/22 06:10:43  toor
 * Initial revision
 *
 */
/*
Copyright (C) 1996 Stephen Hocking.
All Rights Reserved.

Permission to use, copy, modify and distribute this software
for any purpose is hereby granted without fee, provided that the
above copyright notice and this notice appear in all copies
and that both the copyright notice and this notice appear in
supporting documentation.  Stephen Hocking makes no representations about
the suitability of this software for any purpose.  It is provided
"AS IS" without express or implied warranty.

STEPHEN HOCKING DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL SCO BE LIABLE FOR ANY SPECIAL, INDIRECT,
PUNITIVE, CONSEQUENTIAL OR INCIDENTAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, LOSS OF DATA OR LOSS OF
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

"DOOM" is a trademark of iD Software Inc. 
*/
/*
 * Converting between host & wad byte order.
 */

static int      endianData = 1;
#define littleEndian ((*(char *)(&endianData)) == 1)

static unsigned short 
wtohs(unsigned short d)
{
	if (littleEndian)
		return d;
	else
		return ((d & 0xff) << 8) | ((d & 0xff00) >> 8);
}
static unsigned int 
wtohl(unsigned long d)
{
	unsigned long   a, b;

	if (littleEndian)
		return d;
	else
	{
		a = (d & 0xffff);
		a = wtohs((unsigned short) a);
		a <<= 16;
		b = (d & 0xffff0000) >> 16;
		b = wtohs((unsigned short) b);
		return a | b;
	}
}



#define htows(x)	wtohs(x)
#define htowl(x)	wtohl(x)

/*
 * offsets in the wad file for important things
 */

char           *wadbase;	/* the pointer used to map the wad in memory */
long            dir_offset;	/* set this to wadbase + DIR_OFFSET */

#define NUMLUMPS	wtohl(*((int *)(wadbase + 4)))
#define DIR_OFFSET	wtohl(*((int *)(wadbase + 8)))

/*
 * picking apart directory entries
 */

#define	DIR_ITEM_OFFSET(i)	\
	wtohl((*(unsigned int *)(dir_offset + (i * 16))))
#define	DIR_ITEM_SIZE(i)	\
	wtohl((*(unsigned int *)(dir_offset + 4 + (i * 16))))
#define	DIR_ITEM_NAME(i)	\
	((char *)(dir_offset + 8 + (i * 16)))


/*
 * Sound data lumps at offset i
 */

#define SOUND_NUM_SAMPLES(i)	wtohs((unsigned short)*((unsigned short *)(wadbase + (i) + 4)))
#define SOUND_DATA(i)		(wadbase + (i) + 8)

#include <audio/audiolib.h>
#include <audio/soundlib.h>

#if defined(USE_VOXWARE)
#if defined(__FreeBSD__)
#include <machine/soundcard.h>
#else
#include <sys/soundcard.h>
#endif
#endif
