
proc get_commands {fd} {
    upvar #0 get_commands_buffer($fd) buf

    if {![info exists buf]} {set buf ""}
    set data [read $fd]

    if {$data == ""} {
	if {[info commands eof_handler] != ""} {
	    eof_handler $fd
	    return
	}
	error "EOF: $fd"
    }
    set buf "$buf$data"
    set commands [split $buf "\n"]
    set n_commands [llength $commands]
    if {$n_commands <= 1} {return ""}

    set buf [lindex $commands end]
    set commands [lrange $commands 0 [expr $n_commands-2]]
    return $commands
}

proc eval_commands {fd} {
    global message_pipe errorInfo errorCode

    set message_pipe $fd
    set commands [get_commands $fd]
    set errors ""

    foreach cmd $commands {
	if {[catch {uplevel #0 $cmd} status] != 0} {
	    lappend errors [list $status $errorInfo $errorCode]
	}
    }
    foreach error $errors {
	after 1 "error $error"
    }
}

### Retry write command ###

proc puts_retry {args} {
    global errorCode

    set timeout 10
    set newline 1
    set option [lindex $args 0]

    if {$option == "-nonewline"} {
	set newline 0
	set args [lrange $args 1 end]
    }

    if {[llength $args] != 2} {
	error "wrong # args: should be \"puts_retry ?-nonewline? fd message\""
    }

    set fd [lindex $args 0]
    set message [lindex $args 1]
    if {$newline} {
	set message "$message\n"
    }
    set length [string length $message]

    set eagain 0
    while {1} {
	if {[catch {write $fd $message} retval] != 0} {
	    set error [lindex $errorCode 1]
	    if {$error != "EAGAIN" || $eagain >= $timeout} {
		error $retval
	    }
	    incr eagain
	} else {
	    if {$retval == $length} {
		break
	    }
	    set message [string range $message $retval end]
	    incr length -$retval
	}
	sleep 1
    }
}

proc pipe_exec {args} {
    pipe local remote
    dup $remote file61
    close $remote
    set remote file61

    fcntl $local NONBLOCK 1
    fcntl $remote NONBLOCK 1
    fileevent $local readable "eval_commands $local"

    regsub file $remote {} remotefd

    if {[catch \
	   {eval exec $args -pipe $remotefd &} status] != 0} {
	close $local
	close $remote
	error $status
    }
    close $remote
    return $local
}
