/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 D_WADS.H

*/

#ifndef _D_WADS_H_
#define _D_WADS_H_

/* global variables */
extern WadPtr  WadFileList;      /* linked list of wad files */
extern MDirPtr MasterDir;        /* the master directory */

/* prototypes */
void OpenMainWad(char *filename);
void OpenPatchWad(char *filename);
void CloseWadFiles(void);
void CloseUnusedWadFiles(void);

WadPtr BasicWadOpen(char *filename);
void BasicWadRead(WadPtr wadfile, void huge *addr, long size);
void BasicWadSeek(WadPtr wadfile, long offset);

MDirPtr FindMasterDir(MDirPtr from, char *name);
void ListMasterDirectory(FILE *file);
void ListFileDirectory(FILE *file, WadPtr wad);
void BuildNewMainWad(char *filename, Bool patchonly);

void WriteBytes(FILE *file, void huge *addr, long size);
void CopyBytes(FILE *dest, FILE *source, long size);

void DumpDirectoryEntry(FILE *file, char *entryname);
void SaveDirectoryEntry(FILE *file, char *entryname);
void SaveEntryToRawFile(FILE *file, char *entryname);
void SaveEntryFromRawFile(FILE *file, FILE *raw, char *entryname);

#ifdef FAT_ENDIAN
UInt16 SwapInt16(UInt16 x);
UInt32 SwapInt32(UInt32 x);
void WadReadInt16(WadPtr wadfile, UInt16 huge *x);
void WadReadInt32(WadPtr wadfile, UInt32 huge *x);
void WriteInt16(FILE *file, UInt16 huge *x);
void WriteInt32(FILE *file, UInt32 huge *x);

#else
#define SwapInt16(x)          (x)
#define SwapInt32(x)          (x)
#define WadReadInt16(w, p)    BasicWadRead((w), (p), 2L)
#define WadReadInt32(w, p)    BasicWadRead((w), (p), 4L)
#define WriteInt16(f, p)      WriteBytes((f), (p), 2L)
#define WriteInt32(f, p)      WriteBytes((f), (p), 4L)
#endif /* FAT_ENDIAN */

#endif /* _D_WADS_H_ */

/* end of file */
