/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  Contact :                Hartmut Schirmer
 *                           Feldstrasse 118
 *                    D-2300 Kiel 1
 *                           Germany
 *
 *                    No telephone calls please !
 *
 *           NOTE : Please use ZIP 24105 after July 1 1993 !!
 *
 */
#ifndef __BCCGRX_H
#define __BCCGRX_H

#ifndef TRUE
#  define TRUE (1==1)
#endif
#ifndef FALSE
#  define FALSE (1==0)
#endif

#define grOk                0
#define grNoInitGraph      -1
#define grNotDetected      -2
#define grFileNotFound     -3
#define grInvalidDriver    -4
#define grNoLoadMem        -5
#define grNoScanMem        -6
#define grNoFloodMem       -7
#define grFontNotFound     -8
#define grNoFontMem        -9
#define grInvalidMode      -10
#define grError            -11
#define grIOerror          -12
#define grInvalidFont      -13
#define grInvalidFontNum   -14
#define grInvalidVersion   -18

#define DETECT             (-2)
#define NATIVE_GRX         (-3)
#define CURRENT_DRIVER     (-1)
#define VGA                GR_VGA
#define EGA                GR_EGA
#define IBM8514            GR_8514A
#define HERCMONO           GR_HERC

#define EGA64              10
#define EGAMONO            11
#define CGA                12
#define MCGA               13
#define ATT400             14
#define PC3270             15

#define VGALO              0
#define VGAMED             1
#define VGAHI              2
#define IBM8514LO          0
#define IBM8514HI          1
#define HERCMONOHI         0
#define CGAC0              0
#define CGAC1              1
#define CGAC2              2
#define CGAC3              3
#define CGAHI              4
#define MCGAC0             CGAC0
#define MCGAC1             CGAC1
#define MCGAC2             CGAC2
#define MCGAC3             CGAC3
#define MCGAMED            CGAHI
#define MCGAHI             5
#define ATT400C0           MCGAC0
#define ATT400C1           MCGAC1
#define ATT400C2           MCGAC2
#define ATT400C3           MCGAC3
#define ATT400MED          MCGAMED
#define ATT400HI           MCGAHI
#define EGA64LO            0
#define EGA64HI            1
#define EGALO              0
#define EGAHI              1
#define EGAMONOHI          0
#define PC3270HI           0

/* NATIVE_GRX modes : */
#define GRX_DEFAULT_GRAPHICS                0
#define GRX_BIGGEST_NONINTERLACED_GRAPHICS  1
#define GRX_BIGGEST_GRAPHICS                2
#define GRX_BGI_EMULATION                   3
#define __FIRST_DRIVER_SPECIFIC_MODE        4


#ifndef LIGHTMAGENTA
#define BLACK         GrBlack()
#define BLUE          1
#define GREEN         2
#define CYAN          3
#define RED           4
#define MAGENTA       5
#define BROWN         6
#define LIGHTGRAY     7
#define DARKGRAY      8
#define LIGHTBLUE     9
#define LIGHTGREEN   10
#define LIGHTCYAN    11
#define LIGHTRED     12
#define LIGHTMAGENTA 13
#define YELLOW       14
#define WHITE        GrWhite()
#endif

#define EGA_BLACK 0
#define EGA_BLUE 1
#define EGA_GREEN 2
#define EGA_CYAN 3
#define EGA_RED 4
#define EGA_MAGENTA 5
#define EGA_BROWN 20
#define EGA_LIGHTGRAY 7
#define EGA_DARKGRAY 56
#define EGA_LIGHTBLUE 57
#define EGA_LIGHTGREEN 58
#define EGA_LIGHTCYAN 59
#define EGA_LIGHTRED 60
#define EGA_LIGHTMAGENTA 61
#define EGA_YELLOW 62
#define EGA_WHITE 63

#define SOLID_LINE   0
#define DOTTED_LINE  1
#define CENTER_LINE  2
#define DASHED_LINE  3
#define USERBIT_LINE 4

#define NORM_WIDTH   1
#define THICK_WIDTH  3

#define DEFAULT_FONT      0    /* 8x8 bit mapped font */
#define TRIPLEX_FONT      1
#define SMALL_FONT        2
#define SANS_SERIF_FONT   3
#define GOTHIC_FONT       4
#define SCRIPT_FONT       5
#define SIMPLEX_FONT      6
#define TRIPLEX_SCR_FONT  7
#define COMPLEX_FONT      8
#define EUROPEAN_FONT     9
#define BOLD_FONT         10

#define HORIZ_DIR   0       /* left to right */
#define VERT_DIR    1       /* bottom to top */

#define USER_CHAR_SIZE  0   /* user-defined char size */

enum fill_patterns {        /* Fill patterns for get/setfillstyle */
    EMPTY_FILL,     /* fills area in background color */
    SOLID_FILL,     /* fills area in solid fill color */
    LINE_FILL,      /* --- fill */
    LTSLASH_FILL,       /* /// fill */
    SLASH_FILL,     /* /// fill with thick lines */
    BKSLASH_FILL,       /* \\\ fill with thick lines */
    LTBKSLASH_FILL,     /* \\\ fill */
    HATCH_FILL,     /* light hatch fill */
    XHATCH_FILL,        /* heavy cross hatch fill */
    INTERLEAVE_FILL,    /* interleaving line fill */
    WIDE_DOT_FILL,      /* Widely spaced dot fill */
    CLOSE_DOT_FILL,     /* Closely spaced dot fill */
    USER_FILL       /* user defined fill */
};

#define COPY_PUT GrWRITE
#define XOR_PUT  GrXOR
#define OR_PUT   GrOR
#define AND_PUT  GrAND
/*      NOT_PUT  not available */

#define LEFT_TEXT   0
#define CENTER_TEXT 1
#define RIGHT_TEXT  2
#define BOTTOM_TEXT 0
#define TOP_TEXT    2

#define MAXCOLORS 15

struct palettetype {
    unsigned char size;
      signed char colors[MAXCOLORS+1];
};

struct linesettingstype {
    int            linestyle;
    unsigned short upattern;    /* Note : BCC defines unsigned ! */
    int            thickness;
};

struct textsettingstype {
    int font;
    int direction;
    int charsize;
    int horiz;
    int vert;
};

struct fillsettingstype {
    int pattern;
    int color;
};

/* This definition is compatible with the grx
   definition 'int pts[][2]' used to define polygons */
struct pointtype {
    int x, y;
};

struct viewporttype {
    int left, top, right, bottom;
    int clip;
};

struct arccoordstype {
    int x, y;
    int xstart, ystart, xend, yend;
};


extern int           __gr_Mode;
extern int           __gr_INIT;
extern int           __gr_MaxMode;
extern int           __gr_Result;
extern int           __gr_X, __gr_Y;            /* graphics cursor pos */
extern int           __gr_vpl, __gr_vpt,        /* actual viewport     */
		     __gr_vpr, __gr_vpb;
extern int           __gr_color;                /* drawing color       */
extern int           __gr_colorbg;              /* background color    */
extern int           __gr_colorfill;            /* fill color          */
extern int           __gr_WR;                   /* Write mode          */
extern int           __gr_Xasp;                 /* Aspect ratio        */
extern int           __gr_Yasp;
extern GrPattern     __gr_fillpattern;
extern int           __gr_fpatno;
extern int           __gr_lstyle;
extern int           __gr_clip;                 /* actual clipping state    */
extern int           __gr_ADAPTER;              /* Adapter used             */
extern char          __gr_fpatterns[][8];
extern struct palettetype __gr_EGAdef;
extern int           __gr_BGI_w;                /* Width, height and color  */
extern int           __gr_BGI_h;                /* used in                  */
extern int           __gr_BGI_c;                /* GRX_BGI_EMULATION mode   */
extern int           _bold_font, _euro_font,    /* Linkable font files      */
		     _goth_font, _lcom_font,
		     _litt_font, _sans_font,
		     _scri_font, _simp_font,
		     _trip_font, _tscr_font;

#ifdef __cplusplus
extern "C" {
#endif

void     __gr_set_up_modes(void);
void     __gr_drawpoly(int numpoints, void *polypoints, int close);
void     set_BGI_mode(int *graphdriver, int *graphmode);

void     detectgraph(int *graphdriver,int *graphmode);
void     initgraph(int *graphdriver, int *graphmode, char *pathtodriver);
void     setgraphmode(int mode);
char    *getmodename( int mode_number );
void     graphdefaults(void);
char    *getdrivername( void );
char    *grapherrormsg(int errorcode);
void     getviewsettings(struct viewporttype  *viewport);
void     setviewport(int left, int top, int right, int bottom, int clip);
void     getlinesettings(struct linesettingstype  *lineinfo);
void     setlinestyle(int linestyle, unsigned upattern, int thickness);
void     clearviewport(void);
void     bar(int left, int top, int right, int bottom);
void     bar3d(int left,int top,int right,int bottom,int depth, int topflag);
void     rectangle(int left, int top, int right, int bottom);
void     fillpoly(int numpoints, void *polypoints);
void     sector(int x,int y,int stangle,int endangle,int xradius,int yradius);
void     circle(int x, int y, int radius);
void     ellipse(int x,int y,int stangle,int endangle,int xradius,int yradius);
void     fillellipse( int x, int y, int xradius, int yradius );
void     getarccoords(struct arccoordstype  *arccoords);
void     floodfill(int x, int y, int border);
void     line(int x1, int y1, int x2, int y2);
void     setfillpattern( char  *upattern, int color);
void     setfillstyle(int pattern, int color);
void     getimage(int left, int top, int right, int bottom, void  *bitmap);
void     putimage(int left, int top,  void  *bitmap, int op);
unsigned imagesize(int left, int top, int right, int bottom);
void     gettextsettings(struct textsettingstype  *texttypeinfo);
void     settextjustify(int horiz, int vert);
void     settextstyle(int font, int direction, int charsize);
void     setrgbpalette(int color, int red, int green, int blue);
void     setusercharsize(int multx, int divx, int multy, int divy);
void     outtext(char *textstring);
void     outtextxy(int x, int y, char *textstring);
int      textheight( char *textstring);
int      textwidth( char  *textstring);

int      registerbgifont(void *font);
int      installuserfont(char *name);

void     getpalette(struct palettetype  *palette);
void     setallpalette( struct palettetype  *palette);
void     setpalette(int colornum, int color);

#ifdef __cplusplus
}
#endif

#define __ABS(a) (a<0 ? -a : a)
#define __INL__ __inline__ static
#define YR(r)  ((r)*__gr_Xasp/__gr_Yasp)
#define XR(r)  (r)

/* ----------------------------------------------------------------- */
__INL__ void restorecrtmode(void)
{
  GrSetMode(GR_default_text);
}

/* ----------------------------------------------------------------- */
__INL__ void closegraph(void)
{
  restorecrtmode();
  __gr_INIT = FALSE;
}

/* ----------------------------------------------------------------- */
__INL__ int getgraphmode(void)
{
  return (__gr_INIT ? __gr_Mode : (__gr_Result=grNoInitGraph));
}

/* ----------------------------------------------------------------- */
__INL__ int getmaxmode(void)
{
  __gr_set_up_modes();
  return __gr_MaxMode;
}

/* ----------------------------------------------------------------- */
__INL__ void getmoderange(int gd, int *lomode, int *himode)
{
  *lomode = 0;
  *himode = getmaxmode();
}

/* ----------------------------------------------------------------- */
__INL__ int graphresult(void) {
  int res = (__gr_INIT ? __gr_Result : grNoInitGraph);
  __gr_Result = grOk;
  return res;
}

/* ----------------------------------------------------------------- */
__INL__ void moveto(int x, int y) {
  __gr_X = x; __gr_Y = y;
}

/* ----------------------------------------------------------------- */
__INL__ void moverel(int dx, int dy) {
  moveto( __gr_X + dx, __gr_Y + dy);
}

/* ----------------------------------------------------------------- */
__INL__ void cleardevice(void) {
  if (__gr_INIT) {
    GrClearScreen(__gr_colorbg);
    moveto( 0, 0);
  } else
    __gr_Result = grNoInitGraph;
}

/* ----------------------------------------------------------------- */
__INL__ int getmaxcolor(void) {
  if (__gr_INIT) return GrNumColors()-1;
  __gr_Result = grNoInitGraph;
  return 0;
}

/* ----------------------------------------------------------------- */
__INL__ int getbkcolor(void) {
  return __gr_colorbg;
}

/* ----------------------------------------------------------------- */
__INL__ int getcolor(void) {
  return __gr_color;
}

/* ----------------------------------------------------------------- */
__INL__ void setbkcolor(int color) {
  __gr_colorbg= color;
}

/* ----------------------------------------------------------------- */
__INL__ void setcolor(int color) {
  __gr_color= color;
}

/* ----------------------------------------------------------------- */
__INL__ void setwritemode( int mode ) {
  __gr_WR = (mode & (GrXOR | GrOR | GrAND));
}

/* ----------------------------------------------------------------- */
__INL__ int getx(void) {
  return __gr_X;
}

/* ----------------------------------------------------------------- */
__INL__ int gety(void) {
  return __gr_Y;
}

/* ----------------------------------------------------------------- */
__INL__ int getmaxx(void) {
  return GrScreenX()-1;
}

/* ----------------------------------------------------------------- */
__INL__ int getmaxy(void) {
  return GrScreenY()-1;
}

/* ----------------------------------------------------------------- */
__INL__ unsigned getpixel(int x, int y) {
  if (__gr_INIT) return GrPixel(__gr_vpl+x,__gr_vpt+y);
  __gr_Result = grNoInitGraph;
  return 0;
}

/* ----------------------------------------------------------------- */
__INL__ void putpixel(int x, int y, int color) {
  if (__gr_INIT) GrPlot( __gr_vpl+x, __gr_vpt+y, color);
	    else __gr_Result = grNoInitGraph;
}

/* ----------------------------------------------------------------- */
__INL__ void linerel(int dx, int dy) {
  line(__gr_X, __gr_Y, __gr_X+dx, __gr_Y+dy);
}

/* ----------------------------------------------------------------- */
__INL__ void lineto(int x, int y) {
  line( __gr_X, __gr_Y, x, y);
}

/* ----------------------------------------------------------------- */
__INL__ void  drawpoly(int numpoints, void *polypoints) {
  __gr_drawpoly(numpoints, polypoints, FALSE);
}

/* ----------------------------------------------------------------- */
__INL__ void  arc(int x, int y, int stangle, int endangle, int radius) {
  ellipse(x,y,stangle,endangle,radius,radius);
}

/* ----------------------------------------------------------------- */
#ifdef _TP2BCC_
#  define getaspectratio(xa,ya) ({*(xa)=__gr_Xasp; *(ya)=__gr_Yasp; })
#else
__INL__ void getaspectratio(int *xasp, int *yasp) {
   *xasp = __gr_Xasp; *yasp = __gr_Yasp;
}
#endif

/* ----------------------------------------------------------------- */
__INL__ void setaspectratio( int xasp, int yasp ) {
  __gr_Xasp = xasp; __gr_Yasp = yasp;
}

/* ----------------------------------------------------------------- */
__INL__ void getfillsettings(struct fillsettingstype  *fillinfo) {
  fillinfo->pattern = __gr_fpatno;
  fillinfo->color   = __gr_colorfill;
}

/* ----------------------------------------------------------------- */
__INL__ void getfillpattern(char *pattern) {
  memcpy(pattern, &__gr_fpatterns[USER_FILL], 8);
}

/* ----------------------------------------------------------------- */
__INL__ void pieslice(int x, int y, int stangle, int endangle, int radius) {
  sector(x,y,stangle,endangle,radius,radius);
}

/* ----------------------------------------------------------------- */
__INL__ unsigned setgraphbufsize(unsigned bufsize) {
  return 4096; /* BCC default value */
}

/* ----------------------------------------------------------------- */
__INL__ struct palettetype *getdefaultpalette(void) {
  return &__gr_EGAdef;
}

/* ----------------------------------------------------------------- */
__INL__ int getpalettesize(void) {
  __gr_set_up_modes();
  if (__gr_ADAPTER == GR_HERC) return 0;
			  else return 16;
}


/* ----------------------------------------------------------------- */
__INL__ int installbgidriver(char *name, void *detect)
{
  return grError;
}

/* ----------------------------------------------------------------- */
__INL__ int registerfarbgidriver(void *driver)
{
  return grError;
}

/* ----------------------------------------------------------------- */
__INL__ int registerfarbgifont(void *font)
{
  return registerbgifont( font);
}

/* ----------------------------------------------------------------- */
__INL__ void setactivepage(int page) { ; }

/* ----------------------------------------------------------------- */
__INL__ void setvisualpage(int page) { ; }

/* ----------------------------------------------------------------- */
__INL__ void set_BGI_mode_whc(int *gd, int *gm,
			      int width, int height, int colors) {
  __gr_BGI_w = width;
  __gr_BGI_h = height;
  __gr_BGI_c = colors;
  *gd        = NATIVE_GRX;
  *gm        = GRX_BGI_EMULATION;
}

/* ----------------------------------------------------------------- */

#ifndef HOLD_GR_DEFS
#  undef __ABS
#  undef __INL__
#  undef YR
#  undef XR
#endif

#endif

