/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
		
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/

#include "deutex.h"
#include "tools.h"
#include "mkwad.h"
#include "texture.h"
#include "ident.h"
#include "color.h"
#include "picture.h"
#include "sound.h"
#include "text.h"

/*compile only for DeuTex*/
#if defined DeuTex

static void AddSomeJunk(char *file);
/************Begin Tex2Ascii module *************************
**
** Translate TEXTURE1,TEXTURE2 and PNAME in
** a texture list for future modifications
*/
extern char file[128];

/***************End Tex2ascii module ******************/























/*
**
** make a PWAD from creation directives
** load levels,lumps,
**  create textures
** load sounds, pics, sprites, patches, flats,
*/


/*
** Can't handle PATCHES redefined from WAD
*/
Bool CMPOcopyFromWAD(Int32 *size,struct WADINFO *rwad,char *DataDir,char *Dir,char *nam,char *filenam)
{  static struct WADINFO pwad;
   Int16 entry;
   if(MakeFileName(file,DataDir,Dir,"",filenam,"WAD")!=TRUE)
     return FALSE;
   WADRopenR(&pwad,file);
   entry=WADRfindEntry(&pwad,nam);
   if(entry>=0)
   { *size=WADRwriteWADentry(rwad,&pwad,entry);
   }
   WADRclose(&pwad);
   if(entry<=0)return FALSE;
   return TRUE;
}
/*
** find a picture.
** must=TRUE is picture must exist
** returns picture type
*/
Int16 CMPOloadPic(Int32 *size,struct WADINFO *rwad,char *file,char *DataDir,char *Dir,char *nam,char *filenam, Int16 Type, Int16 OfsX, Int16 OfsY)
{ int res=PICNONE;
  if(MakeFileName(file,DataDir,Dir,"",filenam,"BMP")==TRUE)
     res=PICBMP;
  else if(MakeFileName(file,DataDir,Dir,"",filenam,"GIF")==TRUE)
     res=PICGIF;
  else if(MakeFileName(file,DataDir,Dir,"",filenam,"PPM")==TRUE)
     res=PICPPM;
  else if(CMPOcopyFromWAD(size,rwad,DataDir,Dir,nam,filenam)==TRUE)
     return PICWAD;
  if(res!=PICNONE)
    *size = PICsaveInWAD(rwad,file,Type,OfsX,OfsY,res);
  else if(Type!=PLUMP)
    Warning("Could not find file %s, .GIF or .BMP or .PPM",file);
  return res;
}

struct WADINFO *CMPOrwad;
char *CMPOwadout=NULL;
void CMPOerrorAction(void)
{ if(CMPOwadout==NULL) return;
  WADRclose(CMPOrwad); /*close file*/
  Unlink(CMPOwadout);  /*delete file*/
}



void CMPOmakePWAD( char *doomwad,WADTYPE type, char *PWADname,
		     char *DataDir,char *texin, NTRYB select,
		     char trnR, char trnG, char trnB, Bool George)
{  /*
   ** type PWAD as we are generating a real PWAD
   */
   Int32 start=0, size=0;
   static char name[8];
   static char filenam[8];
   /*PNAMES */
   Int16  nbPatchs,p;
   Bool NeedPNAME=FALSE;
   Bool FoundOne=FALSE;
   Bool Repeat;
   IMGTYPE Picture;
   /*optional insertion point*/
   Int16 X,Y;
   /*text file to read*/
   static struct TXTFILE *TXT;
   /*DOOM wad*/
   static struct WADINFO iwad,pwad;
   /*result wad file*/
   static struct WADINFO rwad;
   /*for Pnames*/
   Int16 entry;char huge *EntryP;Int32 EntrySz=0;
   char huge *Colors;
   /* initialisation*/

   Info("Translating %s into a %cWAD %s\n",texin,(type==IWAD)?'I':'P',PWADname);

   /*open iwad,get iwad directory*/
   iwad.ok=0;
   WADRopenR(&iwad,doomwad);

   TXT= TXTopenR(texin);
   WADRopenW(&rwad,PWADname,type); 		/* fake IWAD or real PWAD */
   /*
   ** dirty: set error handler to delete the wad out file,
   ** if an error occurs.
   */
   CMPOrwad = &rwad;
   CMPOwadout = PWADname;
   ProgErrorAction(CMPOerrorAction);
   /*
   ** levels! add your own new levels to DOOM!
   ** read level from a PWAD file
   */
   if(select&BLEVEL)
   {  if(TXTseekSection(TXT,"LEVELS"))
      { while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,FALSE)==TRUE)
	{ p=IDENTlevel(name);
	  if(p<0) ProgError("Illegal level name %.8s",name);
	  if(MakeFileName(file,DataDir,"LEVELS","",filenam,"WAD")!=TRUE)
		ProgError("Can't find Level WAD %s",file);
	  Detail("Reading level WAD file %s\n",file);
	  WADRwriteWADlevel(&rwad,file,name);
	}
      }
   }
   /*
   ** prepare palette for graphics
   */
   /*find PLAYPAL*/
   if(select&(BGRAPHIC|BSPRITE|BPATCH|BFLAT))
   { /*should read playpal file if exist*/
     entry=WADRfindEntry(&iwad,"PLAYPAL");
     if(entry<0) ProgError("Can't find PLAYPAL in main WAD");
     Colors=WADRreadEntry(&iwad,entry,&EntrySz);
     COLinit(trnR,trnG,trnB,Colors,(Int16)EntrySz);
     Free(Colors);
   }
   /*
   **
   **   lumps. non graphic raw data for DOOM
   */
   if(select&BLUMP)
   {  start=size=0;
      if(TXTseekSection(TXT,"LUMPS"))
      { Phase("Making Lumps\n");
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,FALSE)==TRUE)
	{  if(Repeat!=TRUE)
	   { WADRalign4(&rwad);     /*align entry on Int32 word*/
	     start=WADRposition(&rwad);
	     if(MakeFileName(file,DataDir,"LUMPS","",filenam,"LMP")==TRUE)
	     { size=WADRwriteLump(&rwad,file);
	     }
	     else
	     { Picture=CMPOloadPic(&size,&rwad,file,DataDir,"LUMPS",name,filenam,PLUMP,X,Y);
	       if(Picture==PICNONE)
		 if(CMPOcopyFromWAD(&size,&rwad,DataDir,"LUMPS",name,filenam)!=TRUE)
		   ProgError("Can't find Lump or picture file %s.",file);
	     }
	   }
	   WADRdirAddEntry(&rwad,start,size,name);
	}
      }
   }
   /*
   ** initialise list of patch names
   */
   if(select&(BTEXTUR|BPATCH))
   { entry=WADRfindEntry(&iwad,"PNAMES");
     if(entry<0) ProgError("Can't find PNAMES in main WAD");
     EntryP=WADRreadEntry(&iwad,entry,&EntrySz);
     PNMinit(EntryP,EntrySz);
     Free(EntryP);
     NeedPNAME = FALSE;
   }
   /*
   ** read texture1
   */
   if(select&BTEXTUR)
   {  if(TXTseekSection(TXT,"TEXTURE1"))
      { Phase("Making Texture1\n");
	TXUinit();
	entry=WADRfindEntry(&iwad,"TEXTURE1");
	if(entry>=0)
	{ EntryP=WADRreadEntry(&iwad,entry,&EntrySz);
	  TXUreadTEXTURE(EntryP,EntrySz,NULL,0,TRUE);
	  Free(EntryP);
	}
	else Warning("Can't find TEXTURE1 in main WAD");
	FoundOne=FALSE;
	 /*read TEXTURES composing TEXTURE1*/
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,FALSE)==TRUE)
	{ if(MakeFileName(file,DataDir,"TEXTURES","",name,"TXT")==TRUE)
	  { Detail("Reading texture file %s\n",file);
	    TXUreadTexFile(file,TRUE);
	    NeedPNAME=TRUE;
	    FoundOne=TRUE;
	  }
	  else if(MakeFileName(file,DataDir,"TEXTURES","",name,"WAD")==TRUE)
	  { Detail("Reading texture WAD %s\n",file);
	    WADRopenR(&pwad,file);
	    entry=WADRfindEntry(&pwad,"TEXTURE1");
	    if(entry>=0)
	    { EntryP=WADRreadEntry(&pwad,entry,&EntrySz);
	      TXUreadTEXTURE(EntryP,EntrySz,NULL,0,TRUE);
	      Free(EntryP);
	      NeedPNAME=TRUE;
	      FoundOne=TRUE;
	    }
	    WADRclose(&pwad);
	  }
	  else
	    ProgError("Can't find texture list %s",file);
	}
	/*write texture*/
	if(FoundOne==TRUE)
	{ WADRalign4(&rwad);     /*align entry on Int32 word*/
	  start= WADRposition(&rwad);
	  size = TXUwriteTEXTUREtoWAD(&rwad);
	  WADRdirAddEntry(&rwad,start,size,"TEXTURE1");
	}
	TXUfree();
      }
   }
   /*
   ** read texture2
   */
   if(select&BTEXTUR)
   {  if(TXTseekSection(TXT,"TEXTURE2"))
      { Phase("Making Texture2\n");
	TXUinit();
	entry=WADRfindEntry(&iwad,"TEXTURE2");
	if(entry>=0)
	{ EntryP=WADRreadEntry(&iwad,entry,&EntrySz);
	  TXUreadTEXTURE(EntryP,EntrySz,NULL,0,TRUE);
	  Free(EntryP);
	}
	else Warning("Can't find TEXTURE2 in main WAD");
	FoundOne=FALSE;
	 /*read TEXTURES composing TEXTURE2*/
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,FALSE)==TRUE)
	{ if(MakeFileName(file,DataDir,"TEXTURES","",name,"TXT")==TRUE)
	  { Detail("Reading texture file %s\n",file);
	    TXUreadTexFile(file,TRUE);
	    NeedPNAME=TRUE;
	    FoundOne=TRUE;
	  }
	  else if(MakeFileName(file,DataDir,"TEXTURES","",name,"WAD")==TRUE)
	  { Detail("Reading texture WAD %s\n",file);
	    WADRopenR(&pwad,file);
	    entry=WADRfindEntry(&pwad,"TEXTURE2");
	    if(entry>=0)
	    { EntryP=WADRreadEntry(&pwad,entry,&EntrySz);
	      TXUreadTEXTURE(EntryP,EntrySz,NULL,0,TRUE);
	      Free(EntryP);
	      NeedPNAME=TRUE;
	      FoundOne=TRUE;
	    }
	    WADRclose(&pwad);
	  }
	  else
	    ProgError("Can't find texture list %s",file);
	}
	/*write texture*/
	if(FoundOne==TRUE)
	{ WADRalign4(&rwad);     /*align entry on Int32 word*/
	  start= WADRposition(&rwad);
	  size = TXUwriteTEXTUREtoWAD(&rwad);
	  WADRdirAddEntry(&rwad,start,size,"TEXTURE2");
	}
	TXUfree();
      }
   }
   /*
   ** PNAME
   */
   if(select&BTEXTUR)
   {  if(NeedPNAME)    /*write PNAME in PWAD*/
      { /*write entry PNAME*/
	Phase("Making Pnames\n");
	WADRalign4(&rwad);     /*align entry on Int32 word*/
	start=WADRposition(&rwad);
	size =PNMwritePNAMEtoWAD(&rwad);
	WADRdirAddEntry(&rwad,start,size,"PNAMES");
      }
   }
   /*
   **
   **   sounds. all sounds entries
   */
   if(select&BSOUND)
   {  start=size=0;
      if(TXTseekSection(TXT,"SOUNDS"))
      { Phase("Making Sounds\n");
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,FALSE)==TRUE)
	{ if(Repeat!=TRUE)
	  { WADRalign4(&rwad);     /*align entry on Int32 word*/
	    start=WADRposition(&rwad);
	    if(MakeFileName(file,DataDir,"SOUNDS","",filenam,"TXT")==TRUE)
	    { size=SNDcopyPCSoundInWAD(&rwad,file);
	      Detail("Read PC Sound as file %s\n",file);
	    }
	    else
	    { if(MakeFileName(file,DataDir,"SOUNDS","",filenam,"WAV")==TRUE)
	      { size=SNDcopyInWAD(&rwad,file,SNDWAV);
	      }
	      else if(MakeFileName(file,DataDir,"SOUNDS","",filenam,"AU")==TRUE)
	      { size=SNDcopyInWAD(&rwad,file,SNDAU);
	      }
	      else if(MakeFileName(file,DataDir,"SOUNDS","",filenam,"VOC")==TRUE)
	      { size=SNDcopyInWAD(&rwad,file,SNDVOC);
	      }
	      else if(CMPOcopyFromWAD(&size,&rwad,DataDir,"SOUNDS",name,filenam)!=TRUE)
		ProgError("Can't find Sound %s, AU or WAV or WAD",file);
	      Detail("Read Sound in file %s\n",file);
	    }
	  }
	  WADRdirAddEntry(&rwad,start,size,name);
	}
      }
   }
   /*
   **
   **   Musics
   */
   if(select&BMUSIC)
   {  start=size=0;
      if(TXTseekSection(TXT,"MUSICS"))
      { Phase("Making Musics\n");
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,FALSE)==TRUE)
	{ if(Repeat!=TRUE)
	  { WADRalign4(&rwad);     /*align entry on Int32 word*/
	    start=WADRposition(&rwad);
	    /*Music*/
	    if(MakeFileName(file,DataDir,"MUSICS","",filenam,"MUS")==TRUE)
	    { size=WADRwriteLump(&rwad,file);
	      Detail("Read Music as MUS file %s\n",file);
	    }
	    else if(CMPOcopyFromWAD(&size,&rwad,DataDir,"MUSICS",name,filenam)!=TRUE)
	      ProgError("Can't find Music %s",file);
	  }
	  WADRdirAddEntry(&rwad,start,size,name);
	}
      }
   }
   /*
   **  ordinary graphics
   */
   if(select&BGRAPHIC)
   {  start=size=0;
      if(TXTseekSection(TXT,"GRAPHICS"))
      { Phase("Making Graphics\n");
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,TRUE)==TRUE)
	{ if(Repeat!=TRUE)
	  { WADRalign4(&rwad);     /*align entry on Int32 word*/
	    start=WADRposition(&rwad);
	    Picture=CMPOloadPic(&size,&rwad,file,DataDir,"GRAPHICS",name,filenam,PGRAPH,X,Y);
	  }
	  WADRdirAddEntry(&rwad,start,size,name);
	}
      }
   }
   /*
   **  SS_START
   **  sprites
   **  SS_END
   */
   if(select&BSPRITE)
   {  start=size=0;
      if(TXTseekSection(TXT,"SPRITES"))
      { Phase("Making Sprites\n");
	FoundOne=FALSE;
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,TRUE)==TRUE)
	{ /* first sprite seen? */
	  if((Repeat!=TRUE)||(FoundOne!=TRUE))
	  { WADRalign4(&rwad);     /*align entry on Int32 word*/
	    start=WADRposition(&rwad);
	    if(FoundOne!=TRUE)
	    { if(type==IWAD)
		WADRdirAddEntry(&rwad,start,0L,"S_START");
	      else
		WADRdirAddEntry(&rwad,start,0L,"SS_START");
	    }
	    FoundOne=TRUE;
	    CMPOloadPic(&size,&rwad,file,DataDir,"SPRITES",name,filenam,PSPRIT,X,Y);
	  }
	  WADRdirAddEntry(&rwad,start,size,name);
	}
	if(FoundOne==TRUE)
	{ WADRalign4(&rwad);
	  start=WADRposition(&rwad);
	  if((type==IWAD)||(George==TRUE))
	    WADRdirAddEntry(&rwad,start,0L,"S_END");
	  else
	    WADRdirAddEntry(&rwad,start,0L,"SS_END");
	}
      }
   }
   /*
   ** Try to load WALL patches
   **   even if no new textures (old patches could be redefined)
   */
   /* write new patches  in PWAD*/
   /* read the name of the new textures and insert them*/
   /* between P_START and P_END for future completion*/

   if(select&BPATCH)
   {  FoundOne=FALSE;
      /*
      ** First look for patches in [PATCHES]
      */
      start=size=0;
      if(TXTseekSection(TXT,"PATCHES"))
      { Phase("Making Wall Patches\n");
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,TRUE)==TRUE)
	{ if((Repeat!=TRUE)||(FoundOne!=TRUE))
	  { WADRalign4(&rwad);     /*align entry on Int32 word*/
	    start=WADRposition(&rwad);
	    if(FoundOne==FALSE)
	    { if(type==IWAD)
	      { WADRdirAddEntry(&rwad,start,0L,"P_START");
		WADRdirAddEntry(&rwad,start,0L,"P1_START");
	      }
	      else
		WADRdirAddEntry(&rwad,start,0L,"PP_START");
	    }
	    FoundOne=TRUE;
	    CMPOloadPic(&size,&rwad,file,DataDir,"PATCHES",name,filenam,PPATCH,X,Y);
	  }
	  WADRdirAddEntry(&rwad,start,size,name);
	}
      }
      /*
      ** Check if all the needed patches are defined.
      */
      nbPatchs=PNMgetNbOfPatch();
      for(p=0;p<nbPatchs;p++)
      { if(PNMisNew(p)!=TRUE) continue;/*if old patch, forget it*/
	PNMgetPatchName(name,p);
        Normalise(filenam,name);
	/*search in main IWAD directory*/
	if(WADRfindEntry(&iwad,name)>=0)
	{ Output("Reusing DOOM entry %.8s as patch\n",name);
	}
	/*search in current PWAD*/
	else if(WADRfindEntry(&rwad,name)<0)
	{ /*PATCH not found in current WAD, load automatically
	  **from the PATCH directory
	  */
	  WADRalign4(&rwad);     /*align entry on Int32 word*/
	  start=WADRposition(&rwad);
	  Picture=CMPOloadPic(&size,&rwad,file,DataDir,"PATCHES",name,filenam,PPATCH,INVALIDINT,INVALIDINT);
	  if(Picture!=PICNONE)
	  { if(FoundOne==FALSE)
	    { Phase("Making Wall Patches\n");
	      if(type==IWAD)
	      { WADRdirAddEntry(&rwad,start,0L,"P_START");
		WADRdirAddEntry(&rwad,start,0L,"P1_START");
	      }
	      else
		WADRdirAddEntry(&rwad,start,0L,"PP_START");
	    }
	    FoundOne=TRUE;
	    WADRdirAddEntry(&rwad,start,size,name);
	  }
	}
      }
      if(FoundOne==TRUE)
      { WADRalign4(&rwad);     /*align entry on Int32 word*/
	start=WADRposition(&rwad);
	if(type==IWAD)
	{ WADRdirAddEntry(&rwad,start,0L,"P1_END");
	  WADRdirAddEntry(&rwad,start,0L,"P2_START");
	  WADRdirAddEntry(&rwad,start,0L,"P2_END");
	  WADRdirAddEntry(&rwad,start,0L,"P3_START");
	  WADRdirAddEntry(&rwad,start,0L,"P3_END");
	  WADRdirAddEntry(&rwad,start,0L,"P_END");
	}
	else
	  WADRdirAddEntry(&rwad,start,0L,"PP_END");
      }
   }
   /*
   ** clear off Pnames
   */
   if(select&(BTEXTUR|BPATCH))
   { PNMfree();
   }
   /*  FF_START
   **  Flats
   **  FF_END
   */
   if(select&BFLAT)
   {  if(TXTseekSection(TXT,"FLATS"))
      { Phase("Making Flats\n");
	FoundOne=FALSE;
	while(TXTentryParse(name,filenam,&X,&Y,&Repeat,TXT,FALSE)==TRUE)
	{ if((Repeat!=TRUE)||(FoundOne!=TRUE))
	  { WADRalign4(&rwad);     /*align entry on Int32 word*/
	    start=WADRposition(&rwad);
	    if(FoundOne==FALSE)
	    { if(type==IWAD)
	      { WADRdirAddEntry(&rwad,start,0L,"F_START");
		WADRdirAddEntry(&rwad,start,0L,"F1_START");
	      }
	      else
		WADRdirAddEntry(&rwad,start,0L,"FF_START");
	    }
	    FoundOne=TRUE;
	    CMPOloadPic(&size,&rwad,file,DataDir,"FLATS",name,filenam,PFLAT,INVALIDINT,INVALIDINT);
	  }
	  WADRdirAddEntry(&rwad,start,size,name);
	}
	if(FoundOne==TRUE)
	{ start=WADRposition(&rwad);
	  if(type==IWAD)
	  { WADRdirAddEntry(&rwad,start,0L,"F1_END");
	    WADRdirAddEntry(&rwad,start,0L,"F2_START");
	    WADRdirAddEntry(&rwad,start,0L,"F2_END");
	    WADRdirAddEntry(&rwad,start,0L,"F3_START");
	    WADRdirAddEntry(&rwad,start,0L,"F3_END");
	    WADRdirAddEntry(&rwad,start,0L,"F_END");
	  }
	  else
	    WADRdirAddEntry(&rwad,start,0L,"FF_END");
	}
      }
   }
   /*
   ** exit from graphic
   */
   if(select&(BGRAPHIC|BSPRITE|BPATCH|BFLAT)) COLfree();
   /*
   ** iwad not needed anymore
   */
   WADRclose(&iwad);
   /*
   ** the end
   */
   TXTcloseR(TXT);
   WADRwriteDir(&rwad);  /* write the WAD directory */
   ProgErrorCancel();
   WADRclose(&rwad);
   /*add some junk at end of wad file, for DEU 5.21*/
   if(type==PWAD)  AddSomeJunk(PWADname);
}









/***************** Hack the IWAD *********************/
extern Int16 HowMuchJunk;
static char Junk[]="*** This junk is here for DEU 5.21. I am repeating myself anyway.... ********";
static void AddSomeJunk(char *file)
{  FILE *out;Int16 n;
   out=fopen(file,FOPEN_AB); /*open R/W at the end*/
   if(out==NULL) ProgError("Can't write file %s\n",file);
   for(n=0;n<HowMuchJunk;n++)
      if(fwrite(Junk,1,64,out)<64)  Warning("can't insert my junk!");
   fclose(out);

}
/**************** End Hack the IWAD *******************************/


#endif /*DeuTex*/

