/*
  DEUTEX is Copyright (c) 1994,1995 Olivier Montanuy (montanuy@lannion.cnet.fr)

  Legal stuff:
   You can reuse any part of this copyrighted code in any freeware project you wish.
   However I request that you give me some credit for the code you reuse
   If you want to release a modified version of DeuTex, or a version included in another
   program, I request that you warn me by e-mail, because since I don't have much
   time to improve that program, I'd like to know what happens to it.
   
   You are NOT ALLOWED to make ANY commercial derivative from this code without my written
   consent (which isn't hard to get provided you play fair).
		
  Technical stuff:
   This source is released because I lack time to improve it myself.
   Many many parts could be greatly improved, and some should be entirely rewritten.
   I hope it will at least be usefull for inspiration, if nothing else.
*/


#ifndef LITTLE_ENDIAN
/*
** default: processor is assumed to be BIG ENDIAN
** Intel 486.
*/
#define LE_Int32(a)	SwapInt32(a)
#define LE_Int16(a)	SwapInt16(a)
#define BE_Int32(a)	(a)
#define BE_Int16(a)	(a)
#else
/*
** If processor is LITTLE ENDIAN
** Motorola 68040   SUN Sparc
*/
#define BE_Int32(a)	SwapInt32(a)
#define BE_Int16(a)	SwapInt16(a)
#define LE_Int32(a)	(a)
#define LE_Int16(a)	(a)
#endif

void PrintCopyright(void);
void NoCommandGiven(void);


void PrintInit(Bool asFile);
void PrintVerbosity(Int16 level);
void PrintExit(void);

void ProgErrorCancel(void);
void ProgErrorAction(void (*action)(void));
void ProgError( char *, ...);    /*fatal error. halt.*/
void Bug( char *, ...);          /*fatal bug. halt*/
void Warning( char *str, ...);   /*I'm not happy*/
void Output(char *str, ...); /*command text output*/
void Info(char *str, ...);   /*useful indications*/
void Phase(char *str, ...);  /*phase of executions*/
void Detail(char *str, ...); /*technical details*/
void Legal(char *str, ...);  /*legal output*/





/******************tools.c***********************/

/** FILE name , for lumps and BMP **/
void ToLowerCase(char *file);
void MakeDir(char file[128], char *path,char *dir,char *sdir);
Bool MakeFileName(char file[128], char *path,char *dir,char *sdir,char *name,char *extens);
void GetNameOfWAD(char name[8],char *path);
Int16 Chsize(int handle,Int32 newsize);
Int32 GetFileTime(char *path);
void SetFileTime(char *path, Int32 time);
void Unlink(char *file);
void Memcpy(void huge *dest,const void huge *src, Int32 n);
void Memset(void huge *dest,char car, Int32 n);
void huge *Malloc( Int32 size);
void huge *Realloc( void huge *old, Int32 size);
void Free( void huge *);


void Normalise(char dest[8], char *src);

void Progress(void);
void ProgressEnds(void);
