/* sndcvt.c	-  Charles (int@link.xs4all.nl)
**
** convert 16bit sound of DOOM to 8bit ..
**
** (10sep94) initial version
** (15sep94) added support for pcsp
** (17jan95) last version (hopefully 8bit support is included in the next sndserver)
*/

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#define ERRMSG		  strerror(errno)
#define DSP_IN		  "/tmp/dsp"
#define DSP_OUT 	  "/dev/dsp"
#define PCSP_OUT	  "/dev/pcsp"

void do_sndcvt(int,int);
void usage(void);

int Fs=0,Fm=0,Fp=0;


void main(int argc, char **argv)
{
  char	*dspin	= DSP_IN;
  char	*dspout = NULL;
  int	 ifd, ofd;
  int	 c, v, ret;

     if(argc<2)
       usage();

     while((c=getopt(argc, argv, "smpi:o:")) != -1)
      {
	switch(c)
	 {
	   case 's':
		Fs++;
		if(!dspout)
		  dspout = DSP_OUT;
		break;
	   case 'm':
		Fm++;
		if(!dspout)
		  dspout = DSP_OUT;
		break;
	   case 'p':
		Fp++;
		if(!dspout)
		  dspout = PCSP_OUT;
		break;
	   case 'i':
		dspin = optarg;
		break;
	   case 'o':
		dspout = optarg;
		break;
	   default:
		usage();
	 }
      }

     ifd = open(dspin, O_RDONLY);
     if(ifd < 0)
       {
	  fprintf(stderr, "Can't open %s (rd): %s\n", dspin, ERRMSG);
	  exit(1);
       }

     if(!dspout)
       dspout = DSP_OUT;
     ofd = open(dspout, O_WRONLY);
     if(ofd < 0)
       {
	  fprintf(stderr, "Can't open %s (wr): %s\n", dspout, ERRMSG);
	  exit(1);
       }

     if(Fm || Fs)
       {
	  v = 131083;
	  ret = ioctl(ofd, SNDCTL_DSP_SETFRAGMENT, &v);
	  if(ret) perror("SNDCTL_DSP_SETFRAGMENT");

	  v = Fs ? 1 : 0;
	  ret = ioctl(ofd, SNDCTL_DSP_STEREO, &v);
	  if(ret) perror("SNDCTL_DSP_STEREO");
       }

     ret = ioctl(ofd, SNDCTL_DSP_RESET, 0);
     if(ret) perror("SNDCTL_DSP_RESET");

     v = 11025;
     ret = ioctl(ofd, SOUND_PCM_WRITE_RATE, &v);
     if(ret) perror("SOUND_PCM_WRITE_RATE");

     do_sndcvt(ifd, ofd);

  fprintf(stderr, "sndcvt: EOF\n");
  exit(0);
}

void do_sndcvt(int ifd, int ofd)
{
  unsigned short s[1024];
  unsigned char  b[1024];
  int		 i, j;
  int		 cnt;

     while((cnt = read(ifd, &s, 2048)))
      {

	if(Fs)
	  {
	     cnt /= 2;
	     for(i=0;i<cnt;i++)
	       {
		  s[i] ^= 0x8000;
		  b[i]	= (s[i]>>8);
	       }
	  }
	else
	  {
	     cnt /= 2;
	     for(i=0,j=0;i<cnt;i++,j++)
	       {
		  s[i] = ((s[i] ^ 0x8000) + (s[++i] ^ 0x8000)) / 2;
		  b[j] = (s[i]>>8);
	       }
	  }

	if(write(ofd, &b, cnt) != cnt)
	 {
	   fprintf(stderr, "sndcvt: short write: %s\n", ERRMSG);
	   exit(1);
	 }
      }
}

void usage(void)
{
  fprintf(stderr, "sndcvt v3 - convert DOOM's 16bit sound to 8bit - Charles (int@link.xs4all.nl)\n");
  fprintf(stderr, "usage: sndcvt <[-smp]> [-i in] [-o out]\n\n");
  fprintf(stderr, "      -s       stereo dsp\n");
  fprintf(stderr, "      -m       mono dsp\n");
  fprintf(stderr, "      -p       mono pcsp\n");
  fprintf(stderr, "      -i<dev>  input fifo\n");
  fprintf(stderr, "      -o<dev>  output device\n");
  exit(1);
}
